/****************************************************************************
**
** Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 1.0

Item {
    id: progressbar

    property int minimum: 0
    property int maximum: 100
    property int value: 90
    property alias color: gradient1.color
    property alias secondColor: gradient2.color
    property string caption: "text"
    width: 200; height: 26
    clip: true

    Text {
        id: textCaption
        x: 1
        y: 1
        width: 48
        text: caption
        verticalAlignment: Text.AlignVCenter
        horizontalAlignment: Text.AlignHCenter
        anchors.top: parent.top
        anchors.topMargin: 0
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 0
        font.family: "Ubuntu Condensed"
        font.bold: true
        styleColor: "#ffffff"
        style: Text.Raised
        anchors.left: parent.left
        anchors.leftMargin: 0
        font.pixelSize: 12
    }

    BorderImage {
        id: borderimage1
        x: 1
        y: 1
        source: "background.png"
        anchors.left: textCaption.right; anchors.leftMargin: 2; anchors.top: parent.top; anchors.topMargin: 0; anchors.bottom: parent.bottom; anchors.bottomMargin: 0; anchors.right: parent.right; anchors.rightMargin: 0;            transformOrigin: Item.Center
        border { left: 4; top: 4; right: 4; bottom: 4 }

        Rectangle {
               id: highlight

               property int widthDest: ((borderimage1.width * (value - minimum)) / (maximum - minimum) -1)

               width: highlight.widthDest
               Behavior on width { SmoothedAnimation { velocity: 1200 } }
               height: 24

               anchors { left: parent.left; top: parent.top; bottom: parent.bottom; margins: 3 }
               radius: 1
               gradient: Gradient {
                          GradientStop { id: gradient1; position: 0.0 }
                          GradientStop { id: gradient2; position: 0.8 }
                      }
              // border.color: "#ee1a1a"
}

        Text {
            id: textValue
            x: 113
            y: -5
            width: 25
            height: 25
            color: "black"
            font.bold: true
            styleColor: "#ffffff"
            style: Text.Raised
            text: Math.floor((value - minimum) / (maximum - minimum) * 100) + '%'
            anchors.verticalCenterOffset: 4
            anchors.horizontalCenterOffset: 1
            anchors.verticalCenter: parent.verticalCenter
            anchors.horizontalCenter: parent.horizontalCenter
            }
        }
}
