import QtQuick 1.1

Rectangle
{
    id: animColor
   // color:"red"
    
    property real xColor: 0.5
    signal valueChanged(real xvalue)

    onValueChanged:{
        xColor=xvalue
        randomAction()
    }
    function randomAction() {
        animColor.color = Qt.hsla(xColor,0.5,(Math.random()*0.6)+0.2,1)
        var v=Math.random()*50000

        mTimer.interval=v+1000
    }
    
    Timer {
        id:mTimer
        running: true
        repeat: true
        onTriggered: randomAction()
    }
    
    Component.onCompleted: {

        randomAction()
    }
    
    MouseArea {
        anchors.fill: parent
        onClicked: randomAction()
    }

    Behavior on color { ColorAnimation { duration: 1000; easing.type: Easing.InQuad } }
}
