/***********************************************************************
 *                                                                     *
 * Copyright 2016  Lorenzo Porta (Vindex17) <vindex17@outlook.it>      *
 *                                                                     *
 * This program is free software; you can redistribute it and/or       *
 * modify it under the terms of the GNU General Public License as      *
 * published by the Free Software Foundation; either version 3 of      *
 * the License or any later version accepted by the membership of      *
 * KDE e.V. (or its successor approved by the membership of KDE        *
 * e.V.), which shall act as a proxy defined in Section 14 of          *
 * version 3 of the license.                                           *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program. If not, see <http://www.gnu.org/licenses/> *
 *                                                                     *
 ***********************************************************************/


#pragma once


#include <KMessageBox>
#include <QTableWidget>


struct UrlRequester : public QTableWidget
{
    explicit UrlRequester();
    Q_DISABLE_COPY(UrlRequester)

    const QList<std::array<QUrl,2>> & get_operation_url_list() const __attribute__((always_inline,warn_unused_result));
    void add();
    void remove();
    void restore(const QList<QUrl> &&, const QList<QUrl> &&);

private:
    QList<std::array<QUrl,2>> operation_url_list;

    KMessageBox::ButtonCode show_relationship_error_between(const QString &, const QString &) __attribute__((cold,warn_unused_result));
    QTableWidgetItem * init_table_widget_item(const QUrl &, const QString &) __attribute__((warn_unused_result));
};
inline const QList<std::array<QUrl,2>> & UrlRequester::get_operation_url_list() const {return operation_url_list;}
