/***********************************************************************
 *                                                                     *
 * Copyright 2016  Lorenzo Porta (Vindex17) <vindex17@outlook.it>      *
 *                                                                     *
 * This program is free software; you can redistribute it and/or       *
 * modify it under the terms of the GNU General Public License as      *
 * published by the Free Software Foundation; either version 3 of      *
 * the License or any later version accepted by the membership of      *
 * KDE e.V. (or its successor approved by the membership of KDE        *
 * e.V.), which shall act as a proxy defined in Section 14 of          *
 * version 3 of the license.                                           *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program. If not, see <http://www.gnu.org/licenses/> *
 *                                                                     *
 ***********************************************************************/


#include "progressdialogs.hxx"
#include "progressdialogs.moc"

#include <KLocalizedString>
#include <KSeparator>
#include <QDialogButtonBox>
#include <QHBoxLayout>
#include <QVBoxLayout>


static constexpr progress_bar_value_t default_progress_bar_min_value = 0;


ProgressDialog::ProgressDialog(QWidget * const parent, const QString &title) : QDialog(parent)
{
    // Setup widgets
    progress_bar.setRange(default_progress_bar_min_value, default_progress_bar_min_value);
    // ↓
    QDialogButtonBox * const button_box = new QDialogButtonBox(QDialogButtonBox::Abort);
    connect(button_box, &QDialogButtonBox::rejected, this, &ProgressDialog::reject, Qt::DirectConnection);
    // ↓
    QVBoxLayout * const this_layout = new QVBoxLayout(this);
    this_layout->addWidget(&progress_bar);
    this_layout->addWidget(button_box);

    setFixedSize(512, sizeHint().height());
    setWindowTitle(title);
    open();
}


void ProgressDialog::reset(const progress_bar_value_t & max)
{
    progress_bar.setRange(default_progress_bar_min_value, max);
    progress_bar.setValue(default_progress_bar_min_value);
}


TaskProgressDialog::TaskProgressDialog(QWidget * const parent, const progress_bar_value_t &task_number, const QString &title) : QDialog(parent)
{
    step = default_progress_bar_min_value;

    // Setup widgets
    operation_progress_bar.setRange(step, step + step_weight*task_number);
    speed_label.setAlignment(Qt::AlignHCenter);
    speed_label.setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Minimum);
    QDialogButtonBox * const button_box = new QDialogButtonBox(QDialogButtonBox::Abort);
    button_box->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Minimum);
    connect(button_box, &QDialogButtonBox::rejected, this, &TaskProgressDialog::reject, Qt::DirectConnection);
    QHBoxLayout * const bottom_layout = new QHBoxLayout;
    bottom_layout->addWidget(new QLabel(i18nc("@label", "Ongoing operation progress:")));
    bottom_layout->addWidget(&operation_progress_bar);
    bottom_layout->addWidget(&speed_label);
    bottom_layout->addWidget(button_box);
    // ↓
    QVBoxLayout * const this_layout = new QVBoxLayout(this);
    this_layout->addWidget(&description_label1);
    this_layout->addWidget(&description_label2);
    this_layout->addWidget(&description_label3);
    this_layout->addWidget(&task_progress_bar);
    this_layout->addWidget(new KSeparator);
    this_layout->addLayout(bottom_layout);

    setFixedSize(768, sizeHint().height());
    setWindowTitle(title);
    open();
}


void TaskProgressDialog::update_kiojob_speed(KJob *, const ulong &bytes_per_data)
{
    speed_label.setText(QStringLiteral("[ @ ") % KIO::convertSize(bytes_per_data) % QStringLiteral("/s ]"));
}


void TaskProgressDialog::update_progress_bars(KJob *, const ulong &job_percentage)
{
    task_progress_bar.setValue(progress_bar_value_t(job_percentage));
    operation_progress_bar.setValue(step+progress_bar_value_t(job_percentage));
}
