/***********************************************************************
 *                                                                     *
 * Copyright 2016  Lorenzo Porta (Vindex17) <vindex17@outlook.it>      *
 *                                                                     *
 * This program is free software; you can redistribute it and/or       *
 * modify it under the terms of the GNU General Public License as      *
 * published by the Free Software Foundation; either version 3 of      *
 * the License or any later version accepted by the membership of      *
 * KDE e.V. (or its successor approved by the membership of KDE        *
 * e.V.), which shall act as a proxy defined in Section 14 of          *
 * version 3 of the license.                                           *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program. If not, see <http://www.gnu.org/licenses/> *
 *                                                                     *
 ***********************************************************************/


#include "profiledialog.hxx"
#include "profiledialog.moc"

#include <KLocalizedString>
#include <KStandardGuiItem>
#include <QDialogButtonBox>
#include <QLabel>
#include <QPushButton>
#include <QVBoxLayout>


#define ADD_CUSTOM_BUTTON(ACTION, ICON, TEXT) \
    QPushButton * const ACTION##_button = button_box->addButton(TEXT, QDialogButtonBox::ActionRole); \
    ACTION##_button->setIcon(ICON); \
    connect(ACTION##_button, &QPushButton::clicked, [&]{done(ACTION);})


ProfileDialog::ProfileDialog(QWidget * const parent) : QDialog(parent)
{
    // Setup widgets
    QDialogButtonBox * const button_box = new QDialogButtonBox(QDialogButtonBox::Cancel, Qt::Vertical, this);
    connect(button_box, &QDialogButtonBox::rejected, this, &ProfileDialog::reject, Qt::DirectConnection);
    // ↓
    ADD_CUSTOM_BUTTON(load_profile, KStandardGuiItem::open().icon(), i18nc("@action:button", "Load a profile"));
    ADD_CUSTOM_BUTTON(save_profile, KStandardGuiItem::save().icon(), i18nc("@action:button", "Save current profile"));
    ADD_CUSTOM_BUTTON(delete_profile, KStandardGuiItem::del().icon(), i18nc("@action:button", "Delete a profile"));
    ADD_CUSTOM_BUTTON(import_profile, QIcon::fromTheme(QStringLiteral("document-import")), i18nc("@action:button", "Import profiles"));
    ADD_CUSTOM_BUTTON(export_profile, QIcon::fromTheme(QStringLiteral("document-export")), i18nc("@action:button", "Export profiles"));
    // ↓
    QVBoxLayout * const this_layout = new QVBoxLayout(this);
    this_layout->addWidget(button_box);
    this_layout->setSizeConstraint(QLayout::SetFixedSize);
}
