/***********************************************************************
 *                                                                     *
 * Copyright 2016  Lorenzo Porta (Vindex17) <vindex17@outlook.it>      *
 *                                                                     *
 * This program is free software; you can redistribute it and/or       *
 * modify it under the terms of the GNU General Public License as      *
 * published by the Free Software Foundation; either version 3 of      *
 * the License or any later version accepted by the membership of      *
 * KDE e.V. (or its successor approved by the membership of KDE        *
 * e.V.), which shall act as a proxy defined in Section 14 of          *
 * version 3 of the license.                                           *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program. If not, see <http://www.gnu.org/licenses/> *
 *                                                                     *
 ***********************************************************************/


#pragma once


#include <KIO/Global>
#include <QDialog>
#include <QLabel>
#include <QTableWidget>


struct PreviewDialog : public QDialog
{
    typedef std::result_of<decltype(&QTableWidget::rowCount)(QTableWidget)>::type table_row_t;

    explicit PreviewDialog(QWidget * const, const QString &&, const QString &&, const table_row_t &&) __attribute__((nonnull));
    Q_DISABLE_COPY(PreviewDialog)

    void add_copy_in_destination(const QIcon &, const QString &, const KIO::filesize_t &);
    void add_copy_in_source(const QIcon &, const QString &, const KIO::filesize_t &);
    void add_del_in_destination(const QIcon &, const QString &, const KIO::filesize_t &);
    void add_del_in_source(const QIcon &, const QString &, const KIO::filesize_t &);
    void add_mkdir_in_destination(const QString &);
    void add_mkdir_in_source(const QString &);
    void add_overwrite_in_destination(const QIcon &, const QIcon &, const QString &, const KIO::filesize_t &, const KIO::filesize_t &);
    void add_overwrite_in_source(const QIcon &, const QIcon &, const QString &, const KIO::filesize_t &, const KIO::filesize_t &);
    void add_rename_in_destination(const QIcon &, const QString &);
    void add_rename_in_source(const QIcon &, const QString &);

private:
    KIO::filesize_t bytes_to_write = 0, bytes_to_delete = 0;
    QLabel result_label;
    QTableWidget table;
    const QIcon copy_icon = QIcon::fromTheme(QStringLiteral("edit-copy")),
                             del_icon = QIcon::fromTheme(QStringLiteral("edit-delete")),
                             folder_icon = QIcon::fromTheme(QStringLiteral("folder")),
                             mkdir_icon = QIcon::fromTheme(QStringLiteral("folder-add")),
                             new_dir_icon = QIcon::fromTheme(QStringLiteral("folder-grey")),
                             new_file_icon = QIcon::fromTheme(QStringLiteral("none")),
                             overwrite_in_source_icon = QIcon::fromTheme(QStringLiteral("arrow-left-double")),
                             overwrite_icon = QIcon::fromTheme(QStringLiteral("arrow-right-double")),
                             rename_icon = QIcon::fromTheme(QStringLiteral("edit-rename"));
    const QString minus = QStringLiteral("- "), plus = QStringLiteral("+ ");
   table_row_t  current_table_row = 0;

    void append_items_in_table(const std::array<QTableWidgetItem*,3> &&) __attribute__((always_inline));
    void showEvent(QShowEvent * const);
    void show_help() __attribute__((cold));
};
