/***********************************************************************
 *                                                                     *
 * Copyright 2016  Lorenzo Porta (Vindex17) <vindex17@outlook.it>      *
 *                                                                     *
 * This program is free software; you can redistribute it and/or       *
 * modify it under the terms of the GNU General Public License as      *
 * published by the Free Software Foundation; either version 3 of      *
 * the License or any later version accepted by the membership of      *
 * KDE e.V. (or its successor approved by the membership of KDE        *
 * e.V.), which shall act as a proxy defined in Section 14 of          *
 * version 3 of the license.                                           *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program. If not, see <http://www.gnu.org/licenses/> *
 *                                                                     *
 ***********************************************************************/


#pragma once


#include <QTextStream>
#include <QFile>


struct Logger : public QObject
{
    explicit Logger(QObject * const parent) __attribute__((nonnull)) : QObject(parent) {}
    Q_DISABLE_COPY(Logger)
    ~Logger();

    bool open_file(const QString &) __attribute__((warn_unused_result));
    void log_kiojob_info(void *, const QString &, const QString &);
    void write(const QString &);

private:
    QFile log_file;
    QTextStream text_stream {&log_file};
    const QString time_format = QStringLiteral("HH:mm:ss.zzz"), line_separator = QStringLiteral("%1").arg('\n', INT8_MIN, QLatin1Char('-'));
};

inline void Logger::log_kiojob_info(void *, const QString &info_msg, const QString &) {write(info_msg);}
