/***********************************************************************
 *                                                                     *
 * Copyright 2016  Lorenzo Porta (Vindex17) <vindex17@outlook.it>      *
 *                                                                     *
 * This program is free software; you can redistribute it and/or       *
 * modify it under the terms of the GNU General Public License as      *
 * published by the Free Software Foundation; either version 3 of      *
 * the License or any later version accepted by the membership of      *
 * KDE e.V. (or its successor approved by the membership of KDE        *
 * e.V.), which shall act as a proxy defined in Section 14 of          *
 * version 3 of the license.                                           *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program. If not, see <http://www.gnu.org/licenses/> *
 *                                                                     *
 ***********************************************************************/


#include "logger.hxx"
#include "logger.moc"

#include <QTime>


Logger::~Logger()
{
    log_file.close();
    if (Q_UNLIKELY(log_file.size() == 0))
        log_file.remove();
}


bool Logger::open_file(const QString &file_name)
{
    log_file.setFileName(file_name);
    return log_file.open(QFile::Text | QFile::WriteOnly);
}


void Logger::write(const QString &msg)
{
    text_stream << '[' << QTime::currentTime().toString(time_format) << "] " << msg.trimmed() << line_separator << endl;
}
