/***********************************************************************
 *                                                                     *
 * Copyright 2016  Lorenzo Porta (Vindex17) <vindex17@outlook.it>      *
 *                                                                     *
 * This program is free software; you can redistribute it and/or       *
 * modify it under the terms of the GNU General Public License as      *
 * published by the Free Software Foundation; either version 3 of      *
 * the License or any later version accepted by the membership of      *
 * KDE e.V. (or its successor approved by the membership of KDE        *
 * e.V.), which shall act as a proxy defined in Section 14 of          *
 * version 3 of the license.                                           *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program. If not, see <http://www.gnu.org/licenses/> *
 *                                                                     *
 ***********************************************************************/


#pragma once


#include <QGroupBox>
#include <QListWidget>
#include <QMimeDatabase>
#include <QUrl>


struct ExclusionWidget : public QGroupBox
{
    explicit ExclusionWidget();
    Q_DISABLE_COPY(ExclusionWidget)

    QList<QRegularExpression> pcre_list() __attribute__((always_inline,warn_unused_result)); // keep it as QList in order to save them in profiles
    QList<QUrl> urls_to_exclude_list() __attribute__((always_inline,warn_unused_result)); // keep it as QList in order to save them in profiles
    void restore(const QList<QString>&&, const QList<QUrl>&&);

private:
    QHash<QListWidgetItem*,QRegularExpression> pcre_hash;
    QHash<QListWidgetItem*,QUrl> urls_to_exclude_hash;
    QListWidget* const listwidget = new QListWidget;

    void add_directory();
    void add_files();
    void add_pcre();
    void clear();
    void enable_list(const bool&);
    void remove_items();
};

inline QList<QRegularExpression> ExclusionWidget::pcre_list() {return pcre_hash.values();}

inline QList<QUrl> ExclusionWidget::urls_to_exclude_list() {return urls_to_exclude_hash.values();}


__attribute__((always_inline)) inline QIcon icon_for(const QUrl &url) {static const QMimeDatabase mime_db; return QIcon::fromTheme(mime_db.mimeTypeForUrl(url).iconName());}
