/*
 * Copyright (c) 2014 Patrick P. Frey
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */
/// \brief Exported functions of the strus module loader library
/// \file module.hpp
#ifndef _STRUS_LIB_MODULE_HPP_INCLUDED
#define _STRUS_LIB_MODULE_HPP_INCLUDED

/// \brief strus toplevel namespace
namespace strus {

/// \brief Forward declaration
class ModuleLoaderInterface;
/// \brief Forward declaration
class ErrorBufferInterface;

/// \brief Create a module loader interface with the functions needed for creating strus objects.
/// \return the allocated module loader interface
ModuleLoaderInterface* createModuleLoader( ErrorBufferInterface* errorhnd);

}//namespace
#endif

