#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2016 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxwtmpdel.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=5

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

EX_USER=$1
#EX_PID=$2
NXDISPLAY=$3
NXREMOTEIP=$4
NXUSER=$5

if test "x${EX_USER}" = "x"; then
  errorMsg "Username cannot be empty." "1"
elif test "${EX_USER}" != "nx"; then
  errorMsg "Wrong username ${EX_USER}." "1"
fi

if test "x${NXDISPLAY}" = "x"; then
  errorMsg "Argument display cannot be empty." "1"
fi

if test "x${NXREMOTEIP}" = "x"; then
  errorMsg "Argument address cannot be empty." "1"
fi

if test "x${NXUSER}" = "x"; then
  errorMsg "Argument username cannot be empty." "1"
fi

tmp=`${COMMAND_AWK} -F '"' '/^ *CommandSessreg/ {print $2}' "${SERVER_CONFIG_FILE}"`
if [ "x$tmp" = "x" ]; then
  tmp=`${COMMAND_AWK} -F ' ' '/^ *CommandSessreg/ {print $2}' "${SERVER_CONFIG_FILE}"`
fi

if test "x${tmp}" != "x"; then
  if test -f "${tmp}"; then
    COMMAND_SESSREG="${tmp}"
  else
    errorMsg "File '$tmp' doesn't exist." "1"
  fi
else
  errorMsg "Cannot update wtmp/utmp db: sessreg not defined." "1"
fi

if test ! -x "${COMMAND_SESSREG}" ; then
  errorCommandNotFound "${COMMAND_SESSREG}" "1"
fi

exec "${COMMAND_SESSREG}" -d -l "nx:${NXDISPLAY}" -h ${NXREMOTEIP} ${NXUSER}
