#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2016 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxlsof.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT_MIN=3
PARAMS_COUNT_MAX=3

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

getNXRoot

if test -x "/bin/lsof"; then
  COMMAND_LSOF="/bin/lsof"
elif test -x "/usr/bin/lsof"; then
  COMMAND_LSOF="/usr/bin/lsof"
elif test -x "/usr/sbin/lsof"; then
  COMMAND_LSOF="/usr/sbin/lsof"
else
  errorCommandNotFound "lsof" "1"
fi

${COMMAND_LSOF} -p $3 -bMw

