#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2016 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxhost.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=8

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

MODE="$3"
COMMAND_XHOST="$4"
USERNAME="$5"
REQ_USERNAME="$6"
DISPLAY="$7"
GLOBALXAUTHORITY="$8"

if test "x${COMMAND_XHOST}" = "x"; then
  errorMsg "Missing command xhost parameter." "1"
fi

if test "x${MODE}" = "xdel"; then
  OPERATION="-si"
else
  OPERATION="+si"
fi

if test ! -x ${COMMAND_XHOST}; then
  errorCommandNotFound "${COMMAND_XHOST}" "1"
fi

if test "x$GLOBALXAUTHORITY" != "x"; then
  command=`XAUTHORITY=${GLOBALXAUTHORITY} DISPLAY=:${DISPLAY} ${COMMAND_XHOST} ${OPERATION}:localuser:${REQ_USERNAME} 2>&1`
  if test $? -ne 0; then
    errorMsg "Cannot add user: ${REQ_USERNAME} to the access list: ${command}." "1"
  else
    command=`XAUTHORITY=${GLOBALXAUTHORITY} DISPLAY=:${DISPLAY} ${COMMAND_XHOST} ${OPERATION}:localuser:nx 2>&1`
    if test $? -eq 0; then
      ${COMMAND_ECHO} "xhost success"
    fi
  fi
else
  command=`${COMMAND_SU} - ${USERNAME} -c "DISPLAY=:${DISPLAY} ${COMMAND_XHOST} ${OPERATION}:localuser:${REQ_USERNAME} 2>&1"`
  if test $? -ne 0; then
    errorMsg "Cannot add user: ${REQ_USERNAME} to the access list: ${command}." "1"
  else
    command=`${COMMAND_SU} - ${USERNAME} -c "DISPLAY=:${DISPLAY} ${COMMAND_XHOST} ${OPERATION}:localuser:nx 2>&1"`
    if test "$?" -eq 0; then
      ${COMMAND_ECHO} "xhost success"
    fi
  fi
fi
