#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2016 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxfwget.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=4

. "${RestrictedDir}"/nxfunct.sh

isRunByServerOrNode

UTILITY="$3"

CHAIN="$4"

COMMAND="none"

if [ "x$UTILITY" = "xiptables" ];
then
  if [ -x "/bin/iptables" ];
  then
    COMMAND="/bin/iptables"
  elif [ -x "/sbin/iptables" ];
  then
    COMMAND="/sbin/iptables"

  elif [ -x "/usr/bin/iptables" ];
  then
    COMMAND="/usr/bin/iptables"
  elif [ -x "/usr/sbin/iptables" ];
  then
    COMMAND="/usr/sbin/iptables"
  elif [ -x "/usr/local/bin/iptables" ];
  then
    COMMAND="/usr/local/bin/iptables"
  elif [ -x "/usr/local/sbin/iptables" ];
  then
    COMMAND="/usr/local/sbin/iptables"
  fi
elif [ "x$UTILITY" = "xufw" ];
then
  if [ -x "/bin/ufw" ];
  then
    COMMAND="/bin/ufw"
  elif [ -x "/sbin/ufw" ];
  then
    COMMAND="/sbin/ufw"

  elif [ -x "/usr/bin/ufw" ];
  then
    COMMAND="/usr/bin/ufw"
  elif [ -x "/usr/sbin/ufw" ];
  then
    COMMAND="/usr/sbin/ufw"
  elif [ -x "/usr/local/bin/ufw" ];
  then
    COMMAND="/usr/local/bin/ufw"
  elif [ -x "/usr/local/sbin/ufw" ];
  then
    COMMAND="/usr/local/sbin/ufw"
  fi
else
  exit 1
fi

if [ "$COMMAND" = "none" ];
then
  exit 1
fi

RET=1

if [ "x$UTILITY" = "xiptables" ];
then
  ${COMMAND} -L $CHAIN -n --line-numbers
  RET=$?
else
  ${COMMAND} status
  RET=$?
fi

exit $RET
