#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2016 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxtmpperm.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=2

. "${RestrictedDir}"/nxfunct.sh

isRunByNode

ice_dir=/tmp/.ICE-unix;
x11_dir=/tmp/.X11-unix;

for dirname in ${ice_dir} ${x11_dir} ; do
{
  if test ! -d ${dirname}; then
    ${COMMAND_MKDIR} ${dirname}
    if test $? != 0; then
     errorMsg "Cannot create directory: ${dirname}."
    fi
  fi

  if test ! -O ${dirname}; then
    getRootGName
    ${COMMAND_CHOWN} root:${ROOTGNAME} ${dirname}
    if test $? != 0; then
      errorMsg "Cannot chown ${dirname}." "1"
    fi
  fi

  ${COMMAND_CHMOD} 1777 ${dirname}
  if test $? != 0; then
    errorMsg "Cannot chmod ${dirname}." "1"
  fi
}
done

if test -x /sbin/restorecon; then
  /sbin/restorecon -v ${x11_dir}
fi

