#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2016 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxprinteradd.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT_MIN=6
PARAMS_COUNT_MAX=9

. "${RestrictedDir}"/nxfunct.sh

isRunByNode

LPADMIN_TIMEOUT=40

USER=$3
NAME=$4
MODEL=$5
PUBLIC=$6
DESCRIPTION=$7
LOCATION=$8
PRINTER_IS_SHARED=$9

isEnabledCUPSSupport

getCUPSSbin

EXS_USER=`${COMMAND_WHOAMI}`

if test "x${USER}" = "x"; then
  errorMsg "Argument username cannot be empty." "1"
fi

if test ${PARENT_USER} != ${USER} -o ${EXS_USER} != ${USER}; then
  errorMsg "You can add or delete printer only for yourself." "1"
fi

if test "x${NAME}" = "x"; then
  errorMsg "Argument printer name cannot be empty." "1"
fi

if test $# -ge 6; then

  if test "x${MODEL}" = "x"; then
    errorMsg "Argument driver name cannot be empty." "1"
  fi

  if test "x${PUBLIC}" = "x"; then
    errorMsg "Argument public cannot be empty." "1"
  fi
fi

read DEVICE_URI
if test "${PUBLIC}" = "1"; then
  PUBLIC=""
else
  PUBLIC="-u allow:${USER}"
fi

if test -f "${MODEL}"; then
  DRVSWITCH="-P"
else
  DRVSWITCH="-m"
fi

if test "x${DESCRIPTION}" = "x"; then
  DESCRIPTION=" "
fi

if test "x${LOCATION}" = "x"; then
  LOCATION=" "
fi

if test "x${PRINTER_IS_SHARED}" = "x"; then
  PRINTER_IS_SHARED="true"
fi

#export GATEWAY_INTERFACE="CGI/1.1"

${LPADMIN} -p "${NAME}" -E -v "${DEVICE_URI}" ${DRVSWITCH} "${MODEL}" ${PUBLIC} -D "${DESCRIPTION}" -L "${LOCATION}" -o "printer-is-shared=${PRINTER_IS_SHARED}" &
lpPid=$!

(
  i=${LPADMIN_TIMEOUT}
  while [ $i -gt 0 ]; do
    ${COMMAND_KILL} -0 ${lpPid} 2>/dev/null
    if test $? -ne 0; then
      exit
    fi
    i=`${COMMAND_EXPR} $i - 1`
    if test $i -gt 30; then
      ${COMMAND_SLEEP} 0.1
    else
      ${COMMAND_SLEEP} 1
    fi
  done
  errorMsg "Timeout of ${LPADMIN_TIMEOUT} seconds when running lpadmin: killing lpadmin."
  ${COMMAND_KILL} -9 ${lpPid} 2>/dev/null
) &

wait ${lpPid} 2>/dev/null
