#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2016 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxmountiso.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=2

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

getNXRoot

MOUNT_DIR="${NX_ROOT}/var/cloud/content"
MOUNT="mount"
COMMAND_SHARE_MOUNT="/bin/${MOUNT}"

if test ! -x "${COMMAND_SHARE_MOUNT}"; then
  if test -x "/sbin/${MOUNT}"; then
    COMMAND_SHARE_MOUNT="/sbin/${MOUNT}"
  elif test -x "/usr/sbin/${MOUNT}"; then
    COMMAND_SHARE_MOUNT="/usr/sbin/${MOUNT}"
  elif test -x "/usr/bin/${MOUNT}"; then
    COMMAND_SHARE_MOUNT="/usr/bin/${MOUNT}"
  elif test -x "/usr/local/bin/${MOUNT}"; then
    COMMAND_SHARE_MOUNT="/usr/local/bin/${MOUNT}"
  elif test -x "/usr/local/sbin/${MOUNT}"; then
    COMMAND_SHARE_MOUNT="/usr/local/sbin/${MOUNT}"
  else
    errorMsg "Cannot mount iso, missing command ${COMMAND_SHARE_MOUNT}" "1"
  fi
fi

SHARE=`${COMMAND_LS} /dev/disk/by-id/*NoMachineDisk* 2>&1`

if test $? == 0; then
  exec "${COMMAND_SHARE_MOUNT}" "${SHARE}" "${MOUNT_DIR}"
else
  exit 1
fi
