#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2016 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxmountadd.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=7

. "${RestrictedDir}"/nxfunct.sh

isRunByNode

COMMAND_SHARE_MOUNT="/bin/$7"

SHARE=`${COMMAND_ECHO} $3 | ${COMMAND_SED} -e 's/'%28'/\(/g' | ${COMMAND_SED} -e 's/'%29'/\)/g'`
SHARE=`${COMMAND_ECHO} ${SHARE} | ${COMMAND_SED} -e 's/'%5B'/\[/g' | ${COMMAND_SED} -e 's/'%5D'/\]/g'`

MOUNT_DIR=`${COMMAND_ECHO} $4 | ${COMMAND_SED} -e 's/'%28'/\(/g' | ${COMMAND_SED} -e 's/'%29'/\)/g'`
MOUNT_DIR=`${COMMAND_ECHO} ${MOUNT_DIR} | ${COMMAND_SED} -e 's/'%5B'/\[/g' | ${COMMAND_SED} -e 's/'%5D'/\]/g'`

if test ! -x "${COMMAND_SHARE_MOUNT}"; then
  if test -x "/sbin/$7"; then
    COMMAND_SHARE_MOUNT="/sbin/$7"
  elif test -x "/usr/sbin/$7"; then
    COMMAND_SHARE_MOUNT="/usr/sbin/$7"
  elif test -x "/usr/bin/$7"; then
    COMMAND_SHARE_MOUNT="/usr/bin/$7"
  elif test -x "/usr/local/bin/$7"; then
    COMMAND_SHARE_MOUNT="/usr/local/bin/$7"
  elif test -x "/usr/local/sbin/$7"; then
    COMMAND_SHARE_MOUNT="/usr/local/sbin/$7"
  else
    errorMsg "Cannot mount share ${SHARE}, missing command ${COMMAND_SHARE_MOUNT} in ${PATH}. Cannot use NX smb privilegd script to mount shares." "1"
  fi
fi

if test -x "/bin/stat"; then
  COMMAND_STAT="/bin/stat"
elif test -x "/usr/bin/stat"; then
  COMMAND_STAT="/usr/bin/stat"
elif test -x "/usr/local/bin/stat"; then
  COMMAND_STAT="/usr/local/bin/stat"
else
  errorMsg "Cannot stat owner of ${MOUNT_DIR}, missing command ${COMMAND_STAT} in ${PATH}. Cannot use NX smb privilegd script to mount share ${SHARE}" "1"
fi

MYSHARE=`${COMMAND_GREP} '^ *SHARE_BASE_PATH' "${NODE_CONFIG_FILE}"|${COMMAND_SED} -e 's|SHARE_BASE_PATH *||g'|${COMMAND_SED} -e 's|\"||g'|${COMMAND_SED} -e 's|\$(HOME)|'${HOME}'|g'|${COMMAND_SED} -e 's|\$(USER)|'${USER}'|g'`
if test $? != 0; then
  MYSHARE="${HOME}/MyShares"
fi

path_1="${MYSHARE}"
path_2="${MOUNT_DIR}"

if test ! -d  "${path_2}"; then
  errorMsg "Path: ${path_2} does not exist or is not a directory." "1"
else
  path_3=`cd "${path_2}" && /bin/pwd -P`
  if ! ${COMMAND_ECHO} ${path_3} | ${COMMAND_GREP} -q "^${path_1}"; then
   errorMsg "Mount not allowed in ${path_3} . Mount allowed only in ${path_1}." "1"
  fi
fi

outCommand=`${COMMAND_STAT} --version 2>&1 `

if test $? != 0; then
  OWNER=`${COMMAND_LS} -lLd  "${path_2}" | ${COMMAND_AWK} '{ print $SHARE }' `
else
  OWNER=`${COMMAND_STAT} -L -c %U "${path_2}"`
fi

if test "x${OWNER}" != "x$1"; then
  errorMsg "${path_3} is owned by ${OWNER} instead of ${USER}."
  errorMsg "Cannot mount share in ${path_3}: permission denied." "1"
else
  exec "${COMMAND_SHARE_MOUNT}" "${SHARE}" "${MOUNT_DIR}" "$5" "$6"
fi
