# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.NOX is the python interface to the Trilinos nonlinear
solver package NOX:

    http://trilinos.sandia.gov/packages/nox

The purpose of NOX is to provide robust nonlinear solvers for the
problem of finding x such that F(x)=0.  In C++, NOX supports several
namespaces, some of which are sub-modules in python:

    * Abstract          - Base classes for abstract interface to NOX
    * Epetra            - Epetra implementation
    * Epetra.Interface  - Concrete interface for Epetra
    * Solver            - Solver manager class and supporting utilities
    * StatusTest        - Support for customizable stopping criteria

The top-level NOX module provides the following user-level class:

    * Utils  - Various utilities

For an example of usage of all of NOX, please consult the following
script in the example subdirectory of the PyTrilinos package:

    * exNOX_1Dfem.py

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '___init__')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('___init__')
    ___init__ = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('___init__', [dirname(__file__)])
        except ImportError:
            import ___init__
            return ___init__
        try:
            _mod = imp.load_module('___init__', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    ___init__ = swig_import_helper()
    del swig_import_helper
else:
    import ___init__
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_SwigPyIterator

    def value(self):
        """value(SwigPyIterator self) -> PyObject *"""
        return ___init__.SwigPyIterator_value(self)


    def incr(self, n=1):
        """
        incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        incr(SwigPyIterator self) -> SwigPyIterator
        """
        return ___init__.SwigPyIterator_incr(self, n)


    def decr(self, n=1):
        """
        decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        decr(SwigPyIterator self) -> SwigPyIterator
        """
        return ___init__.SwigPyIterator_decr(self, n)


    def distance(self, x):
        """distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return ___init__.SwigPyIterator_distance(self, x)


    def equal(self, x):
        """equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return ___init__.SwigPyIterator_equal(self, x)


    def copy(self):
        """copy(SwigPyIterator self) -> SwigPyIterator"""
        return ___init__.SwigPyIterator_copy(self)


    def next(self):
        """next(SwigPyIterator self) -> PyObject *"""
        return ___init__.SwigPyIterator_next(self)


    def __next__(self):
        """__next__(SwigPyIterator self) -> PyObject *"""
        return ___init__.SwigPyIterator___next__(self)


    def previous(self):
        """previous(SwigPyIterator self) -> PyObject *"""
        return ___init__.SwigPyIterator_previous(self)


    def advance(self, n):
        """advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return ___init__.SwigPyIterator_advance(self, n)


    def __eq__(self, x):
        """__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return ___init__.SwigPyIterator___eq__(self, x)


    def __ne__(self, x):
        """__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return ___init__.SwigPyIterator___ne__(self, x)


    def __iadd__(self, n):
        """__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return ___init__.SwigPyIterator___iadd__(self, n)


    def __isub__(self, n):
        """__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return ___init__.SwigPyIterator___isub__(self, n)


    def __add__(self, n):
        """__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return ___init__.SwigPyIterator___add__(self, n)


    def __sub__(self, *args):
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return ___init__.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = ___init__.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

import PyTrilinos.Teuchos
Have_Epetra = ___init__.Have_Epetra

def version(*args):
    """version() -> std::string"""
    return ___init__.version(*args)

__version__ = version().split()[2]

class Utils(_object):
    """Proxy of C++ NOX::Utils class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Utils, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Utils, name)
    __repr__ = _swig_repr
    Error = ___init__.Utils_Error
    Warning = ___init__.Utils_Warning
    OuterIteration = ___init__.Utils_OuterIteration
    InnerIteration = ___init__.Utils_InnerIteration
    Parameters = ___init__.Utils_Parameters
    Details = ___init__.Utils_Details
    OuterIterationStatusTest = ___init__.Utils_OuterIterationStatusTest
    LinearSolverDetails = ___init__.Utils_LinearSolverDetails
    TestDetails = ___init__.Utils_TestDetails
    StepperIteration = ___init__.Utils_StepperIteration
    StepperDetails = ___init__.Utils_StepperDetails
    StepperParameters = ___init__.Utils_StepperParameters
    Debug = ___init__.Utils_Debug

    def fill(*args):
        """fill(int filln, char fillc) -> Fill"""
        return ___init__.Utils_fill(*args)

    fill = staticmethod(fill)

    def __init__(self, *args):
        """
        __init__(NOX::Utils self, int outputInformation=0xf, int MyPID=0, int outputProcess=0, int outputPrecision=3, Teuchos::RCP< std::ostream > const & outputStream, Teuchos::RCP< std::ostream > const & errorStream) -> Utils
        __init__(NOX::Utils self, ParameterList p) -> Utils
        __init__(NOX::Utils self, Utils u) -> Utils
        """
        this = ___init__.new_Utils(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_Utils

    def reset(self, *args):
        """reset(Utils self, ParameterList p)"""
        return ___init__.Utils_reset(self, *args)


    def isPrintType(self, *args):
        """isPrintType(Utils self, NOX::Utils::MsgType type) -> bool"""
        return ___init__.Utils_isPrintType(self, *args)


    def out(self, *args):
        """
        out(Utils self) -> std::ostream
        out(Utils self, NOX::Utils::MsgType type) -> std::ostream &
        """
        return ___init__.Utils_out(self, *args)


    def pout(self, *args):
        """
        pout(Utils self) -> std::ostream
        pout(Utils self, NOX::Utils::MsgType type) -> std::ostream &
        """
        return ___init__.Utils_pout(self, *args)


    def err(self, *args):
        """err(Utils self) -> std::ostream &"""
        return ___init__.Utils_err(self, *args)


    def perr(self, *args):
        """perr(Utils self) -> std::ostream &"""
        return ___init__.Utils_perr(self, *args)


    def _print(self, *args):
        """_print(Utils self, std::ostream & os)"""
        return ___init__.Utils__print(self, *args)


    def sciformat(*args):
        """
        sciformat(double dval) -> Sci
        sciformat(double dval, int prec) -> Sci
        """
        return ___init__.Utils_sciformat(*args)

    sciformat = staticmethod(sciformat)
Utils_swigregister = ___init__.Utils_swigregister
Utils_swigregister(Utils)

def Utils_fill(*args):
    """Utils_fill(int filln, char fillc) -> Fill"""
    return ___init__.Utils_fill(*args)

def Utils_sciformat(*args):
    """
    sciformat(double dval) -> Sci
    Utils_sciformat(double dval, int prec) -> Sci
    """
    return ___init__.Utils_sciformat(*args)

class Fill(_object):
    """Proxy of C++ NOX::Utils::Fill class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Fill, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Fill, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(NOX::Utils::Fill self, int ntimes, char ch) -> Fill"""
        this = ___init__.new_Fill(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_Fill
    __swig_setmethods__["n"] = ___init__.Fill_n_set
    __swig_getmethods__["n"] = ___init__.Fill_n_get
    if _newclass:
        n = _swig_property(___init__.Fill_n_get, ___init__.Fill_n_set)
    __swig_setmethods__["c"] = ___init__.Fill_c_set
    __swig_getmethods__["c"] = ___init__.Fill_c_get
    if _newclass:
        c = _swig_property(___init__.Fill_c_get, ___init__.Fill_c_set)
Fill_swigregister = ___init__.Fill_swigregister
Fill_swigregister(Fill)

class Sci(_object):
    """Proxy of C++ NOX::Utils::Sci class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sci, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Sci, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(NOX::Utils::Sci self, double val, int precision=-1) -> Sci"""
        this = ___init__.new_Sci(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_Sci
    __swig_setmethods__["d"] = ___init__.Sci_d_set
    __swig_getmethods__["d"] = ___init__.Sci_d_get
    if _newclass:
        d = _swig_property(___init__.Sci_d_get, ___init__.Sci_d_set)
    __swig_setmethods__["p"] = ___init__.Sci_p_set
    __swig_getmethods__["p"] = ___init__.Sci_p_get
    if _newclass:
        p = _swig_property(___init__.Sci_p_get, ___init__.Sci_p_set)
Sci_swigregister = ___init__.Sci_swigregister
Sci_swigregister(Sci)


def __lshift__(*args):
    """
    __lshift__(std::ostream & arg1, Fill arg2) -> std::ostream
    __lshift__(std::ostream & arg1, Sci arg2) -> std::ostream
    __lshift__(std::ostream & arg1, Utils utils) -> std::ostream &
    """
    return ___init__.__lshift__(*args)


# Import sys module
import sys

# Abstract, Solver, and StatusTest namespaces
__all__ = ['Abstract', 'Solver', 'StatusTest']
import Abstract
import Solver
import StatusTest



# Epetra namespace
__all__.append('Epetra')
from . import Epetra
sys.modules["PyTrilinos.NOX.Epetra.___init__"] = sys.modules["___init__"]
del sys.modules["___init__"]

# This file is compatible with both classic and new-style classes.


