# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.NOX.Epetra.Interface is the python interface to the
Epetra::Interface namespace of the Trilinos package NOX:

    http://trilinos.sandia.gov/packages/nox

The purpose of NOX.Epetra.Interface is to provide base classes the
user should derive from in order to define the nonlinear function to
be solved, and if needed, its Jacobian and the desired preconditioner.

NOX.Epetra.Interface provides the following user-level classes:

    * Required        - Required class for computing the nonlinear function
    * Jacobian        - Class for computing the Jacobian (if needed)
    * Preconditioner  - Class for computing the preconditioner (if needed)

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Interface')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Interface')
    _Interface = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Interface', [dirname(__file__)])
        except ImportError:
            import _Interface
            return _Interface
        try:
            _mod = imp.load_module('_Interface', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Interface = swig_import_helper()
    del swig_import_helper
else:
    import _Interface
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Interface.delete_SwigPyIterator

    def value(self):
        return _Interface.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _Interface.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _Interface.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _Interface.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _Interface.SwigPyIterator_equal(self, x)

    def copy(self):
        return _Interface.SwigPyIterator_copy(self)

    def next(self):
        return _Interface.SwigPyIterator_next(self)

    def __next__(self):
        return _Interface.SwigPyIterator___next__(self)

    def previous(self):
        return _Interface.SwigPyIterator_previous(self)

    def advance(self, n):
        return _Interface.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _Interface.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _Interface.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _Interface.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _Interface.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _Interface.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _Interface.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _Interface.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

import PyTrilinos.Teuchos
import PyTrilinos.Epetra
class Required(_object):
    """Proxy of C++ NOX::Epetra::Interface::Required class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Required, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Required, name)
    __repr__ = _swig_repr
    Residual = _Interface.Required_Residual
    Jac = _Interface.Required_Jac
    Prec = _Interface.Required_Prec
    FD_Res = _Interface.Required_FD_Res
    MF_Res = _Interface.Required_MF_Res
    MF_Jac = _Interface.Required_MF_Jac
    User = _Interface.Required_User

    def __init__(self, *args):
        """__init__(NOX::Epetra::Interface::Required self) -> Required"""
        if self.__class__ == Required:
            _self = None
        else:
            _self = self
        this = _Interface.new_Required(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Interface.delete_Required

    def computeF(self, *args):
        """
        computeF(self, Epetra.Vector x, Epetra.Vector F, FillType flag) -> bool

          Virtual method in C++ that is intended to be overridden by user.
          This method defines the nonlinear function to be solved.  Arguments
          x and F will be provided as numpy-hybrid Epetra.Vector objects.
          Return True if the computation is successful.

          It is strongly recommended that computeF() not raise any exceptions,
          accidental or otherwise.  This can be prevented by wrapping your
          algorithm in a try block:

            try:
              # Your code here...
            except Exception, e:
              print 'Python exception raised in computeF():'
              print e
              return False

          By returning False, you tell NOX that computeF() was unsuccessful.

        """
        return _Interface.Required_computeF(self, *args)

    def __disown__(self):
        self.this.disown()
        _Interface.disown_Required(self)
        return weakref_proxy(self)
Required_swigregister = _Interface.Required_swigregister
Required_swigregister(Required)

class Jacobian(_object):
    """Proxy of C++ NOX::Epetra::Interface::Jacobian class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Jacobian, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Jacobian, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(NOX::Epetra::Interface::Jacobian self) -> Jacobian"""
        if self.__class__ == Jacobian:
            _self = None
        else:
            _self = self
        this = _Interface.new_Jacobian(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Interface.delete_Jacobian

    def computeJacobian(self, *args):
        """computeJacobian(Jacobian self, Vector x, Operator Jac) -> bool"""
        return _Interface.Jacobian_computeJacobian(self, *args)

    def __disown__(self):
        self.this.disown()
        _Interface.disown_Jacobian(self)
        return weakref_proxy(self)
Jacobian_swigregister = _Interface.Jacobian_swigregister
Jacobian_swigregister(Jacobian)

class Preconditioner(_object):
    """Proxy of C++ NOX::Epetra::Interface::Preconditioner class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Preconditioner, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Preconditioner, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(NOX::Epetra::Interface::Preconditioner self) -> Preconditioner"""
        if self.__class__ == Preconditioner:
            _self = None
        else:
            _self = self
        this = _Interface.new_Preconditioner(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Interface.delete_Preconditioner

    def computePreconditioner(self, *args):
        """computePreconditioner(Preconditioner self, Vector x, Operator M, ParameterList precParams=None) -> bool"""
        return _Interface.Preconditioner_computePreconditioner(self, *args)

    def __disown__(self):
        self.this.disown()
        _Interface.disown_Preconditioner(self)
        return weakref_proxy(self)
Preconditioner_swigregister = _Interface.Preconditioner_swigregister
Preconditioner_swigregister(Preconditioner)

# This file is compatible with both classic and new-style classes.


