# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.ML is the python interface to the Trilinos multi-level
preconditioner package ML/MLAPI:

    http://trilinos.sandia.gov/packages/ml

The purpose of ML is to provide multilevel preconditioners to
Trilinos.

ML provides the following user-level classes:

    * BaseObject                - Base class for MLAPI objects
    * CompObject                - FLOP counting base class
    * TimeObject                - Timing base class
    * MultiLevelPreconditioner  - Black-box multilevel preconditioner
    * EpetraBaseOperator        - Base class for interface to Epetra
    * BaseOperator              - Base class for all MLAPI operators
    * Space                     - Defines number of elements and their distribution
    * MultiVector               - MLAPI multivector class
    * Operator                  - MLAPI operator class
    * InverseOperator           - MLAPI inverse operator class
    * PyMatrix                  - Python interface to MLAPI operators

For examples of usage, please consult the following scripts in the
example subdirectory of the PyTrilinos package:

    * exMLAPI.py
    * exMLAPI_Simple.py
    * exMLAPI_AztecOO.py
    * exMLAPI_Iterate.py
    * exMLAPI_PyMatrix.py
    * exMLAPI_Smoother.py

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_ML')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_ML')
    _ML = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_ML', [dirname(__file__)])
        except ImportError:
            import _ML
            return _ML
        try:
            _mod = imp.load_module('_ML', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _ML = swig_import_helper()
    del swig_import_helper
else:
    import _ML
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos
import PyTrilinos.Epetra

import Epetra

HAVE_INTTYPES_H = _ML.HAVE_INTTYPES_H
HAVE_STDINT_H = _ML.HAVE_STDINT_H

def GetML_Comm(*args):
    """GetML_Comm() -> ML_Comm *"""
    return _ML.GetML_Comm(*args)

def GetEpetra_Comm(*args):
    """GetEpetra_Comm() -> Comm"""
    return _ML.GetEpetra_Comm(*args)

def Barrier(*args):
    """Barrier()"""
    return _ML.Barrier(*args)

def GetMyPID(*args):
    """GetMyPID() -> int"""
    return _ML.GetMyPID(*args)

def GetNumProcs(*args):
    """GetNumProcs() -> int"""
    return _ML.GetNumProcs(*args)

def GetPrintLevel(*args):
    """GetPrintLevel() -> int"""
    return _ML.GetPrintLevel(*args)

def SetPrintLevel(*args):
    """SetPrintLevel(int Level)"""
    return _ML.SetPrintLevel(*args)

def Init(*args):
    """Init()"""
    return _ML.Init(*args)

def Finalize(*args):
    """Finalize()"""
    return _ML.Finalize(*args)

def GetString(*args):
    """
    GetString(int const & x) -> std::string
    GetString(double const & x) -> std::string
    """
    return _ML.GetString(*args)

def GetMatrixType(*args):
    """GetMatrixType() -> int"""
    return _ML.GetMatrixType(*args)
class BaseObject(_object):
    """Proxy of C++ MLAPI::BaseObject class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BaseObject, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BaseObject, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ML.delete_BaseObject

    def SetLabel(self, *args):
        """SetLabel(BaseObject self, std::string const & Label)"""
        return _ML.BaseObject_SetLabel(self, *args)


    def GetLabel(self, *args):
        """GetLabel(BaseObject self) -> std::string const &"""
        return _ML.BaseObject_GetLabel(self, *args)


    def Print(self, *args):
        """
        Print(self, file=None)

        Print a description of the object to the given file object.  If no
        file object is provided, output is to stdout.
        """
        return _ML.BaseObject_Print(self, *args)


    def __str__(self, *args):
        """
        __str__(self) -> str

        Return the description of the object as a string.
        """
        return _ML.BaseObject___str__(self, *args)

BaseObject_swigregister = _ML.BaseObject_swigregister
BaseObject_swigregister(BaseObject)


def __lshift__(*args):
    """__lshift__(std::ostream & os, BaseObject obj) -> std::ostream &"""
    return _ML.__lshift__(*args)
class Space(BaseObject):
    """Proxy of C++ MLAPI::Space class."""

    __swig_setmethods__ = {}
    for _s in [BaseObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Space, name, value)
    __swig_getmethods__ = {}
    for _s in [BaseObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Space, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(MLAPI::Space self) -> Space
        __init__(MLAPI::Space self, int const NumGlobalElements, int const NumMyElements=-1) -> Space
        __init__(MLAPI::Space self, Map Map) -> Space
        __init__(self, int numGlobalElements, sequence myGlobalElements) -> Space
        __init__(MLAPI::Space self, Space RHS) -> Space
        """
        this = _ML.new_Space(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ML.delete_Space

    def Reshape(self, *args):
        """
        Reshape(Space self)
        Reshape(Space self, int const NumGlobalElements, int const NumMyElements=-1)
        Reshape(Space self, int const NumGlobalElements, int const NumMyElements)
        """
        return _ML.Space_Reshape(self, *args)


    def __eq__(self, *args):
        """__eq__(Space self, Space RHS) -> bool"""
        return _ML.Space___eq__(self, *args)


    def __ne__(self, *args):
        """__ne__(Space self, Space RHS) -> bool"""
        return _ML.Space___ne__(self, *args)


    def __call__(self, *args):
        """__call__(Space self, int i) -> int"""
        return _ML.Space___call__(self, *args)


    def GetNumMyElements(self, *args):
        """GetNumMyElements(Space self) -> int"""
        return _ML.Space_GetNumMyElements(self, *args)


    def GetNumGlobalElements(self, *args):
        """GetNumGlobalElements(Space self) -> int"""
        return _ML.Space_GetNumGlobalElements(self, *args)


    def GetOffset(self, *args):
        """GetOffset(Space self) -> int"""
        return _ML.Space_GetOffset(self, *args)


    def IsLinear(self, *args):
        """IsLinear(Space self) -> bool"""
        return _ML.Space_IsLinear(self, *args)


    def GetMyGlobalElements(self, *args):
        """
        GetMyGlobalElements(self) -> Epetra.SerialDenseVector

        Return an Epetra.SerialDenseVector of global indexes representing the
        elements on this processor.  If the Space is distributed linearly,
        this method returns None.
        """
        return _ML.Space_GetMyGlobalElements(self, *args)

Space_swigregister = _ML.Space_swigregister
Space_swigregister(Space)


def Space_GetMyGlobalElements(*args):
    """
    GetMyGlobalElements(self) -> Epetra.SerialDenseVector

    Return an Epetra.SerialDenseVector of global indexes representing the
    elements on this processor.
    """
    result = _ML.Space_GetMyGlobalElements(*args)
    if result is None:
        offset = args[0].GetOffset()
        data   = range(offset, offset+args[0].GetNumMyElements())
        result = Epetra.IntSerialDenseVector(data)
    return result
Space.GetMyGlobalElements = Space_GetMyGlobalElements

class CompObject(_object):
    """Proxy of C++ MLAPI::CompObject class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CompObject, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CompObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(MLAPI::CompObject self) -> CompObject"""
        this = _ML.new_CompObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ML.delete_CompObject

    def GetFlops(self, *args):
        """GetFlops(CompObject self) -> double"""
        return _ML.CompObject_GetFlops(self, *args)


    def SetFlops(self, *args):
        """SetFlops(CompObject self, double Flops)"""
        return _ML.CompObject_SetFlops(self, *args)


    def UpdateFlops(self, *args):
        """UpdateFlops(CompObject self, double Flops)"""
        return _ML.CompObject_UpdateFlops(self, *args)

CompObject_swigregister = _ML.CompObject_swigregister
CompObject_swigregister(CompObject)

class TimeObject(_object):
    """Proxy of C++ MLAPI::TimeObject class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, TimeObject, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, TimeObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(MLAPI::TimeObject self) -> TimeObject"""
        this = _ML.new_TimeObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ML.delete_TimeObject

    def ResetTimer(self, *args):
        """ResetTimer(TimeObject self)"""
        return _ML.TimeObject_ResetTimer(self, *args)


    def UpdateTime(self, *args):
        """
        UpdateTime(TimeObject self)
        UpdateTime(TimeObject self, double t)
        """
        return _ML.TimeObject_UpdateTime(self, *args)


    def GetTime(self, *args):
        """GetTime(TimeObject self) -> double"""
        return _ML.TimeObject_GetTime(self, *args)

TimeObject_swigregister = _ML.TimeObject_swigregister
TimeObject_swigregister(TimeObject)

class BaseOperator(BaseObject):
    """Proxy of C++ MLAPI::BaseOperator class."""

    __swig_setmethods__ = {}
    for _s in [BaseObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BaseOperator, name, value)
    __swig_getmethods__ = {}
    for _s in [BaseObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BaseOperator, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _ML.delete_BaseOperator

    def Apply(self, *args):
        """Apply(BaseOperator self, MultiVector LHS, MultiVector RHS) -> int"""
        return _ML.BaseOperator_Apply(self, *args)


    def GetOperatorDomainSpace(self, *args):
        """GetOperatorDomainSpace(BaseOperator self) -> Space"""
        return _ML.BaseOperator_GetOperatorDomainSpace(self, *args)


    def GetOperatorRangeSpace(self, *args):
        """GetOperatorRangeSpace(BaseOperator self) -> Space"""
        return _ML.BaseOperator_GetOperatorRangeSpace(self, *args)


    def __init__(self, *args):
        """__init__(MLAPI::BaseOperator self) -> BaseOperator"""
        if self.__class__ == BaseOperator:
            _self = None
        else:
            _self = self
        this = _ML.new_BaseOperator(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    def __disown__(self):
        self.this.disown()
        _ML.disown_BaseOperator(self)
        return weakref_proxy(self)
BaseOperator_swigregister = _ML.BaseOperator_swigregister
BaseOperator_swigregister(BaseOperator)

class DoubleVector(_object):
    """Proxy of C++ MLAPI::DoubleVector class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DoubleVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DoubleVector, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(MLAPI::DoubleVector self, int const size) -> DoubleVector
        __init__(MLAPI::DoubleVector self, double * ptr) -> DoubleVector
        """
        this = _ML.new_DoubleVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ML.delete_DoubleVector

    def Values(self, *args):
        """
        Values(DoubleVector self) -> double
        Values(DoubleVector self) -> double const *
        """
        return _ML.DoubleVector_Values(self, *args)

DoubleVector_swigregister = _ML.DoubleVector_swigregister
DoubleVector_swigregister(DoubleVector)

class MultiVector(BaseObject, CompObject, TimeObject):
    """Proxy of C++ MLAPI::MultiVector class."""

    __swig_setmethods__ = {}
    for _s in [BaseObject, CompObject, TimeObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiVector, name, value)
    __swig_getmethods__ = {}
    for _s in [BaseObject, CompObject, TimeObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MultiVector, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _ML.delete_MultiVector

    def Reshape(self, *args):
        """
        Reshape(MultiVector self)
        Reshape(MultiVector self, Space S, int const NumVectors=1, bool const SetToZero=True)
        """
        return _ML.MultiVector_Reshape(self, *args)


    def Append(self, *args):
        """
        Append(MultiVector self, int const NumVectors=1, bool const SetToZero=True)
        Append(MultiVector self, MultiVector rhs)
        """
        return _ML.MultiVector_Append(self, *args)


    def Delete(self, *args):
        """
        Delete(self, int v)

        Deletes the v-th vector within the MultiVector.
        """
        return _ML.MultiVector_Delete(self, *args)


    def GetVectorSpace(self, *args):
        """
        GetVectorSpace(MultiVector self) -> Space
        GetVectorSpace(MultiVector self) -> Space
        """
        return _ML.MultiVector_GetVectorSpace(self, *args)


    def GetNumVectors(self, *args):
        """GetNumVectors(MultiVector self) -> int"""
        return _ML.MultiVector_GetNumVectors(self, *args)


    def GetMyLength(self, *args):
        """GetMyLength(MultiVector self) -> int"""
        return _ML.MultiVector_GetMyLength(self, *args)


    def GetGlobalLength(self, *args):
        """GetGlobalLength(MultiVector self) -> int"""
        return _ML.MultiVector_GetGlobalLength(self, *args)


    def GetValues(self, *args):
        """
        GetValues(self, int v) -> numpy.ndarray

        Returns a 1D numpy array representing the v-th vector in the
        MultiVector.
        """
        return _ML.MultiVector_GetValues(self, *args)


    def Update(self, *args):
        """
        Update(MultiVector self, double const alpha, int v=-1)
        Update(MultiVector self, MultiVector rhs)
        Update(MultiVector self, double alpha, MultiVector rhs)
        Update(MultiVector self, double alpha, MultiVector x, double beta, MultiVector y)
        Update(MultiVector self, double alpha, MultiVector rhs, double beta)
        """
        return _ML.MultiVector_Update(self, *args)


    def DotProduct(self, *args):
        """DotProduct(MultiVector self, MultiVector rhs, int v=-1) -> double"""
        return _ML.MultiVector_DotProduct(self, *args)


    def Norm2(self, *args):
        """Norm2(MultiVector self, int v=-1) -> double"""
        return _ML.MultiVector_Norm2(self, *args)


    def NormInf(self, *args):
        """NormInf(MultiVector self, int v=-1) -> double"""
        return _ML.MultiVector_NormInf(self, *args)


    def NormOne(self, *args):
        """NormOne(MultiVector self, int v=-1) -> double"""
        return _ML.MultiVector_NormOne(self, *args)


    def Reciprocal(self, *args):
        """Reciprocal(MultiVector self, int v=-1)"""
        return _ML.MultiVector_Reciprocal(self, *args)


    def Scale(self, *args):
        """Scale(MultiVector self, double const Factor, int v=-1)"""
        return _ML.MultiVector_Scale(self, *args)


    def Random(self, *args):
        """Random(MultiVector self, int v=-1)"""
        return _ML.MultiVector_Random(self, *args)


    def Sort(self, *args):
        """Sort(MultiVector self, int v=-1, bool const IsIncreasing=False)"""
        return _ML.MultiVector_Sort(self, *args)


    def IsAlias(self, *args):
        """IsAlias(MultiVector self, MultiVector rhs) -> bool"""
        return _ML.MultiVector_IsAlias(self, *args)


    def __init__(self, *args):
        """
        __init__(MLAPI::MultiVector self) -> MultiVector
        __init__(MLAPI::MultiVector self, Space VectorSpace, int const NumVectors=1, bool SetToZero=True) -> MultiVector
        __init__(MLAPI::MultiVector self, MultiVector rhs) -> MultiVector
        __init__(MLAPI::MultiVector self, Space vectorSpace, PyObject * pyValues) -> MultiVector
        """
        this = _ML.new_MultiVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __add__(self, *args):
        """
        __add__(self, MultiVector rhs) -> MultiVector

        Element-wise addition operator.
        """
        return _ML.MultiVector___add__(self, *args)


    def __sub__(self, *args):
        """
        __sub__(self, MultiVector rhs) -> MultiVector

        Element-wise subtraction operator.
        """
        return _ML.MultiVector___sub__(self, *args)


    def __mul__(self, *args):
        """
        __mul__(self, MultiVector rhs) -> float

          Dot-product multiplication operator.

        __mul__(MultiVector self, double const rhs) -> MultiVector
        __mul__(self, int rhs) -> MultiVector

          Scalar multiplication operators.
        """
        return _ML.MultiVector___mul__(self, *args)


    def __rmul__(self, *args):
        """
        __rmul__(MultiVector self, double const lhs) -> MultiVector
        __rmul__(self, int lhs) -> MultiVector

        Scalar 'reverse' multiplication operators.
        """
        return _ML.MultiVector___rmul__(self, *args)


    def __setitem__(self, *args):
        """
        __setitem__(self, PyObject index, int v, PyObject value)

        Argument index can be an integer or slice index into a vector.
        Argument v must be an integer specifying the desired vector within the
        MultiVector.  The value argument must have a shape that matches the
        shape of the index.
        """
        return _ML.MultiVector___setitem__(self, *args)


    def __getitem__(self, *args):
        """
        __getitem__(self, PyObject index, int v) -> PyObject

        Argument index can be an integer or slice index into a vector.
        Argument v must be an integer specifying the desired vector within the
        MultiVector.  The returned PyObject will be either a scalar or an
        array with the same shape as the index.
        """
        return _ML.MultiVector___getitem__(self, *args)


    def __call__(self, *args):
        """
        __call__(self, int i, int v=0) -> float

        Returns the i-th element of the v-th vector.
        """
        return _ML.MultiVector___call__(self, *args)

MultiVector_swigregister = _ML.MultiVector_swigregister
MultiVector_swigregister(MultiVector)


def Extract(*args):
    """Extract(MultiVector y, int const v) -> MultiVector"""
    return _ML.Extract(*args)

def Redistribute(*args):
    """Redistribute(MultiVector y, int const NumEquations) -> MultiVector"""
    return _ML.Redistribute(*args)
class Operator(BaseOperator, CompObject, TimeObject):
    """Proxy of C++ MLAPI::Operator class."""

    __swig_setmethods__ = {}
    for _s in [BaseOperator, CompObject, TimeObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Operator, name, value)
    __swig_getmethods__ = {}
    for _s in [BaseOperator, CompObject, TimeObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Operator, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(MLAPI::Operator self) -> Operator
        __init__(MLAPI::Operator self, Space DomainSpace, Space RangeSpace, ML_Operator * Op, bool Ownership=True, Teuchos::RefCountPtr< ML_Operator_Box > AuxOp) -> Operator
        __init__(MLAPI::Operator self, Space DomainSpace, Space RangeSpace, RowMatrix Matrix, bool Ownership=True, Teuchos::RefCountPtr< ML_Operator_Box > AuxOp) -> Operator
        __init__(MLAPI::Operator self, Operator RHS) -> Operator
        """
        this = _ML.new_Operator(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ML.delete_Operator

    def Reshape(self, *args):
        """
        Reshape(Operator self)
        Reshape(Operator self, Space DomainSpace, Space RangeSpace, ML_Operator * Op, bool Ownership=True, Teuchos::RefCountPtr< ML_Operator_Box > AuxOp)
        Reshape(Operator self, Space DomainSpace, Space RangeSpace, RowMatrix Matrix, bool Ownership=True, Teuchos::RefCountPtr< ML_Operator_Box > AuxOp)
        """
        return _ML.Operator_Reshape(self, *args)


    def GetOperatorDomainSpace(self, *args):
        """GetOperatorDomainSpace(Operator self) -> Space"""
        return _ML.Operator_GetOperatorDomainSpace(self, *args)


    def GetOperatorRangeSpace(self, *args):
        """GetOperatorRangeSpace(Operator self) -> Space"""
        return _ML.Operator_GetOperatorRangeSpace(self, *args)


    def GetDomainSpace(self, *args):
        """GetDomainSpace(Operator self) -> Space"""
        return _ML.Operator_GetDomainSpace(self, *args)


    def GetRangeSpace(self, *args):
        """GetRangeSpace(Operator self) -> Space"""
        return _ML.Operator_GetRangeSpace(self, *args)


    def GetColumnSpace(self, *args):
        """GetColumnSpace(Operator self) -> Space"""
        return _ML.Operator_GetColumnSpace(self, *args)


    def GetNumGlobalRows(self, *args):
        """GetNumGlobalRows(Operator self) -> int"""
        return _ML.Operator_GetNumGlobalRows(self, *args)


    def GetNumMyRows(self, *args):
        """GetNumMyRows(Operator self) -> int"""
        return _ML.Operator_GetNumMyRows(self, *args)


    def GetNumGlobalCols(self, *args):
        """GetNumGlobalCols(Operator self) -> int"""
        return _ML.Operator_GetNumGlobalCols(self, *args)


    def GetNumMyCols(self, *args):
        """GetNumMyCols(Operator self) -> int"""
        return _ML.Operator_GetNumMyCols(self, *args)


    def GetNumGlobalNonzeros(self, *args):
        """GetNumGlobalNonzeros(Operator self) -> int"""
        return _ML.Operator_GetNumGlobalNonzeros(self, *args)


    def GetNumMyNonzeros(self, *args):
        """GetNumMyNonzeros(Operator self) -> int"""
        return _ML.Operator_GetNumMyNonzeros(self, *args)


    def GetRowMatrix(self, *args):
        """GetRowMatrix(Operator self) -> RowMatrix"""
        return _ML.Operator_GetRowMatrix(self, *args)


    def GetML_Operator(self, *args):
        """GetML_Operator(Operator self) -> ML_Operator *"""
        return _ML.Operator_GetML_Operator(self, *args)


    def GetRCPOperatorBox(self, *args):
        """GetRCPOperatorBox(Operator self) -> Teuchos::RefCountPtr< ML_Operator_Box > const &"""
        return _ML.Operator_GetRCPOperatorBox(self, *args)


    def GetRCPAuxOperatorBox(self, *args):
        """GetRCPAuxOperatorBox(Operator self) -> Teuchos::RefCountPtr< ML_Operator_Box > const &"""
        return _ML.Operator_GetRCPAuxOperatorBox(self, *args)


    def GetRCPRowMatrix(self, *args):
        """GetRCPRowMatrix(Operator self) -> Teuchos::RefCountPtr< Epetra_RowMatrix > const &"""
        return _ML.Operator_GetRCPRowMatrix(self, *args)


    def GetGRID(self, *args):
        """GetGRID(Operator self, int const LRID) -> int"""
        return _ML.Operator_GetGRID(self, *args)


    def GetGCID(self, *args):
        """GetGCID(Operator self, int const LCID) -> int"""
        return _ML.Operator_GetGCID(self, *args)


    def Apply(self, *args):
        """Apply(Operator self, MultiVector X, MultiVector Y) -> int"""
        return _ML.Operator_Apply(self, *args)


    def BuildColumnSpace(self, *args):
        """BuildColumnSpace(Operator self)"""
        return _ML.Operator_BuildColumnSpace(self, *args)


    def __getitem__(self, *args):
        """__getitem__(Operator self, PyObject * args) -> PyObject *"""
        return _ML.Operator___getitem__(self, *args)


    def __add__(self, *args):
        """__add__(Operator self, Operator rhs) -> Operator"""
        return _ML.Operator___add__(self, *args)


    def __sub__(self, *args):
        """__sub__(Operator self, Operator rhs) -> Operator"""
        return _ML.Operator___sub__(self, *args)


    def __mul__(self, *args):
        """
        __mul__(Operator self, MultiVector rhs) -> MultiVector
        __mul__(Operator self, Operator rhs) -> Operator
        __mul__(Operator self, double const rhs) -> Operator
        """
        return _ML.Operator___mul__(self, *args)


    def __div__(self, *args):
        """__div__(Operator self, double const rhs) -> Operator"""
        return _ML.Operator___div__(self, *args)

Operator_swigregister = _ML.Operator_swigregister
Operator_swigregister(Operator)

class PyMatrix(Operator):
    """Proxy of C++ PyTrilinos::PyMatrix class."""

    __swig_setmethods__ = {}
    for _s in [Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PyMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PyMatrix, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(PyTrilinos::PyMatrix self, Space RowSpace, Space ColSpace) -> PyMatrix"""
        this = _ML.new_PyMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ML.delete_PyMatrix

    def GetRowSpace(self, *args):
        """GetRowSpace(PyMatrix self) -> Space"""
        return _ML.PyMatrix_GetRowSpace(self, *args)


    def SetElement(self, *args):
        """SetElement(PyMatrix self, int row, int col, double value)"""
        return _ML.PyMatrix_SetElement(self, *args)


    def FillComplete(self, *args):
        """FillComplete(PyMatrix self)"""
        return _ML.PyMatrix_FillComplete(self, *args)


    def GetMatrix(self, *args):
        """GetMatrix(PyMatrix self) -> FECrsMatrix"""
        return _ML.PyMatrix_GetMatrix(self, *args)


    def __setitem__(self, *args):
        """__setitem__(PyMatrix self, PyObject * args, double val) -> PyObject *"""
        return _ML.PyMatrix___setitem__(self, *args)


    def __getitem__(self, *args):
        """__getitem__(PyMatrix self, PyObject * args) -> PyObject *"""
        return _ML.PyMatrix___getitem__(self, *args)

PyMatrix_swigregister = _ML.PyMatrix_swigregister
PyMatrix_swigregister(PyMatrix)

ML_MEM_SIZE = _ML.ML_MEM_SIZE
ML_MEM_INITIAL = _ML.ML_MEM_INITIAL
ML_MEM_FINAL = _ML.ML_MEM_FINAL
ML_MEM_SMOOTHER = _ML.ML_MEM_SMOOTHER
ML_MEM_COARSE = _ML.ML_MEM_COARSE
ML_MEM_HIERARCHY = _ML.ML_MEM_HIERARCHY
ML_MEM_PREC_FIRST = _ML.ML_MEM_PREC_FIRST
ML_MEM_PREC_OTHER = _ML.ML_MEM_PREC_OTHER
ML_MEM_TOT1 = _ML.ML_MEM_TOT1
ML_MEM_TOT2 = _ML.ML_MEM_TOT2
ML_MEM_INITIAL_MALLOC = _ML.ML_MEM_INITIAL_MALLOC
ML_MEM_FINAL_MALLOC = _ML.ML_MEM_FINAL_MALLOC
ML_MEM_SMOOTHER_MALLOC = _ML.ML_MEM_SMOOTHER_MALLOC
ML_MEM_COARSE_MALLOC = _ML.ML_MEM_COARSE_MALLOC
ML_MEM_HIERARCHY_MALLOC = _ML.ML_MEM_HIERARCHY_MALLOC
ML_MEM_PREC_FIRST_MALLOC = _ML.ML_MEM_PREC_FIRST_MALLOC
ML_MEM_PREC_OTHER_MALLOC = _ML.ML_MEM_PREC_OTHER_MALLOC
ML_MEM_TOT1_MALLOC = _ML.ML_MEM_TOT1_MALLOC
ML_MEM_TOT2_MALLOC = _ML.ML_MEM_TOT2_MALLOC

def SetDefaults(*args):
    """SetDefaults(std::string ProblemType, ParameterList List, int * options=None, double * params=None, bool const OverWrite=True) -> int"""
    return _ML.SetDefaults(*args)

def SetDefaultsDD(*args):
    """SetDefaultsDD(ParameterList List, Teuchos::RCP< std::vector< int,std::allocator< int > > > & options, Teuchos::RCP< std::vector< double,std::allocator< double > > > & params, bool Overwrite=True) -> int"""
    return _ML.SetDefaultsDD(*args)

def SetDefaultsDD_LU(*args):
    """SetDefaultsDD_LU(ParameterList List, Teuchos::RCP< std::vector< int,std::allocator< int > > > & options, Teuchos::RCP< std::vector< double,std::allocator< double > > > & params, bool Overwrite=True) -> int"""
    return _ML.SetDefaultsDD_LU(*args)

def SetDefaultsDD_3Levels(*args):
    """SetDefaultsDD_3Levels(ParameterList List, Teuchos::RCP< std::vector< int,std::allocator< int > > > & options, Teuchos::RCP< std::vector< double,std::allocator< double > > > & params, bool Overwrite=True) -> int"""
    return _ML.SetDefaultsDD_3Levels(*args)

def SetDefaultsDD_3Levels_LU(*args):
    """SetDefaultsDD_3Levels_LU(ParameterList List, Teuchos::RCP< std::vector< int,std::allocator< int > > > & options, Teuchos::RCP< std::vector< double,std::allocator< double > > > & params, bool Overwrite=True) -> int"""
    return _ML.SetDefaultsDD_3Levels_LU(*args)

def SetDefaultsMaxwell(*args):
    """SetDefaultsMaxwell(ParameterList List, Teuchos::RCP< std::vector< int,std::allocator< int > > > & options, Teuchos::RCP< std::vector< double,std::allocator< double > > > & params, bool Overwrite=True) -> int"""
    return _ML.SetDefaultsMaxwell(*args)

def SetDefaultsSA(*args):
    """SetDefaultsSA(ParameterList List, Teuchos::RCP< std::vector< int,std::allocator< int > > > & options, Teuchos::RCP< std::vector< double,std::allocator< double > > > & params, bool Overwrite=True) -> int"""
    return _ML.SetDefaultsSA(*args)

def SetDefaultsNSSA(*args):
    """SetDefaultsNSSA(ParameterList List, Teuchos::RCP< std::vector< int,std::allocator< int > > > & options, Teuchos::RCP< std::vector< double,std::allocator< double > > > & params, bool Overwrite=True) -> int"""
    return _ML.SetDefaultsNSSA(*args)

def ReadXML(*args):
    """ReadXML(std::string const & FileName, ParameterList List, Comm Comm) -> int"""
    return _ML.ReadXML(*args)
ML_SA_FAMILY = _ML.ML_SA_FAMILY
ML_MAXWELL = _ML.ML_MAXWELL
ML_COMPOSITE = _ML.ML_COMPOSITE
class MultiLevelPreconditioner(PyTrilinos.Epetra.Operator):
    """Proxy of C++ ML_Epetra::MultiLevelPreconditioner class."""

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.Epetra.Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiLevelPreconditioner, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.Epetra.Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MultiLevelPreconditioner, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(ML_Epetra::MultiLevelPreconditioner self, RowMatrix RowMatrix, bool const ComputePrec=True) -> MultiLevelPreconditioner
        __init__(ML_Epetra::MultiLevelPreconditioner self, RowMatrix RowMatrix, ParameterList List, bool const ComputePrec=True) -> MultiLevelPreconditioner
        __init__(ML_Epetra::MultiLevelPreconditioner self, ML_Operator * Operator, ParameterList List, bool const ComputePrec=True) -> MultiLevelPreconditioner
        __init__(ML_Epetra::MultiLevelPreconditioner self, ML_Operator * Operator, ParameterList List, Epetra_RowMatrix ** DiagOperators, ParameterList DiagLists, int NBlocks=1, bool const ComputePrec=True) -> MultiLevelPreconditioner
        __init__(ML_Epetra::MultiLevelPreconditioner self, RowMatrix EdgeMatrix, RowMatrix GradMatrix, RowMatrix NodeMatrix, ParameterList List, bool const ComputePrec=True, bool const UseNodeMatrixForSmoother=False) -> MultiLevelPreconditioner
        __init__(ML_Epetra::MultiLevelPreconditioner self, RowMatrix CurlCurlMatrix, RowMatrix MassMatrix, RowMatrix TMatrix, RowMatrix NodeMatrix, ParameterList List, bool const ComputePrec=True) -> MultiLevelPreconditioner
        __init__(ML_Epetra::MultiLevelPreconditioner self, Epetra_MsrMatrix const & EdgeMatrix, ML_Operator * GradMatrix, AZ_MATRIX * NodeMatrix, int * proc_config, ParameterList List, bool const ComputePrec=True) -> MultiLevelPreconditioner
        """
        this = _ML.new_MultiLevelPreconditioner(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ML.delete_MultiLevelPreconditioner

    def Label(self, *args):
        """Label(MultiLevelPreconditioner self) -> char const *"""
        return _ML.MultiLevelPreconditioner_Label(self, *args)


    def PrintUnused(self, *args):
        """
        PrintUnused(MultiLevelPreconditioner self)
        PrintUnused(MultiLevelPreconditioner self, std::ostream & os)
        PrintUnused(MultiLevelPreconditioner self, int const MyPID)
        """
        return _ML.MultiLevelPreconditioner_PrintUnused(self, *args)


    def GetList(self, *args):
        """GetList(MultiLevelPreconditioner self) -> ParameterList"""
        return _ML.MultiLevelPreconditioner_GetList(self, *args)


    def GetOutputList(self, *args):
        """GetOutputList(MultiLevelPreconditioner self) -> ParameterList"""
        return _ML.MultiLevelPreconditioner_GetOutputList(self, *args)


    def PrintList(self, *args):
        """PrintList(MultiLevelPreconditioner self)"""
        return _ML.MultiLevelPreconditioner_PrintList(self, *args)


    def SetParameterList(self, *args):
        """SetParameterList(MultiLevelPreconditioner self, ParameterList List) -> int"""
        return _ML.MultiLevelPreconditioner_SetParameterList(self, *args)


    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        """
        return _ML.MultiLevelPreconditioner_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return _ML.MultiLevelPreconditioner_ApplyInverse(self, *args)


    def ComputePreconditioner(self, *args):
        """ComputePreconditioner(MultiLevelPreconditioner self, bool const CheckFiltering=False) -> int"""
        return _ML.MultiLevelPreconditioner_ComputePreconditioner(self, *args)


    def ReComputePreconditioner(self, *args):
        """ReComputePreconditioner(MultiLevelPreconditioner self, bool keepFineLevelSmoother=False) -> int"""
        return _ML.MultiLevelPreconditioner_ReComputePreconditioner(self, *args)


    def ComputeAdaptivePreconditioner(self, *args):
        """ComputeAdaptivePreconditioner(MultiLevelPreconditioner self, int TentativeNullSpaceSize, double * TentativeNullSpace) -> int"""
        return _ML.MultiLevelPreconditioner_ComputeAdaptivePreconditioner(self, *args)


    def IsPreconditionerComputed(self, *args):
        """IsPreconditionerComputed(MultiLevelPreconditioner self) -> int"""
        return _ML.MultiLevelPreconditioner_IsPreconditionerComputed(self, *args)


    def SetOwnership(self, *args):
        """SetOwnership(MultiLevelPreconditioner self, bool ownership) -> int"""
        return _ML.MultiLevelPreconditioner_SetOwnership(self, *args)


    def SetUseTranspose(self, *args):
        """SetUseTranspose(MultiLevelPreconditioner self, bool useTranspose) -> int"""
        return _ML.MultiLevelPreconditioner_SetUseTranspose(self, *args)


    def NormInf(self, *args):
        """NormInf(MultiLevelPreconditioner self) -> double"""
        return _ML.MultiLevelPreconditioner_NormInf(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(MultiLevelPreconditioner self) -> bool"""
        return _ML.MultiLevelPreconditioner_UseTranspose(self, *args)


    def HasNormInf(self, *args):
        """HasNormInf(MultiLevelPreconditioner self) -> bool"""
        return _ML.MultiLevelPreconditioner_HasNormInf(self, *args)


    def Comm(self, *args):
        """Comm(MultiLevelPreconditioner self) -> Comm"""
        return _ML.MultiLevelPreconditioner_Comm(self, *args)


    def OperatorDomainMap(self, *args):
        """OperatorDomainMap(MultiLevelPreconditioner self) -> Map"""
        return _ML.MultiLevelPreconditioner_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """OperatorRangeMap(MultiLevelPreconditioner self) -> Map"""
        return _ML.MultiLevelPreconditioner_OperatorRangeMap(self, *args)


    def DestroyPreconditioner(self, *args):
        """DestroyPreconditioner(MultiLevelPreconditioner self) -> int"""
        return _ML.MultiLevelPreconditioner_DestroyPreconditioner(self, *args)


    def RowMatrix(self, *args):
        """RowMatrix(MultiLevelPreconditioner self) -> RowMatrix"""
        return _ML.MultiLevelPreconditioner_RowMatrix(self, *args)


    def Map(self, *args):
        """Map(MultiLevelPreconditioner self) -> BlockMap"""
        return _ML.MultiLevelPreconditioner_Map(self, *args)


    def NumGlobalRows(self, *args):
        """NumGlobalRows(MultiLevelPreconditioner self) -> int"""
        return _ML.MultiLevelPreconditioner_NumGlobalRows(self, *args)


    def NumGlobalCols(self, *args):
        """NumGlobalCols(MultiLevelPreconditioner self) -> int"""
        return _ML.MultiLevelPreconditioner_NumGlobalCols(self, *args)


    def NumMyRows(self, *args):
        """NumMyRows(MultiLevelPreconditioner self) -> int"""
        return _ML.MultiLevelPreconditioner_NumMyRows(self, *args)


    def NumMyCols(self, *args):
        """NumMyCols(MultiLevelPreconditioner self) -> int"""
        return _ML.MultiLevelPreconditioner_NumMyCols(self, *args)


    def PrintStencil2D(self, *args):
        """PrintStencil2D(MultiLevelPreconditioner self, int const nx, int const ny, int NodeID=-1, int const EquationID=0) -> int"""
        return _ML.MultiLevelPreconditioner_PrintStencil2D(self, *args)


    def AnalyzeHierarchy(self, *args):
        """AnalyzeHierarchy(MultiLevelPreconditioner self, bool const AnalyzeMatrices, int const PreCycles, int const PostCycles, int const MLCycles) -> int"""
        return _ML.MultiLevelPreconditioner_AnalyzeHierarchy(self, *args)


    def AnalyzeSmoothers(self, *args):
        """AnalyzeSmoothers(MultiLevelPreconditioner self, int const NumPreCycles=1, int const NumPostCycles=1) -> int"""
        return _ML.MultiLevelPreconditioner_AnalyzeSmoothers(self, *args)


    def AnalyzeCoarse(self, *args):
        """AnalyzeCoarse(MultiLevelPreconditioner self) -> int"""
        return _ML.MultiLevelPreconditioner_AnalyzeCoarse(self, *args)


    def AnalyzeCycle(self, *args):
        """AnalyzeCycle(MultiLevelPreconditioner self, int const NumCycles=1) -> int"""
        return _ML.MultiLevelPreconditioner_AnalyzeCycle(self, *args)


    def TestSmoothers(self, *args):
        """
        TestSmoothers(MultiLevelPreconditioner self, ParameterList InputList, bool const IsSymmetric=False) -> int
        TestSmoothers(MultiLevelPreconditioner self, bool const IsSymmetric=False) -> int
        """
        return _ML.MultiLevelPreconditioner_TestSmoothers(self, *args)


    def GetML(self, *args):
        """GetML(MultiLevelPreconditioner self, int const WhichML=-1) -> ML const *"""
        return _ML.MultiLevelPreconditioner_GetML(self, *args)


    def GetML_Aggregate(self, *args):
        """GetML_Aggregate(MultiLevelPreconditioner self) -> ML_Aggregate const *"""
        return _ML.MultiLevelPreconditioner_GetML_Aggregate(self, *args)


    def Visualize(self, *args):
        """Visualize(MultiLevelPreconditioner self, bool VizAggre, bool VizPreSmoother, bool VizPostSmoother, bool VizCycle, int NumApplPreSmoother, int NumApplPostSmoother, int NumCycleSmoother) -> int"""
        return _ML.MultiLevelPreconditioner_Visualize(self, *args)


    def VisualizeAggregates(self, *args):
        """VisualizeAggregates(MultiLevelPreconditioner self) -> int"""
        return _ML.MultiLevelPreconditioner_VisualizeAggregates(self, *args)


    def VisualizeSmoothers(self, *args):
        """VisualizeSmoothers(MultiLevelPreconditioner self, int NumPrecCycles=1, int NumPostCycles=1) -> int"""
        return _ML.MultiLevelPreconditioner_VisualizeSmoothers(self, *args)


    def VisualizeCycle(self, *args):
        """VisualizeCycle(MultiLevelPreconditioner self, int NumCycles=1) -> int"""
        return _ML.MultiLevelPreconditioner_VisualizeCycle(self, *args)


    def CreateLabel(self, *args):
        """CreateLabel(MultiLevelPreconditioner self) -> int"""
        return _ML.MultiLevelPreconditioner_CreateLabel(self, *args)


    def ReportTime(self, *args):
        """ReportTime(MultiLevelPreconditioner self)"""
        return _ML.MultiLevelPreconditioner_ReportTime(self, *args)


    def Complexities(self, *args):
        """Complexities(MultiLevelPreconditioner self, double & complexity, double & fineNnz)"""
        return _ML.MultiLevelPreconditioner_Complexities(self, *args)


    def SetParameterListAndNullSpace(self, *args):
        """SetParameterListAndNullSpace(MultiLevelPreconditioner self, PyObject * obj, MultiVector NullSpace) -> int"""
        return _ML.MultiLevelPreconditioner_SetParameterListAndNullSpace(self, *args)

MultiLevelPreconditioner_swigregister = _ML.MultiLevelPreconditioner_swigregister
MultiLevelPreconditioner_swigregister(MultiLevelPreconditioner)

class InverseOperator(BaseOperator, CompObject, TimeObject):
    """Proxy of C++ MLAPI::InverseOperator class."""

    __swig_setmethods__ = {}
    for _s in [BaseOperator, CompObject, TimeObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InverseOperator, name, value)
    __swig_getmethods__ = {}
    for _s in [BaseOperator, CompObject, TimeObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InverseOperator, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(MLAPI::InverseOperator self) -> InverseOperator
        __init__(MLAPI::InverseOperator self, Operator Op, std::string const Type) -> InverseOperator
        __init__(MLAPI::InverseOperator self, Operator Op, std::string const Type, ParameterList List) -> InverseOperator
        __init__(MLAPI::InverseOperator self, InverseOperator RHS) -> InverseOperator
        """
        this = _ML.new_InverseOperator(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ML.delete_InverseOperator

    def GetOperatorRangeSpace(self, *args):
        """GetOperatorRangeSpace(InverseOperator self) -> Space"""
        return _ML.InverseOperator_GetOperatorRangeSpace(self, *args)


    def GetOperatorDomainSpace(self, *args):
        """GetOperatorDomainSpace(InverseOperator self) -> Space"""
        return _ML.InverseOperator_GetOperatorDomainSpace(self, *args)


    def GetRangeSpace(self, *args):
        """GetRangeSpace(InverseOperator self) -> Space"""
        return _ML.InverseOperator_GetRangeSpace(self, *args)


    def GetDomainSpace(self, *args):
        """GetDomainSpace(InverseOperator self) -> Space"""
        return _ML.InverseOperator_GetDomainSpace(self, *args)


    def RCPRowMatrix(self, *args):
        """RCPRowMatrix(InverseOperator self) -> Teuchos::RefCountPtr< Epetra_RowMatrix > const"""
        return _ML.InverseOperator_RCPRowMatrix(self, *args)


    def RowMatrix(self, *args):
        """RowMatrix(InverseOperator self) -> RowMatrix"""
        return _ML.InverseOperator_RowMatrix(self, *args)


    def GetOperator(self, *args):
        """GetOperator(InverseOperator self) -> Operator"""
        return _ML.InverseOperator_GetOperator(self, *args)


    def GetRCPData(self, *args):
        """
        GetRCPData(InverseOperator self) -> Teuchos::RefCountPtr< Ifpack_Preconditioner >
        GetRCPData(InverseOperator self) -> Teuchos::RefCountPtr< Ifpack_Preconditioner > const &
        """
        return _ML.InverseOperator_GetRCPData(self, *args)


    def GetRCPMLPrec(self, *args):
        """
        GetRCPMLPrec(InverseOperator self) -> Teuchos::RefCountPtr< ML_Epetra::MultiLevelPreconditioner >
        GetRCPMLPrec(InverseOperator self) -> Teuchos::RefCountPtr< ML_Epetra::MultiLevelPreconditioner > const &
        """
        return _ML.InverseOperator_GetRCPMLPrec(self, *args)


    def Apply(self, *args):
        """Apply(InverseOperator self, MultiVector x, MultiVector y) -> int"""
        return _ML.InverseOperator_Apply(self, *args)


    def __call__(self, *args):
        """
        __call__(InverseOperator self, MultiVector LHS) -> MultiVector
        __call__(InverseOperator self, MultiVector LHS, MultiVector RHS) -> MultiVector
        """
        return _ML.InverseOperator___call__(self, *args)


    def __mul__(self, *args):
        """__mul__(InverseOperator self, MultiVector rhs) -> MultiVector"""
        return _ML.InverseOperator___mul__(self, *args)


    def Reshape(self, *args):
        """
        Reshape(InverseOperator self)
        Reshape(InverseOperator self, Operator Op, std::string const Type)
        Reshape(InverseOperator self, Operator Op, std::string const Type, ParameterList List, ParameterList pushlist=None)
        Reshape(InverseOperator self, Ifpack_Preconditioner * prec, Operator Op, bool const ownership)
        Reshape(InverseOperator self, Operator Op, std::string const Type, PyObject * obj) -> bool
        """
        return _ML.InverseOperator_Reshape(self, *args)

InverseOperator_swigregister = _ML.InverseOperator_swigregister
InverseOperator_swigregister(InverseOperator)


def GetRAP(*args):
    """GetRAP(Operator R, Operator A, Operator P) -> Operator"""
    return _ML.GetRAP(*args)

def GetTranspose(*args):
    """GetTranspose(Operator A, bool const byrow=True) -> Operator"""
    return _ML.GetTranspose(*args)

def GetIdentity(*args):
    """GetIdentity(Space DomainSpace, Space RangeSpace) -> Operator"""
    return _ML.GetIdentity(*args)

def GetDiagonal(*args):
    """
    GetDiagonal(Operator A) -> MultiVector
    GetDiagonal(Operator A, int const offset) -> MultiVector
    GetDiagonal(MultiVector D) -> Operator
    """
    return _ML.GetDiagonal(*args)

def GetJacobiIterationOperator(*args):
    """GetJacobiIterationOperator(Operator Amat, double Damping) -> Operator"""
    return _ML.GetJacobiIterationOperator(*args)

def GetPtent1D(*args):
    """GetPtent1D(MultiVector D, int const offset=0) -> Operator"""
    return _ML.GetPtent1D(*args)

def ML_Operator_Add2(*args):
    """ML_Operator_Add2(ML_Operator * A, ML_Operator * B, ML_Operator * C, int matrix_type, double scalarA, double scalarB) -> int"""
    return _ML.ML_Operator_Add2(*args)

def AnalyzeCheap(*args):
    """AnalyzeCheap(Operator A)"""
    return _ML.AnalyzeCheap(*args)

def PrintSparsity(*args):
    """PrintSparsity(Operator A, int NumPDEEquations=1)"""
    return _ML.PrintSparsity(*args)

def GetScaledOperator(*args):
    """GetScaledOperator(Operator A, double const alpha) -> Operator"""
    return _ML.GetScaledOperator(*args)

def Duplicate(*args):
    """
    Duplicate(MultiVector y) -> MultiVector
    Duplicate(MultiVector y, int const v) -> MultiVector
    Duplicate(Operator A) -> Operator
    """
    return _ML.Duplicate(*args)
class EpetraBaseOperator(PyTrilinos.Epetra.Operator):
    """Proxy of C++ MLAPI::EpetraBaseOperator class."""

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.Epetra.Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraBaseOperator, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.Epetra.Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraBaseOperator, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(MLAPI::EpetraBaseOperator self, Map inMap, BaseOperator Op) -> EpetraBaseOperator"""
        this = _ML.new_EpetraBaseOperator(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ML.delete_EpetraBaseOperator

    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return _ML.EpetraBaseOperator_ApplyInverse(self, *args)


    def SetUseTranspose(self, *args):
        """SetUseTranspose(EpetraBaseOperator self, bool UseTransposeFlag) -> int"""
        return _ML.EpetraBaseOperator_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        """
        return _ML.EpetraBaseOperator_Apply(self, *args)


    def NormInf(self, *args):
        """NormInf(EpetraBaseOperator self) -> double"""
        return _ML.EpetraBaseOperator_NormInf(self, *args)


    def Label(self, *args):
        """Label(EpetraBaseOperator self) -> char const *"""
        return _ML.EpetraBaseOperator_Label(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(EpetraBaseOperator self) -> bool"""
        return _ML.EpetraBaseOperator_UseTranspose(self, *args)


    def HasNormInf(self, *args):
        """HasNormInf(EpetraBaseOperator self) -> bool"""
        return _ML.EpetraBaseOperator_HasNormInf(self, *args)


    def Comm(self, *args):
        """Comm(EpetraBaseOperator self) -> Comm"""
        return _ML.EpetraBaseOperator_Comm(self, *args)


    def OperatorDomainMap(self, *args):
        """OperatorDomainMap(EpetraBaseOperator self) -> Map"""
        return _ML.EpetraBaseOperator_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """OperatorRangeMap(EpetraBaseOperator self) -> Map"""
        return _ML.EpetraBaseOperator_OperatorRangeMap(self, *args)


    def Map(self, *args):
        """Map(EpetraBaseOperator self) -> Map"""
        return _ML.EpetraBaseOperator_Map(self, *args)


    def GetBaseOperator(self, *args):
        """GetBaseOperator(EpetraBaseOperator self) -> BaseOperator"""
        return _ML.EpetraBaseOperator_GetBaseOperator(self, *args)

EpetraBaseOperator_swigregister = _ML.EpetraBaseOperator_swigregister
EpetraBaseOperator_swigregister(EpetraBaseOperator)


def Krylov(*args):
    """Krylov(Operator A, MultiVector LHS, MultiVector RHS, BaseOperator Prec, ParameterList List)"""
    return _ML.Krylov(*args)

def __add__(*args):
    """
    __add__(MultiVector x, MultiVector y) -> MultiVector
    __add__(MultiVector x, double const alpha) -> MultiVector
    __add__(double const alpha, MultiVector x) -> MultiVector
    __add__(Operator A, Operator B) -> Operator
    """
    return _ML.__add__(*args)

def __sub__(*args):
    """
    __sub__(MultiVector x, MultiVector y) -> MultiVector
    __sub__(MultiVector x, double const alpha) -> MultiVector
    __sub__(double const alpha, MultiVector x) -> MultiVector
    __sub__(Operator A, Operator B) -> Operator
    """
    return _ML.__sub__(*args)

def __truediv__(*args):
    """
    __truediv__(Operator A, double const alpha) -> Operator
    __truediv__(MultiVector x, double const alpha) -> MultiVector
    """
    return _ML.__truediv__(*args)

def __mul__(*args):
    """
    __mul__(Operator A, MultiVector y) -> MultiVector
    __mul__(Operator A, Operator B) -> Operator
    __mul__(Operator A, double const alpha) -> Operator
    __mul__(double const alpha, Operator A) -> Operator
    __mul__(MultiVector x, double const alpha) -> MultiVector
    __mul__(double const alpha, MultiVector x) -> MultiVector
    __mul__(BaseOperator A, MultiVector x) -> MultiVector
    __mul__(MultiVector x, MultiVector y) -> double
    """
    return _ML.__mul__(*args)

def GetPtent(*args):
    """
    GetPtent(Operator A, ParameterList List, MultiVector ThisNS, Operator Ptent, MultiVector NextNS)
    GetPtent(Operator A, ParameterList List, Operator Ptent)
    GetPtent(RowMatrix A, ParameterList List, double * thisns, Teuchos::RCP< Epetra_CrsMatrix > & Ptent, Teuchos::RCP< Epetra_MultiVector > & NextNS, int const domainoffset=0)
    GetPtent(RowMatrix A, ParameterList List, double * thisns, Teuchos::RCP< Epetra_CrsMatrix > & Ptent, int const domainoffset=0)
    """
    return _ML.GetPtent(*args)

def GetAggregates(*args):
    """GetAggregates(RowMatrix A, ParameterList List, double * thisns, IntVector aggrinfo) -> int"""
    return _ML.GetAggregates(*args)

def GetGlobalAggregates(*args):
    """GetGlobalAggregates(RowMatrix A, ParameterList List, double * thisns, IntVector aggrinfo) -> int"""
    return _ML.GetGlobalAggregates(*args)

def MaxEigAnorm(*args):
    """MaxEigAnorm(Operator Op, bool const DiagonalScaling=False) -> double"""
    return _ML.MaxEigAnorm(*args)

def MaxEigCG(*args):
    """MaxEigCG(Operator Op, bool const DiagonalScaling=False) -> double"""
    return _ML.MaxEigCG(*args)

def MaxEigPowerMethod(*args):
    """MaxEigPowerMethod(Operator Op, bool const DiagonalScaling=False) -> double"""
    return _ML.MaxEigPowerMethod(*args)

def MaxEigAnasazi(*args):
    """MaxEigAnasazi(Operator Op, bool const DiagonalScaling=False) -> double"""
    return _ML.MaxEigAnasazi(*args)

def Eig(*args):
    """Eig(Operator Op, MultiVector ER, MultiVector EI)"""
    return _ML.Eig(*args)

def Eigs(*args):
    """Eigs(Operator A, int NumEigenvalues, MultiVector ER, MultiVector EI)"""
    return _ML.Eigs(*args)

def Gallery(*args):
    """Gallery(std::string const ProblemType, Space MySpace) -> Operator"""
    return _ML.Gallery(*args)

def GetShiftedLaplacian1D(*args):
    """GetShiftedLaplacian1D(int const NX, double const Factor=0.99) -> Operator"""
    return _ML.GetShiftedLaplacian1D(*args)

def GetShiftedLaplacian2D(*args):
    """GetShiftedLaplacian2D(int const NX, int const NY, double const Factor=0.99, bool const RandomScale=False) -> Operator"""
    return _ML.GetShiftedLaplacian2D(*args)

def ReadMatrix(*args):
    """ReadMatrix(char const * FileName) -> Operator"""
    return _ML.ReadMatrix(*args)

def GetRecirc2D(*args):
    """GetRecirc2D(int const NX, int const NY, double const conv, double const diff) -> Operator"""
    return _ML.GetRecirc2D(*args)

def ReadParameterList(*args):
    """ReadParameterList(char const * FileName) -> ParameterList"""
    return _ML.ReadParameterList(*args)

def GetPNonSmoothed(*args):
    """GetPNonSmoothed(Operator A, MultiVector ThisNS, MultiVector NextNS, PyObject * obj) -> Operator"""
    return _ML.GetPNonSmoothed(*args)

def Iterate(*args):
    """Iterate(Operator A, MultiVector LHS, MultiVector RHS, BaseOperator Prec, PyObject * obj) -> bool"""
    return _ML.Iterate(*args)
# This file is compatible with both classic and new-style classes.


