# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA is the python interface to the Trilinos continuation
algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA is to provide a library of continuation
algorithms.  It includes the following sub-modules:

    * Abstract           - Abstract continuation problem base classes
    * Extended           - Classes that extend NOX.Abstract classes to
                           handle an arbitrary number of multi-vectors
                           and scalars
    * MultiContinuation  - Groups and vectors for multi-parameter continuation
    * TimeDependent      - Abstract group for time dependent problems with a
                           mass matrix
    * TurningPoint       - Groups and vectors for turning point bifurcations
    * Hopf               - Groups and vectors for Hopf bifurcations
    * Pitchfork          - Groups and vectors for pitchfork bifurcations
    * Homotopy           - Groups that allow for Homotopy to be applied
    * PhaseTransition    - Groups and vectors for phase transition bifurcations
    * Parameter          - Centralized library for setting/retrieving numerical
                           parameter values in application codes
    * BorderedSolver     - Strategies for solving bordered systems of equations
    * BorderedSystem     - Interface for groups that are bordered systems
    * Bifurcation        - Strategies for creating bifurcation objects
    * StatusTest         - Status checkers
    * StepSize           - Collection of step size control strategies
    * MultiPredictor     - Predictor direction strategies

and classes:

    * GlobalData      - Container class that holds ref-count pointers to
                        'global' objects, i.e., objects that nearly every LOCA
                        object will need access to
    * ErrorCheck      - Error checking algorithm for NOX/LOCA routines
    * Factory         - Provides a single location for instantiating various
                        strategies based on parameter list choices
    * DerivUtils      - Generic derivative computation class to compute various
                        derivatives via finite differencing
    * Stepper         - Implementation of LOCA.Abstract.Iterator for computing
                        points along a continuation curve
    * ParameterVector - LOCA's container for holding a set of parameters that
                        are used by the LOCA continuation routines

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '___init__')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('___init__')
    ___init__ = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('___init__', [dirname(__file__)])
        except ImportError:
            import ___init__
            return ___init__
        try:
            _mod = imp.load_module('___init__', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    ___init__ = swig_import_helper()
    del swig_import_helper
else:
    import ___init__
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_SwigPyIterator

    def value(self):
        return ___init__.SwigPyIterator_value(self)

    def incr(self, n=1):
        return ___init__.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return ___init__.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return ___init__.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return ___init__.SwigPyIterator_equal(self, x)

    def copy(self):
        return ___init__.SwigPyIterator_copy(self)

    def next(self):
        return ___init__.SwigPyIterator_next(self)

    def __next__(self):
        return ___init__.SwigPyIterator___next__(self)

    def previous(self):
        return ___init__.SwigPyIterator_previous(self)

    def advance(self, n):
        return ___init__.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return ___init__.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return ___init__.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return ___init__.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return ___init__.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return ___init__.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return ___init__.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = ___init__.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

import PyTrilinos.Teuchos
import PyTrilinos.NOX.Abstract
import PyTrilinos.NOX.StatusTest

import PyTrilinos.NOX

# LOCA sub-modules
__all__ = ['Extended',
           'MultiContinuation',
           'TimeDependent',
           'TurningPoint',
           'Hopf',
           'Pitchfork',
           'Homotopy',
           'PhaseTransition',
           'Abstract',
           'Parameter',
           'BorderedSolver',
           'BorderedSystem',
           'Bifurcation',
           'StatusTest',
           'StepSize',
           'MultiPredictor',
           'Eigensolver',
           'EigenvalueSort',
           'SaveEigenData',
           'AnasaziOperator'
           ]
from . import Extended
from . import MultiContinuation
from . import TimeDependent
from . import TurningPoint
from . import Hopf
from . import Pitchfork
from . import Homotopy
from . import PhaseTransition
from . import Abstract
from . import Parameter
from . import BorderedSolver
from . import BorderedSystem
from . import Bifurcation
from . import StatusTest
from . import StepSize
from . import MultiPredictor
from . import Eigensolver
from . import EigenvalueSort
from . import SaveEigenData
from . import AnasaziOperator

class GlobalData(_object):
    """Proxy of C++ LOCA::GlobalData class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GlobalData, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GlobalData, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(LOCA::GlobalData self, Teuchos::RCP< NOX::Utils > const & loca_utils, Teuchos::RCP< LOCA::ErrorCheck > const & loca_error_check, Teuchos::RCP< LOCA::Factory > const & loca_factory) -> GlobalData"""
        this = ___init__.new_GlobalData(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_GlobalData
    __swig_setmethods__["locaUtils"] = ___init__.GlobalData_locaUtils_set
    __swig_getmethods__["locaUtils"] = ___init__.GlobalData_locaUtils_get
    if _newclass:
        locaUtils = _swig_property(___init__.GlobalData_locaUtils_get, ___init__.GlobalData_locaUtils_set)
    __swig_setmethods__["locaErrorCheck"] = ___init__.GlobalData_locaErrorCheck_set
    __swig_getmethods__["locaErrorCheck"] = ___init__.GlobalData_locaErrorCheck_get
    if _newclass:
        locaErrorCheck = _swig_property(___init__.GlobalData_locaErrorCheck_get, ___init__.GlobalData_locaErrorCheck_set)
    __swig_setmethods__["locaFactory"] = ___init__.GlobalData_locaFactory_set
    __swig_getmethods__["locaFactory"] = ___init__.GlobalData_locaFactory_get
    if _newclass:
        locaFactory = _swig_property(___init__.GlobalData_locaFactory_get, ___init__.GlobalData_locaFactory_set)
    __swig_setmethods__["parsedParams"] = ___init__.GlobalData_parsedParams_set
    __swig_getmethods__["parsedParams"] = ___init__.GlobalData_parsedParams_get
    if _newclass:
        parsedParams = _swig_property(___init__.GlobalData_parsedParams_get, ___init__.GlobalData_parsedParams_set)
GlobalData_swigregister = ___init__.GlobalData_swigregister
GlobalData_swigregister(GlobalData)


def createGlobalData(*args):
    """createGlobalData(Teuchos::RCP< Teuchos::ParameterList > const & paramList, Teuchos::RCP< LOCA::Abstract::Factory > const & userFactory) -> Teuchos::RCP< LOCA::GlobalData >"""
    return ___init__.createGlobalData(*args)

def destroyGlobalData(*args):
    """destroyGlobalData(Teuchos::RCP< LOCA::GlobalData > const & globalData)"""
    return ___init__.destroyGlobalData(*args)
class ErrorCheck(_object):
    """Proxy of C++ LOCA::ErrorCheck class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ErrorCheck, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ErrorCheck, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(LOCA::ErrorCheck self, Teuchos::RCP< LOCA::GlobalData > const & global_data) -> ErrorCheck"""
        this = ___init__.new_ErrorCheck(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_ErrorCheck
    ThrowError = ___init__.ErrorCheck_ThrowError
    PrintWarning = ___init__.ErrorCheck_PrintWarning

    def throwError(self, *args):
        """throwError(ErrorCheck self, std::string const & callingFunction, std::string const & message, std::string const & throwLabel)"""
        return ___init__.ErrorCheck_throwError(self, *args)


    def printWarning(self, *args):
        """printWarning(ErrorCheck self, std::string const & callingFunction, std::string const & message)"""
        return ___init__.ErrorCheck_printWarning(self, *args)


    def checkReturnType(self, *args):
        """
        checkReturnType(ErrorCheck self, NOX::Abstract::Group::ReturnType const & status, std::string const & callingFunction)
        checkReturnType(ErrorCheck self, NOX::Abstract::Group::ReturnType const & status, LOCA::ErrorCheck::ActionType const & action, std::string const & callingFunction, std::string const & message)
        """
        return ___init__.ErrorCheck_checkReturnType(self, *args)


    def combineReturnTypes(self, *args):
        """combineReturnTypes(ErrorCheck self, NOX::Abstract::Group::ReturnType const & status1, NOX::Abstract::Group::ReturnType const & status2) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.ErrorCheck_combineReturnTypes(self, *args)


    def combineAndCheckReturnTypes(self, *args):
        """combineAndCheckReturnTypes(ErrorCheck self, NOX::Abstract::Group::ReturnType const & status1, NOX::Abstract::Group::ReturnType const & status2, std::string const & callingFunction) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.ErrorCheck_combineAndCheckReturnTypes(self, *args)

ErrorCheck_swigregister = ___init__.ErrorCheck_swigregister
ErrorCheck_swigregister(ErrorCheck)

class Factory(_object):
    """Proxy of C++ LOCA::Factory class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Factory, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Factory, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Factory self, Teuchos::RCP< LOCA::GlobalData > const & global_data) -> Factory
        __init__(LOCA::Factory self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::Abstract::Factory > const & userFactory) -> Factory
        """
        this = ___init__.new_Factory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_Factory

    def createPredictorStrategy(self, *args):
        """createPredictorStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & predictorParams) -> Teuchos::RCP< LOCA::MultiPredictor::AbstractStrategy >"""
        return ___init__.Factory_createPredictorStrategy(self, *args)


    def createContinuationStrategy(self, *args):
        """createContinuationStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & stepperParams, Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup > const & grp, Teuchos::RCP< LOCA::MultiPredictor::AbstractStrategy > const & pred, std::vector< int,std::allocator< int > > const & paramIDs) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractStrategy >"""
        return ___init__.Factory_createContinuationStrategy(self, *args)


    def createBifurcationStrategy(self, *args):
        """createBifurcationStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & bifurcationParams, Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup > const & grp) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup >"""
        return ___init__.Factory_createBifurcationStrategy(self, *args)


    def createStepSizeStrategy(self, *args):
        """createStepSizeStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & stepsizeParams) -> Teuchos::RCP< LOCA::StepSize::AbstractStrategy >"""
        return ___init__.Factory_createStepSizeStrategy(self, *args)


    def createBorderedSolverStrategy(self, *args):
        """createBorderedSolverStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams) -> Teuchos::RCP< LOCA::BorderedSolver::AbstractStrategy >"""
        return ___init__.Factory_createBorderedSolverStrategy(self, *args)


    def createEigensolverStrategy(self, *args):
        """createEigensolverStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & eigenParams) -> Teuchos::RCP< LOCA::Eigensolver::AbstractStrategy >"""
        return ___init__.Factory_createEigensolverStrategy(self, *args)


    def createEigenvalueSortStrategy(self, *args):
        """createEigenvalueSortStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & eigenParams) -> Teuchos::RCP< LOCA::EigenvalueSort::AbstractStrategy >"""
        return ___init__.Factory_createEigenvalueSortStrategy(self, *args)


    def createSaveEigenDataStrategy(self, *args):
        """createSaveEigenDataStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & eigenParams) -> Teuchos::RCP< LOCA::SaveEigenData::AbstractStrategy >"""
        return ___init__.Factory_createSaveEigenDataStrategy(self, *args)


    def createAnasaziOperatorStrategy(self, *args):
        """createAnasaziOperatorStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & eigenParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams, Teuchos::RCP< NOX::Abstract::Group > const & grp) -> Teuchos::RCP< LOCA::AnasaziOperator::AbstractStrategy >"""
        return ___init__.Factory_createAnasaziOperatorStrategy(self, *args)


    def createMooreSpenceTurningPointSolverStrategy(self, *args):
        """createMooreSpenceTurningPointSolverStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams) -> Teuchos::RCP< LOCA::TurningPoint::MooreSpence::SolverStrategy >"""
        return ___init__.Factory_createMooreSpenceTurningPointSolverStrategy(self, *args)


    def createMooreSpencePitchforkSolverStrategy(self, *args):
        """createMooreSpencePitchforkSolverStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams) -> Teuchos::RCP< LOCA::Pitchfork::MooreSpence::SolverStrategy >"""
        return ___init__.Factory_createMooreSpencePitchforkSolverStrategy(self, *args)


    def createMooreSpenceHopfSolverStrategy(self, *args):
        """createMooreSpenceHopfSolverStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams) -> Teuchos::RCP< LOCA::Hopf::MooreSpence::SolverStrategy >"""
        return ___init__.Factory_createMooreSpenceHopfSolverStrategy(self, *args)

Factory_swigregister = ___init__.Factory_swigregister
Factory_swigregister(Factory)

class DerivUtils(_object):
    """Proxy of C++ LOCA::DerivUtils class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DerivUtils, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DerivUtils, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::DerivUtils self, Teuchos::RCP< LOCA::GlobalData > const & global_data, double perturb=1.0e-6) -> DerivUtils
        __init__(LOCA::DerivUtils self, DerivUtils arg2) -> DerivUtils
        """
        this = ___init__.new_DerivUtils(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_DerivUtils

    def clone(self, *args):
        """clone(DerivUtils self, NOX::CopyType type) -> Teuchos::RCP< LOCA::DerivUtils >"""
        return ___init__.DerivUtils_clone(self, *args)


    def computeDfDp(self, *args):
        """computeDfDp(DerivUtils self, LOCA::MultiContinuation::AbstractGroup & grp, std::vector< int,std::allocator< int > > const & param_ids, MultiVector result, bool isValidF) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.DerivUtils_computeDfDp(self, *args)


    def computeDJnDp(self, *args):
        """computeDJnDp(DerivUtils self, LOCA::MultiContinuation::AbstractGroup & arg2, std::vector< int,std::allocator< int > > const & paramIDs, Vector nullVector, MultiVector result, bool isValid) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.DerivUtils_computeDJnDp(self, *args)


    def computeDJnDxa(self, *args):
        """
        computeDJnDxa(DerivUtils self, LOCA::MultiContinuation::AbstractGroup & grp, Vector nullVector, MultiVector aVector, MultiVector result) -> NOX::Abstract::Group::ReturnType
        computeDJnDxa(DerivUtils self, LOCA::MultiContinuation::AbstractGroup & grp, Vector nullVector, MultiVector aVector, Vector JnVector, MultiVector result) -> NOX::Abstract::Group::ReturnType
        """
        return ___init__.DerivUtils_computeDJnDxa(self, *args)


    def computeDwtJnDp(self, *args):
        """computeDwtJnDp(DerivUtils self, LOCA::MultiContinuation::AbstractGroup & grp, std::vector< int,std::allocator< int > > const & paramIDs, Vector w, Vector nullVector, NOX::Abstract::MultiVector::DenseMatrix & result, bool isValid) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.DerivUtils_computeDwtJnDp(self, *args)


    def computeDwtJDp(self, *args):
        """computeDwtJDp(DerivUtils self, LOCA::MultiContinuation::AbstractGroup & grp, std::vector< int,std::allocator< int > > const & paramIDs, Vector w, MultiVector result, bool isValid) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.DerivUtils_computeDwtJDp(self, *args)


    def computeDwtJnDx(self, *args):
        """
        computeDwtJnDx(DerivUtils self, LOCA::MultiContinuation::AbstractGroup & grp, Vector w, Vector nullVector, Vector result) -> NOX::Abstract::Group::ReturnType
        computeDwtJnDx(DerivUtils self, LOCA::MultiContinuation::AbstractGroup & grp, MultiVector w, Vector nullVector, MultiVector result) -> NOX::Abstract::Group::ReturnType
        """
        return ___init__.DerivUtils_computeDwtJnDx(self, *args)


    def computeDCeDp(self, *args):
        """computeDCeDp(DerivUtils self, LOCA::Hopf::MooreSpence::AbstractGroup & grp, std::vector< int,std::allocator< int > > const & paramIDs, Vector yVector, Vector zVector, double w, MultiVector result_real, MultiVector result_imag, bool isValid) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.DerivUtils_computeDCeDp(self, *args)


    def computeDCeDxa(self, *args):
        """
        computeDCeDxa(DerivUtils self, LOCA::Hopf::MooreSpence::AbstractGroup & grp, Vector yVector, Vector zVector, double w, MultiVector aVector, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType
        computeDCeDxa(DerivUtils self, LOCA::Hopf::MooreSpence::AbstractGroup & grp, Vector yVector, Vector zVector, double w, MultiVector aVector, Vector Ce_real, Vector Ce_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType
        """
        return ___init__.DerivUtils_computeDCeDxa(self, *args)


    def computeDwtCeDp(self, *args):
        """computeDwtCeDp(DerivUtils self, LOCA::Hopf::MinimallyAugmented::AbstractGroup & grp, std::vector< int,std::allocator< int > > const & paramIDs, Vector w1, Vector w2, Vector yVector, Vector zVector, double omega, NOX::Abstract::MultiVector::DenseMatrix & result_real, NOX::Abstract::MultiVector::DenseMatrix & result_imag, bool isValid) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.DerivUtils_computeDwtCeDp(self, *args)


    def computeDwtCeDx(self, *args):
        """computeDwtCeDx(DerivUtils self, LOCA::Hopf::MinimallyAugmented::AbstractGroup & grp, Vector w1, Vector w2, Vector yVector, Vector zVector, double omega, Vector result_real, Vector result_imag) -> NOX::Abstract::Group::ReturnType"""
        return ___init__.DerivUtils_computeDwtCeDx(self, *args)

DerivUtils_swigregister = ___init__.DerivUtils_swigregister
DerivUtils_swigregister(DerivUtils)

import Abstract
class Stepper(Abstract.Iterator):
    """Proxy of C++ LOCA::Stepper class."""

    __swig_setmethods__ = {}
    for _s in [Abstract.Iterator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Stepper, name, value)
    __swig_getmethods__ = {}
    for _s in [Abstract.Iterator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Stepper, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Stepper self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup > const & initialGuess, Teuchos::RCP< LOCA::StatusTest::Abstract > const & lt, Teuchos::RCP< NOX::StatusTest::Generic > const & nt, Teuchos::RCP< Teuchos::ParameterList > const & p) -> Stepper
        __init__(LOCA::Stepper self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup > const & initialGuess, Teuchos::RCP< NOX::StatusTest::Generic > const & nt, Teuchos::RCP< Teuchos::ParameterList > const & p) -> Stepper
        """
        if self.__class__ == Stepper:
            _self = None
        else:
            _self = self
        this = ___init__.new_Stepper(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_Stepper

    def reset(self, *args):
        """
        reset(Stepper self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup > const & initialGuess, Teuchos::RCP< LOCA::StatusTest::Abstract > const & lt, Teuchos::RCP< NOX::StatusTest::Generic > const & nt, Teuchos::RCP< Teuchos::ParameterList > const & p) -> bool
        reset(Stepper self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup > const & initialGuess, Teuchos::RCP< NOX::StatusTest::Generic > const & nt, Teuchos::RCP< Teuchos::ParameterList > const & p) -> bool
        """
        return ___init__.Stepper_reset(self, *args)


    def eigensolverReset(self, *args):
        """eigensolverReset(Stepper self, Teuchos::RCP< Teuchos::ParameterList > & newEigensolverList) -> bool"""
        return ___init__.Stepper_eigensolverReset(self, *args)


    def getSolutionGroup(self, *args):
        """getSolutionGroup(Stepper self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup const >"""
        return ___init__.Stepper_getSolutionGroup(self, *args)


    def getBifurcationGroup(self, *args):
        """getBifurcationGroup(Stepper self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup const >"""
        return ___init__.Stepper_getBifurcationGroup(self, *args)


    def getList(self, *args):
        """getList(Stepper self) -> Teuchos::RCP< Teuchos::ParameterList const >"""
        return ___init__.Stepper_getList(self, *args)


    def getSolver(self, *args):
        """getSolver(Stepper self) -> Teuchos::RCP< NOX::Solver::Generic const >"""
        return ___init__.Stepper_getSolver(self, *args)


    def getContinuationParameter(self, *args):
        """getContinuationParameter(Stepper self) -> double"""
        return ___init__.Stepper_getContinuationParameter(self, *args)


    def start(self, *args):
        """start(Stepper self) -> LOCA::Abstract::Iterator::IteratorStatus"""
        return ___init__.Stepper_start(self, *args)


    def finish(self, *args):
        """finish(Stepper self, LOCA::Abstract::Iterator::IteratorStatus iteratorStatus) -> LOCA::Abstract::Iterator::IteratorStatus"""
        return ___init__.Stepper_finish(self, *args)


    def preprocess(self, *args):
        """preprocess(Stepper self, LOCA::Abstract::Iterator::StepStatus stepStatus) -> LOCA::Abstract::Iterator::StepStatus"""
        return ___init__.Stepper_preprocess(self, *args)


    def compute(self, *args):
        """compute(Stepper self, LOCA::Abstract::Iterator::StepStatus stepStatus) -> LOCA::Abstract::Iterator::StepStatus"""
        return ___init__.Stepper_compute(self, *args)


    def postprocess(self, *args):
        """postprocess(Stepper self, LOCA::Abstract::Iterator::StepStatus stepStatus) -> LOCA::Abstract::Iterator::StepStatus"""
        return ___init__.Stepper_postprocess(self, *args)


    def stop(self, *args):
        """stop(Stepper self, LOCA::Abstract::Iterator::StepStatus stepStatus) -> LOCA::Abstract::Iterator::IteratorStatus"""
        return ___init__.Stepper_stop(self, *args)


    def printInitializationInfo(self, *args):
        """printInitializationInfo(Stepper self)"""
        return ___init__.Stepper_printInitializationInfo(self, *args)


    def printStartStep(self, *args):
        """printStartStep(Stepper self)"""
        return ___init__.Stepper_printStartStep(self, *args)


    def printEndStep(self, *args):
        """printEndStep(Stepper self, LOCA::Abstract::Iterator::StepStatus stepStatus)"""
        return ___init__.Stepper_printEndStep(self, *args)


    def printEndInfo(self, *args):
        """printEndInfo(Stepper self)"""
        return ___init__.Stepper_printEndInfo(self, *args)


    def withinThreshold(self, *args):
        """withinThreshold(Stepper self) -> bool"""
        return ___init__.Stepper_withinThreshold(self, *args)

    def __disown__(self):
        self.this.disown()
        ___init__.disown_Stepper(self)
        return weakref_proxy(self)

    def iterate(self, *args):
        """iterate(Stepper self) -> LOCA::Abstract::Iterator::IteratorStatus"""
        return ___init__.Stepper_iterate(self, *args)


    def setLastIteration(self, *args):
        """setLastIteration(Stepper self)"""
        return ___init__.Stepper_setLastIteration(self, *args)


    def isLastIteration(self, *args):
        """isLastIteration(Stepper self) -> bool"""
        return ___init__.Stepper_isLastIteration(self, *args)


    def computeStepStatus(self, *args):
        """computeStepStatus(Stepper self, LOCA::Abstract::Iterator::StepStatus preStatus, LOCA::Abstract::Iterator::StepStatus compStatus, LOCA::Abstract::Iterator::StepStatus postStatus) -> LOCA::Abstract::Iterator::StepStatus"""
        return ___init__.Stepper_computeStepStatus(self, *args)

Stepper_swigregister = ___init__.Stepper_swigregister
Stepper_swigregister(Stepper)

class ParameterVector(_object):
    """Proxy of C++ LOCA::ParameterVector class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ParameterVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ParameterVector, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::ParameterVector self) -> ParameterVector
        __init__(LOCA::ParameterVector self, ParameterVector source) -> ParameterVector
        """
        this = ___init__.new_ParameterVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def clone(self, *args):
        """clone(ParameterVector self) -> ParameterVector"""
        return ___init__.ParameterVector_clone(self, *args)

    __swig_destroy__ = ___init__.delete_ParameterVector

    def addParameter(self, *args):
        """addParameter(ParameterVector self, std::string label, double value=0.0) -> int"""
        return ___init__.ParameterVector_addParameter(self, *args)


    def init(self, *args):
        """init(ParameterVector self, double value) -> bool"""
        return ___init__.ParameterVector_init(self, *args)


    def scale(self, *args):
        """
        scale(ParameterVector self, double value) -> bool
        scale(ParameterVector self, ParameterVector p) -> bool
        """
        return ___init__.ParameterVector_scale(self, *args)


    def update(self, *args):
        """update(ParameterVector self, double alpha, ParameterVector alphaVector, double b) -> bool"""
        return ___init__.ParameterVector_update(self, *args)


    def setValue(self, *args):
        """
        setValue(ParameterVector self, unsigned int i, double value)
        setValue(ParameterVector self, std::string label, double value)
        """
        return ___init__.ParameterVector_setValue(self, *args)


    def getValue(self, *args):
        """
        getValue(ParameterVector self, unsigned int i) -> double
        getValue(ParameterVector self, std::string label) -> double
        """
        return ___init__.ParameterVector_getValue(self, *args)


    def getIndex(self, *args):
        """getIndex(ParameterVector self, std::string label) -> int"""
        return ___init__.ParameterVector_getIndex(self, *args)


    def getDoubleArrayPointer(self, *args):
        """getDoubleArrayPointer(ParameterVector self) -> double *"""
        return ___init__.ParameterVector_getDoubleArrayPointer(self, *args)


    def isParameter(self, *args):
        """isParameter(ParameterVector self, std::string label) -> bool"""
        return ___init__.ParameterVector_isParameter(self, *args)


    def getLabel(self, *args):
        """getLabel(ParameterVector self, unsigned int i) -> std::string"""
        return ___init__.ParameterVector_getLabel(self, *args)


    def length(self, *args):
        """length(ParameterVector self) -> int"""
        return ___init__.ParameterVector_length(self, *args)


    def getValuesVector(self, *args):
        """getValuesVector(ParameterVector self) -> std::vector< double,std::allocator< double > > const &"""
        return ___init__.ParameterVector_getValuesVector(self, *args)


    def getNamesVector(self, *args):
        """getNamesVector(ParameterVector self) -> std::vector< std::string,std::allocator< std::string > > const &"""
        return ___init__.ParameterVector_getNamesVector(self, *args)

ParameterVector_swigregister = ___init__.ParameterVector_swigregister
ParameterVector_swigregister(ParameterVector)


def __lshift__(*args):
    """__lshift__(std::ostream & stream, ParameterVector p) -> std::ostream &"""
    return ___init__.__lshift__(*args)


# Epetra namespace
__all__.append("Epetra")
from . import Epetra

# Fix ___init__ ambiguity
del ___init__
from . import ___init__

# This file is compatible with both classic and new-style classes.


