# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.EpetraExt is the python interface to the Trilinos linear
algebra services extension package EpetraExt:

    http://trilinos.sandia.gov/packages/epetraext

The purpose of EpetraExt is to provide various extensions to Epetra
that were not considered appropriate for the Epetra package.  These
extensions include I/O, matrix-matrix operations and graph coloring.

Currently, only a subset of EpetraExt classes and functions have
python interfaces, including the following user-level classes:

    * XMLReader                      - Read Epetra data from an XML file
    * XMLWriter                      - Write Epetra data as an XML file
    * CrsGraph_MapColoring           - Compute a graph coloring
    * CrsGraph_MapColoringIndex      - Compute indexes for a graph coloring

and functions:

    * MatrixMarketFileToBlockMap     - Read a BlockMap from an MM file
    * MatrixMarketFileToBlockMaps    - Read BlockMaps from an MM file
    * MatrixMarketFileToMap          - Read a Map from an MM file
    * MatrixMarketFileToMultiVector  - Read a MultiVector from an MM file
    * MatrixMarketFileToCrsMatrix    - Read a CrsMatrix from an MM file
    * MatlabFileToCrsMatrix          - Read a CrsMatrix from an ML file
    * BlockMapToMatrixMarketFile     - Write a BlockMap to an MM file
    * MultiVectorToMatrixMarketFile  - Write a MultiVector to an MM file
    * MultiVectorToMatlabFile        - Write a MultiVector to an ML file
    * RowMatrixToMatrixMarketFile    - Write a RowMatrix to an MM file
    * RowMatrixToMatlabFile          - Write a RowMatrix to an ML file
    * Add                            - Add two CrsMatrix objects
    * Multiply                       - Multiply two CrsMatrix objects

For examples of usage, please consult the following scripts in the
example subdirectory of the PyTrilinos package:

    * exEpetraExt_IO_MatrixMarket.py
    * exEpetraExt_IO_XML.py
    * exEpetraExt_MatrixMatrix.py

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_EpetraExt')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_EpetraExt')
    _EpetraExt = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_EpetraExt', [dirname(__file__)])
        except ImportError:
            import _EpetraExt
            return _EpetraExt
        try:
            _mod = imp.load_module('_EpetraExt', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _EpetraExt = swig_import_helper()
    del swig_import_helper
else:
    import _EpetraExt
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_SwigPyIterator

    def value(self):
        """value(SwigPyIterator self) -> PyObject *"""
        return _EpetraExt.SwigPyIterator_value(self)


    def incr(self, n=1):
        """
        incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        incr(SwigPyIterator self) -> SwigPyIterator
        """
        return _EpetraExt.SwigPyIterator_incr(self, n)


    def decr(self, n=1):
        """
        decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        decr(SwigPyIterator self) -> SwigPyIterator
        """
        return _EpetraExt.SwigPyIterator_decr(self, n)


    def distance(self, x):
        """distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _EpetraExt.SwigPyIterator_distance(self, x)


    def equal(self, x):
        """equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _EpetraExt.SwigPyIterator_equal(self, x)


    def copy(self):
        """copy(SwigPyIterator self) -> SwigPyIterator"""
        return _EpetraExt.SwigPyIterator_copy(self)


    def next(self):
        """next(SwigPyIterator self) -> PyObject *"""
        return _EpetraExt.SwigPyIterator_next(self)


    def __next__(self):
        """__next__(SwigPyIterator self) -> PyObject *"""
        return _EpetraExt.SwigPyIterator___next__(self)


    def previous(self):
        """previous(SwigPyIterator self) -> PyObject *"""
        return _EpetraExt.SwigPyIterator_previous(self)


    def advance(self, n):
        """advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _EpetraExt.SwigPyIterator_advance(self, n)


    def __eq__(self, x):
        """__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _EpetraExt.SwigPyIterator___eq__(self, x)


    def __ne__(self, x):
        """__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _EpetraExt.SwigPyIterator___ne__(self, x)


    def __iadd__(self, n):
        """__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _EpetraExt.SwigPyIterator___iadd__(self, n)


    def __isub__(self, n):
        """__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _EpetraExt.SwigPyIterator___isub__(self, n)


    def __add__(self, n):
        """__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _EpetraExt.SwigPyIterator___add__(self, n)


    def __sub__(self, *args):
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _EpetraExt.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _EpetraExt.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

import PyTrilinos.Teuchos
import PyTrilinos.Epetra

def EpetraExt_Version(*args):
    """EpetraExt_Version() -> std::string"""
    return _EpetraExt.EpetraExt_Version(*args)

__version__ = EpetraExt_Version().split()[2]

class XMLReader(_object):
    """Proxy of C++ EpetraExt::XMLReader class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XMLReader, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XMLReader, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(EpetraExt::XMLReader self, Comm Comm, std::string const & FileName) -> XMLReader"""
        this = _EpetraExt.new_XMLReader(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _EpetraExt.delete_XMLReader

    def ReadMap(self, *args):
        """
        ReadMap(XMLReader self, std::string const & name) -> Map


        Return a Map read from an XML file specified by filename 'name'.

        """
        return _EpetraExt.XMLReader_ReadMap(self, *args)


    def Read64Map(self, *args):
        """Read64Map(XMLReader self, std::string const & name) -> Map"""
        return _EpetraExt.XMLReader_Read64Map(self, *args)


    def ReadMultiVector(self, *args):
        """
        ReadMultiVector(XMLReader self, std::string const & name) -> MultiVector


        Return a MultiVector read from an XML file specified by filename
        'name'.

        """
        return _EpetraExt.XMLReader_ReadMultiVector(self, *args)


    def Read64MultiVector(self, *args):
        """Read64MultiVector(XMLReader self, std::string const & name) -> MultiVector"""
        return _EpetraExt.XMLReader_Read64MultiVector(self, *args)


    def ReadCrsGraph(self, *args):
        """
        ReadCrsGraph(XMLReader self, std::string const & name) -> CrsGraph


        Return a CrsGraph read from an XML file specified by filename 'name'.

        """
        return _EpetraExt.XMLReader_ReadCrsGraph(self, *args)


    def Read64CrsGraph(self, *args):
        """Read64CrsGraph(XMLReader self, std::string const & name) -> CrsGraph"""
        return _EpetraExt.XMLReader_Read64CrsGraph(self, *args)


    def ReadCrsMatrix(self, *args):
        """
        ReadCrsMatrix(XMLReader self, std::string const & name) -> CrsMatrix


        Return a CrsMatrix read from an XML file specified by filename 'name'.

        """
        return _EpetraExt.XMLReader_ReadCrsMatrix(self, *args)


    def Read64CrsMatrix(self, *args):
        """Read64CrsMatrix(XMLReader self, std::string const & name) -> CrsMatrix"""
        return _EpetraExt.XMLReader_Read64CrsMatrix(self, *args)

XMLReader_swigregister = _EpetraExt.XMLReader_swigregister
XMLReader_swigregister(XMLReader)

class XMLWriter(_object):
    """Proxy of C++ EpetraExt::XMLWriter class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XMLWriter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XMLWriter, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(EpetraExt::XMLWriter self, Comm Comm, std::string const & FileName) -> XMLWriter"""
        this = _EpetraExt.new_XMLWriter(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _EpetraExt.delete_XMLWriter

    def Create(self, *args):
        """Create(XMLWriter self, std::string const & Label)"""
        return _EpetraExt.XMLWriter_Create(self, *args)


    def Close(self, *args):
        """Close(XMLWriter self)"""
        return _EpetraExt.XMLWriter_Close(self, *args)


    def Write(self, *args):
        """
        Write(XMLWriter self, std::string const & Label, Map Map)
        Write(XMLWriter self, std::string const & Label, RowMatrix Matrix)
        Write(XMLWriter self, std::string const & Label, MultiVector MultiVector)
        Write(XMLWriter self, std::string const & Label, std::vector< std::string,std::allocator< std::string > > const & Content)
        Write(XMLWriter self, std::string const & Label, std::string const & Text)
        Write(XMLWriter self, std::string const & Label, ParameterList List)
        """
        return _EpetraExt.XMLWriter_Write(self, *args)

XMLWriter_swigregister = _EpetraExt.XMLWriter_swigregister
XMLWriter_swigregister(XMLWriter)

class Xform_CrsGraph_MapColoring(_object):
    """Proxy of C++ EpetraExt::Transform<(Epetra_CrsGraph,Epetra_MapColoring)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Xform_CrsGraph_MapColoring, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Xform_CrsGraph_MapColoring, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_Xform_CrsGraph_MapColoring

    def __call__(self, *args):
        """__call__(Xform_CrsGraph_MapColoring self, CrsGraph orig) -> MapColoring"""
        return _EpetraExt.Xform_CrsGraph_MapColoring___call__(self, *args)


    def fwd(self, *args):
        """fwd(Xform_CrsGraph_MapColoring self) -> bool"""
        return _EpetraExt.Xform_CrsGraph_MapColoring_fwd(self, *args)


    def rvs(self, *args):
        """rvs(Xform_CrsGraph_MapColoring self) -> bool"""
        return _EpetraExt.Xform_CrsGraph_MapColoring_rvs(self, *args)


    def analyze(self, *args):
        """analyze(Xform_CrsGraph_MapColoring self, CrsGraph orig) -> bool"""
        return _EpetraExt.Xform_CrsGraph_MapColoring_analyze(self, *args)


    def construct(self, *args):
        """construct(Xform_CrsGraph_MapColoring self) -> MapColoring"""
        return _EpetraExt.Xform_CrsGraph_MapColoring_construct(self, *args)


    def isConstructed(self, *args):
        """isConstructed(Xform_CrsGraph_MapColoring self) -> bool"""
        return _EpetraExt.Xform_CrsGraph_MapColoring_isConstructed(self, *args)

Xform_CrsGraph_MapColoring_swigregister = _EpetraExt.Xform_CrsGraph_MapColoring_swigregister
Xform_CrsGraph_MapColoring_swigregister(Xform_CrsGraph_MapColoring)

class Xform_CrsGraph_vecIntVector(_object):
    """Proxy of C++ EpetraExt::Transform<(Epetra_CrsGraph,std::vector<(Epetra_GIDTypeVector<(int)>::impl,std::allocator<(Epetra_GIDTypeVector<(int)>::impl)>)>)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Xform_CrsGraph_vecIntVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Xform_CrsGraph_vecIntVector, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_Xform_CrsGraph_vecIntVector

    def __call__(self, *args):
        """__call__(Xform_CrsGraph_vecIntVector self, CrsGraph orig) -> EpetraExt::Transform< Epetra_CrsGraph,std::vector< Epetra_GIDTypeVector< int >::impl,std::allocator< Epetra_GIDTypeVector< int >::impl > > >::NewTypeRef"""
        return _EpetraExt.Xform_CrsGraph_vecIntVector___call__(self, *args)


    def fwd(self, *args):
        """fwd(Xform_CrsGraph_vecIntVector self) -> bool"""
        return _EpetraExt.Xform_CrsGraph_vecIntVector_fwd(self, *args)


    def rvs(self, *args):
        """rvs(Xform_CrsGraph_vecIntVector self) -> bool"""
        return _EpetraExt.Xform_CrsGraph_vecIntVector_rvs(self, *args)


    def analyze(self, *args):
        """analyze(Xform_CrsGraph_vecIntVector self, CrsGraph orig) -> bool"""
        return _EpetraExt.Xform_CrsGraph_vecIntVector_analyze(self, *args)


    def construct(self, *args):
        """construct(Xform_CrsGraph_vecIntVector self) -> EpetraExt::Transform< Epetra_CrsGraph,std::vector< Epetra_GIDTypeVector< int >::impl,std::allocator< Epetra_GIDTypeVector< int >::impl > > >::NewTypeRef"""
        return _EpetraExt.Xform_CrsGraph_vecIntVector_construct(self, *args)


    def isConstructed(self, *args):
        """isConstructed(Xform_CrsGraph_vecIntVector self) -> bool"""
        return _EpetraExt.Xform_CrsGraph_vecIntVector_isConstructed(self, *args)

Xform_CrsGraph_vecIntVector_swigregister = _EpetraExt.Xform_CrsGraph_vecIntVector_swigregister
Xform_CrsGraph_vecIntVector_swigregister(Xform_CrsGraph_vecIntVector)

class Xform_CrsGraph_vecLongVector(_object):
    """Proxy of C++ EpetraExt::Transform<(Epetra_CrsGraph,std::vector<(Epetra_GIDTypeVector<(long long)>::impl,std::allocator<(Epetra_GIDTypeVector<(long long)>::impl)>)>)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Xform_CrsGraph_vecLongVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Xform_CrsGraph_vecLongVector, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_Xform_CrsGraph_vecLongVector

    def __call__(self, *args):
        """__call__(Xform_CrsGraph_vecLongVector self, CrsGraph orig) -> EpetraExt::Transform< Epetra_CrsGraph,std::vector< Epetra_GIDTypeVector< long long >::impl,std::allocator< Epetra_GIDTypeVector< long long >::impl > > >::NewTypeRef"""
        return _EpetraExt.Xform_CrsGraph_vecLongVector___call__(self, *args)


    def fwd(self, *args):
        """fwd(Xform_CrsGraph_vecLongVector self) -> bool"""
        return _EpetraExt.Xform_CrsGraph_vecLongVector_fwd(self, *args)


    def rvs(self, *args):
        """rvs(Xform_CrsGraph_vecLongVector self) -> bool"""
        return _EpetraExt.Xform_CrsGraph_vecLongVector_rvs(self, *args)


    def analyze(self, *args):
        """analyze(Xform_CrsGraph_vecLongVector self, CrsGraph orig) -> bool"""
        return _EpetraExt.Xform_CrsGraph_vecLongVector_analyze(self, *args)


    def construct(self, *args):
        """construct(Xform_CrsGraph_vecLongVector self) -> EpetraExt::Transform< Epetra_CrsGraph,std::vector< Epetra_GIDTypeVector< long long >::impl,std::allocator< Epetra_GIDTypeVector< long long >::impl > > >::NewTypeRef"""
        return _EpetraExt.Xform_CrsGraph_vecLongVector_construct(self, *args)


    def isConstructed(self, *args):
        """isConstructed(Xform_CrsGraph_vecLongVector self) -> bool"""
        return _EpetraExt.Xform_CrsGraph_vecLongVector_isConstructed(self, *args)

Xform_CrsGraph_vecLongVector_swigregister = _EpetraExt.Xform_CrsGraph_vecLongVector_swigregister
Xform_CrsGraph_vecLongVector_swigregister(Xform_CrsGraph_vecLongVector)

class Xform_CrsMatrix_CrsMatrix(_object):
    """Proxy of C++ EpetraExt::Transform<(Epetra_CrsMatrix,Epetra_CrsMatrix)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Xform_CrsMatrix_CrsMatrix, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Xform_CrsMatrix_CrsMatrix, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_Xform_CrsMatrix_CrsMatrix

    def __call__(self, *args):
        """__call__(Xform_CrsMatrix_CrsMatrix self, CrsMatrix orig) -> CrsMatrix"""
        return _EpetraExt.Xform_CrsMatrix_CrsMatrix___call__(self, *args)


    def fwd(self, *args):
        """fwd(Xform_CrsMatrix_CrsMatrix self) -> bool"""
        return _EpetraExt.Xform_CrsMatrix_CrsMatrix_fwd(self, *args)


    def rvs(self, *args):
        """rvs(Xform_CrsMatrix_CrsMatrix self) -> bool"""
        return _EpetraExt.Xform_CrsMatrix_CrsMatrix_rvs(self, *args)


    def analyze(self, *args):
        """analyze(Xform_CrsMatrix_CrsMatrix self, CrsMatrix orig) -> bool"""
        return _EpetraExt.Xform_CrsMatrix_CrsMatrix_analyze(self, *args)


    def construct(self, *args):
        """construct(Xform_CrsMatrix_CrsMatrix self) -> CrsMatrix"""
        return _EpetraExt.Xform_CrsMatrix_CrsMatrix_construct(self, *args)


    def isConstructed(self, *args):
        """isConstructed(Xform_CrsMatrix_CrsMatrix self) -> bool"""
        return _EpetraExt.Xform_CrsMatrix_CrsMatrix_isConstructed(self, *args)

Xform_CrsMatrix_CrsMatrix_swigregister = _EpetraExt.Xform_CrsMatrix_CrsMatrix_swigregister
Xform_CrsMatrix_CrsMatrix_swigregister(Xform_CrsMatrix_CrsMatrix)

class SXform_CrsGraph_MapColoring(Xform_CrsGraph_MapColoring):
    """Proxy of C++ EpetraExt::StructuralTransform<(Epetra_CrsGraph,Epetra_MapColoring)> class."""

    __swig_setmethods__ = {}
    for _s in [Xform_CrsGraph_MapColoring]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SXform_CrsGraph_MapColoring, name, value)
    __swig_getmethods__ = {}
    for _s in [Xform_CrsGraph_MapColoring]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SXform_CrsGraph_MapColoring, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def fwd(self, *args):
        """fwd(SXform_CrsGraph_MapColoring self) -> bool"""
        return _EpetraExt.SXform_CrsGraph_MapColoring_fwd(self, *args)


    def rvs(self, *args):
        """rvs(SXform_CrsGraph_MapColoring self) -> bool"""
        return _EpetraExt.SXform_CrsGraph_MapColoring_rvs(self, *args)

    __swig_destroy__ = _EpetraExt.delete_SXform_CrsGraph_MapColoring
SXform_CrsGraph_MapColoring_swigregister = _EpetraExt.SXform_CrsGraph_MapColoring_swigregister
SXform_CrsGraph_MapColoring_swigregister(SXform_CrsGraph_MapColoring)

class SXform_CrsGraph_vecIntVector(Xform_CrsGraph_vecIntVector):
    """Proxy of C++ EpetraExt::StructuralTransform<(Epetra_CrsGraph,std::vector<(Epetra_GIDTypeVector<(int)>::impl)>)> class."""

    __swig_setmethods__ = {}
    for _s in [Xform_CrsGraph_vecIntVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SXform_CrsGraph_vecIntVector, name, value)
    __swig_getmethods__ = {}
    for _s in [Xform_CrsGraph_vecIntVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SXform_CrsGraph_vecIntVector, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def fwd(self, *args):
        """fwd(SXform_CrsGraph_vecIntVector self) -> bool"""
        return _EpetraExt.SXform_CrsGraph_vecIntVector_fwd(self, *args)


    def rvs(self, *args):
        """rvs(SXform_CrsGraph_vecIntVector self) -> bool"""
        return _EpetraExt.SXform_CrsGraph_vecIntVector_rvs(self, *args)

    __swig_destroy__ = _EpetraExt.delete_SXform_CrsGraph_vecIntVector
SXform_CrsGraph_vecIntVector_swigregister = _EpetraExt.SXform_CrsGraph_vecIntVector_swigregister
SXform_CrsGraph_vecIntVector_swigregister(SXform_CrsGraph_vecIntVector)

class SXform_CrsGraph_vecLongVector(Xform_CrsGraph_vecLongVector):
    """Proxy of C++ EpetraExt::StructuralTransform<(Epetra_CrsGraph,std::vector<(Epetra_GIDTypeVector<(long long)>::impl)>)> class."""

    __swig_setmethods__ = {}
    for _s in [Xform_CrsGraph_vecLongVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SXform_CrsGraph_vecLongVector, name, value)
    __swig_getmethods__ = {}
    for _s in [Xform_CrsGraph_vecLongVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SXform_CrsGraph_vecLongVector, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def fwd(self, *args):
        """fwd(SXform_CrsGraph_vecLongVector self) -> bool"""
        return _EpetraExt.SXform_CrsGraph_vecLongVector_fwd(self, *args)


    def rvs(self, *args):
        """rvs(SXform_CrsGraph_vecLongVector self) -> bool"""
        return _EpetraExt.SXform_CrsGraph_vecLongVector_rvs(self, *args)

    __swig_destroy__ = _EpetraExt.delete_SXform_CrsGraph_vecLongVector
SXform_CrsGraph_vecLongVector_swigregister = _EpetraExt.SXform_CrsGraph_vecLongVector_swigregister
SXform_CrsGraph_vecLongVector_swigregister(SXform_CrsGraph_vecLongVector)

class SameXform_CrsMatrix(Xform_CrsMatrix_CrsMatrix):
    """Proxy of C++ EpetraExt::SameTypeTransform<(Epetra_CrsMatrix)> class."""

    __swig_setmethods__ = {}
    for _s in [Xform_CrsMatrix_CrsMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SameXform_CrsMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [Xform_CrsMatrix_CrsMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SameXform_CrsMatrix, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_SameXform_CrsMatrix
SameXform_CrsMatrix_swigregister = _EpetraExt.SameXform_CrsMatrix_swigregister
SameXform_CrsMatrix_swigregister(SameXform_CrsMatrix)

class CrsGraph_MapColoring(SXform_CrsGraph_MapColoring):
    """Proxy of C++ EpetraExt::CrsGraph_MapColoring class."""

    __swig_setmethods__ = {}
    for _s in [SXform_CrsGraph_MapColoring]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsGraph_MapColoring, name, value)
    __swig_getmethods__ = {}
    for _s in [SXform_CrsGraph_MapColoring]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CrsGraph_MapColoring, name)
    __repr__ = _swig_repr
    GREEDY = _EpetraExt.CrsGraph_MapColoring_GREEDY
    LUBY = _EpetraExt.CrsGraph_MapColoring_LUBY
    JONES_PLASSMAN = _EpetraExt.CrsGraph_MapColoring_JONES_PLASSMAN
    PSEUDO_PARALLEL = _EpetraExt.CrsGraph_MapColoring_PSEUDO_PARALLEL
    __swig_destroy__ = _EpetraExt.delete_CrsGraph_MapColoring

    def __init__(self, *args):
        """__init__(EpetraExt::CrsGraph_MapColoring self, EpetraExt::CrsGraph_MapColoring::ColoringAlgorithm algo, int reordering=0, bool distance1=False, int verbosity=0) -> CrsGraph_MapColoring"""
        this = _EpetraExt.new_CrsGraph_MapColoring(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __call__(self, *args):
        """__call__(CrsGraph_MapColoring self, CrsGraph orig) -> MapColoring"""
        return _EpetraExt.CrsGraph_MapColoring___call__(self, *args)

CrsGraph_MapColoring_swigregister = _EpetraExt.CrsGraph_MapColoring_swigregister
CrsGraph_MapColoring_swigregister(CrsGraph_MapColoring)

class TCrsGraph_MapColoringIndex_int(SXform_CrsGraph_vecIntVector):
    """Proxy of C++ EpetraExt::TCrsGraph_MapColoringIndex<(int)> class."""

    __swig_setmethods__ = {}
    for _s in [SXform_CrsGraph_vecIntVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TCrsGraph_MapColoringIndex_int, name, value)
    __swig_getmethods__ = {}
    for _s in [SXform_CrsGraph_vecIntVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TCrsGraph_MapColoringIndex_int, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
TCrsGraph_MapColoringIndex_int_swigregister = _EpetraExt.TCrsGraph_MapColoringIndex_int_swigregister
TCrsGraph_MapColoringIndex_int_swigregister(TCrsGraph_MapColoringIndex_int)

class TCrsGraph_MapColoringIndex_long(SXform_CrsGraph_vecLongVector):
    """Proxy of C++ EpetraExt::TCrsGraph_MapColoringIndex<(long long)> class."""

    __swig_setmethods__ = {}
    for _s in [SXform_CrsGraph_vecLongVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TCrsGraph_MapColoringIndex_long, name, value)
    __swig_getmethods__ = {}
    for _s in [SXform_CrsGraph_vecLongVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TCrsGraph_MapColoringIndex_long, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
TCrsGraph_MapColoringIndex_long_swigregister = _EpetraExt.TCrsGraph_MapColoringIndex_long_swigregister
TCrsGraph_MapColoringIndex_long_swigregister(TCrsGraph_MapColoringIndex_long)

class CrsGraph_MapColoringIndex(TCrsGraph_MapColoringIndex_int):
    """Proxy of C++ EpetraExt::CrsGraph_MapColoringIndex class."""

    __swig_setmethods__ = {}
    for _s in [TCrsGraph_MapColoringIndex_int]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsGraph_MapColoringIndex, name, value)
    __swig_getmethods__ = {}
    for _s in [TCrsGraph_MapColoringIndex_int]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CrsGraph_MapColoringIndex, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_CrsGraph_MapColoringIndex

    def __init__(self, *args):
        """__init__(EpetraExt::CrsGraph_MapColoringIndex self, MapColoring ColorMap) -> CrsGraph_MapColoringIndex"""
        this = _EpetraExt.new_CrsGraph_MapColoringIndex(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __call__(self, *args):
        """__call__(CrsGraph_MapColoringIndex self, CrsGraph orig) -> std::vector< Epetra_IntVector,std::allocator< Epetra_IntVector > > &"""
        return _EpetraExt.CrsGraph_MapColoringIndex___call__(self, *args)

CrsGraph_MapColoringIndex_swigregister = _EpetraExt.CrsGraph_MapColoringIndex_swigregister
CrsGraph_MapColoringIndex_swigregister(CrsGraph_MapColoringIndex)

class CrsGraph_MapColoringIndex64(TCrsGraph_MapColoringIndex_long):
    """Proxy of C++ EpetraExt::CrsGraph_MapColoringIndex64 class."""

    __swig_setmethods__ = {}
    for _s in [TCrsGraph_MapColoringIndex_long]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsGraph_MapColoringIndex64, name, value)
    __swig_getmethods__ = {}
    for _s in [TCrsGraph_MapColoringIndex_long]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CrsGraph_MapColoringIndex64, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_CrsGraph_MapColoringIndex64

    def __init__(self, *args):
        """__init__(EpetraExt::CrsGraph_MapColoringIndex64 self, MapColoring ColorMap) -> CrsGraph_MapColoringIndex64"""
        this = _EpetraExt.new_CrsGraph_MapColoringIndex64(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __call__(self, *args):
        """__call__(CrsGraph_MapColoringIndex64 self, CrsGraph orig) -> std::vector< Epetra_LongLongVector,std::allocator< Epetra_LongLongVector > > &"""
        return _EpetraExt.CrsGraph_MapColoringIndex64___call__(self, *args)

CrsGraph_MapColoringIndex64_swigregister = _EpetraExt.CrsGraph_MapColoringIndex64_swigregister
CrsGraph_MapColoringIndex64_swigregister(CrsGraph_MapColoringIndex64)


def MatrixMarketFileToMultiVector(*args):
    """
    MatrixMarketFileToMultiVector(str filename, Epetra.BlockMap) ->
        Epetra.MultiVector

    Return a MultiVector read from a matix market file.
    """
    return _EpetraExt.MatrixMarketFileToMultiVector(*args)

def MultiVectorToMatrixMarketFile(*args):
    """MultiVectorToMatrixMarketFile(char const * filename, MultiVector A, char const * matrixName=None, char const * matrixDescription=None, bool writeHeader=True) -> int"""
    return _EpetraExt.MultiVectorToMatrixMarketFile(*args)

def MultiVectorToMatlabFile(*args):
    """MultiVectorToMatlabFile(char const * filename, MultiVector A) -> int"""
    return _EpetraExt.MultiVectorToMatlabFile(*args)

def MultiVectorToMatrixMarketHandle(*args):
    """MultiVectorToMatrixMarketHandle(std::FILE * handle, MultiVector A) -> int"""
    return _EpetraExt.MultiVectorToMatrixMarketHandle(*args)

def MultiVectorToMatlabHandle(*args):
    """MultiVectorToMatlabHandle(std::FILE * handle, MultiVector A) -> int"""
    return _EpetraExt.MultiVectorToMatlabHandle(*args)

def MultiVectorToHandle(*args):
    """MultiVectorToHandle(std::FILE * handle, MultiVector A, bool mmFormat) -> int"""
    return _EpetraExt.MultiVectorToHandle(*args)

def writeMultiVector(*args):
    """writeMultiVector(std::FILE * handle, MultiVector A, bool mmFormat) -> int"""
    return _EpetraExt.writeMultiVector(*args)

def MatlabFileToCrsMatrix(*args):
    """
    MatlabFileToCrsMatrix(str filename, Epetra.Comm) -> Epetra.CrsMatrix

    Return a CrsMatrix read from a matlab file.
    """
    return _EpetraExt.MatlabFileToCrsMatrix(*args)

def MatrixMarketFileToCrsMatrix(*args):
    """
    MatrixMarketFileToCrsMatrix(str filename, Epetra.Map rowMap, Epetra.Map
        colMap=None, Epetra.Map rangeMap=None, Epetra.Map domainMap=None) ->
        Epetra.CrsMatrix

    Return a CrsMatrix read from a matrix market file.
    MatrixMarketFileToCrsMatrix(str filename, Epetra.Map rowMap, Epetra.Map
        colMap=None, Epetra.Map rangeMap=None, Epetra.Map domainMap=None) ->
        Epetra.CrsMatrix

    Return a CrsMatrix read from a matrix market file.
    MatrixMarketFileToCrsMatrix(str filename, Epetra.Map rowMap, Epetra.Map
        colMap=None, Epetra.Map rangeMap=None, Epetra.Map domainMap=None) ->
        Epetra.CrsMatrix

    Return a CrsMatrix read from a matrix market file.
    MatrixMarketFileToCrsMatrix(str filename, Epetra.Map rowMap, Epetra.Map
        colMap=None, Epetra.Map rangeMap=None, Epetra.Map domainMap=None) ->
        Epetra.CrsMatrix

    Return a CrsMatrix read from a matrix market file.
    MatrixMarketFileToCrsMatrix(str filename, Epetra.Map rowMap, Epetra.Map
        colMap=None, Epetra.Map rangeMap=None, Epetra.Map domainMap=None) ->
        Epetra.CrsMatrix

    Return a CrsMatrix read from a matrix market file.
    """
    return _EpetraExt.MatrixMarketFileToCrsMatrix(*args)

def HypreFileToCrsMatrix(*args):
    """HypreFileToCrsMatrix(char const * filename, Comm comm) -> int"""
    return _EpetraExt.HypreFileToCrsMatrix(*args)

def MatrixMarketFileToCrsMatrixHandle(*args):
    """MatrixMarketFileToCrsMatrixHandle(char const * filename, Comm comm, Map rowMap=None, Map colMap=None, Map rangeMap=None, Map domainMap=None, bool const transpose=0, bool const verbose=0) -> int"""
    return _EpetraExt.MatrixMarketFileToCrsMatrixHandle(*args)

def MatlabFileToCrsMatrix64(*args):
    """MatlabFileToCrsMatrix64(char const * filename, Comm comm) -> int"""
    return _EpetraExt.MatlabFileToCrsMatrix64(*args)

def MatrixMarketFileToCrsMatrix64(*args):
    """
    MatrixMarketFileToCrsMatrix64(char const * filename, Comm comm, bool const transpose=0, bool const verbose=0) -> int
    MatrixMarketFileToCrsMatrix64(char const * filename, Map rowMap, Map rangeMap, Map domainMap, bool const transpose=0, bool const verbose=0) -> int
    MatrixMarketFileToCrsMatrix64(char const * filename, Map rowMap, bool const transpose=0, bool const verbose=0) -> int
    MatrixMarketFileToCrsMatrix64(char const * filename, Map rowMap, Map colMap, bool const transpose=0, bool const verbose=0) -> int
    MatrixMarketFileToCrsMatrix64(char const * filename, Map rowMap, Map colMap, Map rangeMap, Map domainMap, bool const transpose=0, bool const verbose=0) -> int
    """
    return _EpetraExt.MatrixMarketFileToCrsMatrix64(*args)

def HypreFileToCrsMatrix64(*args):
    """HypreFileToCrsMatrix64(char const * filename, Comm comm) -> int"""
    return _EpetraExt.HypreFileToCrsMatrix64(*args)

def MatrixMarketFileToCrsMatrixHandle64(*args):
    """MatrixMarketFileToCrsMatrixHandle64(char const * filename, Comm comm, Map rowMap=None, Map colMap=None, Map rangeMap=None, Map domainMap=None, bool const transpose=0, bool const verbose=0) -> int"""
    return _EpetraExt.MatrixMarketFileToCrsMatrixHandle64(*args)

def RowMatrixToMatrixMarketFile(*args):
    """RowMatrixToMatrixMarketFile(char const * filename, RowMatrix A, char const * matrixName=None, char const * matrixDescription=None, bool writeHeader=True) -> int"""
    return _EpetraExt.RowMatrixToMatrixMarketFile(*args)

def RowMatrixToMatlabFile(*args):
    """RowMatrixToMatlabFile(char const * filename, RowMatrix A) -> int"""
    return _EpetraExt.RowMatrixToMatlabFile(*args)

def RowMatrixToHandle(*args):
    """RowMatrixToHandle(std::FILE * handle, RowMatrix A) -> int"""
    return _EpetraExt.RowMatrixToHandle(*args)

def writeRowMatrix(*args):
    """writeRowMatrix(std::FILE * handle, RowMatrix A) -> int"""
    return _EpetraExt.writeRowMatrix(*args)

def MatrixMarketFileToBlockMap(*args):
    """
    MatrixMarketFileToBlockMap(str filename, Epetra.Comm) -> Epetra.BlockMap

    Return a BlockMap read from a matrix market file.
    """
    return _EpetraExt.MatrixMarketFileToBlockMap(*args)

def MatrixMarketFileToBlockMap64(*args):
    """MatrixMarketFileToBlockMap64(char const * filename, Comm comm) -> int"""
    return _EpetraExt.MatrixMarketFileToBlockMap64(*args)

def MatrixMarketFileToMap(*args):
    """
    MatrixMarketFileToMap(str filename, Epetra.Comm) -> Epetra.Map

    Return a Map read from a matrix market file.
    """
    return _EpetraExt.MatrixMarketFileToMap(*args)

def MatrixMarketFileToMap64(*args):
    """MatrixMarketFileToMap64(char const * filename, Comm comm) -> int"""
    return _EpetraExt.MatrixMarketFileToMap64(*args)

def MatrixMarketFileToBlockMaps(*args):
    """
    MatrixMarketFileToBlockMaps(str filename, Epetra.Comm) ->
        (Epetra.BlockMap rowMap, Epetra.BlockMap colMap, Epetra.BlockMap rangeMap,
         Epetra.BlockMap domainMap)

    Return a tuple of BlockMaps read from a matrix market file.  The
    BlockMaps, listed in order, are the row map, the column map, the range
    map and the domain map.
    """
    return _EpetraExt.MatrixMarketFileToBlockMaps(*args)

def MatrixMarketFileToBlockMaps64(*args):
    """MatrixMarketFileToBlockMaps64(char const * filename, Comm comm) -> int"""
    return _EpetraExt.MatrixMarketFileToBlockMaps64(*args)

def BlockMapToMatrixMarketFile(*args):
    """BlockMapToMatrixMarketFile(char const * filename, BlockMap blockMap, char const * mapName=None, char const * mapDescription=None, bool writeHeader=True) -> int"""
    return _EpetraExt.BlockMapToMatrixMarketFile(*args)

def BlockMapToHandle(*args):
    """BlockMapToHandle(std::FILE * handle, BlockMap blockMap) -> int"""
    return _EpetraExt.BlockMapToHandle(*args)

def writeBlockMap(*args):
    """
    writeBlockMap(std::FILE * handle, long long length, int const * v1, int const * v2, bool doSizes) -> int
    writeBlockMap(std::FILE * handle, long long length, long long const * v1, int const * v2, bool doSizes) -> int
    """
    return _EpetraExt.writeBlockMap(*args)
class CrsMatrix_SubCopy(SameXform_CrsMatrix):
    """Proxy of C++ EpetraExt::CrsMatrix_SubCopy class."""

    __swig_setmethods__ = {}
    for _s in [SameXform_CrsMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsMatrix_SubCopy, name, value)
    __swig_getmethods__ = {}
    for _s in [SameXform_CrsMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CrsMatrix_SubCopy, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_CrsMatrix_SubCopy

    def __init__(self, *args):
        """
        __init__(EpetraExt::CrsMatrix_SubCopy self, Map newMap) -> CrsMatrix_SubCopy
        __init__(EpetraExt::CrsMatrix_SubCopy self, Map newRangeAndRowMap, Map newDomainMap) -> CrsMatrix_SubCopy
        """
        this = _EpetraExt.new_CrsMatrix_SubCopy(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __call__(self, *args):
        """__call__(CrsMatrix_SubCopy self, CrsMatrix orig) -> CrsMatrix"""
        return _EpetraExt.CrsMatrix_SubCopy___call__(self, *args)


    def fwd(self, *args):
        """fwd(CrsMatrix_SubCopy self) -> bool"""
        return _EpetraExt.CrsMatrix_SubCopy_fwd(self, *args)


    def rvs(self, *args):
        """rvs(CrsMatrix_SubCopy self) -> bool"""
        return _EpetraExt.CrsMatrix_SubCopy_rvs(self, *args)

CrsMatrix_SubCopy_swigregister = _EpetraExt.CrsMatrix_SubCopy_swigregister
CrsMatrix_SubCopy_swigregister(CrsMatrix_SubCopy)


def Add(*args):
    """
    Add(Epetra.CrsMatrix A, bool flag, float valA, Epetra.CrsMatrix B,
        float valB) -> int

    Compute B <- valA * A + valB * B.  If flag is True, use the transpose
    of A.  B must either have the structure of A+B or not yet have
    FillComplete() called on it.
    """
    return _EpetraExt.Add(*args)

def Multiply(*args):
    """
    Multiply(Epetra.CrsMatrix A, bool transposeA, Epetra.CrsMatrix B, bool
        transposeB, Epetra.CrsMatrix C) -> int

    Compute C <- A * B, where transposeA and transposeB control the
    transposition of A and B respectively.  C must have the structure of A
    * B, or not yet have FillComplete() called on it.
    """
    return _EpetraExt.Multiply(*args)

from PyTrilinos import Epetra
from PyTrilinos import PropertyBase
from PyTrilinos import typed_tuple
from PyTrilinos import tuple_of_int
from PyTrilinos import tuple_of_str
tuple_of_Vector = typed_tuple(Epetra.Vector)



class InArgs(PropertyBase):
    """
    InArgs proxy class.

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    description  - string description of associated ModelEvaluation
    x            - bool or Epetra.Vector: solution vector support.  If True, the
                   solver should allocate the vector.  If False, x is not
                   supported.  If a vector, the solver should use the
                   user-provided data.  (default False)
    x_dot        - bool or Epetra.Vector: time derivative of solution vector
                   support.  If True, the solver should allocate the vector.  If
                   False, x_dot is not supported.  If a vector, the solver
                   should use the user- provided data.  (default False)
    p            - int or tuple_of_Vector: VARIABLE P support.  If an int, the
                   solver should allocate an array of the given number of
                   vectors.  If 0, p is not supported.  If a tuple_of_Vector,
                   the solver should use the user-provided data.  (default 0)
    t            - float: time (default None)
    alpha        - float: VARIABLE ALPHA (default None)
    beta         - float: VARIABLE BETA (default None)
    """
    props = {'description' : str,
             'x'           : (bool, Epetra.Vector),
#'x_poly'      : Teuchos.Polynomial,
             'x_dot'       : (bool, Epetra.Vector),
#'x_dot_poly'  : Teuchos.Polynomial,
             'p'           : (int, tuple_of_Vector),
             't'           : float,
             'alpha'       : float,
             'beta'        : float
             }
    defaults = {'description' : 'WARNING!  THIS INARGS OBJECT IS UNINITALIZED!',
                'x'           : False,
                'x_dot'       : False,
                'p'           : 0
                }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)



class Evaluation(PropertyBase):
    """
    Evaluation< RCP<Epetra_Vector> > proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    vector  - Epetra.Vector: (default None)
    type    - str: an enumeration limited to 'exact', 'approx_deriv', and
              'very_approx_deriv' (default None)
    """
    props = {'vector' : Epetra.Vector,
             'type'   : ('exact', 'approx_deriv', 'very_approx_deriv')
             }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)

tuple_of_Evaluation = typed_tuple(Evaluation)



class DerivativeSupport(PropertyBase):
    """
    DerivativeSupport proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    linearOp      - bool: True indicates that derivative is a linear operator
                    (default False)
    mVByCol       - bool: True indicates that derivative is a MultiVector stored
                    by column (defualt False)
    transMVByRow  - bool: True indicates that derivative is a transpose
                    MultiVector stored by row (default False)
    """
    props = {'linearOp'     : bool,
             'mVByCol'      : bool,
             'transMVByRow' : bool
             }
    defaults = {'linearOp'     : False,
                'mVByCol'      : False,
                'transMVByRow' : False
                }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)
    def none(self):
        noTrue = [True] * len(self.props)
        return (props.values() == noTrue)

tuple_of_DerivativeSupport = typed_tuple(DerivativeSupport)



class DerivativeProperties(PropertyBase):
    """
    DerivativeProperties proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    linearity        - str: an enumeration limited to 'unknown', 'const' and
                       'nonconst' (default 'unknown')
    rank             - str: an enumeration limited to 'unknown', 'full' and
                       'deficient' (default 'unknown')
    supportsAdjoint  - bool: True indicates that the adjoint is supported
                       (default False)
    """
    props = {'linearity'       : ('unknown', 'const', 'nonconst'),
             'rank'            : ('unknown', 'full', 'deficient'),
             'supportsAdjoint' : bool}
    defaults = {'linearity'       : 'unknown',
                'rank'            : 'unknown',
                'supportsAdjoint' : False}
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)

tuple_of_DerivativeProperties = typed_tuple(DerivativeProperties)



class DerivativeMultiVector(PropertyBase):
    """
    DerivativeMultiVector proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    multiVector   - Epetra.MultiVector: (default None)
    orientation   - str: an enumeration limited to 'mv_by_col', and
                    'trans_mv_by_row' (default None)
    paramIndexes  - tuple_of_int: (default None)
    """
    props = {'multiVector'  : Epetra.MultiVector,
             'orientation'  : ('mv_by_col', 'trans_mv_by_row'),
             'paramIndexes' : tuple_of_int
             }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)



class Derivative(PropertyBase):
    """
    Derivative proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    operator               - Epetra.Operator (default None)
    derivativeMultiVector  - DerivativeMultiVector (default None)

    Only one or the other of these two attributes should be set, to indicate the
    nature of the derivitive evaluation.
    """
    props = {'operator'              : Epetra.Operator,
             'derivativeMultiVector' : DerivativeMultiVector
             }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)
    def isEmpty(self):
        return (self.operator is None) and (self.derivativeMultiVector is None)

tuple_of_Derivative = typed_tuple(Derivative)



class OutArgs(PropertyBase):
    """
    OutArgs proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    description          - string description of associated ModelEvaluation
    g                    - (int, tuple_of_Evaluation): VARIABLE G support.  If
                           an int, the solver should allocate an array of the
                           given number of Evaluations.  If 0, g is not
                           supported.  If a tuple_of_Evaluation, the solver
                           should use the user-provided data.  (default 0)
    f                    - (bool, Evaluation): VARIABLE F support.  If True, the
                           solver should allocate the Evaluation.  If False, f
                           is not supported.  If an Evaluation, the solver
                           should use the user-supplied data.  (default False)
    W                    - (bool, Epetra.Operator): VARIABLE W support.  If True, the
                           solver should allocate the operator.  If False, W
                           is not supported.  If an operator, the solver
                           should use the user-supplied data.  (default False)
    W_properties         - DerivativeProperties: derivative properties for
                           VARIABLE W.  (default None)
    DfDp                 - (int, tuple_of_Derivative): VARIABLE DFDP support.  If
                           an int, the solver should allocate an array of the
                           given number of Derivatives.  If 0, DfDp is not
                           supported.  If a tuple_of_Derivative, the solver
                           should use the user-provided data.  (default 0)
    DfDp_properties      - tuple_of_DerivativeProperties: derivative properties
                           for VARIABLE DFDP.  (default None)
    DgDx                 - (int, tuple_of_Derivative): VARIABLE DGDX support.  If
                           an int, the solver should allocate an array of the
                           given number of Derivatives.  If 0, DgDx is not
                           supported.  If a tuple_of_Derivative, the solver
                           should use the user-provided data.  (default 0)
    DgDx_properties      - tuple_of_DerivativeProperties: derivative properties
                           for VARIABLE DGDX.  (default None)
    DgDx_dot             - (int, tuple_of_Derivative): VARIABLE DGDX_DOT support.
                           If an int, the solver should allocate an array of the
                           given number of Derivatives.  If 0, DgDx_dot is not
                           supported.  If a tuple_of_Derivative, the solver
                           should use the user-provided data.  (default 0)
    DgDx_dot_properties  - tuple_of_DerivativeProperties: derivative properties
                           for VARIABLE DGDX_DOT.  (default None)
    DgDp                 - (int, tuple_of_Derivative): VARIABLE DGDP support.  If
                           an int, the solver should allocate an array of the
                           given number of Derivatives.  If 0, DgDp is not
                           supported.  If a tuple_of_Derivative, the solver
                           should use the user-provided data.  (default 0)
    DgDp_properties      - tuple_of_DerivativeProperties: derivative properties
                           for VARIABLE DGDP.  (default None)
    """
    props = {'description'         : str,
             'g'                   : (int, tuple_of_Evaluation),
             'f'                   : (bool, Evaluation),
             'W'                   : (bool, Epetra.Operator),
             'W_properties'        : DerivativeProperties,
#'f_poly'              : Teuchos.Polynomial,
             'DfDp'                : (int, tuple_of_Derivative),
             'DfDp_properties'     : tuple_of_DerivativeProperties,
             'DgDx'                : (int, tuple_of_Derivative),
             'DgDx_properties'     : tuple_of_DerivativeProperties,
             'DgDx_dot'            : (int, tuple_of_Derivative),
             'DgDx_dot_properties' : tuple_of_DerivativeProperties,
             'DgDp'                : (int, tuple_of_Derivative),
             'DgDp_properties'     : tuple_of_DerivativeProperties
             }
    defaults = {'description' : 'WARNING!  THIS OUTARGS OBJECT IS UNINITALIZED!',
                'g'           : 0,
                'f'           : False,
                'W'           : False,
                'DfDp'        : 0,
                'DgDx'        : 0,
                'DgDx_dot'    : 0,
                'DgDp'        : 0
                }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)


class ModelEvaluator(PyTrilinos.Teuchos.Describable):
    """Proxy of C++ EpetraExt::ModelEvaluator class."""

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.Teuchos.Describable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ModelEvaluator, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.Teuchos.Describable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ModelEvaluator, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_ModelEvaluator

    def get_x_map(self, *args):
        """get_x_map(ModelEvaluator self) -> Teuchos::RCP< Epetra_Map const >"""
        return _EpetraExt.ModelEvaluator_get_x_map(self, *args)


    def get_f_map(self, *args):
        """get_f_map(ModelEvaluator self) -> Teuchos::RCP< Epetra_Map const >"""
        return _EpetraExt.ModelEvaluator_get_f_map(self, *args)


    def get_p_map(self, *args):
        """get_p_map(ModelEvaluator self, int l) -> Teuchos::RCP< Epetra_Map const >"""
        return _EpetraExt.ModelEvaluator_get_p_map(self, *args)


    def get_p_names(self, *args):
        """get_p_names(ModelEvaluator self, int l) -> Teuchos::RCP< Teuchos::Array< std::string > const >"""
        return _EpetraExt.ModelEvaluator_get_p_names(self, *args)


    def get_g_map(self, *args):
        """get_g_map(ModelEvaluator self, int j) -> Teuchos::RCP< Epetra_Map const >"""
        return _EpetraExt.ModelEvaluator_get_g_map(self, *args)


    def get_x_init(self, *args):
        """get_x_init(ModelEvaluator self) -> Teuchos::RCP< Epetra_Vector const >"""
        return _EpetraExt.ModelEvaluator_get_x_init(self, *args)


    def get_x_dot_init(self, *args):
        """get_x_dot_init(ModelEvaluator self) -> Teuchos::RCP< Epetra_Vector const >"""
        return _EpetraExt.ModelEvaluator_get_x_dot_init(self, *args)


    def get_p_init(self, *args):
        """get_p_init(ModelEvaluator self, int l) -> Teuchos::RCP< Epetra_Vector const >"""
        return _EpetraExt.ModelEvaluator_get_p_init(self, *args)


    def get_t_init(self, *args):
        """get_t_init(ModelEvaluator self) -> double"""
        return _EpetraExt.ModelEvaluator_get_t_init(self, *args)


    def getInfBound(self, *args):
        """getInfBound(ModelEvaluator self) -> double"""
        return _EpetraExt.ModelEvaluator_getInfBound(self, *args)


    def get_x_lower_bounds(self, *args):
        """get_x_lower_bounds(ModelEvaluator self) -> Teuchos::RCP< Epetra_Vector const >"""
        return _EpetraExt.ModelEvaluator_get_x_lower_bounds(self, *args)


    def get_x_upper_bounds(self, *args):
        """get_x_upper_bounds(ModelEvaluator self) -> Teuchos::RCP< Epetra_Vector const >"""
        return _EpetraExt.ModelEvaluator_get_x_upper_bounds(self, *args)


    def get_p_lower_bounds(self, *args):
        """get_p_lower_bounds(ModelEvaluator self, int l) -> Teuchos::RCP< Epetra_Vector const >"""
        return _EpetraExt.ModelEvaluator_get_p_lower_bounds(self, *args)


    def get_p_upper_bounds(self, *args):
        """get_p_upper_bounds(ModelEvaluator self, int l) -> Teuchos::RCP< Epetra_Vector const >"""
        return _EpetraExt.ModelEvaluator_get_p_upper_bounds(self, *args)


    def get_t_lower_bound(self, *args):
        """get_t_lower_bound(ModelEvaluator self) -> double"""
        return _EpetraExt.ModelEvaluator_get_t_lower_bound(self, *args)


    def get_t_upper_bound(self, *args):
        """get_t_upper_bound(ModelEvaluator self) -> double"""
        return _EpetraExt.ModelEvaluator_get_t_upper_bound(self, *args)


    def create_W(self, *args):
        """create_W(ModelEvaluator self) -> Teuchos::RCP< Epetra_Operator >"""
        return _EpetraExt.ModelEvaluator_create_W(self, *args)


    def create_DfDp_op(self, *args):
        """create_DfDp_op(ModelEvaluator self, int l) -> Teuchos::RCP< Epetra_Operator >"""
        return _EpetraExt.ModelEvaluator_create_DfDp_op(self, *args)


    def create_DgDx_dot_op(self, *args):
        """create_DgDx_dot_op(ModelEvaluator self, int j) -> Teuchos::RCP< Epetra_Operator >"""
        return _EpetraExt.ModelEvaluator_create_DgDx_dot_op(self, *args)


    def create_DgDx_op(self, *args):
        """create_DgDx_op(ModelEvaluator self, int j) -> Teuchos::RCP< Epetra_Operator >"""
        return _EpetraExt.ModelEvaluator_create_DgDx_op(self, *args)


    def create_DgDp_op(self, *args):
        """create_DgDp_op(ModelEvaluator self, int j, int l) -> Teuchos::RCP< Epetra_Operator >"""
        return _EpetraExt.ModelEvaluator_create_DgDp_op(self, *args)


    def createInArgs(self, *args):
        """createInArgs(ModelEvaluator self) -> EpetraExt::ModelEvaluator::InArgs"""
        return _EpetraExt.ModelEvaluator_createInArgs(self, *args)


    def createOutArgs(self, *args):
        """createOutArgs(ModelEvaluator self) -> EpetraExt::ModelEvaluator::OutArgs"""
        return _EpetraExt.ModelEvaluator_createOutArgs(self, *args)


    def evalModel(self, *args):
        """evalModel(ModelEvaluator self, EpetraExt::ModelEvaluator::InArgs const & inArgs, EpetraExt::ModelEvaluator::OutArgs const & outArgs)"""
        return _EpetraExt.ModelEvaluator_evalModel(self, *args)


    def __init__(self, *args):
        """__init__(EpetraExt::ModelEvaluator self) -> ModelEvaluator"""
        if self.__class__ == ModelEvaluator:
            _self = None
        else:
            _self = self
        this = _EpetraExt.new_ModelEvaluator(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    def __disown__(self):
        self.this.disown()
        _EpetraExt.disown_ModelEvaluator(self)
        return weakref_proxy(self)
ModelEvaluator_swigregister = _EpetraExt.ModelEvaluator_swigregister
ModelEvaluator_swigregister(ModelEvaluator)

# This file is compatible with both classic and new-style classes.


