# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.Amesos is the python interface to the Trilinos direct
linear solver package Amesos:

    http://trilinos.sandia.gov/packages/amesos

The purpose of Amesos is to provide a common interface to a variety of
third-party direct solvers, made compatible with PyTrilinos.Epetra.
Note that the C++ version of Amesos uses the prefix 'Amesos_', which
has been stripped from the python implementation.

The most important classes of the Amesos module are:

    * Factory      - Factory class
    * Lapack       - LAPACK interface
    * Klu          - KLU interface
    * Umfpack      - UMFPACK interface
    * Scalapack    - SCALAPACK interface
    * Superlu      - SuperLU interface
    * Superludist  - SuperLU_DIST interface
    * Dscpack      - DSCPACK interface
    * Mumps        - MUMPS interface

Use dir(Amesos) to see what specific interfaces have been enabled on
your platform.  For examples of usage, please consult the examples
subdirectory of the PyTrilinos package, scripts exAmesos_Simple.py and
exAmesos_Factory.py.

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Amesos')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Amesos')
    _Amesos = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Amesos', [dirname(__file__)])
        except ImportError:
            import _Amesos
            return _Amesos
        try:
            _mod = imp.load_module('_Amesos', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Amesos = swig_import_helper()
    del swig_import_helper
else:
    import _Amesos
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Amesos.delete_SwigPyIterator

    def value(self):
        """value(SwigPyIterator self) -> PyObject *"""
        return _Amesos.SwigPyIterator_value(self)


    def incr(self, n=1):
        """
        incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        incr(SwigPyIterator self) -> SwigPyIterator
        """
        return _Amesos.SwigPyIterator_incr(self, n)


    def decr(self, n=1):
        """
        decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        decr(SwigPyIterator self) -> SwigPyIterator
        """
        return _Amesos.SwigPyIterator_decr(self, n)


    def distance(self, x):
        """distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _Amesos.SwigPyIterator_distance(self, x)


    def equal(self, x):
        """equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Amesos.SwigPyIterator_equal(self, x)


    def copy(self):
        """copy(SwigPyIterator self) -> SwigPyIterator"""
        return _Amesos.SwigPyIterator_copy(self)


    def next(self):
        """next(SwigPyIterator self) -> PyObject *"""
        return _Amesos.SwigPyIterator_next(self)


    def __next__(self):
        """__next__(SwigPyIterator self) -> PyObject *"""
        return _Amesos.SwigPyIterator___next__(self)


    def previous(self):
        """previous(SwigPyIterator self) -> PyObject *"""
        return _Amesos.SwigPyIterator_previous(self)


    def advance(self, n):
        """advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Amesos.SwigPyIterator_advance(self, n)


    def __eq__(self, x):
        """__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Amesos.SwigPyIterator___eq__(self, x)


    def __ne__(self, x):
        """__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Amesos.SwigPyIterator___ne__(self, x)


    def __iadd__(self, n):
        """__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Amesos.SwigPyIterator___iadd__(self, n)


    def __isub__(self, n):
        """__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Amesos.SwigPyIterator___isub__(self, n)


    def __add__(self, n):
        """__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Amesos.SwigPyIterator___add__(self, n)


    def __sub__(self, *args):
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _Amesos.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _Amesos.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

import PyTrilinos.Teuchos
import PyTrilinos.Epetra
class Factory(_object):
    """Proxy of C++ Amesos class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Factory, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Factory, name)
    __repr__ = _swig_repr

    def Create(self, *args):
        """
        Create(Factory self, char const * ClassType, Epetra_LinearProblem LinearProblem) -> BaseSolver
        Create(Factory self, std::string const CT, Epetra_LinearProblem LinearProblem) -> BaseSolver
        """
        return _Amesos.Factory_Create(self, *args)


    def Query(self, *args):
        """
        Query(Factory self, char const * ClassType) -> bool
        Query(Factory self, std::string const CT) -> bool
        """
        return _Amesos.Factory_Query(self, *args)


    def GetValidParameters(*args):
        """GetValidParameters() -> ParameterList"""
        return _Amesos.Factory_GetValidParameters(*args)

    GetValidParameters = staticmethod(GetValidParameters)

    def __init__(self, *args):
        """__init__(Amesos self) -> Factory"""
        this = _Amesos.new_Factory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Amesos.delete_Factory
Factory_swigregister = _Amesos.Factory_swigregister
Factory_swigregister(Factory)

def Factory_GetValidParameters(*args):
    """Factory_GetValidParameters() -> ParameterList"""
    return _Amesos.Factory_GetValidParameters(*args)

class BaseSolver(PyTrilinos.Teuchos.ParameterListAcceptor):
    """Proxy of C++ Amesos_BaseSolver class."""

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.Teuchos.ParameterListAcceptor]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BaseSolver, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.Teuchos.ParameterListAcceptor]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BaseSolver, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def getParameterList(self, *args):
        """getParameterList(BaseSolver self) -> Teuchos::RCP< Teuchos::ParameterList const >"""
        return _Amesos.BaseSolver_getParameterList(self, *args)

    __swig_destroy__ = _Amesos.delete_BaseSolver

    def SymbolicFactorization(self, *args):
        """SymbolicFactorization(BaseSolver self) -> int"""
        return _Amesos.BaseSolver_SymbolicFactorization(self, *args)


    def NumericFactorization(self, *args):
        """NumericFactorization(BaseSolver self) -> int"""
        return _Amesos.BaseSolver_NumericFactorization(self, *args)


    def Solve(self, *args):
        """Solve(BaseSolver self) -> int"""
        return _Amesos.BaseSolver_Solve(self, *args)


    def SetUseTranspose(self, *args):
        """SetUseTranspose(BaseSolver self, bool UseTranspose) -> int"""
        return _Amesos.BaseSolver_SetUseTranspose(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(BaseSolver self) -> bool"""
        return _Amesos.BaseSolver_UseTranspose(self, *args)


    def SetParameters(self, *args):
        """SetParameters(BaseSolver self, ParameterList ParameterList) -> int"""
        return _Amesos.BaseSolver_SetParameters(self, *args)


    def GetProblem(self, *args):
        """GetProblem(BaseSolver self) -> Epetra_LinearProblem"""
        return _Amesos.BaseSolver_GetProblem(self, *args)


    def MatrixShapeOK(self, *args):
        """MatrixShapeOK(BaseSolver self) -> bool"""
        return _Amesos.BaseSolver_MatrixShapeOK(self, *args)


    def Comm(self, *args):
        """Comm(BaseSolver self) -> Comm"""
        return _Amesos.BaseSolver_Comm(self, *args)


    def NumSymbolicFact(self, *args):
        """NumSymbolicFact(BaseSolver self) -> int"""
        return _Amesos.BaseSolver_NumSymbolicFact(self, *args)


    def NumNumericFact(self, *args):
        """NumNumericFact(BaseSolver self) -> int"""
        return _Amesos.BaseSolver_NumNumericFact(self, *args)


    def NumSolve(self, *args):
        """NumSolve(BaseSolver self) -> int"""
        return _Amesos.BaseSolver_NumSolve(self, *args)


    def PrintStatus(self, *args):
        """PrintStatus(BaseSolver self)"""
        return _Amesos.BaseSolver_PrintStatus(self, *args)


    def PrintTiming(self, *args):
        """PrintTiming(BaseSolver self)"""
        return _Amesos.BaseSolver_PrintTiming(self, *args)


    def setParameterList(self, *args):
        """setParameterList(BaseSolver self, Teuchos::RCP< Teuchos::ParameterList > const & paramList)"""
        return _Amesos.BaseSolver_setParameterList(self, *args)


    def getNonconstParameterList(self, *args):
        """getNonconstParameterList(BaseSolver self) -> Teuchos::RCP< Teuchos::ParameterList >"""
        return _Amesos.BaseSolver_getNonconstParameterList(self, *args)


    def unsetParameterList(self, *args):
        """unsetParameterList(BaseSolver self) -> Teuchos::RCP< Teuchos::ParameterList >"""
        return _Amesos.BaseSolver_unsetParameterList(self, *args)


    def GetTiming(self, *args):
        """GetTiming(BaseSolver self, ParameterList TimingParameterList)"""
        return _Amesos.BaseSolver_GetTiming(self, *args)

BaseSolver_swigregister = _Amesos.BaseSolver_swigregister
BaseSolver_swigregister(BaseSolver)
cvar = _Amesos.cvar
StructurallySingularMatrixError = cvar.StructurallySingularMatrixError
NumericallySingularMatrixError = cvar.NumericallySingularMatrixError

class Lapack(BaseSolver):
    """Proxy of C++ Amesos_Lapack class."""

    __swig_setmethods__ = {}
    for _s in [BaseSolver]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Lapack, name, value)
    __swig_getmethods__ = {}
    for _s in [BaseSolver]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Lapack, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Amesos_Lapack self, Epetra_LinearProblem LinearProblem) -> Lapack"""
        this = _Amesos.new_Lapack(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Amesos.delete_Lapack

    def SymbolicFactorization(self, *args):
        """SymbolicFactorization(Lapack self) -> int"""
        return _Amesos.Lapack_SymbolicFactorization(self, *args)


    def NumericFactorization(self, *args):
        """NumericFactorization(Lapack self) -> int"""
        return _Amesos.Lapack_NumericFactorization(self, *args)


    def Solve(self, *args):
        """Solve(Lapack self) -> int"""
        return _Amesos.Lapack_Solve(self, *args)


    def GetProblem(self, *args):
        """GetProblem(Lapack self) -> Epetra_LinearProblem"""
        return _Amesos.Lapack_GetProblem(self, *args)


    def MatrixShapeOK(self, *args):
        """MatrixShapeOK(Lapack self) -> bool"""
        return _Amesos.Lapack_MatrixShapeOK(self, *args)


    def SetUseTranspose(self, *args):
        """SetUseTranspose(Lapack self, bool UseTranspose_in) -> int"""
        return _Amesos.Lapack_SetUseTranspose(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(Lapack self) -> bool"""
        return _Amesos.Lapack_UseTranspose(self, *args)


    def Comm(self, *args):
        """Comm(Lapack self) -> Comm"""
        return _Amesos.Lapack_Comm(self, *args)


    def setParameterList(self, *args):
        """setParameterList(Lapack self, Teuchos::RCP< Teuchos::ParameterList > const & paramList)"""
        return _Amesos.Lapack_setParameterList(self, *args)


    def unsetParameterList(self, *args):
        """unsetParameterList(Lapack self) -> Teuchos::RCP< Teuchos::ParameterList >"""
        return _Amesos.Lapack_unsetParameterList(self, *args)


    def SetParameters(self, *args):
        """SetParameters(Lapack self, ParameterList ParameterList) -> int"""
        return _Amesos.Lapack_SetParameters(self, *args)


    def GEEV(self, *args):
        """GEEV(Lapack self, Vector Er, Vector Ei) -> int"""
        return _Amesos.Lapack_GEEV(self, *args)


    def NumSymbolicFact(self, *args):
        """NumSymbolicFact(Lapack self) -> int"""
        return _Amesos.Lapack_NumSymbolicFact(self, *args)


    def NumNumericFact(self, *args):
        """NumNumericFact(Lapack self) -> int"""
        return _Amesos.Lapack_NumNumericFact(self, *args)


    def NumSolve(self, *args):
        """NumSolve(Lapack self) -> int"""
        return _Amesos.Lapack_NumSolve(self, *args)


    def PrintTiming(self, *args):
        """PrintTiming(Lapack self)"""
        return _Amesos.Lapack_PrintTiming(self, *args)


    def PrintStatus(self, *args):
        """PrintStatus(Lapack self)"""
        return _Amesos.Lapack_PrintStatus(self, *args)


    def GetTiming(self, *args):
        """GetTiming(Lapack self, ParameterList TimingParameterList)"""
        return _Amesos.Lapack_GetTiming(self, *args)

Lapack_swigregister = _Amesos.Lapack_swigregister
Lapack_swigregister(Lapack)

class Klu(BaseSolver):
    """Proxy of C++ Amesos_Klu class."""

    __swig_setmethods__ = {}
    for _s in [BaseSolver]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Klu, name, value)
    __swig_getmethods__ = {}
    for _s in [BaseSolver]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Klu, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Amesos_Klu self, Epetra_LinearProblem LinearProblem) -> Klu"""
        this = _Amesos.new_Klu(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Amesos.delete_Klu

    def SymbolicFactorization(self, *args):
        """SymbolicFactorization(Klu self) -> int"""
        return _Amesos.Klu_SymbolicFactorization(self, *args)


    def NumericFactorization(self, *args):
        """NumericFactorization(Klu self) -> int"""
        return _Amesos.Klu_NumericFactorization(self, *args)


    def Solve(self, *args):
        """Solve(Klu self) -> int"""
        return _Amesos.Klu_Solve(self, *args)


    def GetProblem(self, *args):
        """GetProblem(Klu self) -> Epetra_LinearProblem"""
        return _Amesos.Klu_GetProblem(self, *args)


    def MatrixShapeOK(self, *args):
        """MatrixShapeOK(Klu self) -> bool"""
        return _Amesos.Klu_MatrixShapeOK(self, *args)


    def SetUseTranspose(self, *args):
        """SetUseTranspose(Klu self, bool UseTranspose_in) -> int"""
        return _Amesos.Klu_SetUseTranspose(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(Klu self) -> bool"""
        return _Amesos.Klu_UseTranspose(self, *args)


    def Comm(self, *args):
        """Comm(Klu self) -> Comm"""
        return _Amesos.Klu_Comm(self, *args)


    def SetParameters(self, *args):
        """SetParameters(Klu self, ParameterList ParameterList) -> int"""
        return _Amesos.Klu_SetParameters(self, *args)


    def NumSymbolicFact(self, *args):
        """NumSymbolicFact(Klu self) -> int"""
        return _Amesos.Klu_NumSymbolicFact(self, *args)


    def NumNumericFact(self, *args):
        """NumNumericFact(Klu self) -> int"""
        return _Amesos.Klu_NumNumericFact(self, *args)


    def NumSolve(self, *args):
        """NumSolve(Klu self) -> int"""
        return _Amesos.Klu_NumSolve(self, *args)


    def PrintTiming(self, *args):
        """PrintTiming(Klu self)"""
        return _Amesos.Klu_PrintTiming(self, *args)


    def PrintStatus(self, *args):
        """PrintStatus(Klu self)"""
        return _Amesos.Klu_PrintStatus(self, *args)


    def GetTiming(self, *args):
        """GetTiming(Klu self, ParameterList TimingParameterList)"""
        return _Amesos.Klu_GetTiming(self, *args)

Klu_swigregister = _Amesos.Klu_swigregister
Klu_swigregister(Klu)

# This file is compatible with both classic and new-style classes.


