/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.xml.crypto.NodeSetData;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMSubTreeData
implements NodeSetData {
    private boolean excludeComments;
    private Iterator ni;
    private Node root;

    public DOMSubTreeData(Node root, boolean excludeComments) {
        this.root = root;
        this.ni = new DelayedNodeIterator(root, excludeComments);
        this.excludeComments = excludeComments;
    }

    @Override
    public Iterator iterator() {
        return this.ni;
    }

    public Node getRoot() {
        return this.root;
    }

    public boolean excludeComments() {
        return this.excludeComments;
    }

    static class DelayedNodeIterator
    implements Iterator {
        private Node root;
        private List nodeSet;
        private ListIterator li;
        private boolean withComments;

        DelayedNodeIterator(Node root, boolean excludeComments) {
            this.root = root;
            this.withComments = !excludeComments;
        }

        @Override
        public boolean hasNext() {
            if (this.nodeSet == null) {
                this.nodeSet = this.dereferenceSameDocumentURI(this.root);
                this.li = this.nodeSet.listIterator();
            }
            return this.li.hasNext();
        }

        public Object next() {
            if (this.nodeSet == null) {
                this.nodeSet = this.dereferenceSameDocumentURI(this.root);
                this.li = this.nodeSet.listIterator();
            }
            if (this.li.hasNext()) {
                return (Node)this.li.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private List dereferenceSameDocumentURI(Node node) {
            ArrayList nodeSet = new ArrayList();
            if (node != null) {
                this.nodeSetMinusCommentNodes(node, nodeSet, null);
            }
            return nodeSet;
        }

        private void nodeSetMinusCommentNodes(Node node, List nodeSet, Node prevSibling) {
            switch (node.getNodeType()) {
                case 1: {
                    NamedNodeMap attrs = node.getAttributes();
                    if (attrs != null) {
                        int len = attrs.getLength();
                        for (int i = 0; i < len; ++i) {
                            nodeSet.add(attrs.item(i));
                        }
                    }
                    nodeSet.add(node);
                }
                case 9: {
                    Node pSibling = null;
                    for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                        this.nodeSetMinusCommentNodes(child, nodeSet, pSibling);
                        pSibling = child;
                    }
                    break;
                }
                case 3: 
                case 4: {
                    if (prevSibling != null && (prevSibling.getNodeType() == 3 || prevSibling.getNodeType() == 4)) {
                        return;
                    }
                }
                case 7: {
                    nodeSet.add(node);
                    break;
                }
                case 8: {
                    if (!this.withComments) break;
                    nodeSet.add(node);
                }
            }
        }
    }
}

