/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import sun.awt.X11ComponentPeer;
import sun.awt.X11GraphicsDevice;
import sun.awt.image.OffScreenImage;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.SurfaceManager;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.x11.X11SurfaceData;

public class X11GraphicsConfig
extends GraphicsConfiguration
implements SurfaceManager.ProxiedGraphicsConfig {
    protected X11GraphicsDevice screen;
    protected int visual;
    int depth;
    int colormap;
    ColorModel colorModel;
    long aData;
    boolean doubleBuffer;
    private Object disposerReferent = new Object();
    private BufferCapabilities bufferCaps;
    private static ImageCapabilities imageCaps = new ImageCapabilities(X11SurfaceData.isAccelerationEnabled());
    protected int bitsPerPixel;
    protected SurfaceType surfaceType;
    public RenderLoops solidloops;

    public static X11GraphicsConfig getConfig(X11GraphicsDevice device, int visualnum, int depth, int colormap, boolean doubleBuffer) {
        return new X11GraphicsConfig(device, visualnum, depth, colormap, doubleBuffer);
    }

    public static X11GraphicsConfig getConfig(X11GraphicsDevice device, int visualnum, int depth, int colormap, int type) {
        return new X11GraphicsConfig(device, visualnum, depth, colormap, false);
    }

    private native int getNumColors();

    private native void init(int var1, int var2);

    private native ColorModel makeColorModel();

    protected X11GraphicsConfig(X11GraphicsDevice device, int visualnum, int depth, int colormap, boolean doubleBuffer) {
        this.screen = device;
        this.visual = visualnum;
        this.doubleBuffer = doubleBuffer;
        this.depth = depth;
        this.colormap = colormap;
        this.init(visualnum, this.screen.getScreen());
        long x11CfgData = this.getAData();
        Disposer.addRecord(this.disposerReferent, new X11GCDisposerRecord(x11CfgData));
    }

    @Override
    public GraphicsDevice getDevice() {
        return this.screen;
    }

    public int getVisual() {
        return this.visual;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getColormap() {
        return this.colormap;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public synchronized SurfaceType getSurfaceType() {
        if (this.surfaceType != null) {
            return this.surfaceType;
        }
        this.surfaceType = X11SurfaceData.getSurfaceType(this, 1);
        return this.surfaceType;
    }

    @Override
    public Object getProxyKey() {
        return this.screen.getProxyKeyFor(this.getSurfaceType());
    }

    public synchronized RenderLoops getSolidLoops(SurfaceType stype) {
        if (this.solidloops == null) {
            this.solidloops = SurfaceData.makeRenderLoops(SurfaceType.OpaqueColor, CompositeType.SrcNoEa, stype);
        }
        return this.solidloops;
    }

    @Override
    public synchronized ColorModel getColorModel() {
        if (this.colorModel == null) {
            SystemColor.window.getRGB();
            this.colorModel = this.makeColorModel();
            if (this.colorModel == null) {
                this.colorModel = Toolkit.getDefaultToolkit().getColorModel();
            }
        }
        return this.colorModel;
    }

    @Override
    public ColorModel getColorModel(int transparency) {
        switch (transparency) {
            case 1: {
                return this.getColorModel();
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                return ColorModel.getRGBdefault();
            }
        }
        return null;
    }

    public static DirectColorModel createDCM32(int rMask, int gMask, int bMask, int aMask, boolean aPre) {
        return new DirectColorModel(ColorSpace.getInstance(1000), 32, rMask, gMask, bMask, aMask, aPre, 3);
    }

    public static ComponentColorModel createABGRCCM() {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8, 8};
        int[] bOffs = new int[]{3, 2, 1, 0};
        return new ComponentColorModel(cs, nBits, true, true, 3, 0);
    }

    @Override
    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    @Override
    public AffineTransform getNormalizingTransform() {
        double xscale = this.getXResolution(this.screen.getScreen()) / 72.0;
        double yscale = this.getYResolution(this.screen.getScreen()) / 72.0;
        return new AffineTransform(xscale, 0.0, 0.0, yscale, 0.0, 0.0);
    }

    private native double getXResolution(int var1);

    private native double getYResolution(int var1);

    public long getAData() {
        return this.aData;
    }

    public String toString() {
        return "X11GraphicsConfig[dev=" + this.screen + ",vis=0x" + Integer.toHexString(this.visual) + "]";
    }

    private static native void initIDs();

    @Override
    public Rectangle getBounds() {
        return this.pGetBounds(this.screen.getScreen());
    }

    public native Rectangle pGetBounds(int var1);

    @Override
    public BufferCapabilities getBufferCapabilities() {
        if (this.bufferCaps == null) {
            this.bufferCaps = this.doubleBuffer ? new XDBECapabilities() : super.getBufferCapabilities();
        }
        return this.bufferCaps;
    }

    @Override
    public ImageCapabilities getImageCapabilities() {
        return imageCaps;
    }

    public boolean isDoubleBuffered() {
        return this.doubleBuffer;
    }

    private static native void dispose(long var0);

    public SurfaceData createSurfaceData(X11ComponentPeer peer) {
        return X11SurfaceData.createData(peer);
    }

    public Image createAcceleratedImage(Component target, int width, int height) {
        ColorModel model = this.getColorModel(1);
        WritableRaster wr = model.createCompatibleWritableRaster(width, height);
        return new OffScreenImage(target, model, wr, model.isAlphaPremultiplied());
    }

    private native long createBackBuffer(long var1, int var3);

    private native void swapBuffers(long var1, int var3);

    public long createBackBuffer(X11ComponentPeer peer, int numBuffers, BufferCapabilities caps) throws AWTException {
        if (!X11GraphicsDevice.isDBESupported()) {
            throw new AWTException("Page flipping is not supported");
        }
        if (numBuffers > 2) {
            throw new AWTException("Only double or single buffering is supported");
        }
        BufferCapabilities configCaps = this.getBufferCapabilities();
        if (!configCaps.isPageFlipping()) {
            throw new AWTException("Page flipping is not supported");
        }
        long window = peer.getContentWindow();
        int swapAction = X11GraphicsConfig.getSwapAction(caps.getFlipContents());
        return this.createBackBuffer(window, swapAction);
    }

    public native void destroyBackBuffer(long var1);

    public VolatileImage createBackBufferImage(Component target, long backBuffer) {
        return new SunVolatileImage(target, target.getWidth(), target.getHeight(), backBuffer);
    }

    public void flip(X11ComponentPeer peer, Component target, VolatileImage xBackBuffer, int x1, int y1, int x2, int y2, BufferCapabilities.FlipContents flipAction) {
        long window = peer.getContentWindow();
        int swapAction = X11GraphicsConfig.getSwapAction(flipAction);
        this.swapBuffers(window, swapAction);
    }

    private static int getSwapAction(BufferCapabilities.FlipContents flipAction) {
        if (flipAction == BufferCapabilities.FlipContents.BACKGROUND) {
            return 1;
        }
        if (flipAction == BufferCapabilities.FlipContents.PRIOR) {
            return 2;
        }
        if (flipAction == BufferCapabilities.FlipContents.COPIED) {
            return 3;
        }
        return 0;
    }

    @Override
    public boolean isTranslucencyCapable() {
        return this.isTranslucencyCapable(this.getAData());
    }

    private native boolean isTranslucencyCapable(long var1);

    static {
        X11GraphicsConfig.initIDs();
    }

    private static class X11GCDisposerRecord
    implements DisposerRecord {
        private long x11ConfigData;

        public X11GCDisposerRecord(long x11CfgData) {
            this.x11ConfigData = x11CfgData;
        }

        @Override
        public synchronized void dispose() {
            if (this.x11ConfigData != 0L) {
                X11GraphicsConfig.dispose(this.x11ConfigData);
                this.x11ConfigData = 0L;
            }
        }
    }

    private static class XDBECapabilities
    extends BufferCapabilities {
        public XDBECapabilities() {
            super(imageCaps, imageCaps, BufferCapabilities.FlipContents.UNDEFINED);
        }
    }
}

