/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;

public class WrapperGenerator {
    private static final Logger log = Logger.getLogger("WrapperGenerator");
    boolean generateLog = true;
    boolean wide;
    private static Charset charset = Charset.forName("ISO-8859-15");
    String package_name = "sun.awt.X11";
    String package_path = "sun/awt/X11";
    String sizerFileName = "sizer.c";
    String defaultBaseClass = "XWrapperBase";
    String compile_options = "-lX11";
    static Hashtable symbolTable = new Hashtable();
    static Hashtable sizeTable32bit = new Hashtable();
    static Hashtable sizeTable64bit = new Hashtable();
    static Hashtable knownSizes32 = new Hashtable();
    static Hashtable knownSizes64 = new Hashtable();

    public String makeComment(String str) {
        StringTokenizer st = new StringTokenizer(str, "\r\n");
        String ret = "";
        while (st.hasMoreTokens()) {
            ret = ret + "//" + st.nextToken() + "\n";
        }
        return ret;
    }

    public String getJavaTypeForSize(int size) {
        switch (size) {
            case 1: {
                return "byte";
            }
            case 2: {
                return "short";
            }
            case 4: {
                return "int";
            }
            case 8: {
                return "long";
            }
        }
        throw new RuntimeException("Unsupported size: " + size);
    }

    public String getOffsets(StructType stp, AtomicType atp, boolean wide) {
        String key = stp.getName() + "." + atp.getName();
        return wide ? (String)sizeTable64bit.get(key) : (String)sizeTable32bit.get(key);
    }

    public String getStructSize(StructType stp, boolean wide) {
        return wide ? (String)sizeTable64bit.get(stp.getName()) : (String)sizeTable32bit.get(stp.getName());
    }

    public int getLongSize(boolean wide) {
        return Integer.parseInt(wide ? (String)sizeTable64bit.get("long") : (String)sizeTable32bit.get("long"));
    }

    public int getPtrSize(boolean wide) {
        return Integer.parseInt(wide ? (String)sizeTable64bit.get("ptr") : (String)sizeTable32bit.get("ptr"));
    }

    public int getBoolSize(boolean wide) {
        return this.getOrdinalSize("Bool", wide);
    }

    public int getOrdinalSize(String ordinal, boolean wide) {
        return Integer.parseInt(wide ? (String)sizeTable64bit.get(ordinal) : (String)sizeTable32bit.get(ordinal));
    }

    public void writeToString(StructType stp, PrintWriter pw) {
        pw.println("\n\n\tString getName() {\n\t\treturn \"" + stp.getName() + "\"; \n\t}");
        pw.println("\n\n\tString getFieldsAsString() {\n\t\tStringBuilder ret = new StringBuilder(" + stp.getNumFields() * 40 + ");\n");
        Enumeration e = stp.getMembers();
        while (e.hasMoreElements()) {
            AtomicType tp = (AtomicType)e.nextElement();
            int type = tp.getType();
            String name = tp.getName().replace('.', '_');
            if (name == null || name.length() <= 0) continue;
            if (type == 12) {
                pw.println("\t\tret.append(\"" + name + " = \" ).append( XAtom.get(get_" + name + "()) ).append(\", \");");
                continue;
            }
            if (name.equals("type")) {
                pw.println("\t\tret.append(\"type = \").append( XlibWrapper.eventToString[get_type()] ).append(\", \");");
                continue;
            }
            if (name.equals("window")) {
                pw.println("\t\tret.append(\"window = \" ).append( getWindow(get_window()) ).append(\", \");");
                continue;
            }
            if (type == 10) {
                pw.print("\t\tret.append(\"{\")");
                for (int i = 0; i < tp.getArrayLength(); ++i) {
                    pw.print("\n\t\t.append( get_" + name + "(" + i + ") ).append(\" \")");
                }
                pw.println(".append( \"}\");");
                continue;
            }
            pw.println("\t\tret.append(\"" + name + " = \").append( get_" + name + "() ).append(\", \");");
        }
        pw.println("\t\treturn ret.toString();\n\t}\n\n");
    }

    public void writeStubs(StructType stp, PrintWriter pw) {
        String prefix = "";
        prefix = !stp.getIsInterface() ? "\t\tabstract " : "\t";
        Enumeration e = stp.getMembers();
        while (e.hasMoreElements()) {
            AtomicType tp = (AtomicType)e.nextElement();
            int type = tp.getType();
            String name = tp.getName().replace('.', '_');
            if (name == null || name.length() <= 0) continue;
            if (type == 10) {
                pw.println(prefix + "long get_" + name + "();");
                pw.println(prefix + tp.getJavaType() + " get_" + name + "(int index);");
                pw.println(prefix + "void set_" + name + "(int index, " + tp.getJavaType() + " v);");
                continue;
            }
            pw.println(prefix + tp.getJavaType() + " get_" + name + "();");
            if (type == 9) continue;
            pw.println(prefix + "void set_" + name + "(" + tp.getJavaType() + " v);");
        }
    }

    private int padSize(int size, int wordLength) {
        int bytesPerWord = wordLength / 8;
        return (size + bytesPerWord / 2) / bytesPerWord * bytesPerWord;
    }

    public void writeAccessorImpls(StructType stp, PrintWriter pw) {
        int i = 0;
        String s_size_32 = this.getStructSize(stp, false);
        String s_size_64 = this.getStructSize(stp, true);
        int acc_size_32 = 0;
        int acc_size_64 = 0;
        String s_log = this.generateLog ? "log.finest(\"\");" : "";
        Enumeration e = stp.getMembers();
        while (e.hasMoreElements()) {
            AtomicType tp = (AtomicType)e.nextElement();
            int type = tp.getType();
            String name = tp.getName().replace('.', '_');
            String pref = "\tpublic ";
            if (name == null || name.length() <= 0) continue;
            String jt = tp.getJavaType();
            String ja_32 = tp.getJavaAccess(false);
            String ja_64 = tp.getJavaAccess(true);
            String ja = ja_32;
            int elemSize_32 = AtomicType.getNativeSizeForAccess(ja_32);
            int elemSize_64 = AtomicType.getNativeSizeForAccess(ja_64);
            String elemSize = tp.getItemSize();
            if (type == 10) {
                acc_size_32 += elemSize_32 * tp.getArrayLength();
                acc_size_64 += elemSize_64 * tp.getArrayLength();
                pw.println(pref + tp.getJavaType() + " get_" + name + "(int index) { " + s_log + "return " + tp.getJavaResult(stp.getOffset(tp) + "+index*" + elemSize, null) + "; }");
                if (tp.getReferencedType() instanceof AtomicType) {
                    pw.println(MessageFormat.format(pref + "void set_{0}(int index, {1} v) '{' {3} {2}; '}'", name, jt, tp.getJavaConversion("pData+" + stp.getOffset(tp) + " + index*" + elemSize, "v"), s_log));
                }
                pw.println(pref + "long get_" + name + "() { " + s_log + "return pData+" + stp.getOffset(tp) + "; }");
            } else if (type == 6) {
                pw.println(MessageFormat.format(pref + "{0} get_{1}(int index) '{' {3} return {2}; '}'", jt, name, tp.getJavaResult("index*" + elemSize, "Native.getLong(pData+" + stp.getOffset(tp) + ")"), s_log));
                pw.println(pref + "long get_" + name + "() { " + s_log + "return Native.getLong(pData+" + stp.getOffset(tp) + "); }");
                pw.println(MessageFormat.format(pref + "void set_{0}({1} v) '{' {3} {2}; '}'", name, "long", "Native.putLong(pData + " + stp.getOffset(tp) + ", v)", s_log));
                acc_size_32 += elemSize_32;
                acc_size_64 += elemSize_64;
            } else {
                acc_size_32 += elemSize_32;
                acc_size_64 += elemSize_64;
                pw.println(pref + tp.getJavaType() + " get_" + name + "() { " + s_log + "return " + tp.getJavaResult(stp.getOffset(tp), null) + "; }");
                if (type != 9) {
                    pw.println(MessageFormat.format(pref + "void set_{0}({1} v) '{' {3} {2}; '}'", name, jt, tp.getJavaConversion("pData+" + stp.getOffset(tp), "v"), s_log));
                }
            }
            ++i;
        }
        if (s_size_32 != null && !s_size_32.equals(Integer.toString(acc_size_32))) {
            log.fine("32 bits: The size of the structure " + stp.getName() + " " + s_size_32 + " is not equal to the accumulated size " + acc_size_32 + " of the fields");
        } else if (s_size_64 != null && !s_size_64.equals(Integer.toString(acc_size_64))) {
            log.fine("64 bits: The size of the structure " + stp.getName() + " " + s_size_64 + " is not equal to the accumulated size " + acc_size_64 + " of the fields");
        }
    }

    public void writeWrapperSubclass(StructType stp, PrintWriter pw, boolean wide) {
        pw.println("class " + stp.getJavaClassName() + "AccessorImpl" + " extends " + stp.getJavaClassName() + "Accessor  {");
        pw.println("/*\nThis class serves as a Wrapper for the following X Struct \nsThe offsets here are calculated based on actual compiler.\n\n" + stp.getDescription() + "\n\n */");
        this.writeAccessorImpls(stp, pw);
        pw.println("\n\n } \n\n");
    }

    public void writeWrapper(String outputDir, StructType stp) {
        if (stp.getNumFields() > 0) {
            try {
                FileOutputStream fs = new FileOutputStream(outputDir + "/" + stp.getJavaClassName() + ".java");
                PrintWriter pw = new PrintWriter(fs);
                pw.println("// This file is an automatically generated file, please do not edit this file, modify the WrapperGenerator.java file instead !\n");
                pw.println("package " + this.package_name + ";\n");
                pw.println("import sun.misc.*;\n");
                pw.println("import sun.util.logging.PlatformLogger;");
                String baseClass = stp.getBaseClass();
                if (baseClass == null) {
                    baseClass = this.defaultBaseClass;
                }
                if (stp.getIsInterface()) {
                    pw.print("public interface ");
                    pw.print(stp.getJavaClassName());
                } else {
                    pw.print("public class ");
                    pw.print(stp.getJavaClassName() + " extends " + baseClass);
                }
                if (stp.getInterfaces() != null) {
                    pw.print(" implements " + stp.getInterfaces());
                }
                pw.println(" { ");
                if (!stp.getIsInterface()) {
                    pw.println("\tprivate Unsafe unsafe = XlibWrapper.unsafe; ");
                    pw.println("\tprivate final boolean should_free_memory;");
                    pw.println("\tpublic static int getSize() { return " + stp.getSize() + "; }");
                    pw.println("\tpublic int getDataSize() { return getSize(); }");
                    pw.println("\n\tlong pData;");
                    pw.println("\n\tpublic long getPData() { return pData; }");
                    pw.println("\n\n\tpublic " + stp.getJavaClassName() + "(long addr) {");
                    if (this.generateLog) {
                        pw.println("\t\tlog.finest(\"Creating\");");
                    }
                    pw.println("\t\tpData=addr;");
                    pw.println("\t\tshould_free_memory = false;");
                    pw.println("\t}");
                    pw.println("\n\n\tpublic " + stp.getJavaClassName() + "() {");
                    if (this.generateLog) {
                        pw.println("\t\tlog.finest(\"Creating\");");
                    }
                    pw.println("\t\tpData = unsafe.allocateMemory(getSize());");
                    pw.println("\t\tshould_free_memory = true;");
                    pw.println("\t}");
                    pw.println("\n\n\tpublic void dispose() {");
                    if (this.generateLog) {
                        pw.println("\t\tlog.finest(\"Disposing\");");
                    }
                    pw.println("\t\tif (should_free_memory) {");
                    if (this.generateLog) {
                        pw.println("\t\t\tlog.finest(\"freeing memory\");");
                    }
                    pw.println("\t\t\tunsafe.freeMemory(pData); \n\t}");
                    pw.println("\t\t}");
                    this.writeAccessorImpls(stp, pw);
                    this.writeToString(stp, pw);
                } else {
                    pw.println("\n\n\tvoid dispose();");
                    pw.println("\n\tlong getPData();");
                    this.writeStubs(stp, pw);
                }
                pw.println("}\n\n\n");
                pw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean readSizeInfo(InputStream is, boolean wide) {
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                String[] splits = line.split("\\p{Space}");
                if (splits.length != 2) continue;
                if (wide) {
                    sizeTable64bit.put(splits[0], splits[1]);
                    continue;
                }
                sizeTable32bit.put(splits[0], splits[1]);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void writeFunctionCallWrapper(String outputDir, FunctionType ft) {
        try {
            AtomicType at3;
            FileOutputStream fs = new FileOutputStream(outputDir + "/" + ft.getName() + ".java");
            PrintWriter pw = new PrintWriter(fs);
            pw.println("// This file is an automatically generated file, please do not edit this file, modify the WrapperGenerator.java file instead !\n");
            pw.println("package " + this.package_name + ";\n");
            pw.println("import sun.misc.Unsafe;\n");
            pw.println("class " + ft.getName() + " {");
            pw.println("\tprivate static Unsafe unsafe = XlibWrapper.unsafe;");
            pw.println("\tprivate boolean __executed = false;");
            pw.println("\tprivate boolean __disposed = false;");
            for (AtomicType at2 : ft.getArguments()) {
                if (at2.isIn()) {
                    pw.println("\t" + at2.getJavaType() + " _" + at2.getName() + ";");
                    continue;
                }
                pw.println("\tlong " + at2.getName() + "_ptr = unsafe.allocateMemory(Native.get" + at2.getTypeUpperCase() + "Size());");
            }
            pw.println("\tpublic " + ft.getName() + "(");
            Iterator iter = ft.getArguments().iterator();
            boolean first = true;
            while (iter.hasNext()) {
                at3 = (AtomicType)iter.next();
                if (!at3.isIn() && !at3.isInOut()) continue;
                if (!first) {
                    pw.println(",");
                }
                first = false;
                pw.print("\t\t" + at3.getJavaType() + " " + at3.getName());
            }
            pw.println("\t)");
            pw.println("\t{");
            for (AtomicType at3 : ft.getArguments()) {
                if (!at3.isIn() && !at3.isInOut()) continue;
                pw.println("\t\tset_" + at3.getName() + "(" + at3.getName() + ");");
            }
            pw.println("\t}");
            pw.println("\tpublic " + ft.getReturnType() + " execute() {");
            if (ft.isVoid()) {
                pw.println("\t\texecute(null);");
            } else {
                pw.println("\t\treturn execute(null);");
            }
            pw.println("\t}");
            pw.println("\tpublic " + ft.getReturnType() + " execute(XToolkit.XErrorHandler errorHandler) {");
            pw.println("\t\tif (__disposed) {");
            pw.println("\t\t    throw new IllegalStateException(\"Disposed\");");
            pw.println("\t\t}");
            pw.println("\t\tXToolkit.awtLock();");
            pw.println("\t\ttry {");
            pw.println("\t\t\tif (__executed) {");
            pw.println("\t\t\t    throw new IllegalStateException(\"Already executed\");");
            pw.println("\t\t\t}");
            pw.println("\t\t\t__executed = true;");
            pw.println("\t\t\tif (errorHandler != null) {");
            pw.println("\t\t\t    XErrorHandlerUtil.WITH_XERROR_HANDLER(errorHandler);");
            pw.println("\t\t\t}");
            for (AtomicType at3 : ft.getArguments()) {
                if (at3.isIn() || !at3.isAutoFree()) continue;
                pw.println("\t\t\tNative.put" + at3.getTypeUpperCase() + "(" + at3.getName() + "_ptr, 0);");
            }
            if (!ft.isVoid()) {
                pw.println("\t\t\t" + ft.getReturnType() + " status = ");
            }
            pw.println("\t\t\tXlibWrapper." + ft.getName() + "(XToolkit.getDisplay(), ");
            iter = ft.getArguments().iterator();
            first = true;
            while (iter.hasNext()) {
                at3 = (AtomicType)iter.next();
                if (!first) {
                    pw.println(",");
                }
                first = false;
                if (at3.isIn()) {
                    pw.print("\t\t\t\tget_" + at3.getName() + "()");
                    continue;
                }
                pw.print("\t\t\t\t" + at3.getName() + "_ptr");
            }
            pw.println("\t\t\t);");
            pw.println("\t\t\tif (errorHandler != null) {");
            pw.println("\t\t\t    XErrorHandlerUtil.RESTORE_XERROR_HANDLER();");
            pw.println("\t\t\t}");
            if (!ft.isVoid()) {
                pw.println("\t\t\treturn status;");
            }
            pw.println("\t\t} finally {");
            pw.println("\t\t    XToolkit.awtUnlock();");
            pw.println("\t\t}");
            pw.println("\t}");
            pw.println("\tpublic boolean isExecuted() {");
            pw.println("\t    return __executed;");
            pw.println("\t}");
            pw.println("\t");
            pw.println("\tpublic boolean isDisposed() {");
            pw.println("\t    return __disposed;");
            pw.println("\t}");
            pw.println("\tpublic void finalize() {");
            pw.println("\t    dispose();");
            pw.println("\t}");
            pw.println("\tpublic void dispose() {");
            pw.println("\t\tXToolkit.awtLock();");
            pw.println("\t\ttry {");
            pw.println("\t\tif (__disposed || !__executed) {");
            pw.println("\t\t    return;");
            pw.println("\t\t} finally {");
            pw.println("\t\t    XToolkit.awtUnlock();");
            pw.println("\t\t}");
            pw.println("\t\t}");
            for (AtomicType at3 : ft.getArguments()) {
                if (at3.isIn()) continue;
                if (at3.isAutoFree()) {
                    pw.println("\t\tif (__executed && get_" + at3.getName() + "()!= 0) {");
                    pw.println("\t\t\tXlibWrapper.XFree(get_" + at3.getName() + "());");
                    pw.println("\t\t}");
                }
                pw.println("\t\tunsafe.freeMemory(" + at3.getName() + "_ptr);");
            }
            pw.println("\t\t__disposed = true;");
            pw.println("\t\t}");
            pw.println("\t}");
            for (AtomicType at3 : ft.getArguments()) {
                pw.println("\tpublic " + at3.getJavaType() + " get_" + at3.getName() + "() {");
                pw.println("\t\tif (__disposed) {");
                pw.println("\t\t    throw new IllegalStateException(\"Disposed\");");
                pw.println("\t\t}");
                pw.println("\t\tif (!__executed) {");
                pw.println("\t\t    throw new IllegalStateException(\"Not executed\");");
                pw.println("\t\t}");
                if (at3.isIn()) {
                    pw.println("\t\treturn _" + at3.getName() + ";");
                } else {
                    pw.println("\t\treturn Native.get" + at3.getTypeUpperCase() + "(" + at3.getName() + "_ptr);");
                }
                pw.println("\t}");
                pw.println("\tpublic void set_" + at3.getName() + "(" + at3.getJavaType() + " data) {");
                if (at3.isIn()) {
                    pw.println("\t\t_" + at3.getName() + " = data;");
                } else {
                    pw.println("\t\tNative.put" + at3.getTypeUpperCase() + "(" + at3.getName() + "_ptr, data);");
                }
                pw.println("\t}");
            }
            pw.println("}");
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeJavaWrapperClass(String outputDir) {
        try {
            Enumeration e = symbolTable.elements();
            while (e.hasMoreElements()) {
                BaseType tp = (BaseType)e.nextElement();
                if (tp instanceof StructType) {
                    StructType st = (StructType)tp;
                    this.writeWrapper(outputDir, st);
                    continue;
                }
                if (!(tp instanceof FunctionType)) continue;
                this.writeFunctionCallWrapper(outputDir, (FunctionType)tp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeNativeSizer(String file) {
        int i = 0;
        int j = 0;
        try {
            StructType stp;
            BaseType tp;
            FileOutputStream fs = new FileOutputStream(file);
            PrintWriter pw = new PrintWriter(fs);
            pw.println("/* This file is an automatically generated file, please do not edit this file, modify the XlibParser.java file instead !*/\n");
            pw.println("#include <X11/Xlib.h>\n#include <X11/Xutil.h>\n#include <X11/Xos.h>\n#include <X11/Xatom.h>\n#include <stdio.h>\n");
            pw.println("#include <X11/extensions/Xdbe.h>");
            pw.println("#include <X11/XKBlib.h>");
            pw.println("#include \"awt_p.h\"");
            pw.println("#include \"color.h\"");
            pw.println("#include \"colordata.h\"");
            pw.println("\ntypedef struct\n");
            pw.println("{\n");
            pw.println("    unsigned long flags;\n");
            pw.println("    unsigned long functions;\n");
            pw.println("    unsigned long decorations;\n");
            pw.println("    long inputMode;\n");
            pw.println("    unsigned long status;\n");
            pw.println("} PropMwmHints;\n");
            pw.println("\n\nint main(){");
            j = 0;
            Enumeration eo = symbolTable.elements();
            while (eo.hasMoreElements()) {
                tp = (BaseType)eo.nextElement();
                if (!(tp instanceof StructType) || (stp = (StructType)tp).getIsInterface()) continue;
                pw.println(stp.getName() + "  temp" + j + ";\n");
                ++j;
            }
            j = 0;
            pw.println("printf(\"long\t%d\\n\",(int)sizeof(long));");
            pw.println("printf(\"int\t%d\\n\",(int)sizeof(int));");
            pw.println("printf(\"short\t%d\\n\",(int)sizeof(short));");
            pw.println("printf(\"ptr\t%d\\n\",(int)sizeof(void *));");
            pw.println("printf(\"Bool\t%d\\n\",(int)sizeof(Bool));");
            pw.println("printf(\"Atom\t%d\\n\",(int)sizeof(Atom));");
            pw.println("printf(\"Window\t%d\\n\",(int)sizeof(Window));");
            eo = symbolTable.elements();
            while (eo.hasMoreElements()) {
                tp = (BaseType)eo.nextElement();
                if (!(tp instanceof StructType) || (stp = (StructType)tp).getIsInterface()) continue;
                Enumeration e = stp.getMembers();
                while (e.hasMoreElements()) {
                    AtomicType atp = (AtomicType)e.nextElement();
                    if (atp.isAlias()) continue;
                    pw.println("printf(\"" + stp.getName() + "." + atp.getName() + "\t%d\\n\"" + ",(int)((unsigned long ) &temp" + j + "." + atp.getName() + "- (unsigned long ) &temp" + j + ")  );");
                    ++i;
                }
                pw.println("printf(\"" + stp.getName() + "\t%d\\n\"" + ",(int)sizeof(temp" + j + "));");
                ++j;
            }
            pw.println("return 0;");
            pw.println("}");
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initTypes() {
        symbolTable.put("int", new AtomicType(0, "", "int"));
        symbolTable.put("short", new AtomicType(7, "", "short"));
        symbolTable.put("long", new AtomicType(2, "", "long"));
        symbolTable.put("float", new AtomicType(5, "", "float"));
        symbolTable.put("double", new AtomicType(4, "", "double"));
        symbolTable.put("Bool", new AtomicType(8, "", "Bool"));
        symbolTable.put("char", new AtomicType(1, "", "char"));
        symbolTable.put("byte", new AtomicType(11, "", "byte"));
        symbolTable.put("pointer", new AtomicType(6, "", "pointer"));
        symbolTable.put("longlong", new AtomicType(3, "", "longlong"));
        symbolTable.put("Atom", new AtomicType(12, "", "Atom"));
        symbolTable.put("ulong", new AtomicType(13, "", "ulong"));
    }

    public WrapperGenerator(String outputDir, String xlibFilename) {
        this.initTypes();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(xlibFilename));
            BaseType curType = null;
            while ((line = in.readLine()) != null) {
                BaseType bt;
                int commentStart = line.indexOf("//");
                if (commentStart >= 0) {
                    line = line.substring(0, commentStart);
                }
                if ("".equals(line)) continue;
                String[] splits = line.split("\\p{Space}+");
                if (splits.length >= 2) {
                    String struct_name = curType.getName();
                    String field_name = splits[1];
                    String s_type = splits[2];
                    BaseType bt2 = curType;
                    int type = AtomicType.getTypeForString(s_type);
                    AtomicType atp = null;
                    if (bt2 != null && type != -1) {
                        atp = new AtomicType(type, field_name, s_type);
                        if (splits.length > 3) {
                            atp.setAttributes(splits);
                        }
                        if (bt2 instanceof StructType) {
                            StructType stp = (StructType)bt2;
                            stp.addMember(atp);
                            continue;
                        }
                        if (!(bt2 instanceof FunctionType)) continue;
                        ((FunctionType)bt2).addArgument(atp);
                        continue;
                    }
                    if (bt2 != null) continue;
                    System.out.println("Cannot find " + struct_name);
                    continue;
                }
                if (line == null || (bt = (BaseType)symbolTable.get(line)) != null) continue;
                if (line.startsWith("!")) {
                    FunctionType ft = new FunctionType(line);
                    ft.setName(line);
                    symbolTable.put(ft.getName(), ft);
                    curType = ft;
                    continue;
                }
                StructType stp = new StructType(line);
                stp.setName(line);
                curType = stp;
                symbolTable.put(stp.getName(), stp);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void makeSizer(String outputDir) {
        this.sizerFileName = this.wide ? "sizer.64.c" : "sizer.32.c";
        File fp = new File(outputDir, this.sizerFileName);
        this.writeNativeSizer(fp.getAbsolutePath());
    }

    private boolean readSizeInfo(String sizeInfo) {
        try {
            File f = new File(sizeInfo + ".32");
            boolean res = true;
            FileInputStream fis = null;
            if (f.exists()) {
                fis = new FileInputStream(f);
                res = this.readSizeInfo(fis, false);
                fis.close();
            }
            if ((f = new File(sizeInfo + ".64")).exists()) {
                fis = new FileInputStream(f);
                res &= this.readSizeInfo(fis, true);
                fis.close();
            }
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void startGeneration(String outputDir, String sizeInfo) {
        if (this.readSizeInfo(sizeInfo)) {
            this.writeJavaWrapperClass(outputDir);
        } else {
            System.out.println("Error calculating offsets");
        }
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Usage:\nWrapperGenerator <output_dir> <xlibtypes.txt> <action> [<platform> | <sizes info file>]");
            System.out.println("Where <action>: gen, sizer");
            System.out.println("      <platform>: 32, 64");
            System.exit(1);
        }
        WrapperGenerator xparser = new WrapperGenerator(args[0], args[1]);
        if (args[2].equals("sizer")) {
            xparser.wide = args[3].equals("64");
            xparser.makeSizer(args[0]);
        } else if (args[2].equals("gen")) {
            xparser.startGeneration(args[0], args[3]);
        }
    }

    static {
        knownSizes64.put("XComposeStatus", 16);
        knownSizes64.put("XTimeCoord", 16);
        knownSizes64.put("XExtData", 32);
        knownSizes64.put("XWindowChanges", 40);
        knownSizes64.put("XOMCharSetList", 16);
        knownSizes64.put("XModifierKeymap", 16);
        knownSizes32.put("XIMValuesList", 8);
        knownSizes32.put("XGCValues", 92);
    }

    private static class FunctionType
    extends BaseType {
        Vector args = new Vector();
        String description;
        boolean packed;
        String returnType;
        int alignment;

        public FunctionType(String _desc) {
            this.description = _desc;
            this.setName(_desc);
        }

        boolean isVoid() {
            return this.returnType == null;
        }

        String getReturnType() {
            if (this.returnType == null) {
                return "void";
            }
            return this.returnType;
        }

        public int getNumArgs() {
            return this.args.size();
        }

        public void setName(String _name) {
            if (_name.startsWith("!")) {
                _name = _name.substring(1, _name.length());
            }
            if (_name.indexOf("|") != -1) {
                this.returnType = _name.substring(_name.indexOf("|") + 1, _name.length());
                _name = _name.substring(0, _name.indexOf("|"));
            }
            this.name = _name.replaceAll("[* \t]", "");
        }

        public String getDescription() {
            return this.description;
        }

        public Collection getArguments() {
            return this.args;
        }

        public void addArgument(BaseType tp) {
            this.args.add(tp);
        }
    }

    private static class StructType
    extends BaseType {
        Vector members = new Vector();
        String description;
        boolean packed;
        int size;
        String baseClass;
        String interfaces;
        boolean isInterface;
        String javaClassName;

        public StructType(String _desc) {
            this.parseDescription(_desc);
        }

        public int getNumFields() {
            return this.members.size();
        }

        public void setName(String _name) {
            _name = _name.replaceAll("[* \t]", "");
            this.parseDescription(_name);
        }

        public void setSize(int i) {
            this.size = i;
        }

        public String getDescription() {
            return this.description;
        }

        public Enumeration getMembers() {
            return this.members.elements();
        }

        public void addMember(BaseType tp) {
            this.members.add(tp);
        }

        public String getBaseClass() {
            return this.baseClass;
        }

        public String getInterfaces() {
            return this.interfaces;
        }

        public boolean getIsInterface() {
            return this.isInterface;
        }

        public String getJavaClassName() {
            return this.javaClassName;
        }

        void parseDescription(String _desc) {
            if (_desc.indexOf(91) != -1) {
                this.baseClass = _desc.substring(_desc.indexOf(91) + 1, _desc.indexOf(93));
                _desc = _desc.substring(0, _desc.indexOf(91)) + _desc.substring(_desc.indexOf(93) + 1);
            }
            if (_desc.indexOf(123) != -1) {
                this.interfaces = _desc.substring(_desc.indexOf(123) + 1, _desc.indexOf(125));
                _desc = _desc.substring(0, _desc.indexOf(123)) + _desc.substring(_desc.indexOf(125) + 1);
            }
            if (_desc.startsWith("-")) {
                this.isInterface = true;
                _desc = _desc.substring(1, _desc.length());
            }
            if (_desc.indexOf("|") != -1) {
                this.javaClassName = _desc.substring(_desc.indexOf(124) + 1, _desc.length());
                _desc = _desc.substring(0, _desc.indexOf(124));
            }
            this.name = _desc;
            if (this.javaClassName == null) {
                this.javaClassName = this.name;
            }
            this.description = _desc;
        }

        public String getSize() {
            String s32 = (String)sizeTable32bit.get(this.getName());
            String s64 = (String)sizeTable64bit.get(this.getName());
            if (s32 == null || s64 == null) {
                return s32 == null ? s64 : s32;
            }
            if (s32.equals(s64)) {
                return s32;
            }
            return MessageFormat.format("((XlibWrapper.dataModel == 32)?({0}):({1}))", s32, s64);
        }

        public String getOffset(AtomicType atp) {
            String key = this.getName() + "." + (atp.isAlias() ? atp.getAliasName() : atp.getName());
            String s64 = (String)sizeTable64bit.get(key);
            String s32 = (String)sizeTable32bit.get(key);
            if (s32 == null || s64 == null) {
                return s32 == null ? s64 : s32;
            }
            if (s32.equals(s64)) {
                return s32;
            }
            return MessageFormat.format("((XlibWrapper.dataModel == 32)?({0}):({1}))", s32, s64);
        }
    }

    private static class AtomicType
    extends BaseType {
        private boolean alias;
        private String aliasName;
        static final int TYPE_INT = 0;
        static final int TYPE_CHAR = 1;
        static final int TYPE_LONG = 2;
        static final int TYPE_LONG_LONG = 3;
        static final int TYPE_DOUBLE = 4;
        static final int TYPE_FLOAT = 5;
        static final int TYPE_PTR = 6;
        static final int TYPE_SHORT = 7;
        static final int TYPE_BOOL = 8;
        static final int TYPE_STRUCT = 9;
        static final int TYPE_ARRAY = 10;
        static final int TYPE_BYTE = 11;
        static final int TYPE_ATOM = 12;
        static final int TYPE_ULONG = 13;
        int type;
        int offset;
        int direction;
        BaseType referencedType;
        int arrayLength = -1;
        boolean autoFree = false;

        static int getTypeForString(String str) {
            int type = -1;
            if (str.equals("int")) {
                type = 0;
            } else if (str.equals("long")) {
                type = 2;
            } else if (str.equals("byte")) {
                type = 11;
            } else if (str.equals("char")) {
                type = 1;
            } else if (str.equals("long long")) {
                type = 3;
            } else if (str.equals("double")) {
                type = 4;
            } else if (str.equals("float")) {
                type = 5;
            } else if (str.equals("pointer")) {
                type = 6;
            } else if (str.equals("short")) {
                type = 7;
            } else if (str.equals("Bool")) {
                type = 8;
            } else if (str.equals("struct")) {
                type = 9;
            } else if (str.equals("Atom")) {
                type = 12;
            } else if (str.equals("array")) {
                type = 10;
            } else if (str.equals("ulong")) {
                type = 13;
            } else {
                throw new IllegalArgumentException("Uknown type string: " + str);
            }
            return type;
        }

        String getJavaType() {
            if (this.referencedType != null) {
                if (this.referencedType instanceof AtomicType) {
                    return ((AtomicType)this.referencedType).getJavaType();
                }
                return this.referencedType.getName();
            }
            return AtomicType.getJavaTypeForType(this.type);
        }

        static String getJavaTypeForType(int type) {
            switch (type) {
                case 0: {
                    return "int";
                }
                case 1: {
                    return "char";
                }
                case 11: {
                    return "byte";
                }
                case 2: 
                case 3: 
                case 6: 
                case 13: {
                    return "long";
                }
                case 4: {
                    return "double";
                }
                case 5: {
                    return "float";
                }
                case 7: {
                    return "short";
                }
                case 8: {
                    return "boolean";
                }
                case 12: {
                    return "long";
                }
            }
            throw new IllegalArgumentException("Unknown type: " + type);
        }

        String getItemSize() {
            int i64;
            if (this.referencedType != null) {
                if (this.referencedType instanceof StructType) {
                    return ((StructType)this.referencedType).getSize();
                }
                return ((AtomicType)this.referencedType).getItemSize();
            }
            int i32 = AtomicType.getNativeSizeForAccess(this.getJavaAccess(false));
            if (i32 != (i64 = AtomicType.getNativeSizeForAccess(this.getJavaAccess(true)))) {
                return "Native.get" + this.getNativeAccess() + "Size()";
            }
            return Integer.toString(i32);
        }

        String getJavaResult(String offset, String base) {
            String res = null;
            switch (this.type) {
                case 9: {
                    res = "pData + " + offset;
                    break;
                }
                case 6: {
                    if (this.referencedType == null || this.referencedType instanceof StructType) {
                        res = base + "+" + offset;
                        break;
                    }
                    if (!(this.referencedType instanceof AtomicType)) break;
                    res = MessageFormat.format("Native.get{0}({1})", AtomicType.getNativeAccessForType(((AtomicType)this.referencedType).type), base + "+" + offset);
                    break;
                }
                case 10: {
                    if (this.referencedType instanceof StructType) {
                        res = "pData + " + offset;
                        break;
                    }
                    if (!(this.referencedType instanceof AtomicType)) break;
                    res = MessageFormat.format("Native.get{0}(pData + {1})", AtomicType.getNativeAccessForType(((AtomicType)this.referencedType).type), offset);
                    break;
                }
                default: {
                    res = MessageFormat.format("(Native.get{0}(pData+{1}))", this.getNativeAccess(), offset);
                }
            }
            return this.getJavaResultConversion(res, base);
        }

        String getJavaResultConversion(String value, String base) {
            if (this.referencedType != null) {
                if (this.referencedType instanceof StructType) {
                    if (this.type == 6) {
                        return MessageFormat.format("({2} != 0)?(new {0}({1})):(null)", this.referencedType.getName(), value, base);
                    }
                    return MessageFormat.format("new {0}({1})", this.referencedType.getName(), value);
                }
                return value;
            }
            return AtomicType.getJavaResultConversionForType(this.type, value);
        }

        static String getJavaResultConversionForType(int type, String value) {
            return value;
        }

        String getNativeAccess() {
            return AtomicType.getNativeAccessForType(this.type);
        }

        String getJavaAccess(boolean wide) {
            return AtomicType.getJavaAccessForType(this.type, wide);
        }

        static String getJavaAccessForType(int type, boolean wide) {
            switch (type) {
                case 0: {
                    return "Int";
                }
                case 1: {
                    return "Char";
                }
                case 11: {
                    return "Byte";
                }
                case 2: 
                case 6: 
                case 9: 
                case 10: 
                case 12: {
                    return wide ? "Long" : "Int";
                }
                case 3: {
                    return "Long";
                }
                case 13: {
                    return wide ? "ULong" : "UInt";
                }
                case 4: {
                    return "Double";
                }
                case 5: {
                    return "Float";
                }
                case 7: {
                    return "Short";
                }
                case 8: {
                    return "Int";
                }
            }
            throw new IllegalArgumentException("Unknown type: " + type);
        }

        static String getNativeAccessForType(int type) {
            switch (type) {
                case 0: {
                    return "Int";
                }
                case 1: {
                    return "Char";
                }
                case 11: {
                    return "Byte";
                }
                case 2: 
                case 6: 
                case 9: 
                case 10: {
                    return "Long";
                }
                case 3: {
                    return "Long";
                }
                case 13: {
                    return "ULong";
                }
                case 4: {
                    return "Double";
                }
                case 5: {
                    return "Float";
                }
                case 7: {
                    return "Short";
                }
                case 8: {
                    return "Bool";
                }
                case 12: {
                    return "Long";
                }
            }
            throw new IllegalArgumentException("Unknown type: " + type);
        }

        static int getNativeSizeForAccess(String access) {
            if (access.equals("Int")) {
                return 4;
            }
            if (access.equals("Byte")) {
                return 1;
            }
            if (access.equals("Long")) {
                return 8;
            }
            if (access.equals("Double")) {
                return 8;
            }
            if (access.equals("Float")) {
                return 4;
            }
            if (access.equals("Char")) {
                return 2;
            }
            if (access.equals("Short")) {
                return 2;
            }
            if (access.equals("ULong")) {
                return 8;
            }
            if (access.equals("UInt")) {
                return 4;
            }
            throw new IllegalArgumentException("Unknow access type: " + access);
        }

        String getJavaConversion(String offset, String value) {
            if (this.referencedType != null) {
                if (this.referencedType instanceof StructType) {
                    return AtomicType.getJavaConversionForType(6, offset, value + ".pData");
                }
                if (this.type == 10) {
                    return AtomicType.getJavaConversionForType(((AtomicType)this.referencedType).type, offset, value);
                }
                return AtomicType.getJavaConversionForType(6, offset, value);
            }
            return AtomicType.getJavaConversionForType(this.type, offset, value);
        }

        static String getJavaConversionForType(int type, String offset, String value) {
            return MessageFormat.format("Native.put{0}({2}, {1})", AtomicType.getNativeAccessForType(type), value, offset);
        }

        public AtomicType(int _type, String _name, String _real_type) {
            this.name = _name.replaceAll("[* \t]", "");
            if (this.name.indexOf("[") != -1 || this.name.indexOf("]") != -1) {
                this.name = this.name.replaceAll("\\[.*\\]", "");
            }
            this.type = _type;
            this.real_type = _real_type;
            if (this.real_type == null) {
                System.out.println(" real type is null");
            }
        }

        public boolean isIn() {
            return this.direction == 0;
        }

        public boolean isOut() {
            return this.direction == 1;
        }

        public boolean isInOut() {
            return this.direction == 2;
        }

        public boolean isAutoFree() {
            return this.autoFree;
        }

        public void setAttributes(String[] attributes) {
            String mod = attributes[3];
            if ("in".equals(mod)) {
                this.direction = 0;
            } else if ("out".equals(mod)) {
                this.direction = 1;
                if (attributes.length > 4 && "free".equals(attributes[4])) {
                    this.autoFree = true;
                }
            } else if ("inout".equals(mod)) {
                this.direction = 2;
            } else if ("alias".equals(mod)) {
                this.alias = true;
                this.aliasName = attributes[4];
            } else if (this.type == 10 || this.type == 6 || this.type == 9) {
                this.referencedType = (BaseType)symbolTable.get(mod);
                if (this.referencedType == null) {
                    log.warning("Can't find type for name " + mod);
                }
                if (attributes.length > 4) {
                    try {
                        this.arrayLength = Integer.parseInt(attributes[4]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public BaseType getReferencedType() {
            return this.referencedType;
        }

        public int getArrayLength() {
            return this.arrayLength;
        }

        public void setOffset(int o) {
            this.offset = o;
        }

        public int getType() {
            return this.type;
        }

        public String getTypeUpperCase() {
            switch (this.type) {
                case 0: {
                    return "Int";
                }
                case 1: {
                    return "Char";
                }
                case 11: {
                    return "Byte";
                }
                case 2: 
                case 3: 
                case 6: {
                    return "Long";
                }
                case 4: {
                    return "Double";
                }
                case 5: {
                    return "Float";
                }
                case 7: {
                    return "Short";
                }
                case 8: {
                    return "Int";
                }
                case 12: {
                    return "Long";
                }
                case 13: {
                    return "ULong";
                }
            }
            throw new IllegalArgumentException("Uknown type");
        }

        public int getOffset() {
            return this.offset;
        }

        public boolean isAlias() {
            return this.alias;
        }

        public String getAliasName() {
            return this.aliasName;
        }
    }

    private static abstract class BaseType {
        String real_type;
        String name;

        private BaseType() {
        }

        public String getName() {
            return this.name;
        }

        public String getRealType() {
            return this.real_type;
        }

        public String toString() {
            return this.name;
        }
    }
}

