/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.BasicBlock;
import llvm.Instruction;
import llvm.UnaryInstruction;
import llvm.Value;
import llvm.llvmJNI;

public class LoadInst
extends UnaryInstruction {
    private long swigCPtr;

    protected LoadInst(long l2, boolean bl2) {
        super(llvmJNI.SWIGLoadInstUpcast(l2), bl2);
        this.swigCPtr = l2;
    }

    protected static long getCPtr(LoadInst loadInst) {
        return loadInst == null ? 0L : loadInst.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_LoadInst(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static LoadInst Create(Value value, String string, Instruction instruction) {
        long l2 = llvmJNI.LoadInst_Create__SWIG_0(Value.getCPtr(value), value, string, Instruction.getCPtr(instruction), instruction);
        return l2 == 0L ? null : new LoadInst(l2, false);
    }

    public static LoadInst Create(Value value, String string, BasicBlock basicBlock) {
        long l2 = llvmJNI.LoadInst_Create__SWIG_1(Value.getCPtr(value), value, string, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l2 == 0L ? null : new LoadInst(l2, false);
    }

    public boolean isVolatile() {
        return llvmJNI.LoadInst_isVolatile(this.swigCPtr, this);
    }

    public void setVolatile(boolean bl2) {
        llvmJNI.LoadInst_setVolatile(this.swigCPtr, this, bl2);
    }

    public long getAlignment() {
        return llvmJNI.LoadInst_getAlignment(this.swigCPtr, this);
    }

    public void setAlignment(long l2) {
        llvmJNI.LoadInst_setAlignment(this.swigCPtr, this, l2);
    }

    public Value getPointerOperand() {
        long l2 = llvmJNI.LoadInst_getPointerOperand__SWIG_0(this.swigCPtr, this);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public static long getPointerOperandIndex() {
        return llvmJNI.LoadInst_getPointerOperandIndex();
    }

    public long getPointerAddressSpace() {
        return llvmJNI.LoadInst_getPointerAddressSpace(this.swigCPtr, this);
    }

    public static boolean classof(LoadInst loadInst) {
        return llvmJNI.LoadInst_classof__SWIG_0(LoadInst.getCPtr(loadInst), loadInst);
    }

    public static boolean classof(Instruction instruction) {
        return llvmJNI.LoadInst_classof__SWIG_1(Instruction.getCPtr(instruction), instruction);
    }

    public static boolean classof(Value value) {
        return llvmJNI.LoadInst_classof__SWIG_2(Value.getCPtr(value), value);
    }

    public static LoadInst dyn_cast(UnaryInstruction unaryInstruction) {
        long l2 = llvmJNI.LoadInst_dyn_cast(UnaryInstruction.getCPtr(unaryInstruction), unaryInstruction);
        return l2 == 0L ? null : new LoadInst(l2, false);
    }
}

