/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class SubjectAltName
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    private GeneralNames a = new GeneralNames();
    ASN1Template b;

    public SubjectAltName() {
        this.extensionTypeFlag = 17;
        this.criticality = false;
        this.setStandardOID(17);
        this.extensionTypeString = "SubjectAltName";
    }

    public SubjectAltName(GeneralNames generalNames, boolean bl2) throws CertificateException {
        this.extensionTypeFlag = 17;
        this.criticality = bl2;
        if (generalNames == null) {
            throw new CertificateException("GeneralName is null.");
        }
        try {
            this.a = (GeneralNames)generalNames.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CertificateException("Cloning error. Cannot initialize SubjectAltName");
        }
        this.setStandardOID(17);
        this.extensionTypeString = "SubjectAltName";
    }

    public void addGeneralName(GeneralName generalName) {
        if (generalName != null) {
            this.a.addGeneralName(generalName);
        }
    }

    public void setGeneralNames(GeneralNames generalNames) throws CertificateException {
        try {
            if (generalNames != null) {
                this.a = (GeneralNames)generalNames.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CertificateException("Can't add new name to SubjectAltName");
        }
    }

    public GeneralNames getGeneralNames() {
        return this.a;
    }

    public void decodeValue(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            this.a = new GeneralNames(byArray, n2, 0);
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not decode SubjectAltName extension.");
        }
    }

    public int derEncodeValueInit() {
        try {
            byte[] byArray = new byte[this.a.getDERLen(0)];
            int n2 = this.a.getDEREncoding(byArray, 0, 0);
            EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, n2);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{encodedContainer};
            this.b = new ASN1Template(aSN1ContainerArray);
            return this.b.derEncodeInit();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int n3 = this.b.derEncode(byArray, n2);
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SubjectAltName subjectAltName = new SubjectAltName();
        if (this.a != null) {
            subjectAltName.a = (GeneralNames)this.a.clone();
        }
        if (this.b != null) {
            subjectAltName.derEncodeValueInit();
        }
        super.copyValues(subjectAltName);
        return subjectAltName;
    }

    protected void reset() {
        super.reset();
        this.a = new GeneralNames();
    }
}

