/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.certj.cert.CRLExtension;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class IssuerAltName
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension,
CRLExtension {
    private GeneralNames a = new GeneralNames();
    ASN1Template b;

    public IssuerAltName() {
        this.extensionTypeFlag = 18;
        this.criticality = false;
        this.setStandardOID(18);
        this.extensionTypeString = "IssuerAltName";
    }

    public IssuerAltName(GeneralNames generalNames, boolean bl2) throws CertificateException {
        this.extensionTypeFlag = 18;
        this.criticality = bl2;
        if (generalNames == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            this.a = (GeneralNames)generalNames.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CertificateException("Can't initialise IssuerAltName");
        }
        this.setStandardOID(18);
        this.extensionTypeString = "IssuerAltName";
    }

    public void addGeneralName(GeneralName generalName) {
        if (generalName != null) {
            this.a.addGeneralName(generalName);
        }
    }

    public void setGeneralNames(GeneralNames generalNames) throws CertificateException {
        try {
            if (generalNames != null) {
                this.a = (GeneralNames)generalNames.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CertificateException("Can't add new name to IssuerAltName");
        }
    }

    public GeneralNames getGeneralNames() {
        return this.a;
    }

    public void decodeValue(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            this.a = new GeneralNames(byArray, n2, 0);
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not decode IssuerAltName extension.");
        }
    }

    public int derEncodeValueInit() {
        try {
            byte[] byArray = new byte[this.a.getDERLen(0)];
            int n2 = this.a.getDEREncoding(byArray, 0, 0);
            EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, n2);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{encodedContainer};
            this.b = new ASN1Template(aSN1ContainerArray);
        }
        catch (Exception exception) {
            return 0;
        }
        try {
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int n3 = this.b.derEncode(byArray, n2);
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        IssuerAltName issuerAltName = new IssuerAltName();
        if (this.a != null) {
            issuerAltName.a = (GeneralNames)this.a.clone();
        }
        if (this.b != null) {
            issuerAltName.derEncodeValueInit();
        }
        super.copyValues(issuerAltName);
        return issuerAltName;
    }

    protected void reset() {
        super.reset();
        this.a = new GeneralNames();
    }
}

