/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoPlist {
    public static final String PORTRAIT = "portrait";
    public static final String LANDSCAPE = "landscape";
    public static final String ORIENTATION_PORTRAIT = "UIInterfaceOrientationPortrait";
    public static final String ORIENTATION_PORTRAIT_UPSIDE_DOWN = "UIInterfaceOrientationPortraitUpsideDown";
    public static final String ORIENTATION_LANDSCAPE_LEFT = "UIInterfaceOrientationLandscapeLeft";
    public static final String ORIENTATION_LANDSCAPE_RIGHT = "UIInterfaceOrientationLandscapeRight";
    public static final String DEVICE_FAMILY = "UIDeviceFamily";
    public static final String REQUIRED_DEVICE_CAPABILITIES = "UIRequiredDeviceCapabilities";
    public static final String ARMV7 = "armv7";
    public static final String OPENGLES2 = "opengles-2";
    private Document m_doc = null;
    private String m_executable = null;
    private String m_name = null;
    private String m_iconPath = null;
    private String m_iconLargePath = null;
    private String m_iconSmall50Path = null;
    private String m_icon2xPath = null;
    private String m_identifier = null;
    private String m_version = null;
    private String m_iosDisplayMode = null;
    private Boolean m_fullscreen = false;
    private Boolean m_autoOrients = false;
    private String m_softKeyboardBehavior = null;
    private String m_aspectRatio = null;
    private String m_infoAdditions = null;
    private String m_initialWindowTitle = null;
    private String m_initialWindowContent = null;
    private int m_maxSWFVersion = -1;
    private DocumentBuilder m_docBuilder = null;
    private String m_renderMode = null;
    private String m_debugHost = null;

    public void setExecutable(String executable) {
        this.m_executable = executable;
    }

    public void setIdentifier(String identifier) {
        this.m_identifier = identifier;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setIcon(String path) {
        this.m_iconPath = path;
    }

    public void setIconLarge(String path) {
        this.m_iconLargePath = path;
    }

    public void setIconSmall50(String path) {
        this.m_iconSmall50Path = path;
    }

    public void setIcon2x(String path) {
        this.m_icon2xPath = path;
    }

    public void setVersionNumber(String value) {
        this.m_version = value;
    }

    public void setInitialWindowTitle(String value) {
        this.m_initialWindowTitle = value;
    }

    public void setInitialWindowContent(String value) {
        this.m_initialWindowContent = value;
    }

    public void setMaxSWFVersion(int maxSWFVersion) {
        this.m_maxSWFVersion = maxSWFVersion;
    }

    public void setFullscreen(Boolean value) {
        if (value != null) {
            this.m_fullscreen = value;
        }
    }

    public void setInfoAdditions(String value) {
        this.m_infoAdditions = value;
    }

    public void setAutoOrients(Boolean value) {
        if (value != null) {
            this.m_autoOrients = value;
        }
    }

    public void setAspectRatio(String aspectRatio) {
        this.m_aspectRatio = aspectRatio;
    }

    public void setRenderMode(String renderMode) {
        this.m_renderMode = renderMode;
    }

    public void setDisplayMode(String displayMode) {
        this.m_iosDisplayMode = displayMode;
    }

    public void setSoftKeyboardBehavior(String softKeyboardBehavior) {
        this.m_softKeyboardBehavior = softKeyboardBehavior;
    }

    public void setForOutgoingDebuggingConnection(String debugHost, int debugPort) {
        this.m_debugHost = debugHost;
    }

    private Document createPlistDoc() throws ParserConfigurationException {
        if (this.m_docBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.m_docBuilder = factory.newDocumentBuilder();
        }
        DOMImplementation domImpl = this.m_docBuilder.getDOMImplementation();
        DocumentType doctype = domImpl.createDocumentType("plist", "-//Apple Computer//DTD PLIST 1.0//EN", "http://www.apple.com/DTDs/PropertyList-1.0.dtd");
        return domImpl.createDocument(null, "plist", doctype);
    }

    private Element appendType(Node root, String type, String value) {
        Element elemType = this.m_doc.createElement(type);
        if (value != null) {
            elemType.appendChild(this.m_doc.createTextNode(value));
        }
        root.appendChild(elemType);
        return elemType;
    }

    private void appendKey(Node root, String key) {
        this.appendType(root, "key", key);
    }

    private void appendString(Node root, String value) {
        this.appendType(root, "string", value);
    }

    private void appendKeyString(Node root, String key, String value) {
        this.appendKey(root, key);
        this.appendString(root, value);
    }

    private void appendKeyBool(Node root, String key, Boolean value) {
        this.appendKey(root, key);
        this.appendType(root, value != false ? "true" : "false", null);
    }

    private Element appendKeyArray(Node root, String key) {
        this.appendKey(root, key);
        return this.appendType(root, "array", null);
    }

    private static String join(Collection<?> s2, String delimiter) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> iter = s2.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    private void ensureRequiredCapabilities(Node capabilities) {
        for (String capabilityToAdd : new String[]{ARMV7, OPENGLES2}) {
            NodeList children = capabilities.getChildNodes();
            boolean capabilityToAddSeen = false;
            if (capabilities.getNodeName().trim().equals("array")) {
                for (int i2 = 0; i2 < children.getLength(); ++i2) {
                    Node child = children.item(i2);
                    if (child.getNodeType() != 1 || !child.getTextContent().equals(capabilityToAdd)) continue;
                    capabilityToAddSeen = true;
                }
                if (capabilityToAddSeen) continue;
                this.appendString(capabilities, capabilityToAdd);
                continue;
            }
            if (!capabilities.getNodeName().trim().equals("dict")) continue;
            boolean afterCapabilityToAdd = false;
            for (int i3 = 0; i3 < children.getLength(); ++i3) {
                Node child = children.item(i3);
                if (child.getNodeType() != 1) continue;
                if (child.getTextContent().trim().equals(capabilityToAdd)) {
                    capabilityToAddSeen = true;
                    afterCapabilityToAdd = true;
                }
                if (child.getNodeName().trim().equals("true") && afterCapabilityToAdd) {
                    afterCapabilityToAdd = false;
                }
                if (!child.getNodeName().trim().equals("false") || !afterCapabilityToAdd) continue;
                afterCapabilityToAdd = false;
                Element trueNode = this.m_doc.createElement("true");
                capabilities.insertBefore(trueNode, child);
                capabilities.removeChild(child);
            }
            if (capabilityToAddSeen) continue;
            this.appendKeyBool(capabilities, capabilityToAdd, true);
        }
    }

    private boolean checkForIpadSupport(Node deviceFamilies) {
        NodeList array = deviceFamilies.getChildNodes();
        for (int i2 = 0; i2 < array.getLength(); ++i2) {
            Node child = array.item(i2);
            if (child.getNodeType() != 1 || !child.getTextContent().trim().equals("2")) continue;
            return true;
        }
        return false;
    }

    public String getXML() throws IOException {
        String result = null;
        try {
            this.m_doc = this.createPlistDoc();
            Element plist = this.m_doc.getDocumentElement();
            plist.setAttribute("version", "1.0");
            Element dict = this.appendType(plist, "dict", null);
            this.appendKeyBool(dict, "CFBundleAllowMixedLocalizations", true);
            List<Object> numbers = new ArrayList<Integer>();
            String[] versionArray = this.m_version.split("\\.");
            int versionArrayLength = versionArray.length;
            if (versionArrayLength > 0) {
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (i2 < versionArrayLength) {
                        numbers.add(new Integer(versionArray[i2]));
                        continue;
                    }
                    numbers.add(new Integer(0));
                }
            } else {
                numbers = Arrays.asList(1, 1, 1);
            }
            if (numbers.size() > 1 && (Integer)numbers.get(1) > 99) {
                numbers.set(1, 99);
            }
            if (numbers.size() > 2 && (Integer)numbers.get(2) > 99) {
                numbers.set(2, 99);
            }
            this.appendKeyString(dict, "CFBundleVersion", InfoPlist.join(numbers, "."));
            this.appendKeyString(dict, "CFBundleShortVersionString", this.m_version);
            this.appendKeyString(dict, "CFBundleIdentifier", this.m_identifier);
            this.appendKeyString(dict, "CFBundleInfoDictionaryVersion", "6.0");
            this.appendKeyString(dict, "CFBundleExecutable", this.m_executable);
            this.appendKeyString(dict, "CFBundleDisplayName", this.m_name);
            this.appendKeyString(dict, "CFBundlePackageType", "APPL");
            this.appendKeyString(dict, "DTCompiler", "4.2");
            this.appendKeyString(dict, "DTPlatformBuild", "8C134");
            this.appendKeyString(dict, "DTPlatformName", "iphoneos");
            this.appendKeyString(dict, "DTPlatformVersion", "4.2 Seed 2");
            this.appendKeyString(dict, "DTSDKName", "iphoneos4.2");
            this.appendKeyString(dict, "DTXcode", "0325");
            this.appendKeyString(dict, "DTXcodeBuild", "10M2423");
            this.appendKeyBool(dict, "LSRequiresIPhoneOS", true);
            this.appendKeyString(dict, "MinimumOSVersion", "4.0");
            this.appendKeyString(dict, "NSMainNibFile", "MainWindow");
            this.appendKeyString(dict, "NSMainNibFile~ipad", "MainWindow-iPad");
            this.appendKeyString(dict, "CFBundleResourceSpecification", "ResourceRules.plist");
            this.appendKeyBool(dict, "UIStatusBarHidden", this.m_fullscreen);
            if (this.m_aspectRatio != null) {
                String orientation = this.m_aspectRatio.equals(LANDSCAPE) ? ORIENTATION_LANDSCAPE_RIGHT : ORIENTATION_PORTRAIT;
                this.appendKeyString(dict, "UIInterfaceOrientation", orientation);
            }
            if (this.m_renderMode != null) {
                this.appendKeyString(dict, "renderMode", this.m_renderMode);
            }
            if (this.m_iosDisplayMode != null) {
                this.appendKeyString(dict, "CTRequestedDisplayResolution", this.m_iosDisplayMode);
            }
            if (this.m_debugHost != null) {
                this.appendKeyString(dict, "DebugHost", this.m_debugHost);
            }
            if (this.m_softKeyboardBehavior != null) {
                this.appendKeyString(dict, "CTSoftKeyboardBehavior", this.m_softKeyboardBehavior);
            }
            this.appendKeyBool(dict, "CTAutoOrients", this.m_autoOrients);
            this.appendKeyString(dict, "CTInitialWindowTitle", this.m_initialWindowTitle);
            if (this.m_initialWindowContent != null) {
                this.appendKeyString(dict, "CTInitialWindowContent", this.m_initialWindowContent);
            }
            if (this.m_maxSWFVersion != -1) {
                this.appendKeyString(dict, "CTMaxSWFMajorVersion", String.valueOf(this.m_maxSWFVersion));
            }
            Element arraySupportedPlatforms = this.appendKeyArray(dict, "CFBundleSupportedPlatforms");
            this.appendString(arraySupportedPlatforms, "iPhoneOS");
            boolean deviceFamilyTagSeen = false;
            boolean requiredDeviceCapabilitesSeen = false;
            boolean iPadSupport = false;
            if (this.m_infoAdditions != null) {
                String infoAdditionsPList = "<plist><dict>" + this.m_infoAdditions + "</dict></plist>";
                Document document = this.m_docBuilder.parse(new InputSource(new StringReader(infoAdditionsPList)));
                Node rootNode = document.getDocumentElement().getFirstChild();
                boolean afterDeviceFamily = false;
                boolean afterRequiredDeviceCapabilities = false;
                NodeList children = rootNode.getChildNodes();
                for (int i3 = 0; i3 < children.getLength(); ++i3) {
                    Node child = this.m_doc.importNode(children.item(i3), true);
                    if (child.getNodeType() != 1) continue;
                    dict.appendChild(child);
                    if (child.getTextContent().trim().equals(DEVICE_FAMILY)) {
                        deviceFamilyTagSeen = true;
                        afterDeviceFamily = true;
                    }
                    if (child.getNodeName().trim().equals("array") && afterDeviceFamily) {
                        iPadSupport = this.checkForIpadSupport(child);
                        afterDeviceFamily = false;
                    }
                    if (child.getTextContent().trim().equals(REQUIRED_DEVICE_CAPABILITIES)) {
                        requiredDeviceCapabilitesSeen = true;
                        afterRequiredDeviceCapabilities = true;
                    }
                    if (!child.getNodeName().trim().equals("array") && !child.getNodeName().trim().equals("dict") || !afterRequiredDeviceCapabilities) continue;
                    this.ensureRequiredCapabilities(child);
                    afterRequiredDeviceCapabilities = false;
                }
            }
            if (!deviceFamilyTagSeen) {
                Element deviceFamilyNode = this.appendKeyArray(dict, DEVICE_FAMILY);
                this.appendString(deviceFamilyNode, "1");
            }
            if (!requiredDeviceCapabilitesSeen) {
                Element arrayRequiredDeviceCapabilities = this.appendKeyArray(dict, REQUIRED_DEVICE_CAPABILITIES);
                this.appendString(arrayRequiredDeviceCapabilities, ARMV7);
                this.appendString(arrayRequiredDeviceCapabilities, OPENGLES2);
            }
            if (iPadSupport) {
                if (this.m_iconPath != null || this.m_iconLargePath != null || this.m_iconSmall50Path != null || this.m_icon2xPath != null) {
                    Element arrayIcons = this.appendKeyArray(dict, "CFBundleIconFiles");
                    if (this.m_iconLargePath != null) {
                        this.appendString(arrayIcons, this.m_iconLargePath);
                    }
                    if (this.m_iconPath != null) {
                        this.appendString(arrayIcons, this.m_iconPath);
                    }
                    if (this.m_iconSmall50Path != null) {
                        this.appendString(arrayIcons, this.m_iconSmall50Path);
                    }
                    if (this.m_icon2xPath != null) {
                        this.appendString(arrayIcons, this.m_icon2xPath);
                    }
                }
                Element arrayOrientations = this.appendKeyArray(dict, "UISupportedInterfaceOrientations");
                if (this.m_aspectRatio == null || this.m_aspectRatio.equals(PORTRAIT)) {
                    this.appendString(arrayOrientations, ORIENTATION_PORTRAIT);
                    this.appendString(arrayOrientations, ORIENTATION_PORTRAIT_UPSIDE_DOWN);
                }
                if (this.m_aspectRatio == null || this.m_aspectRatio.equals(LANDSCAPE)) {
                    this.appendString(arrayOrientations, ORIENTATION_LANDSCAPE_RIGHT);
                    this.appendString(arrayOrientations, ORIENTATION_LANDSCAPE_LEFT);
                }
            }
            DOMSource domSource = new DOMSource(this.m_doc);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("doctype-public", "-//Apple//DTD PLIST 1.0//EN");
            transformer.setOutputProperty("doctype-system", "http://www.apple.com/DTDs/PropertyList-1.0.dtd");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            transformer.transform(domSource, sr);
            result = sw.toString();
        }
        catch (ParserConfigurationException e2) {
            throw new IOException("PLIST generation failed due to parser error:" + e2);
        }
        catch (TransformerException e3) {
            throw new IOException("PLIST generation failed due to transformer error:" + e3);
        }
        catch (SAXException e4) {
            throw new IOException("PLIST generation failed due to SAX error:" + e4);
        }
        catch (IOException e5) {
            throw new IOException("PLIST generation failed due to IO error:" + e5);
        }
        return result;
    }
}

