/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.InvalidInputException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils
extends com.adobe.ucf.Utils {
    public static void consumeOutput(Process process) {
        new OutputEater(process.getInputStream()).run();
        new OutputEater(process.getErrorStream()).run();
    }

    public static File getSDKLibDir() throws IOException {
        try {
            return Utils.getJarFile().getParentFile();
        }
        catch (Exception e2) {
            throw new IOException("failed to get jar directory");
        }
    }

    public static File getJarFile() throws IOException {
        try {
            return new File(new Utils().getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Exception e2) {
            throw new IOException("failed to find jar file");
        }
    }

    public static boolean deleteAll(File file) {
        if (file.isDirectory()) {
            File[] children;
            for (File child : children = file.listFiles()) {
                if (Utils.deleteAll(child)) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static byte[] readIn(InputStream in) throws IOException {
        byte[] data = new byte[in.available()];
        in.read(data);
        return data;
    }

    public static void writeOut(InputStream in, File f2) throws IOException {
        FileOutputStream out = new FileOutputStream(f2);
        Utils.writeThrough(in, out);
        ((OutputStream)out).close();
    }

    public static File getFileWithExtension(String outputFilename, String extension) {
        File outputFile = new File(outputFilename);
        String name = outputFile.getName();
        if (!name.matches(".+\\.[^\\.]+")) {
            name = name + extension;
        }
        return new File(outputFile.getParentFile(), name);
    }

    public static Process execSafely(File directory, String ... args) throws IOException {
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            return Utils.execSafelyWin(directory, args);
        }
        return Utils.execSafelyUnix(directory, args);
    }

    private static Process execSafelyUnix(File directory, String ... args) throws IOException {
        File cmdFile = File.createTempFile("cmd", null);
        cmdFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(cmdFile);
        if (directory != null) {
            out.write(("cd " + Utils.quote(directory.getPath()) + "\n").getBytes("UTF-8"));
        }
        for (String arg : args) {
            out.write((Utils.quote(arg) + " ").getBytes("UTF-8"));
        }
        out.close();
        return new ProcessBuilder("/bin/sh", cmdFile.getAbsolutePath()).start();
    }

    private static Process execSafelyWin(File directory, String ... args) throws IOException {
        String varNameBase = "ADT_ENV_VAR_";
        ProcessBuilder builder = new ProcessBuilder("cmd", "/c");
        if (directory != null) {
            builder.directory(directory);
        }
        int count = 0;
        for (String arg : args) {
            String varName = "ADT_ENV_VAR_" + count;
            builder.command().add("%" + varName + "%");
            builder.environment().put(varName, "\"" + arg + "\"");
            ++count;
        }
        return builder.start();
    }

    public static Process execSafely(File directory, List<String> args) throws IOException {
        return Utils.execSafely(directory, args.toArray(new String[0]));
    }

    private static String quote(String string) {
        return "\"" + string.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\\\"") + "\"";
    }

    protected static String getRelativePath(File source, File root) {
        return root.toURI().relativize(source.toURI()).getPath();
    }

    public static String performPlatformUnicodePathNormalization(String path) {
        File temp = null;
        try {
            temp = File.createTempFile("temp", null);
            String string = Utils.getRelativePath(new File(temp, path).getCanonicalFile(), temp.getCanonicalFile());
            return string;
        }
        catch (IOException e2) {
            throw new IllegalStateException("couldn't cannonicalize path");
        }
        finally {
            if (temp != null && temp.exists()) {
                temp.delete();
            }
        }
    }

    public static File createTempDirectory(File parentDir) throws IOException {
        String dirName = UUID.randomUUID().toString();
        File temp = new File(parentDir, dirName);
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    public static File createTempDirectory() throws IOException {
        return Utils.createTempDirectory(new File(System.getProperty("java.io.tmpdir")));
    }

    public static void extractZipFile(File file, File dstDir, String srcDir) throws IOException {
        byte[] buf = new byte[1024];
        ZipFile zipFile = new ZipFile(file.getAbsolutePath());
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (srcDir != null && !entry.getName().startsWith(srcDir)) continue;
            InputStream inStream = zipFile.getInputStream(entry);
            File outFile = new File(dstDir + File.separator + entry.getName());
            outFile.getParentFile().mkdirs();
            BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(dstDir + File.separator + entry.getName()));
            int n2 = 0;
            while ((n2 = inStream.read(buf, 0, 1024)) > -1) {
                ((OutputStream)outStream).write(buf, 0, n2);
            }
            inStream.close();
            ((OutputStream)outStream).close();
        }
        zipFile.close();
    }

    public static int getSWFVersion(File file) throws InvalidInputException {
        try {
            FileInputStream is = new FileInputStream(file);
            byte[] b3 = new byte[4];
            ((InputStream)is).read(b3);
            ((InputStream)is).close();
            if ((b3[0] == 70 || b3[0] == 67) && b3[1] == 87 && b3[2] == 83) {
                return b3[3];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new InvalidInputException("Invalid swf file " + file.getAbsolutePath());
    }

    public static String getMimetype(File file) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        ZipFile zip = null;
        try {
            String[] validMimetypes;
            zip = new ZipFile(file);
            ZipEntry mimetypeEntry = zip.entries().nextElement();
            if (mimetypeEntry == null || mimetypeEntry.getMethod() != 0) {
                return null;
            }
            InputStream mimetypeIn = zip.getInputStream(mimetypeEntry);
            ByteArrayOutputStream mimetypeBytes = new ByteArrayOutputStream();
            Utils.writeThrough(mimetypeIn, mimetypeBytes);
            String mimetype = mimetypeBytes.toString("UTF-8");
            for (String validMimetype : validMimetypes = new String[]{"application/vnd.adobe.air-application-installer-package+zip", "application/vnd.adobe.air-application-intermediate-package+zip", "application/vnd.adobe.air-native-application-installer-package+zip", "application/vnd.adobe.air-native-extension-package+zip"}) {
                if (!mimetype.equals(validMimetype)) continue;
                return mimetype;
            }
            zip.close();
            mimetypeIn.close();
            mimetypeBytes.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String stringJoin(String[] list, String separator) {
        if (list == null || list.length == 0) {
            return "";
        }
        String joinedString = list[0];
        for (int i2 = 1; i2 < list.length; ++i2) {
            joinedString = joinedString + separator + list[i2];
        }
        return joinedString;
    }

    public static class OutputEater
    extends Thread {
        private InputStream _in;
        private OutputStream _out;

        public OutputEater(InputStream in, OutputStream out) {
            this._in = in;
            this._out = out;
        }

        public OutputEater(InputStream in) {
            this(in, null);
        }

        public void run() {
            try {
                com.adobe.ucf.Utils.writeThrough(this._in, this._out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

