/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.ADTOutputStream;
import com.adobe.ucf.Packager;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;

public abstract class ADTPackager
extends Packager {
    protected static final String PACKAGER_SUBTYPE_AIR = "AIR";
    protected static final String PACKAGER_SUBTYPE_ANE = "ANE";
    protected boolean m_validate = true;
    protected boolean m_sign = true;
    private String m_subtype;

    protected ADTPackager(String subtype) {
        this.m_subtype = subtype;
    }

    public abstract void createPackage() throws IOException, GeneralSecurityException;

    public void createIntermediate() throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract void setIntermediateFile(File var1);

    protected void addMetaWithPath(File source, String path) {
        if (path == null) {
            path = "";
        }
        path = "META-INF/" + this.m_subtype + "/" + path;
        this.addFileWithPath(source, path, true);
    }

    protected void addMetaFileOrDir(File file, File root, String prefixPath) {
        if (prefixPath == null) {
            prefixPath = "";
        }
        prefixPath = "META-INF/" + this.m_subtype + "/" + prefixPath;
        this.addFileOrDir(file, root, prefixPath, true);
    }

    protected void setValidate(boolean validate) {
        this.m_validate = validate;
        this.getADTStream().setValidate(validate);
    }

    protected ADTOutputStream getADTStream() {
        return (ADTOutputStream)this.getStream();
    }

    protected void validateSigningCertificate(Certificate[] certchain) throws CertificateException {
        if (certchain == null || certchain.length == 0) {
            throw new IllegalArgumentException("empty certificate chain");
        }
        String CODE_SIGNING_OID = "1.3.6.1.5.5.7.3.3";
        List<String> extendedKeyUsage = ((X509Certificate)certchain[0]).getExtendedKeyUsage();
        if (extendedKeyUsage == null || !extendedKeyUsage.contains("1.3.6.1.5.5.7.3.3")) {
            throw new CertificateException("not a code signing certificate");
        }
    }
}

