/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Binding;
import adobe.abc.BuiltinDomain;
import adobe.abc.GlobalOptimizer;
import adobe.abc.Name;
import adobe.abc.Namespace;
import adobe.abc.Pair;
import adobe.abc.Symtab;
import adobe.abc.Type;
import adobe.abc.Typeref;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import macromedia.asc.util.APIVersions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain {
    public final int api;
    public static final int LARGEST_NON_SYS_VERSION = APIVersions.max_version_num - 2;
    public static final int LARGEST_API = 1 << APIVersions.max_version_num - APIVersions.min_version_num;
    public static final int SMALLEST_API = 1;
    public final Namespace PUBLIC;
    private Namespace PUBLIC_PACKAGE;
    public final Name AS3_TOSTRING;
    private final Domain m_base;
    private final Symtab<Type> m_namedTypes;
    private final Symtab<Typeref> m_namedScripts;
    protected boolean m_throwOnFailedLookup;
    private final Map<Type, Set<Type>> m_parameterizedTypesInstances;
    private final Map<Type, Type> m_parameterizedITypeToCType;

    public Domain() {
        this(null, false, new HashMap<Type, Set<Type>>(), Namespace.toAPI(LARGEST_NON_SYS_VERSION));
    }

    public Domain(Domain base, boolean throwOnFailedLookup, int api) {
        this(base, throwOnFailedLookup, base.m_parameterizedTypesInstances, api);
    }

    private Domain(Domain base, boolean throwOnFailedLookup, Map<Type, Set<Type>> parameterizedTypeInstances, int api) {
        this.m_base = base;
        this.m_namedTypes = new Symtab();
        this.m_namedScripts = new Symtab();
        this.m_throwOnFailedLookup = throwOnFailedLookup;
        this.m_parameterizedTypesInstances = parameterizedTypeInstances;
        this.m_parameterizedITypeToCType = new HashMap<Type, Type>();
        this.api = api;
        this.PUBLIC = Namespace.getVersionedNamespace(8, "", api);
        this.AS3_TOSTRING = new Name(Namespace.getVersionedNamespace(8, "http://adobe.com/AS3/2006/builtin", api), "toString");
    }

    protected Namespace PUBLIC_PACKAGE() {
        if (this.PUBLIC_PACKAGE == null) {
            this.PUBLIC_PACKAGE = Namespace.getVersionedNamespace(22, "", this.api);
        }
        return this.PUBLIC_PACKAGE;
    }

    public Type getNamedType(Name n2, boolean recursive) {
        Type result = null;
        if (this.m_base != null && recursive) {
            result = this.m_base.getNamedType(n2, true);
        }
        if (result == null) {
            result = this.m_namedTypes.get(n2);
        }
        return result;
    }

    public Typeref getNamedScript(Name n2) {
        Typeref result = null;
        if (this.m_base != null) {
            result = this.m_base.getNamedScript(n2);
        }
        if (result == null) {
            result = this.m_namedScripts.get(n2);
        }
        return result;
    }

    public Name getDefinitionName(Name n2) {
        Name result = null;
        if (this.m_base != null) {
            result = this.m_base.getDefinitionName(n2);
        }
        if (result == null) {
            result = this.m_namedScripts.getName(n2);
        }
        return result;
    }

    public boolean isNamedScript(Name n2) {
        return this.m_base != null && this.m_base.isNamedScript(n2) || this.m_namedScripts.contains(n2);
    }

    public void addNamedType(Type t2) {
        this.m_namedTypes.put(t2.getName(), t2);
    }

    public void addNamedType(Name name, Type t2) {
        this.m_namedTypes.put(name, t2);
    }

    public void addNamedScript(Name n2, Typeref t2) {
        assert (t2.exact && !t2.nullable);
        this.m_namedScripts.put(n2, t2);
    }

    private Type resolveParameterizedType(Name n2) {
        Type parameterType;
        assert (n2.isParameterizedTypeName());
        Type parameterizedType = this.resolveTypeName(n2.getParameterizedTypeName(), null, true);
        assert (parameterizedType != null);
        Type type = n2.getTypeParamName().isAny() ? BuiltinDomain.instance().ANY() : (parameterType = this.resolveTypeName(n2.getTypeParamName(), this.m_throwOnFailedLookup ? null : BuiltinDomain.instance().OBJECT()));
        assert (parameterType != null);
        Type result = new Type(n2, parameterizedType, new Type[]{parameterType});
        Type resultCType = new Type(n2.append("$"), BuiltinDomain.instance().CLASS());
        resultCType.itype = result;
        assert (this.getNamedType(result.name, true) == null);
        this.addNamedType(result);
        assert (this.getCType(result.name) == null);
        this.m_parameterizedITypeToCType.put(result, resultCType);
        assert (this.getNamedType(n2, false) == result);
        assert (this.getCType(result.name) == resultCType);
        Set<Type> instances = this.m_parameterizedTypesInstances.get(parameterizedType);
        if (instances == null) {
            instances = new HashSet<Type>();
            this.m_parameterizedTypesInstances.put(parameterizedType, instances);
        }
        instances.add(result);
        return result;
    }

    public Type resolveTypeName(Name n2, Type base) {
        return this.resolveTypeName(n2, base, false);
    }

    private Pair<Type, Binding> getClassBinding(Type iType) {
        Name exactName = iType.getName();
        Typeref scriptTypeRef = this.getNamedScript(exactName);
        if (scriptTypeRef == null) {
            return null;
        }
        assert (!iType.isParameterizedTypeInstance());
        Type scriptType = scriptTypeRef.t;
        Binding classBinding = scriptType.find(exactName);
        assert (classBinding.isClass());
        assert (classBinding.type != null);
        return new Pair<Type, Binding>(scriptType, classBinding);
    }

    public GlobalOptimizer.Metadata[] getClassMetadata(Name n2) {
        Type iType = this.getNamedType(n2, true);
        if (iType == null) {
            return null;
        }
        Pair<Type, Binding> scriptAndBinding = this.getClassBinding(iType);
        if (scriptAndBinding == null) {
            assert (iType.isParameterizedTypeInstance());
            return null;
        }
        return ((Binding)scriptAndBinding.snd).md;
    }

    private Type getCType(Name n2) {
        Type result;
        Type iType = this.getNamedType(n2, true);
        if (iType == null) {
            return null;
        }
        Pair<Type, Binding> scriptAndBinding = this.getClassBinding(iType);
        if (scriptAndBinding != null) {
            result = ((Binding)scriptAndBinding.snd).type.t;
        } else {
            assert (iType.isParameterizedTypeInstance());
            Domain d2 = this;
            result = null;
            while (d2 != null && result == null) {
                result = d2.m_parameterizedITypeToCType.get(iType);
                d2 = d2.m_base;
            }
        }
        assert (result == null || result.itype == iType);
        return result;
    }

    public Type resolveCType(Name n2) {
        Type result = this.getCType(n2);
        if (result == null) {
            this.resolveTypeName(n2, null, true);
            result = this.getCType(n2);
            assert (result != null);
        }
        return result;
    }

    private Type resolveTypeName(Name n2, Type base, boolean forceThrowOnFailedLookup) {
        Type t2 = this.getNamedType(n2, true);
        if (t2 == null) {
            if (n2.isParameterizedTypeName()) {
                t2 = this.resolveParameterizedType(n2);
                assert (t2 != null);
                return t2;
            }
            if (this.m_throwOnFailedLookup || forceThrowOnFailedLookup) {
                throw new Error("Unable to find named traits: " + n2.format());
            }
            Name n22 = new Name(7, Namespace.getVersionedNamespace(22, "", Namespace.toAPI(LARGEST_NON_SYS_VERSION)), n2.name);
            t2 = this.getNamedType(n22, true);
            if (t2 == null) {
                t2 = new Type(n22, base);
                this.addNamedType(t2);
            }
        }
        return t2;
    }

    public boolean containsNamedType(Type at2) {
        return this.containsNamedType(at2.getName());
    }

    public boolean containsNamedType(Name n2) {
        return this.m_namedTypes.contains(n2);
    }

    public Name createNameWithPublicNamespace(String name) {
        return new Name(7, this.PUBLIC, name);
    }

    public Map<Type, Set<Type>> parameterizedTypesInstances() {
        return this.m_parameterizedTypesInstances;
    }
}

