/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.SequentialType;
import llvm.Type;
import llvm.llvmJNI;

public class VectorType
extends SequentialType {
    private long swigCPtr;

    protected VectorType(long l2, boolean bl2) {
        super(llvmJNI.SWIGVectorTypeUpcast(l2), bl2);
        this.swigCPtr = l2;
    }

    protected static long getCPtr(VectorType vectorType) {
        return vectorType == null ? 0L : vectorType.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_VectorType(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static VectorType get(Type type, long l2) {
        long l3 = llvmJNI.VectorType_get(Type.getCPtr(type), type, l2);
        return l3 == 0L ? null : new VectorType(l3, false);
    }

    public static VectorType getInteger(VectorType vectorType) {
        long l2 = llvmJNI.VectorType_getInteger(VectorType.getCPtr(vectorType), vectorType);
        return l2 == 0L ? null : new VectorType(l2, false);
    }

    public static VectorType getExtendedElementVectorType(VectorType vectorType) {
        long l2 = llvmJNI.VectorType_getExtendedElementVectorType(VectorType.getCPtr(vectorType), vectorType);
        return l2 == 0L ? null : new VectorType(l2, false);
    }

    public static VectorType getTruncatedElementVectorType(VectorType vectorType) {
        long l2 = llvmJNI.VectorType_getTruncatedElementVectorType(VectorType.getCPtr(vectorType), vectorType);
        return l2 == 0L ? null : new VectorType(l2, false);
    }

    public static boolean isValidElementType(Type type) {
        return llvmJNI.VectorType_isValidElementType(Type.getCPtr(type), type);
    }

    public long getNumElements() {
        return llvmJNI.VectorType_getNumElements(this.swigCPtr, this);
    }

    public long getBitWidth() {
        return llvmJNI.VectorType_getBitWidth(this.swigCPtr, this);
    }

    public static boolean classof(VectorType vectorType) {
        return llvmJNI.VectorType_classof__SWIG_0(VectorType.getCPtr(vectorType), vectorType);
    }

    public static boolean classof(Type type) {
        return llvmJNI.VectorType_classof__SWIG_1(Type.getCPtr(type), type);
    }

    public static VectorType dyn_cast(SequentialType sequentialType) {
        long l2 = llvmJNI.VectorType_dyn_cast(SequentialType.getCPtr(sequentialType), sequentialType);
        return l2 == 0L ? null : new VectorType(l2, false);
    }
}

