/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import java.math.BigInteger;
import llvm.FoldingSetNodeID;
import llvm.SWIGTYPE_p_llvm__APInt__ms;
import llvm.SWIGTYPE_p_llvm__APInt__mu;
import llvm.SWIGTYPE_p_llvm__SmallVectorImplT_char_t;
import llvm.SWIGTYPE_p_unsigned_long_long;
import llvm.StringRef;
import llvm.llvmJNI;
import llvm.raw_ostream;

public class APInt {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected APInt(long l2, boolean bl2) {
        this.swigCMemOwn = bl2;
        this.swigCPtr = l2;
    }

    protected static long getCPtr(APInt aPInt) {
        return aPInt == null ? 0L : aPInt.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_APInt(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public APInt(long l2, BigInteger bigInteger, boolean bl2) {
        this(llvmJNI.new_APInt__SWIG_0(l2, bigInteger, bl2), true);
    }

    public APInt(long l2, BigInteger bigInteger) {
        this(llvmJNI.new_APInt__SWIG_1(l2, bigInteger), true);
    }

    public APInt(long l2, long l3, SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long) {
        this(llvmJNI.new_APInt__SWIG_2(l2, l3, SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long)), true);
    }

    public APInt(long l2, StringRef stringRef, short s2) {
        this(llvmJNI.new_APInt__SWIG_3(l2, StringRef.getCPtr(stringRef), stringRef, s2), true);
    }

    public APInt(APInt aPInt) {
        this(llvmJNI.new_APInt__SWIG_4(APInt.getCPtr(aPInt), aPInt), true);
    }

    public APInt() {
        this(llvmJNI.new_APInt__SWIG_5(), true);
    }

    public void Profile(FoldingSetNodeID foldingSetNodeID) {
        llvmJNI.APInt_Profile(this.swigCPtr, this, FoldingSetNodeID.getCPtr(foldingSetNodeID), foldingSetNodeID);
    }

    public boolean isNegative() {
        return llvmJNI.APInt_isNegative(this.swigCPtr, this);
    }

    public boolean isNonNegative() {
        return llvmJNI.APInt_isNonNegative(this.swigCPtr, this);
    }

    public boolean isStrictlyPositive() {
        return llvmJNI.APInt_isStrictlyPositive(this.swigCPtr, this);
    }

    public boolean isAllOnesValue() {
        return llvmJNI.APInt_isAllOnesValue(this.swigCPtr, this);
    }

    public boolean isMaxValue() {
        return llvmJNI.APInt_isMaxValue(this.swigCPtr, this);
    }

    public boolean isMaxSignedValue() {
        return llvmJNI.APInt_isMaxSignedValue(this.swigCPtr, this);
    }

    public boolean isMinValue() {
        return llvmJNI.APInt_isMinValue(this.swigCPtr, this);
    }

    public boolean isMinSignedValue() {
        return llvmJNI.APInt_isMinSignedValue(this.swigCPtr, this);
    }

    public boolean isIntN(long l2) {
        return llvmJNI.APInt_isIntN(this.swigCPtr, this, l2);
    }

    public boolean isSignedIntN(long l2) {
        return llvmJNI.APInt_isSignedIntN(this.swigCPtr, this, l2);
    }

    public boolean isPowerOf2() {
        return llvmJNI.APInt_isPowerOf2(this.swigCPtr, this);
    }

    public boolean isSignBit() {
        return llvmJNI.APInt_isSignBit(this.swigCPtr, this);
    }

    public boolean getBoolValue() {
        return llvmJNI.APInt_getBoolValue(this.swigCPtr, this);
    }

    public BigInteger getLimitedValue(BigInteger bigInteger) {
        return llvmJNI.APInt_getLimitedValue__SWIG_0(this.swigCPtr, this, bigInteger);
    }

    public BigInteger getLimitedValue() {
        return llvmJNI.APInt_getLimitedValue__SWIG_1(this.swigCPtr, this);
    }

    public static APInt getMaxValue(long l2) {
        return new APInt(llvmJNI.APInt_getMaxValue(l2), true);
    }

    public static APInt getSignedMaxValue(long l2) {
        return new APInt(llvmJNI.APInt_getSignedMaxValue(l2), true);
    }

    public static APInt getMinValue(long l2) {
        return new APInt(llvmJNI.APInt_getMinValue(l2), true);
    }

    public static APInt getSignedMinValue(long l2) {
        return new APInt(llvmJNI.APInt_getSignedMinValue(l2), true);
    }

    public static APInt getSignBit(long l2) {
        return new APInt(llvmJNI.APInt_getSignBit(l2), true);
    }

    public static APInt getAllOnesValue(long l2) {
        return new APInt(llvmJNI.APInt_getAllOnesValue(l2), true);
    }

    public static APInt getNullValue(long l2) {
        return new APInt(llvmJNI.APInt_getNullValue(l2), true);
    }

    public APInt getHiBits(long l2) {
        return new APInt(llvmJNI.APInt_getHiBits(this.swigCPtr, this, l2), true);
    }

    public APInt getLoBits(long l2) {
        return new APInt(llvmJNI.APInt_getLoBits(this.swigCPtr, this, l2), true);
    }

    public static APInt getBitsSet(long l2, long l3, long l4) {
        return new APInt(llvmJNI.APInt_getBitsSet(l2, l3, l4), true);
    }

    public static APInt getHighBitsSet(long l2, long l3) {
        return new APInt(llvmJNI.APInt_getHighBitsSet(l2, l3), true);
    }

    public static APInt getLowBitsSet(long l2, long l3) {
        return new APInt(llvmJNI.APInt_getLowBitsSet(l2, l3), true);
    }

    public BigInteger getHashValue() {
        return llvmJNI.APInt_getHashValue(this.swigCPtr, this);
    }

    public SWIGTYPE_p_unsigned_long_long getRawData() {
        long l2 = llvmJNI.APInt_getRawData(this.swigCPtr, this);
        return l2 == 0L ? null : new SWIGTYPE_p_unsigned_long_long(l2, false);
    }

    public APInt And(APInt aPInt) {
        return new APInt(llvmJNI.APInt_And(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt), true);
    }

    public APInt Or(APInt aPInt) {
        return new APInt(llvmJNI.APInt_Or(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt), true);
    }

    public APInt Xor(APInt aPInt) {
        return new APInt(llvmJNI.APInt_Xor(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt), true);
    }

    public APInt ashr(long l2) {
        return new APInt(llvmJNI.APInt_ashr__SWIG_0(this.swigCPtr, this, l2), true);
    }

    public APInt lshr(long l2) {
        return new APInt(llvmJNI.APInt_lshr__SWIG_0(this.swigCPtr, this, l2), true);
    }

    public APInt shl(long l2) {
        return new APInt(llvmJNI.APInt_shl__SWIG_0(this.swigCPtr, this, l2), true);
    }

    public APInt rotl(long l2) {
        return new APInt(llvmJNI.APInt_rotl__SWIG_0(this.swigCPtr, this, l2), true);
    }

    public APInt rotr(long l2) {
        return new APInt(llvmJNI.APInt_rotr__SWIG_0(this.swigCPtr, this, l2), true);
    }

    public APInt ashr(APInt aPInt) {
        return new APInt(llvmJNI.APInt_ashr__SWIG_1(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt), true);
    }

    public APInt lshr(APInt aPInt) {
        return new APInt(llvmJNI.APInt_lshr__SWIG_1(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt), true);
    }

    public APInt shl(APInt aPInt) {
        return new APInt(llvmJNI.APInt_shl__SWIG_1(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt), true);
    }

    public APInt rotl(APInt aPInt) {
        return new APInt(llvmJNI.APInt_rotl__SWIG_1(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt), true);
    }

    public APInt rotr(APInt aPInt) {
        return new APInt(llvmJNI.APInt_rotr__SWIG_1(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt), true);
    }

    public APInt udiv(APInt aPInt) {
        return new APInt(llvmJNI.APInt_udiv(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt), true);
    }

    public APInt sdiv(APInt aPInt) {
        return new APInt(llvmJNI.APInt_sdiv(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt), true);
    }

    public APInt urem(APInt aPInt) {
        return new APInt(llvmJNI.APInt_urem(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt), true);
    }

    public APInt srem(APInt aPInt) {
        return new APInt(llvmJNI.APInt_srem(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt), true);
    }

    public static void udivrem(APInt aPInt, APInt aPInt2, APInt aPInt3, APInt aPInt4) {
        llvmJNI.APInt_udivrem(APInt.getCPtr(aPInt), aPInt, APInt.getCPtr(aPInt2), aPInt2, APInt.getCPtr(aPInt3), aPInt3, APInt.getCPtr(aPInt4), aPInt4);
    }

    public static void sdivrem(APInt aPInt, APInt aPInt2, APInt aPInt3, APInt aPInt4) {
        llvmJNI.APInt_sdivrem(APInt.getCPtr(aPInt), aPInt, APInt.getCPtr(aPInt2), aPInt2, APInt.getCPtr(aPInt3), aPInt3, APInt.getCPtr(aPInt4), aPInt4);
    }

    public boolean eq(APInt aPInt) {
        return llvmJNI.APInt_eq(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt);
    }

    public boolean ne(APInt aPInt) {
        return llvmJNI.APInt_ne(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt);
    }

    public boolean ult(APInt aPInt) {
        return llvmJNI.APInt_ult(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt);
    }

    public boolean slt(APInt aPInt) {
        return llvmJNI.APInt_slt(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt);
    }

    public boolean ule(APInt aPInt) {
        return llvmJNI.APInt_ule(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt);
    }

    public boolean sle(APInt aPInt) {
        return llvmJNI.APInt_sle(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt);
    }

    public boolean ugt(APInt aPInt) {
        return llvmJNI.APInt_ugt(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt);
    }

    public boolean sgt(APInt aPInt) {
        return llvmJNI.APInt_sgt(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt);
    }

    public boolean uge(APInt aPInt) {
        return llvmJNI.APInt_uge(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt);
    }

    public boolean sge(APInt aPInt) {
        return llvmJNI.APInt_sge(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt);
    }

    public boolean intersects(APInt aPInt) {
        return llvmJNI.APInt_intersects(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt);
    }

    public APInt trunc(long l2) {
        return new APInt(llvmJNI.APInt_trunc(this.swigCPtr, this, l2), false);
    }

    public APInt sext(long l2) {
        return new APInt(llvmJNI.APInt_sext(this.swigCPtr, this, l2), false);
    }

    public APInt zext(long l2) {
        return new APInt(llvmJNI.APInt_zext(this.swigCPtr, this, l2), false);
    }

    public APInt sextOrTrunc(long l2) {
        return new APInt(llvmJNI.APInt_sextOrTrunc(this.swigCPtr, this, l2), false);
    }

    public APInt zextOrTrunc(long l2) {
        return new APInt(llvmJNI.APInt_zextOrTrunc(this.swigCPtr, this, l2), false);
    }

    public APInt set() {
        return new APInt(llvmJNI.APInt_set__SWIG_0(this.swigCPtr, this), false);
    }

    public APInt set(long l2) {
        return new APInt(llvmJNI.APInt_set__SWIG_1(this.swigCPtr, this, l2), false);
    }

    public APInt clear() {
        return new APInt(llvmJNI.APInt_clear__SWIG_0(this.swigCPtr, this), false);
    }

    public APInt clear(long l2) {
        return new APInt(llvmJNI.APInt_clear__SWIG_1(this.swigCPtr, this, l2), false);
    }

    public APInt flip() {
        return new APInt(llvmJNI.APInt_flip__SWIG_0(this.swigCPtr, this), false);
    }

    public APInt flip(long l2) {
        return new APInt(llvmJNI.APInt_flip__SWIG_1(this.swigCPtr, this, l2), false);
    }

    public long getBitWidth() {
        return llvmJNI.APInt_getBitWidth(this.swigCPtr, this);
    }

    public long getNumWords() {
        return llvmJNI.APInt_getNumWords__SWIG_0(this.swigCPtr, this);
    }

    public static long getNumWords(long l2) {
        return llvmJNI.APInt_getNumWords__SWIG_1(l2);
    }

    public long getActiveBits() {
        return llvmJNI.APInt_getActiveBits(this.swigCPtr, this);
    }

    public long getActiveWords() {
        return llvmJNI.APInt_getActiveWords(this.swigCPtr, this);
    }

    public long getMinSignedBits() {
        return llvmJNI.APInt_getMinSignedBits(this.swigCPtr, this);
    }

    public BigInteger getZExtValue() {
        return llvmJNI.APInt_getZExtValue(this.swigCPtr, this);
    }

    public long getSExtValue() {
        return llvmJNI.APInt_getSExtValue(this.swigCPtr, this);
    }

    public static long getBitsNeeded(StringRef stringRef, short s2) {
        return llvmJNI.APInt_getBitsNeeded(StringRef.getCPtr(stringRef), stringRef, s2);
    }

    public long countLeadingZeros() {
        return llvmJNI.APInt_countLeadingZeros(this.swigCPtr, this);
    }

    public long countLeadingOnes() {
        return llvmJNI.APInt_countLeadingOnes(this.swigCPtr, this);
    }

    public long countTrailingZeros() {
        return llvmJNI.APInt_countTrailingZeros(this.swigCPtr, this);
    }

    public long countTrailingOnes() {
        return llvmJNI.APInt_countTrailingOnes(this.swigCPtr, this);
    }

    public long countPopulation() {
        return llvmJNI.APInt_countPopulation(this.swigCPtr, this);
    }

    public void print(raw_ostream raw_ostream2, boolean bl2) {
        llvmJNI.APInt_print(this.swigCPtr, this, raw_ostream.getCPtr(raw_ostream2), raw_ostream2, bl2);
    }

    public void toString(SWIGTYPE_p_llvm__SmallVectorImplT_char_t sWIGTYPE_p_llvm__SmallVectorImplT_char_t, long l2, boolean bl2) {
        llvmJNI.APInt_toString__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_llvm__SmallVectorImplT_char_t.getCPtr(sWIGTYPE_p_llvm__SmallVectorImplT_char_t), l2, bl2);
    }

    public void toStringUnsigned(SWIGTYPE_p_llvm__SmallVectorImplT_char_t sWIGTYPE_p_llvm__SmallVectorImplT_char_t, long l2) {
        llvmJNI.APInt_toStringUnsigned__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_llvm__SmallVectorImplT_char_t.getCPtr(sWIGTYPE_p_llvm__SmallVectorImplT_char_t), l2);
    }

    public void toStringUnsigned(SWIGTYPE_p_llvm__SmallVectorImplT_char_t sWIGTYPE_p_llvm__SmallVectorImplT_char_t) {
        llvmJNI.APInt_toStringUnsigned__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_llvm__SmallVectorImplT_char_t.getCPtr(sWIGTYPE_p_llvm__SmallVectorImplT_char_t));
    }

    public void toStringSigned(SWIGTYPE_p_llvm__SmallVectorImplT_char_t sWIGTYPE_p_llvm__SmallVectorImplT_char_t, long l2) {
        llvmJNI.APInt_toStringSigned__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_llvm__SmallVectorImplT_char_t.getCPtr(sWIGTYPE_p_llvm__SmallVectorImplT_char_t), l2);
    }

    public void toStringSigned(SWIGTYPE_p_llvm__SmallVectorImplT_char_t sWIGTYPE_p_llvm__SmallVectorImplT_char_t) {
        llvmJNI.APInt_toStringSigned__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_llvm__SmallVectorImplT_char_t.getCPtr(sWIGTYPE_p_llvm__SmallVectorImplT_char_t));
    }

    public String toString(long l2, boolean bl2) {
        return llvmJNI.APInt_toString__SWIG_1(this.swigCPtr, this, l2, bl2);
    }

    public APInt byteSwap() {
        return new APInt(llvmJNI.APInt_byteSwap(this.swigCPtr, this), true);
    }

    public double roundToDouble(boolean bl2) {
        return llvmJNI.APInt_roundToDouble__SWIG_0(this.swigCPtr, this, bl2);
    }

    public double roundToDouble() {
        return llvmJNI.APInt_roundToDouble__SWIG_1(this.swigCPtr, this);
    }

    public double signedRoundToDouble() {
        return llvmJNI.APInt_signedRoundToDouble(this.swigCPtr, this);
    }

    public double bitsToDouble() {
        return llvmJNI.APInt_bitsToDouble(this.swigCPtr, this);
    }

    public float bitsToFloat() {
        return llvmJNI.APInt_bitsToFloat(this.swigCPtr, this);
    }

    public APInt doubleToBits(double d2) {
        return new APInt(llvmJNI.APInt_doubleToBits(this.swigCPtr, this, d2), false);
    }

    public APInt floatToBits(float f2) {
        return new APInt(llvmJNI.APInt_floatToBits(this.swigCPtr, this, f2), false);
    }

    public long logBase2() {
        return llvmJNI.APInt_logBase2(this.swigCPtr, this);
    }

    public long ceilLogBase2() {
        return llvmJNI.APInt_ceilLogBase2(this.swigCPtr, this);
    }

    public int exactLogBase2() {
        return llvmJNI.APInt_exactLogBase2(this.swigCPtr, this);
    }

    public APInt sqrt() {
        return new APInt(llvmJNI.APInt_sqrt(this.swigCPtr, this), true);
    }

    public APInt abs() {
        return new APInt(llvmJNI.APInt_abs(this.swigCPtr, this), true);
    }

    public APInt multiplicativeInverse(APInt aPInt) {
        return new APInt(llvmJNI.APInt_multiplicativeInverse(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt), true);
    }

    public SWIGTYPE_p_llvm__APInt__ms magic() {
        return new SWIGTYPE_p_llvm__APInt__ms(llvmJNI.APInt_magic(this.swigCPtr, this), true);
    }

    public SWIGTYPE_p_llvm__APInt__mu magicu() {
        return new SWIGTYPE_p_llvm__APInt__mu(llvmJNI.APInt_magicu(this.swigCPtr, this), true);
    }

    public static void tcSet(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, BigInteger bigInteger, long l2) {
        llvmJNI.APInt_tcSet(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), bigInteger, l2);
    }

    public static void tcAssign(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long2, long l2) {
        llvmJNI.APInt_tcAssign(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long2), l2);
    }

    public static boolean tcIsZero(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, long l2) {
        return llvmJNI.APInt_tcIsZero(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), l2);
    }

    public static int tcExtractBit(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, long l2) {
        return llvmJNI.APInt_tcExtractBit(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), l2);
    }

    public static void tcExtract(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, long l2, SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long2, long l3, long l4) {
        llvmJNI.APInt_tcExtract(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), l2, SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long2), l3, l4);
    }

    public static void tcSetBit(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, long l2) {
        llvmJNI.APInt_tcSetBit(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), l2);
    }

    public static void tcClearBit(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, long l2) {
        llvmJNI.APInt_tcClearBit(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), l2);
    }

    public static long tcLSB(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, long l2) {
        return llvmJNI.APInt_tcLSB(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), l2);
    }

    public static long tcMSB(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, long l2) {
        return llvmJNI.APInt_tcMSB(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), l2);
    }

    public static void tcNegate(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, long l2) {
        llvmJNI.APInt_tcNegate(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), l2);
    }

    public static BigInteger tcAdd(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long2, BigInteger bigInteger, long l2) {
        return llvmJNI.APInt_tcAdd(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long2), bigInteger, l2);
    }

    public static BigInteger tcSubtract(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long2, BigInteger bigInteger, long l2) {
        return llvmJNI.APInt_tcSubtract(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long2), bigInteger, l2);
    }

    public static int tcMultiplyPart(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long2, BigInteger bigInteger, BigInteger bigInteger2, long l2, long l3, boolean bl2) {
        return llvmJNI.APInt_tcMultiplyPart(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long2), bigInteger, bigInteger2, l2, l3, bl2);
    }

    public static int tcMultiply(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long2, SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long3, long l2) {
        return llvmJNI.APInt_tcMultiply(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long2), SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long3), l2);
    }

    public static long tcFullMultiply(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long2, SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long3, long l2, long l3) {
        return llvmJNI.APInt_tcFullMultiply(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long2), SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long3), l2, l3);
    }

    public static int tcDivide(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long2, SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long3, SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long4, long l2) {
        return llvmJNI.APInt_tcDivide(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long2), SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long3), SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long4), l2);
    }

    public static void tcShiftLeft(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, long l2, long l3) {
        llvmJNI.APInt_tcShiftLeft(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), l2, l3);
    }

    public static void tcShiftRight(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, long l2, long l3) {
        llvmJNI.APInt_tcShiftRight(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), l2, l3);
    }

    public static void tcAnd(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long2, long l2) {
        llvmJNI.APInt_tcAnd(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long2), l2);
    }

    public static void tcOr(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long2, long l2) {
        llvmJNI.APInt_tcOr(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long2), l2);
    }

    public static void tcXor(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long2, long l2) {
        llvmJNI.APInt_tcXor(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long2), l2);
    }

    public static void tcComplement(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, long l2) {
        llvmJNI.APInt_tcComplement(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), l2);
    }

    public static int tcCompare(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long2, long l2) {
        return llvmJNI.APInt_tcCompare(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long2), l2);
    }

    public static BigInteger tcIncrement(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, long l2) {
        return llvmJNI.APInt_tcIncrement(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), l2);
    }

    public static void tcSetLeastSignificantBits(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, long l2, long l3) {
        llvmJNI.APInt_tcSetLeastSignificantBits(SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), l2, l3);
    }

    public void dump() {
        llvmJNI.APInt_dump(this.swigCPtr, this);
    }
}

