/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.ExtensionAttribute;
import java.io.Serializable;
import java.util.Vector;

public class ExtensionAttributes
implements Cloneable,
Serializable {
    private Vector a = new Vector();
    protected int special;
    protected ASN1Template asn1Template = null;

    public ExtensionAttributes(byte[] byArray, int n2, int n3) throws NameException {
        this.special = n3;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(n3, 12544, new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            int n4 = ofContainer.getContainerCount();
            for (int i2 = 0; i2 < n4; ++i2) {
                ASN1Container aSN1Container = ofContainer.containerAt(i2);
                this.a.addElement(new ExtensionAttribute(aSN1Container.data, aSN1Container.dataOffset, 0));
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of ExtensionAttributes.");
        }
    }

    public ExtensionAttributes() {
    }

    public void addAttribute(ExtensionAttribute extensionAttribute) {
        if (extensionAttribute != null) {
            this.a.addElement(extensionAttribute);
        }
    }

    public ExtensionAttribute getAttribute(int n2) throws NameException {
        if (n2 >= this.a.size()) {
            throw new NameException(" Invalid index ");
        }
        return (ExtensionAttribute)this.a.elementAt(n2);
    }

    public int getAttributeCount() {
        return this.a.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.a.size() - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(((ExtensionAttribute)this.a.elementAt(i2)).toString());
            stringBuffer.append(",");
        }
        stringBuffer.append(((ExtensionAttribute)this.a.elementAt(n2)).toString());
        return stringBuffer.toString();
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n2] == 0 && byArray[n2 + 1] == 0) {
            return n2 + 2;
        }
        try {
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n2) throws NameException {
        this.special = n2;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            if (this.asn1Template == null || n3 != this.special) {
                this.getDERLen(n3);
            }
            int n4 = this.asn1Template.derEncode(byArray, n2);
            this.asn1Template = null;
            return n4;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Unable to encode ExtensionAttributes");
        }
    }

    private int a() {
        if (this.asn1Template != null && this.special == this.special) {
            return 0;
        }
        try {
            Vector<OfContainer> vector = new Vector<OfContainer>();
            OfContainer ofContainer = new OfContainer(this.special, true, 0, 12544, new EncodedContainer(12288));
            vector.addElement(ofContainer);
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                byte[] byArray = new byte[((ExtensionAttribute)this.a.elementAt(i2)).getDERLen(0)];
                int n2 = ((ExtensionAttribute)this.a.elementAt(i2)).getDEREncoding(byArray, 0, 0);
                EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, n2);
                ofContainer.addContainer(encodedContainer);
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            this.asn1Template = new ASN1Template((ASN1Container[])objectArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ExtensionAttributes)) {
            return false;
        }
        ExtensionAttributes extensionAttributes = (ExtensionAttributes)object;
        if (this.a.size() != extensionAttributes.a.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            if (((ExtensionAttribute)this.a.elementAt(i2)).equals((ExtensionAttribute)extensionAttributes.a.elementAt(i2))) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        ExtensionAttributes extensionAttributes = new ExtensionAttributes();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            extensionAttributes.a.addElement(this.a.elementAt(i2));
        }
        extensionAttributes.special = this.special;
        if (this.asn1Template != null) {
            extensionAttributes.a();
        }
        return extensionAttributes;
    }
}

