/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.apk;

import com.adobe.air.Listener;
import com.adobe.air.Message;
import com.adobe.air.apk.OrderManifestHandler;
import com.adobe.air.apk.OutputHandler;
import com.adobe.air.apk.StringPoolHandler;
import java.io.File;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class AndroidManifestXMLParser {
    static String mInputFilePath;
    static String mPackageName;
    static String mAppName;
    static String mOutputFilePath;
    static String mOrderedFilePath;
    static String mAppVersionCode;
    static String mAppVersionName;

    public String createBinary(String inputFile, String packageName, String applicationName, int applicationVersionCode, String applicationVersionName, Listener listener, String descriptorFileName) {
        mInputFilePath = inputFile;
        mPackageName = packageName;
        mAppName = applicationName;
        mOutputFilePath = mInputFilePath + "bin";
        mOrderedFilePath = mInputFilePath + "ordered";
        mAppVersionCode = Integer.toString(applicationVersionCode);
        mAppVersionName = applicationVersionName.equals("") ? mAppVersionCode : applicationVersionName;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            OutputHandler outputHandler = new OutputHandler(listener, descriptorFileName);
            StringPoolHandler stringPoolHandler = new StringPoolHandler();
            OrderManifestHandler orderManifestHandler = new OrderManifestHandler(listener, descriptorFileName);
            parser.parse(new File(mInputFilePath), (DefaultHandler)orderManifestHandler);
            parser.parse(new File(mOrderedFilePath), (DefaultHandler)stringPoolHandler);
            parser.parse(new File(mOrderedFilePath), (DefaultHandler)outputHandler);
            return mOutputFilePath;
        }
        catch (Exception ex) {
            listener.message(new Message(100, "ERROR", descriptorFileName, -1, -1, null));
            return null;
        }
    }
}

