/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.apk;

import com.adobe.pki.Base64;
import com.adobe.ucf.CodeSigner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

public class APKSigner
extends CodeSigner {
    private Manifest m_manifest;
    private PrivateKey m_signingKey;
    private X509Certificate m_signingCert;
    private Signature m_signature;
    private static final String DIGEST_ALGORITHM = "SHA1";
    private static final String DIGEST_ATTR = "SHA1-Digest";
    private static final String DIGEST_MANIFEST_ATTR = "SHA1-Digest-Manifest";
    private static final String PATH_MANIFEST_MF = "META-INF/MANIFEST.MF";
    private static final String PATH_CERT_SF = "META-INF/CERT.SF";
    private static final String PATH_CERT = "META-INF/CERT.";
    private static final String MANIFEST_VERSION_NAME = Attributes.Name.MANIFEST_VERSION.toString();
    private static final String MANIFEST_VERSION_VALUE = "1.0";
    private static final String CREATED_BY_NAME = "Created-By";
    private static final String CREATED_BY_VALUE = "1.0 (Android)";
    private static final String SIGNATURE_VERSION_NAME = "Signature-Version";
    private static final String SIGNATURE_VERSION_VALUE = "1.0";

    public APKSigner() {
        block2: {
            this.m_manifest = null;
            this.m_signingKey = null;
            this.m_signingCert = null;
            this.m_signature = null;
            this.m_manifest = new Manifest();
            Attributes main2 = this.m_manifest.getMainAttributes();
            main2.putValue(MANIFEST_VERSION_NAME, "1.0");
            main2.putValue(CREATED_BY_NAME, CREATED_BY_VALUE);
            try {
                this.m_sharedDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
            }
            catch (NoSuchAlgorithmException e2) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void addFileDigestToManifest(byte[] digest, String path) {
        Attributes attr = new Attributes();
        this.m_manifest.getEntries().put(path, attr);
        attr.putValue(DIGEST_ATTR, Base64.encodeBytes(digest));
    }

    public String getSignatureXML() throws GeneralSecurityException, IOException {
        return null;
    }

    public void setCertificateChain(Certificate[] certchain) throws CertificateException {
    }

    public void setPrivateKey(PrivateKey key) {
        this.m_signingKey = key;
    }

    public void setSignerCertificate(Certificate cert) throws CertificateException {
        this.m_signingCert = (X509Certificate)cert;
    }

    public void setTimestampURL(String url) {
    }

    public byte[] sign() throws InvalidKeyException, NoSuchAlgorithmException {
        return null;
    }

    private void initializeSignature() throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.m_signingKey == null) {
            throw new IllegalStateException("Private key must be set before signing manifest.");
        }
        this.m_signature = Signature.getInstance("SHA1with" + this.m_signingKey.getAlgorithm());
        this.m_signature.initSign(this.m_signingKey);
    }

    public String getManifestFilePath() {
        return PATH_MANIFEST_MF;
    }

    public String getSignedManifestFilePath() {
        return PATH_CERT_SF;
    }

    public String getSignatureBlockFilePath() {
        if (this.m_signingKey == null) {
            throw new IllegalStateException("Private key must be set for generating manifest name.");
        }
        return PATH_CERT + this.m_signingKey.getAlgorithm();
    }

    public byte[] getManifestFile() {
        ByteArrayOutputStream out;
        block2: {
            out = new ByteArrayOutputStream();
            try {
                this.m_manifest.write(out);
            }
            catch (IOException e2) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return out.toByteArray();
    }

    public byte[] getSignatureBlockFile() throws NoSuchAlgorithmException, InvalidKeyException {
        ByteArrayOutputStream out;
        block6: {
            if (this.m_signature == null) {
                this.initializeSignature();
            }
            if (this.m_signingKey == null) {
                throw new IllegalStateException("Certificate must be set before signing manifest.");
            }
            out = new ByteArrayOutputStream();
            try {
                X500Name setStraightName = new X500Name(this.m_signingCert.getIssuerX500Principal().getName());
                BigInteger signingCertificateSerial = this.m_signingCert.getSerialNumber();
                SignerInfo signerInfo = new SignerInfo(setStraightName, signingCertificateSerial, AlgorithmId.get(DIGEST_ALGORITHM), AlgorithmId.get(this.m_signingKey.getAlgorithm()), this.m_signature.sign());
                X509Certificate[] signingCerts = new X509Certificate[]{this.m_signingCert};
                SignerInfo[] signerInfos = new SignerInfo[]{signerInfo};
                ContentInfo noContent = new ContentInfo(ContentInfo.DATA_OID, null);
                AlgorithmId[] algorithmIds = new AlgorithmId[]{AlgorithmId.get(DIGEST_ALGORITHM)};
                PKCS7 pkcs7 = new PKCS7(algorithmIds, noContent, signingCerts, signerInfos);
                pkcs7.encodeSignedData(out);
            }
            catch (IOException e2) {
                assert (false);
            }
            catch (SignatureException e3) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        return out.toByteArray();
    }

    public byte[] getSignedManifestFile() throws NoSuchAlgorithmException, InvalidKeyException {
        ByteArrayOutputStream out;
        block7: {
            if (this.m_signature == null) {
                this.initializeSignature();
            }
            out = new ByteArrayOutputStream();
            Manifest signatureManifest = new Manifest();
            Attributes main2 = signatureManifest.getMainAttributes();
            main2.putValue(SIGNATURE_VERSION_NAME, "1.0");
            main2.putValue(CREATED_BY_NAME, CREATED_BY_VALUE);
            MessageDigest msgDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
            try {
                PrintStream print = new PrintStream((OutputStream)new DigestOutputStream(new ByteArrayOutputStream(), msgDigest), true, "UTF-8");
                this.m_manifest.write(print);
                print.flush();
                main2.putValue(DIGEST_MANIFEST_ATTR, Base64.encodeBytes(msgDigest.digest()));
                Map<String, Attributes> entries = this.m_manifest.getEntries();
                for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
                    print.print("Name: " + entry.getKey() + "\r\n");
                    for (Map.Entry<Object, Object> att : entry.getValue().entrySet()) {
                        print.print(att.getKey() + ": " + att.getValue() + "\r\n");
                    }
                    print.print("\r\n");
                    print.flush();
                    Attributes sfAttr = new Attributes();
                    sfAttr.putValue(DIGEST_ATTR, Base64.encodeBytes(msgDigest.digest()));
                    signatureManifest.getEntries().put(entry.getKey(), sfAttr);
                }
                signatureManifest.write(out);
                this.m_signature.update(out.toByteArray());
            }
            catch (IOException e2) {
                assert (false);
            }
            catch (SignatureException e3) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
        return out.toByteArray();
    }
}

