/***************************************************************************************
  KaffeineTY
  Copyright (c) 2014 Dat Phan Quang <ineedyou.lonely@gmail.com>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Cambridge, MA 02110-1301, USA.
*****************************************************************************************/

#include "controlmodule.moc"

//KDE
#include <KPluginFactory>

//Local
#include "config.h"
#include "ui_controlmodule.h"

K_PLUGIN_FACTORY(KaffeinetyModuleFactory, registerPlugin<Kaffeinety::ControlModule>();)
K_EXPORT_PLUGIN(KaffeinetyModuleFactory("kcmkaffeinety", "kaffeinety"))

namespace Kaffeinety {
ControlModule::ControlModule(QWidget* parent, const QVariantList& )
: KCModule(KaffeinetyModuleFactory::componentData(), parent)
, tyConfig(new Config)
, tyUi(new Ui::ControlModule)
{
  tyUi->setupUi(this);
  addConfig(tyConfig, this);
  connect(tyUi->parameter, SIGNAL(textChanged(QString)), this, SLOT(updateChange()));
  connect(tyUi->enable, SIGNAL(clicked(bool)), this, SLOT(updateChange()));
}

ControlModule::~ControlModule()
{
  delete tyConfig;
  delete tyUi;
}

void ControlModule::load()
{
    QString p = tyConfig->parameter();
    bool e = tyConfig->enable();
    tyUi->parameter->setText(p);
    tyUi->enable->setChecked(e);
    KCModule::load();
}

void ControlModule::save()
{
    tyConfig->setParameter(tyUi->parameter->text());
    tyConfig->setEnable(tyUi->enable->isChecked());
    tyConfig->writeConfig();
    KCModule::save();
}

void ControlModule::defaults()
{
    KCModule::defaults();
    QString p = tyConfig->defaultParameterValue();
    bool e = tyConfig->defaultEnableValue();
    tyUi->parameter->setText(p);
    tyUi->enable->setChecked(e);
    
}

void ControlModule::updateChange()
{
  QString p=tyUi->parameter->text();
  bool e = tyUi->enable->isChecked();
  unmanagedWidgetChangeState((p != tyConfig->parameter())||(e!=tyConfig->enable()));
}

}

