/***************************************************************************************
  KaffeineTY
  Copyright (c) 2013 Dat Phan Quang <ineedyou.lonely@gmail.com>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Cambridge, MA 02110-1301, USA.
*****************************************************************************************/

#include <cstdlib>
#include <stdio.h>
#include <KApplication>
#include <KAboutData>
#include <KCmdLineArgs>
#include <KMessageBox>
#include <KLocale>
#include <kuniqueapplication.h>
#include "kaffeinety.h"

int main (int argc, char *argv[])
{
    KAboutData aboutData(
                         // The program name used internally.
                         "KaffeineTY",
                         // The message catalog name
                         // If null, program name is used instead.
                         0,
                         // A displayable program name string.
                         ki18n("KaffeineTY"),
                         // The program version string.
                          "0.0.1",
                         // Short description of what the app does.
                         ki18n("Application to disable screensaver and powersaving features"),
                         // The license this code is released under
                         KAboutData::License_GPL,
                         // Copyright Statement
                         ki18n("(c) 2013 by Dat Phan Quang"),
                         // Optional text shown in the About box.
                         // Can contain any information desired.
                         ki18n("For TY birthday"),
                         // The program homepage string.
                         "http://yhanoi.com/forum/",
                         // The bug report email address
                         "ineedyou.lonely@gmail.com");
 
    KCmdLineArgs::init( argc, argv, &aboutData );
    if (!KUniqueApplication::start()) {
      fprintf(stderr, "KaffeineTY is already running!\n");
      return 0;
    }
    KUniqueApplication app;

    Kaffeinety::MainApp mainApp;
    
    
    return app.exec();
} 
