/***************************************************************************************
  KaffeineTY
  Copyright (c) 2014 Dat Phan Quang <ineedyou.lonely@gmail.com>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Cambridge, MA 02110-1301, USA.
*****************************************************************************************/

#ifndef KAFFEINETY_H
#define KAFFEINETY_H
//Qt
#include <QObject>
#include <QStringList>
#include <QString>
#include <QTimer>
//KDE
#include <ksysguard/process.h>
#include <ksysguard/processes.h>
#include <Solid/PowerManagement>

namespace Kaffeinety
{
  class Config;
  class MainApp: public QObject
  {
    Q_OBJECT
  public:
    MainApp();
    ~MainApp();
  private:
    KSysGuard::Processes *p;
    Config* tyConfig;
    QTimer* tyTimer;
    int cookie1, cookie2;
    bool enable, activated;
    void getActiveProcess();
    void toogle();
    bool isProcessRunning(QString proc);
    void getBatteryStatus();
    bool isLowBattery;
    QStringList getParameter();
  private slots:
    void check();
    void updateBatteryChargePercent(int newValue, const QString& udi);
  };
}
#endif