/***************************************************************************************
  KaffeineTY
  Copyright (c) 2014 Dat Phan Quang <ineedyou.lonely@gmail.com>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Cambridge, MA 02110-1301, USA.
*****************************************************************************************/

#include "kaffeinety.h"
#include <config.h>
#include <Solid/Battery>
#include <Solid/Device>
#include <QDebug>
namespace Kaffeinety
{
MainApp::MainApp()
    : tyConfig(new Config)
    , cookie1(-1)
    , cookie2(-1)
    , activated(false)
    , isLowBattery(false)
{
    tyTimer = new QTimer(this);
    p = new KSysGuard::Processes();
    tyConfig->readConfig();
    enable = tyConfig->enable();
    connect(tyTimer, SIGNAL(timeout()), this, SLOT(check()));
    getBatteryStatus();
    tyTimer->setInterval(25000);
    tyTimer->start();
}

MainApp::~MainApp()
{
    toogle();
    delete p;
    delete tyConfig;
    delete tyTimer;
}

void MainApp::getActiveProcess()
{
    QString str;
    QList<KSysGuard::Process*> listProc;
    bool s = false;
    tyConfig->readConfig();
    enable = tyConfig->enable();
    
    if (!enable || isLowBattery) {
      toogle();
      return;
    }
    p->updateAllProcesses();
    listProc = p->getAllProcesses();
    foreach (KSysGuard::Process* p, listProc)
    {
        if (isProcessRunning(p->name))
        {
            s = true;
            if (!activated)
                toogle();
	    break;
        }
    }
    if (!s && activated)
        toogle();

}

QStringList MainApp::getParameter()
{
    tyConfig->readConfig();
    QString param=tyConfig->parameter(); //user input parameter
    QStringList list = param.split("|");
    return list;
}

bool MainApp::isProcessRunning(QString proc)
{
    QStringList l = getParameter();
    if (l.contains(proc))
        return true;
    return false;
}

void MainApp::toogle()
{
   
    if (!activated)
    {
       
        cookie1 = Solid::PowerManagement::beginSuppressingScreenPowerManagement("KaffeineTY has enabled system-wide inhibition");
        cookie2 = Solid::PowerManagement::beginSuppressingSleep("KaffeineTY has enabled system-wide inhibition");
        activated = true;
    }
    else {
    
        Solid::PowerManagement::stopSuppressingScreenPowerManagement(cookie1);
        Solid::PowerManagement::stopSuppressingSleep(cookie2);
        cookie1 = cookie2 = -1;
        activated = false;
    }

}

void MainApp::check()
{
    getActiveProcess();
}

void MainApp::getBatteryStatus()
{
    const QList<Solid::Device> listBattery = Solid::Device::listFromType(Solid::DeviceInterface::Battery);
    if (listBattery.isEmpty()) {
        isLowBattery = false;
        return;
    }
    foreach (const Solid::Device &deviceBattery, listBattery) {
        const Solid::Battery* battery = deviceBattery.as<Solid::Battery>();

        connect(battery, SIGNAL(chargePercentChanged(int,QString)), this,
                SLOT(updateBatteryChargePercent(int,QString)));

        // Set initial value
        updateBatteryChargePercent(battery->chargePercent(), deviceBattery.udi());
    }
}

void MainApp::updateBatteryChargePercent(int newValue, const QString& udi)
{
  //qDebug()<<newValue;
  if (newValue < 10) isLowBattery = true;
  else isLowBattery = false;
}

}
