#
#-*- coding: UTF-8 -*- 
#
# The Python script
#
# setup.py for gnuConcept
#
#
#-------------------------------------------------------------------------------
VERSION = '0.39.1'
NAME = 'itmages-service'
AUTHOR = 'Khramtsov Vladimir'
AUTHOR_EMAIL = 'harestomper@gmail.com'
URL = 'https://code.launchpad.net/~itmages/itmages/itmages-service'
long_desc = 'ITmages service is a service that runs all the time in the system, and \
 service requests on bus DBus, offering to work with image hosting ITmages. \
 Using ITmages service you no longer need to write a uploader, and deal with a hosting API. Just use DBus.'

#-------------------------------------------------------------------------------
import os
import sys
from glob import glob
from distutils.core import setup
from distutils.command import bdist_rpm as _bdistrpm
#-------------------------------------------------------------------------------


#-------------------------------------------------------------------------------
# Correction for PyVersion in py scripts
try:
    major = sys.version_info.major
    minor = sys.version_info.minor
except AttributeError:
    major = sys.version_info[0]
    minor = sys.version_info[1]

pyver = "%s.%s" % (major, minor)
commandline1 = """sed -i 's#\#\!/usr/bin/python.*#\#\!/usr/bin/python%s#' %s"""
commandline2 = """sed -i 's#(Python, rev .*)#(Python, rev %s)#' %s"""
commandline3 = """sed -i 's#define version .*#define version %s#' %s"""
commandline4 = """sed -i 's#define unmangled_version .*#define unmangled_version %s#' %s"""
commandline5 = """sed -i 's/py[0-9].[0-9]/py%s/' %s"""

try:
    pwd = os.environ["PWD"]
except KeyError:
    pwd = os.path.abspath(".")

for fname in glob("*") + glob("*/*") + glob("*/*/*"):
    if "setup.py" in fname:
        continue
    if fname.startswith(".") or fname.endswith((".pyc", ".pyo", ".png")):
        continue
    fname = os.path.join(pwd, fname)

    if os.path.isfile(fname):
        os.system(commandline1 % (pyver, fname))
        os.system(commandline2 % (VERSION, fname))
        os.system(commandline3 % (VERSION, fname))
        os.system(commandline4 % (VERSION, fname))
        os.system(commandline5 % (pyver, fname))
#-------------------------------------------------------------------------------

class bdist_rpm(_bdistrpm.bdist_rpm):

    def _make_spec_file(self):
        l = [line.replace('\n', '') for line in file('data/itmages-service.spec', 'r')]
        return l
#-------------------------------------------------------------------------------


setup(  
        name = NAME,
        version = VERSION,
        author = AUTHOR,
        author_email = AUTHOR_EMAIL,
        description = long_desc,
        long_description = long_desc,
        url = URL,
        license = "GNU General Public License (GPL)",

        classifiers = ['Development Status :: 5 - Production/Alpha',
                       'Environment :: Console',
                       'Natural Language :: English',
                       'Natural Language :: Russian',
                       'Operating System :: POSIX :: Linux',
                       'Programming Language :: Python :: 2.7',
                       'Topic :: Communications :: Email',
                      ],

        packages = ['itmagesd', "itmagesd"],

        data_files = [
                        ('share/itmages',  ['data/testwindow.ui',]),
                        ("share/doc/itmages/example", ["data/dbustestwin.py_",]),
                        ('share/applications', ['data/itmagesd.desktop',]),
                        ("share/dbus-1/services",
                            ["data/org.freedesktop.ITmagesEngine.service",])
                     ],

        scripts =  ['scripts/itmagesd',],

        cmdclass = {
                    'bdist_rpm': bdist_rpm,
                    }
    )
