#
# -*- coding: utf-8 -*-
#
#       Copyright 2011 Voldemar Khramtsov <harestomper@gmail.com>
#       
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#       
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#       
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.

import types
import pycurl
import threading

from itmagesd.tools import *
from itmagesd.common import ActionType


try:
    import cStringIO as StringIO
    stringio_type = StringIO.OutputType
except ImportError:
    import StringIO
    stringio_type = StringIO.StringIO

TRUE = 1
FALSE = 0
RESPMSG = '<response><status>failed</status><reason>%s</reason></response>'

UPLOAD = 0
DOWNLOD = 1
LOGIN = 2
LOGOUT = 3
CKLOGIN = 4
CKCONNECT = 5
DELETE = 6
GETPICTURES = 7
QUITING = 8
START = 9
SHORT = 10

HOMEDIR = os.path.join(os.environ['HOME'], '.itmages')
COOKIEDIR = os.path.join(HOMEDIR, 'cookies')
COOKIES = os.path.join(HOMEDIR, 'cookies', '%s@itmages')
LOADPATH = os.path.join(HOMEDIR, 'download')

USERAGENT = 'User-Agent: ITmages upload service (Python, rev 0.27)'
LINKPROTO = 'http://itmages.ru/api/%s'


class Interface(object):

    def __init__(self, name):
        self.quiting = False
        self.cancel = False
        self.activeurl = None
        self.action = None

        self.name = name or os.path.basename(tempfile.mktemp())
        self.useragent = USERAGENT
        self.tempcookies = tempfile.mktemp('@cookie')
        self.verbose = False 
        self.activeurl = None
        self.proxyport = None
        self.proxynode = None
        self.proxyuser = None
        self.proxypass = None
        self.proxytype = None
        self.password = None
        self.username = None
        self.addition = None
        self.cookiedir = COOKIEDIR
        self.cookies = ""
        self.sufix = 'itmages'
        self.httppost = None
        self.postfields = None
        self.key = None
        self.id = None


    def set_action(self, action):
        url = None
        key = None

        if action in ('logout', LOGOUT):
            action, key = LOGOUT, 'logout'
        elif action in ('check', CKLOGIN):
            action, key = CKLOGIN, 'check'
        elif action in ('add', 'upload', UPLOAD):
            action, key = UPLOAD, 'add'
        elif action in ('login', 'auth', LOGIN):
            action, key = LOGIN, 'login'
        elif action in ('exit', '**exit**', QUITING, 'quit'):
            action = QUITING
        elif action in ('checkconnect', 'connect', CKCONNECT, "check_connection"):
            action = CKCONNECT
        elif action in ('getpictures', 'getinfo', 'getlist', GETPICTURES):
            action = GETPICTURES
            key = 'getpictures'
        elif action in ('delete', 'remove', 'del', DELETE):
            action = DELETE
            key = 'delete'
        elif action in ("short", SHORT, "getshort"):
            action, key = SHORT, "short"

        if action in (UPLOAD,
                      LOGIN,
                      LOGOUT,
                      CKLOGIN,
                      CKCONNECT,
                      DELETE,
                      QUITING,
                      START,
                      GETPICTURES,
                      SHORT)\
                      and isinstance(action, types.IntType):

            self.activeurl = key and LINKPROTO % key or 'http://itmages.ru'
            self.action = action
            return True
        else:
            return False


        
    def set_default(self, **kw):
        self.useragent = kw.get('useragent') or USERAGENT
        self.verbose = kw.get('verbose') in (True, 1)
        self.activeurl = kw.get('url') or self.activeurl
        filename = kw.get('filename')
        self.addition = kw.get('addition') or filename
        self.cookiedir = COOKIEDIR
        self.proxyport = kw.get('proxyport')
        self.proxynode = kw.get('proxynode')
        self.proxyuser = kw.get('proxyuser')
        self.proxypass = kw.get('proxypass')
        self.proxytype = kw.get('proxytype')
        self.password = kw.get('passwd')
        self.username = kw.get('user')
        self.key = kw.get('key')
        self.id = kw.get('id')
        self.sufix = 'itmages'
        self.httppost = None

        if filename:
            fp = urllib.urlopen(filename)
            mime = fp.info().type
            norm_name = str(filename.strip())
            lower = norm_name.lower()

            if not lower.endswith(('.jpeg', '.jpg', '.gif', '.png')):
                format = mime.split('/')[1]
                norm_name = norm_name + '.%s' % format

            self.httppost = [('xmldata', 'requested'),
                      ('UFileManager[picture]', os.path.basename(norm_name)),
                      ('UFileManager[picture]', (pycurl.FORM_FILE, str(filename),
                       pycurl.FORM_CONTENTTYPE, mime, pycurl.FORM_FILENAME,
                       os.path.basename(norm_name)))]

        if None in (self.username, self.password):
            postfields = {}
            if self.action in (LOGIN, GETPICTURES, CKLOGIN, LOGOUT, DELETE):
                raise ValueError, "This action is required username and password"
        else:
            postfields = {'name': self.username, 'passwd': self.password}
            
        self.postfields = kw.get('postfields') or postfields

        if self.action == DELETE and None in (self.key, self.id):
            raise ValueError, "Action 'delete' required key and id"
        else:
            self.postfields['id'] = self.id
            self.postfields['key'] = self.key


    def _set_proxy(self, curl):
        if self.proxytype is not None:
            curl.setopt(pycurl.PROXYTYPE, self.proxytype)

            if self.proxyport and self.proxynode:
                proxy = '%s:%s' % (self.proxynode, self.proxyport)
                curl.setopt(pycurl.PROXY, proxy)

                if self.proxyuser and self.proxypass:
                    userpwd = '%s:%s' % (self.proxyuser, self.proxypass)
                    curl.setopt(pycurl.PROXYUSERPWD, userpwd)


    def set_options(self, curl):
        self._set_proxy(curl)


        if self.username and self.cookiedir:
            self.cookies = os.path.join(self.cookiedir, '%s@%s' % (self.username, self.sufix))
        else:
            self.cookies = self.tempcookies

        if self.cookies and not os.path.exists(os.path.dirname(self.cookies)):
            try:
                os.makedirs(os.path.dirname(self.cookies))
            except (IOError, OSError):
                sys.stderr.write('ERROR: Folder "%s" is not by created' % \
                                 os.path.dirname(self.cookies))

        if self.action == CKCONNECT:
            curl.setopt(pycurl.CONNECT_ONLY, TRUE)

        if (self.httppost or self.postfields) and self.action != CKCONNECT:
            curl.setopt(pycurl.POST, TRUE)

            if self.httppost and self.action == UPLOAD:
                curl.setopt(pycurl.HTTPPOST, self.httppost)

            elif self.postfields \
                and self.action in (SHORT, LOGIN, CKLOGIN, LOGOUT, GETPICTURES, DELETE):
                curl.setopt(pycurl.POSTFIELDS, urllib.urlencode(self.postfields))


    def start(self, *args):
        threading.Thread(target=self.execute).start()


    def execute(self, *args):
        sock = find_alive_socket(self.name)
        self.__iomod_msg = sock

        conn = pycurl.Curl()
        self.set_options(conn)
        writable = StringIO.StringIO()
        conn.setopt(pycurl.VERBOSE, TRUE)
        conn.setopt(pycurl.NOSIGNAL, TRUE)
        conn.setopt(pycurl.NOPROGRESS, FALSE)
        conn.setopt(pycurl.URL, self.activeurl)
        conn.setopt(pycurl.USERAGENT, self.useragent)
        conn.setopt(pycurl.WRITEFUNCTION, writable.write)
        conn.setopt(pycurl.COOKIEJAR, str(self.cookies))
        conn.setopt(pycurl.COOKIEFILE, str(self.cookies))
        conn.setopt(pycurl.DEBUGFUNCTION, self.__debugfunction)
        conn.setopt(pycurl.PROGRESSFUNCTION, self.__progress_func)

        try:
            conn.perform()

        except pycurl.error, e:
            msg = RESPMSG % e[1]
            code = e[0]
            writable.write(msg)

        else:
            code = conn.getinfo(pycurl.RESPONSE_CODE)

        finally:
            conn.close()
            response = writable.getvalue()
            msg = message_dump(
                                ActionType.IOMOD_RESPONSE,
                                code = code,
                                data = response,
                                name = self.name,
                                action = self.action,
                                addition = self.addition,
                              )

            self.action = None
            try:
                self.__iomod_msg.send(msg)
                self.__iomod_msg.close()
            except Exception:
                pass

                    

    def __progress_func(self, *args):
        dump = message_dump(
                              ActionType.IOMOD_PROGRESS,
                              dt = args[0],
                              dr = args[1],
                              ut = args[2],
                              ur = args[3],
                              name = self.name,
                              action = self.action,
                              addition = self.addition,
                            )
        try:
            self.__iomod_msg.send(dump)
        except socket.error, e:
            return 1
        else:
            return 0


    def __debugfunction(self, debug_type, debug_msg):
        if not self.verbose:
            return

        types = {pycurl.INFOTYPE_DATA_IN: 'Input data',
                 pycurl.INFOTYPE_DATA_OUT: 'Output data',
                 pycurl.INFOTYPE_HEADER_IN: 'Input header',
                 pycurl.INFOTYPE_HEADER_OUT: 'Output header',
                 pycurl.INFOTYPE_TEXT: 'Text',}
        debug_str = types.get(debug_type)

        try:
            unicode(debug_msg, 'utf-8')
        except UnicodeError:
            pass
        else:
            fd = file('/tmp/debug.curl', 'a')
            fd.write("debug(%s): %s \n" % (debug_str, str(debug_msg)))


#-------------------------------------------------------------------------------
###        
