#
# -*- coding: utf-8 -*-
#
#
import sys
import os
import time
import atexit
from signal import SIGTERM

class Daemon(object):

    def __init__(self, pidfile, stdin='/dev/null', stdout='/dev/null', stderr='/dev/null'):
        self.stdin = stdin
        self.stdout = stdout
        self.stderr = stderr
        self.pidfile = pidfile

    def daemonize(self):
        try:
            pid = os.fork()
            if pid > 0:
                sys.exit(0)
        except OSError, e:
            sys.stderr.write("fork #1 failed: %d (%s)\n" % (e.errno, e.strerror))
            sys.exit(1)

        os.chdir("/")
        os.setsid()
        os.umask(0)

        try:
            pid = os.fork()
            if pid > 0:
                sys.exit(0)
        except OSError, e:
            sys.stderr.write("fork #2 failed: %d (%s)\n" % (e.errno, e.strerror))
            sys.exit(1)

        sys.stdout.flush()
        sys.stderr.flush()
        si = file(self.stdin, 'r')
        so = file(self.stdout, 'a+')
        se = file(self.stderr, 'a+', 0)
        os.dup2(si.fileno(), sys.stdin.fileno())
        os.dup2(so.fileno(), sys.stdout.fileno())
        os.dup2(se.fileno(), sys.stderr.fileno())

        atexit.register(self.delpid)
        pid = str(os.getpid())
        file(self.pidfile,'w+').write("%s\n" % pid)
        

    def delpid(self):
        os.remove(self.pidfile)


    def has_process(self):
        pid = self.get_pid()
        if pid:
            if os.path.exists('/proc/%s' % pid):
                return True
            else:
                self.delpid()
        return False
        

    def get_pid(self):
        try:
            pf = file(self.pidfile,'r')
            pid = int(pf.read().strip())
            pf.close()
        except (ValueError, IOError):
            pid = None

        return pid


    def start(self):
        if not self.has_process():
            self.daemonize()
            self.run()
            return True
        else:
            return False
                


    def status(self):
        pid = self.get_pid()
        if self.has_process():
            message = "Daemon is running. PID = %s\n"
            sys.stdout.write(message % pid)
            return True
#            sys.exit(0)
        else:
            message = "Daemon is not running\n"
            sys.stdout.write(message)
            return False
#            sys.exit(1)


    def stop(self):
        pid = self.get_pid()
        message = "Stoping daemon %s \t\t\t\t\t "
        sys.stdout.write(message % (pid and 'with PID = %s' % pid or ''))

        if self.has_process():
            try:
                while 1:
                    os.kill(pid, SIGTERM)
                    time.sleep(0.1)
            except OSError, err:
                err = str(err)

        if self.has_process() or not pid:
            sys.stdout.write('[FAIL]\n')
#            sys.exit(1)
        else:
            sys.stdout.write('[ OK ]\n')
#            sys.exit(0)


    def restart(self):
        self.stop()
        self.start()


    def run(self):
        pass
