#
# -*- coding: utf-8 -*-
#       
#       Copyright 2011 Voldemar Khramtsov <harestomper@gmail.com>
#       
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#       
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#       
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.

#-------------------------------------------------------------------------------
import os
import glib
import tempfile


class stat:
    cancel_all = False
    quiting = False
    temporary = []
    pause = False
    verbose = True
    isdaemon = False


DBUS_INTERFACE = 'org.freedesktop.ITmagesEngine'
DBUS_PATH = '/org/freedesktop/ITmagesEngine'

MIMETYPES = ('image/jpeg', 'image/png', 'image/gif')
RESP_CANCELLED = '''<response><status>cancelled</status>separator<reason>Action cancelled</reason></response>'''

USERCONFIGDIR = os.path.join(glib.get_user_config_dir(), "itmagesd")
TEMPFOLDER = os.path.join(glib.get_user_cache_dir(), 'itmages', 'pictures')
tempfile.tempdir = TEMPFOLDER
stat.temporary.append(TEMPFOLDER)
SOCKNAME = tempfile.mktemp('.socket')
DAEMON_CONF = os.path.join(USERCONFIGDIR, "service.xml")

if not os.path.exists(TEMPFOLDER):
    os.makedirs(TEMPFOLDER)

if not os.path.exists(USERCONFIGDIR):
    os.makedirs(USERCONFIGDIR)

class Messages:
    UNSUPPORTED = "Is unsupported argument type."
    CAN_NOT_BE_PUT = "This file can not be put to queue."
    ITEM_EXISTS = "This file is already exists in queue."
    IMPOSSIBLE_METHOD = "Impossible for apply this specified method"
    ARGUMENTS_REQUIRES = "This action requires arguments 'user', 'passwd', 'key' and 'id'."
    USERDATA_REQUIRED = "Not found 'user' or 'passwd' keys. For this action its keys is required."

class ActionType:
    IOMOD_RESPONSE = "iomodresponse"
    IOMOD_PROGRESS = "iomodprogress"


def echo (message, output="o"):
    if stat.verbose:
        if output == "e":
            std = sys.stderr
        else:
            std = sys.stdout
        std.write("%s\n" % message)
###
