#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QSystemTrayIcon>
#include <QDate>
#include "ui_mainwindow.h"

class MainWindow : public QMainWindow, public Ui::MainWindow
{
    Q_OBJECT

    public:
        MainWindow(QWidget *parent = 0);
        bool findevents;
        bool portableapp;
        bool shownoevents;
        int eventscount;
        QString datafile;
        QDate prevdate;

    protected:
        void closeEvent(QCloseEvent *event);
        void timerEvent(QTimerEvent*);

    private slots:
        void SortDataFile();
        void GoSite();
        void LaunchEditor();
        void ShowAbout();
        void EventsSelectione();
        void iconActivated(QSystemTrayIcon::ActivationReason reason);

    private:
        QAction *quitAction;
        QAction *launchAction;
        QAction *sortAction;
        QAction *siteAction;
        QAction *aboutAction;
        QSystemTrayIcon *trayIcon;
        QMenu *trayIconMenu;

};

#endif // MAINWINDOW_H
