#include <QtGui>
#include <QDate>
#include <QString>
#include <QByteArray>
#include <QTextStream>
#include <QMessageBox>
#include <QDesktopServices>
#include <QProcess>

#include "mainwindow.h"

MainWindow::MainWindow(QWidget *parent) : QMainWindow(parent)
{
    setupUi(this);
    //****************** Create TrayIcon Menu ***************************************

    sortAction = new QAction(tr("&Sort events list"), this);
    sortAction->setIcon(QIcon(":ico/sort.png"));
    connect(sortAction, SIGNAL(triggered()), this, SLOT(SortDataFile()));

    launchAction = new QAction(tr("&Launch editor"), this);
    launchAction->setIcon(QIcon(":ico/edit.png"));
    connect(launchAction, SIGNAL(triggered()), this, SLOT(LaunchEditor()));

    siteAction = new QAction(tr("&Go to site"), this);
    siteAction->setIcon(QIcon(":ico/gosite.png"));
    connect(siteAction, SIGNAL(triggered()), this, SLOT(GoSite()));

    aboutAction = new QAction(tr("&About"), this);
    aboutAction->setIcon(QIcon(":ico/about.png"));
    connect(aboutAction, SIGNAL(triggered()), this, SLOT(ShowAbout()));

    quitAction = new QAction(tr("&Quit"), this);
    quitAction->setIcon(QIcon(":ico/quit.png"));
    connect(quitAction, SIGNAL(triggered()), qApp, SLOT(quit()));

    trayIconMenu = new QMenu(this);

    trayIconMenu->addAction(sortAction);
    trayIconMenu->addAction(launchAction);
    trayIconMenu->addAction(siteAction);
    trayIconMenu->addAction(aboutAction);
    trayIconMenu->addSeparator();
    trayIconMenu->addAction(quitAction);

    trayIcon = new QSystemTrayIcon(this);
    trayIcon->setContextMenu(trayIconMenu);

    //********************************************************************************

    connect(trayIcon, SIGNAL(activated(QSystemTrayIcon::ActivationReason)),
            this, SLOT(iconActivated(QSystemTrayIcon::ActivationReason)));

    trayIcon->setIcon(QIcon(":ico/normal.png"));
    trayIcon->show();

    //datafile = QDesktopServices::storageLocation(QDesktopServices::DocumentsLocation);
    datafile = qApp->applicationDirPath();
    datafile.append("/reminder.dat");
    QFile cf(datafile);
    if (!cf.exists())
    {
        datafile = QDesktopServices::storageLocation(QDesktopServices::HomeLocation);
        datafile.append("/.config/reminder.dat");
        QFile cf(datafile);
        if (!cf.exists())
        {
            QStringList list;
            list.append("03.03;День рождения разработчика hzs reminder;1983\n");
            list.append("04.10;Дата создания hzs reminder;2010\n");
            cf.open(QIODevice::WriteOnly | QIODevice::Truncate | QIODevice::Text);
            QTextStream out(&cf);
            for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it )
                out << *it;
            cf.close();
        }
        portableapp = false;
    }
    else
        portableapp = true;
    shownoevents = false;
    EventsSelectione();
    prevdate = QDate::currentDate();
    startTimer(60000 * 60);
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    if (trayIcon->isVisible()) {
        hide();
        event->ignore();
    }
}

void MainWindow::iconActivated(QSystemTrayIcon::ActivationReason reason)
{
    switch (reason)
    {
        case QSystemTrayIcon::Trigger:
        {
            EventsSelectione();
            break;
        }

        case QSystemTrayIcon::MiddleClick:
        {
            qApp->quit();
            break;
        }
     }
}

void MainWindow::SortDataFile()
{
    QFile cf(datafile);
    if (!cf.exists())
    {
        //trayIcon->showMessage(tr("Error sorting events"), tr("Data file 'reminder.dat' not found!\nCreate valid file 'reminder.dat' and restart programm"));
        QString kstr = "kdialog --title "; kstr.append('"');
        kstr.append(tr("Error sorting events"));
        kstr.append('"'); kstr.append(" --passivepopup "); kstr.append('"');
        kstr.append(tr("Data file 'reminder.dat' not found!\nCreate valid file 'reminder.dat' and restart programm"));
        kstr.append('"');
        int res = QProcess::execute ( kstr );
        if (res){
            trayIcon->showMessage(tr("Error sorting events"), tr("Data file 'reminder.dat' not found!\nCreate valid file 'reminder.dat' and restart programm"));
        }
    }
    else
    {
        QString line;
        QStringList list;
        cf.open(QIODevice::ReadOnly);
        while (!cf.atEnd())
        {
            line = cf.readLine();
            list.append(line);
        }
        cf.close();
        list.sort();
        cf.open(QIODevice::WriteOnly | QIODevice::Truncate | QIODevice::Text);
        QTextStream out(&cf);
        for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it )
            out << *it;
        cf.close();
        //trayIcon->showMessage("hzs reminder:", tr("Events sorted by dates"));
        QString kstr = "kdialog --title "; kstr.append('"');
        kstr.append(tr("hzs reminder:"));
        kstr.append('"'); kstr.append(" --passivepopup "); kstr.append('"');
        kstr.append(tr("Events sorted by dates"));
        kstr.append('"');
        int res = QProcess::execute ( kstr );
        if (res){
            trayIcon->showMessage(tr("hzs reminder:"), tr("Events sorted by dates"));
        }
    }
}

void MainWindow::EventsSelectione()
{
    int currentyear;
    eventscount = 0;
    QDate date = QDate::currentDate();
    QDate basedate;
    currentyear = date.year();
    QFile cf(datafile);
    if (!cf.exists())
    {
        //trayIcon->showMessage(tr("Error loading programm"), tr("Data file 'reminder.dat' not found!\nCreate valid file 'reminder.dat' and restart programm"));
        QString kstr = "kdialog --title "; kstr.append('"');
        kstr.append(tr("Error loading programm"));
        kstr.append('"'); kstr.append(" --passivepopup "); kstr.append('"');
        kstr.append(tr("Data file 'reminder.dat' not found!\nCreate valid file 'reminder.dat' and restart programm"));
        kstr.append('"');
        int res = QProcess::execute ( kstr );
        if (res){
            trayIcon->showMessage(tr("Error loading programm"), tr("Data file 'reminder.dat' not found!\nCreate valid file 'reminder.dat' and restart programm"));
        }
    }
    else
    {
        QString lines = "";
        QString line, templine;
        QString baseevent;
        QStringList list;
        int baseyear, basemonth, baseday, dot, semi, lastsemi, daysto, yearsto;
        bool icotoday = false;
;
        cf.open(QIODevice::ReadOnly);
        while (!cf.atEnd())
        {
            line = cf.readLine();
            dot = line.indexOf(".");
            semi = line.indexOf(";");
            lastsemi = line.lastIndexOf(";");
            basemonth = line.mid(0, dot).toInt();
            baseday = line.mid(dot + 1, semi - dot - 1).toInt();
            baseevent = line.mid(semi + 1, lastsemi - semi - 1);
            baseyear = line.mid(lastsemi + 1, line.length() - lastsemi - 2).toInt();

            if (basedate.setDate(currentyear, basemonth, baseday))
            {
                daysto = date.daysTo(basedate);
                yearsto = currentyear - baseyear;
                if(daysto <= 4 && daysto >= 0)
                {
                    if (daysto == 0)
                    {
                        lines.append(tr("Today: "));
                        icotoday = true;
                    }
                    if (daysto == 1)
                    {
                        templine.setNum(daysto);
                        lines.append(templine);
                        lines.append(tr(" day to: "));
                        trayIcon->setIcon(QIcon(":ico/soon.png"));
                    }
                    if (daysto > 1)
                    {
                        templine.setNum(daysto);
                        lines.append(templine);
                        lines.append(tr(" days to: "));
                        trayIcon->setIcon(QIcon(":ico/soon.png"));
                    }
                    lines.append(baseevent);
                    lines.append(" ");
                    if (yearsto > 0 && yearsto < 100)
                    {
                        templine.setNum(yearsto);
                        lines.append("(");
                        lines.append(templine);
                        lines.append(")");
                    }
                    lines.append("\n");
                    eventscount ++;
                }
            }
        }
        cf.close();
        if (icotoday == true)
            trayIcon->setIcon(QIcon(":ico/today.png"));
        if (eventscount > 1)
            //trayIcon->showMessage(tr("hzs reminder: events found"), lines);
        {
            QString kstr = "kdialog --title "; kstr.append('"');
            kstr.append(tr("hzs reminder: events found"));
            kstr.append('"'); kstr.append(" --passivepopup "); kstr.append('"');
            kstr.append(lines);
            kstr.append('"');
            int res = QProcess::execute ( kstr );
            if (res){
                trayIcon->showMessage(tr("hzs reminder: events found"), lines);
            }
        }
        if (eventscount == 1)
            //trayIcon->showMessage(tr("hzs reminder: event found"), lines);
        {
            QString kstr = "kdialog --title "; kstr.append('"');
            kstr.append(tr("hzs reminder: event found"));
            kstr.append('"'); kstr.append(" --passivepopup "); kstr.append('"');
            kstr.append(lines);
            kstr.append('"');
            int res = QProcess::execute ( kstr );
            if (res){
                trayIcon->showMessage(tr("hzs reminder: event found"), lines);
            }
        }
        if (eventscount == 0)
        {
            //trayIcon->showMessage(tr("hzs reminder:"), tr("No events found"));
            if (shownoevents)
                {
                    QString kstr = "kdialog --title "; kstr.append('"');
                    kstr.append(tr("hzs reminder:"));
                    kstr.append('"'); kstr.append(" --passivepopup "); kstr.append('"');
                    kstr.append(tr("No events found"));
                    kstr.append('"');
                    int res = QProcess::execute ( kstr );
                    if (res){
                        trayIcon->showMessage(tr("hzs reminder:"), tr("No events found"));
                    }
                }
            trayIcon->setIcon(QIcon(":ico/normal.png"));
            shownoevents = true;
        }
    }
}

void MainWindow::ShowAbout()
{
    QString aline = tr("hzs reminder v. 2012.09.30\n© 2012 Nisel Alexander II (hzs)\n");//special edition for DarkneSS\n");
    aline.append(tr("Licence: GPLv3\n"));
    if (portableapp)
        aline.append(tr("portable mode\n"));
    else
        aline.append(tr("standalone mode\n"));

    QString kstr = "kdialog --title "; kstr.append('"');
    kstr.append(tr("About hzs reminder:"));
    kstr.append('"'); kstr.append(" --passivepopup "); kstr.append('"');
    kstr.append(aline);
    kstr.append(tr("\nGo to <a href = http://software.nisel.net/reminder.html>hzs reminder's site</a>\n"));
    kstr.append(tr("\nMain site: <a href = http://nisel.ru>http://nisel.ru</a>"));
    kstr.append('"');

    int res = QProcess::execute ( kstr );
    if (res)
    {
        aline.append(tr("\nhttp://nisel.ru"));
        trayIcon->showMessage(tr("About hzs reminder:"), aline);
    }

}

void MainWindow::LaunchEditor()
{
    QString fileedit = "file:///";
    fileedit.append(datafile);
    QDesktopServices::openUrl(QUrl(fileedit, QUrl::TolerantMode));
}

void MainWindow::GoSite()
{
    QDesktopServices::openUrl(QUrl("http://software.nisel.net/reminder.html", QUrl::TolerantMode));
}

void MainWindow::timerEvent(QTimerEvent*)
{
    if (QDate::currentDate() > prevdate)
    {
        EventsSelectione();
        prevdate = QDate::currentDate();
    }
}
