/**
 * \file
 * \brief Header file which defines GXM variables and functions
 *
 * Copyright (C) 2015 PSP2SDK Project
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef _PSP2_GXM_
#define _PSP2_GXM_

#include <psp2/types.h>

#ifdef __cplusplus
extern "C" {
#endif

// Error Codes

enum {
	SCE_GXM_ERROR_UNINITIALIZED	= 0x805B0000,
	SCE_GXM_ERROR_ALREADY_INITIALIZED	= 0x805B0001,
	SCE_GXM_ERROR_OUT_OF_MEMORY	= 0x805B0002,
	SCE_GXM_ERROR_INVALID_VALUE	= 0x805B0003,
	SCE_GXM_ERROR_INVALID_POINTER	= 0x805B0004,
	SCE_GXM_ERROR_INVALID_ALIGNMENT	= 0x805B0005,
	SCE_GXM_ERROR_NOT_WITHIN_SCENE	= 0x805B0006,
	SCE_GXM_ERROR_WITHIN_SCENE	= 0x805B0007,
	SCE_GXM_ERROR_NULL_PROGRAM	= 0x805B0008,
	SCE_GXM_ERROR_UNSUPPORTED	= 0x805B0009,
	SCE_GXM_ERROR_PATCHER_INTERNAL	= 0x805B000A,
	SCE_GXM_ERROR_RESERVE_FAILED	= 0x805B000B,
	SCE_GXM_ERROR_PROGRAM_IN_USE	= 0x805B000C,
	SCE_GXM_ERROR_INVALID_INDEX_COUNT	= 0x805B000D,
	SCE_GXM_ERROR_INVALID_POLYGON_MODE	= 0x805B000E,
	SCE_GXM_ERROR_INVALID_SAMPLER_RESULT_TYPE_PRECISION	= 0x805B000F,
	SCE_GXM_ERROR_INVALID_SAMPLER_RESULT_TYPE_COMPONENT_COUNT	= 0x805B0010,
	SCE_GXM_ERROR_UNIFORM_BUFFER_NOT_RESERVED	= 0x805B0011,
	SCE_GXM_ERROR_INVALID_AUXILIARY_SURFACE	= 0x805B0013,
	SCE_GXM_ERROR_INVALID_PRECOMPUTED_DRAW	= 0x805B0014,
	SCE_GXM_ERROR_INVALID_PRECOMPUTED_VERTEX_STATE	= 0x805B0015,
	SCE_GXM_ERROR_INVALID_PRECOMPUTED_FRAGMENT_STATE	= 0x805B0016,
	SCE_GXM_ERROR_DRIVER	= 0x805B0017
};

typedef void (SceGxmDisplayQueueCallback)(const void *callbackData);

typedef struct SceGxmInitializeParams {
	unsigned int flags;
	unsigned int displayQueueMaxPendingCount;
	SceGxmDisplayQueueCallback *displayQueueCallback;
	unsigned int displayQueueCallbackDataSize;
	SceSize parameterBufferSize;
} SceGxmInitializeParams;

typedef enum SceGxmMemoryAttribFlags {
	SCE_GXM_MEMORY_ATTRIB_READ	= 1,
	SCE_GXM_MEMORY_ATTRIB_WRITE	= 2,
	SCE_GXM_MEMORY_ATTRIB_RW	= (SCE_GXM_MEMORY_ATTRIB_READ | SCE_GXM_MEMORY_ATTRIB_WRITE)
} SceGxmMemoryAttribFlags;

typedef enum SceGxmAttributeFormat {
	SCE_GXM_ATTRIBUTE_FORMAT_U8,
	SCE_GXM_ATTRIBUTE_FORMAT_S8,
	SCE_GXM_ATTRIBUTE_FORMAT_U16,
	SCE_GXM_ATTRIBUTE_FORMAT_S16,
	SCE_GXM_ATTRIBUTE_FORMAT_U8N,
	SCE_GXM_ATTRIBUTE_FORMAT_S8N,
	SCE_GXM_ATTRIBUTE_FORMAT_U16N,
	SCE_GXM_ATTRIBUTE_FORMAT_S16N,
	SCE_GXM_ATTRIBUTE_FORMAT_F16,
	SCE_GXM_ATTRIBUTE_FORMAT_F32
} SceGxmAttributeFormat;

typedef enum SceGxmDepthStencilFormat {
	SCE_GXM_DEPTH_STENCIL_FORMAT_DF32	= 0x00044000u,
	SCE_GXM_DEPTH_STENCIL_FORMAT_S8	= 0x00022000u,
	SCE_GXM_DEPTH_STENCIL_FORMAT_DF32_S8	= 0x00066000u,
	SCE_GXM_DEPTH_STENCIL_FORMAT_S8D24	= 0x01266000u,
	SCE_GXM_DEPTH_STENCIL_FORMAT_D16	= 0x02444000u
} SceGxmDepthStencilFormat;

typedef enum SceGxmPrimitiveType {
	SCE_GXM_PRIMITIVE_TRIANGLES	= 0x00000000u,
	SCE_GXM_PRIMITIVE_LINES	= 0x04000000u,
	SCE_GXM_PRIMITIVE_POINTS	= 0x08000000u,
	SCE_GXM_PRIMITIVE_TRIANGLE_STRIP	= 0x0c000000u,
	SCE_GXM_PRIMITIVE_TRIANGLE_FAN	= 0x10000000u,
	SCE_GXM_PRIMITIVE_TRIANGLE_EDGES	= 0x14000000u
} SceGxmPrimitiveType;

typedef enum SceGxmEdgeEnableFlags {
	SCE_GXM_EDGE_ENABLE_01	= 0x00000100u,
	SCE_GXM_EDGE_ENABLE_12	= 0x00000200u,
	SCE_GXM_EDGE_ENABLE_20	= 0x00000400u
} SceGxmEdgeEnableFlags;

typedef enum SceGxmRegionClipMode {
	SCE_GXM_REGION_CLIP_NONE	= 0x00000000u,
	SCE_GXM_REGION_CLIP_ALL	= 0x40000000u,
	SCE_GXM_REGION_CLIP_OUTSIDE	= 0x80000000u,
	SCE_GXM_REGION_CLIP_INSIDE	= 0xc0000000u
} SceGxmRegionClipMode;

typedef enum SceGxmDepthFunc {
	SCE_GXM_DEPTH_FUNC_NEVER	= 0x00000000u,
	SCE_GXM_DEPTH_FUNC_LESS	= 0x00400000u,
	SCE_GXM_DEPTH_FUNC_EQUAL	= 0x00800000u,
	SCE_GXM_DEPTH_FUNC_LESS_EQUAL	= 0x00c00000u,
	SCE_GXM_DEPTH_FUNC_GREATER	= 0x01000000u,
	SCE_GXM_DEPTH_FUNC_NOT_EQUAL	= 0x01400000u,
	SCE_GXM_DEPTH_FUNC_GREATER_EQUAL	= 0x01800000u,
	SCE_GXM_DEPTH_FUNC_ALWAYS	= 0x01c00000u
} SceGxmDepthFunc;

typedef enum SceGxmStencilFunc {
	SCE_GXM_STENCIL_FUNC_NEVER	= 0x00000000u,
	SCE_GXM_STENCIL_FUNC_LESS	= 0x02000000u,
	SCE_GXM_STENCIL_FUNC_EQUAL	= 0x04000000u,
	SCE_GXM_STENCIL_FUNC_LESS_EQUAL	= 0x06000000u,
	SCE_GXM_STENCIL_FUNC_GREATER	= 0x08000000u,
	SCE_GXM_STENCIL_FUNC_NOT_EQUAL	= 0x0a000000u,
	SCE_GXM_STENCIL_FUNC_GREATER_EQUAL	= 0x0c000000u,
	SCE_GXM_STENCIL_FUNC_ALWAYS	= 0x0e000000u
} SceGxmStencilFunc;

typedef enum SceGxmStencilOp {
	SCE_GXM_STENCIL_OP_KEEP	= 0x00000000u,
	SCE_GXM_STENCIL_OP_ZERO	= 0x00000001u,
	SCE_GXM_STENCIL_OP_REPLACE	= 0x00000002u,
	SCE_GXM_STENCIL_OP_INCR	= 0x00000003u,
	SCE_GXM_STENCIL_OP_DECR	= 0x00000004u,
	SCE_GXM_STENCIL_OP_INVERT	= 0x00000005u,
	SCE_GXM_STENCIL_OP_INCR_WRAP	= 0x00000006u,
	SCE_GXM_STENCIL_OP_DECR_WRAP	= 0x00000007u
} SceGxmStencilOp;

typedef enum SceGxmCullMode {
	SCE_GXM_CULL_NONE	= 0x00000000u,
	SCE_GXM_CULL_CW	= 0x00000001u,
	SCE_GXM_CULL_CCW	= 0x00000002u
} SceGxmCullMode;

typedef enum SceGxmPolygonMode {
	SCE_GXM_POLYGON_MODE_TRIANGLE_FILL	= 0x00000000u,
	SCE_GXM_POLYGON_MODE_LINE	= 0x00008000u,
	SCE_GXM_POLYGON_MODE_POINT_10UV	= 0x00010000u,
	SCE_GXM_POLYGON_MODE_POINT	= 0x00018000u,
	SCE_GXM_POLYGON_MODE_POINT_01UV	= 0x00020000u,
	SCE_GXM_POLYGON_MODE_TRIANGLE_LINE	= 0x00028000u,
	SCE_GXM_POLYGON_MODE_TRIANGLE_POINT	= 0x00030000u
} SceGxmPolygonMode;

typedef enum SceGxmColorSwizzle4Mode {
	SCE_GXM_COLOR_SWIZZLE4_ABGR	= 0x00000000u,
	SCE_GXM_COLOR_SWIZZLE4_ARGB	= 0x00100000u,
	SCE_GXM_COLOR_SWIZZLE4_RGBA	= 0x00200000u,
	SCE_GXM_COLOR_SWIZZLE4_BGRA	= 0x00300000u
} SceGxmColorSwizzle4Mode;

typedef enum SceGxmColorSwizzle3Mode {
	SCE_GXM_COLOR_SWIZZLE3_BGR	= 0x00000000u,
	SCE_GXM_COLOR_SWIZZLE3_RGB	= 0x00100000u
} SceGxmColorSwizzle3Mode;

typedef enum SceGxmColorSwizzle2Mode {
	SCE_GXM_COLOR_SWIZZLE2_GR	= 0x00000000u,
	SCE_GXM_COLOR_SWIZZLE2_RG	= 0x00100000u,
	SCE_GXM_COLOR_SWIZZLE2_RA	= 0x00200000u,
	SCE_GXM_COLOR_SWIZZLE2_AR = 0x00300000u
} SceGxmColorSwizzle2Mode;

typedef enum SceGxmColorSwizzle1Mode {
	SCE_GXM_COLOR_SWIZZLE1_R	= 0x00000000u,
	SCE_GXM_COLOR_SWIZZLE1_G	= 0x00100000u,
	SCE_GXM_COLOR_SWIZZLE1_A	= 0x00100000u
} SceGxmColorSwizzle1Mode;

typedef enum SceGxmColorBaseFormat {
	SCE_GXM_COLOR_BASE_FORMAT_U8U8U8U8	= 0x00000000,
	SCE_GXM_COLOR_BASE_FORMAT_U8U8U8	= 0x10000000,
	SCE_GXM_COLOR_BASE_FORMAT_U5U6U5	= 0x30000000,
	SCE_GXM_COLOR_BASE_FORMAT_U1U5U5U5	= 0x40000000,
	SCE_GXM_COLOR_BASE_FORMAT_U4U4U4U4	= 0x50000000,
	SCE_GXM_COLOR_BASE_FORMAT_U8U3U3U2	= 0x60000000,
	SCE_GXM_COLOR_BASE_FORMAT_F16	= 0xf0000000,
	SCE_GXM_COLOR_BASE_FORMAT_F16F16	= 0x00800000,
	SCE_GXM_COLOR_BASE_FORMAT_F32	= 0x10800000,
	SCE_GXM_COLOR_BASE_FORMAT_S16	= 0x20800000,
	SCE_GXM_COLOR_BASE_FORMAT_S16S16	= 0x30800000,
	SCE_GXM_COLOR_BASE_FORMAT_U16	= 0x40800000,
	SCE_GXM_COLOR_BASE_FORMAT_U16U16	= 0x50800000,
	SCE_GXM_COLOR_BASE_FORMAT_U2U10U10U10	= 0x60800000,
	SCE_GXM_COLOR_BASE_FORMAT_U8	= 0x80800000,
	SCE_GXM_COLOR_BASE_FORMAT_S8	= 0x90800000,
	SCE_GXM_COLOR_BASE_FORMAT_S5S5U6	= 0xa0800000,
	SCE_GXM_COLOR_BASE_FORMAT_U8U8	= 0xb0800000,
	SCE_GXM_COLOR_BASE_FORMAT_S8S8	= 0xc0800000,
	SCE_GXM_COLOR_BASE_FORMAT_U8S8S8U8	= 0xd0800000,
	SCE_GXM_COLOR_BASE_FORMAT_S8S8S8S8	= 0xe0800000,
	SCE_GXM_COLOR_BASE_FORMAT_F16F16F16F16	= 0x01000000,
	SCE_GXM_COLOR_BASE_FORMAT_F32F32	= 0x11000000,
	SCE_GXM_COLOR_BASE_FORMAT_F11F11F10	= 0x21000000,
	SCE_GXM_COLOR_BASE_FORMAT_SE5M9M9M9	= 0x31000000,
	SCE_GXM_COLOR_BASE_FORMAT_U2F10F10F10	= 0x41000000
} SceGxmColorBaseFormat;

typedef enum SceGxmColorFormat {
	// Supported formats

	SCE_GXM_COLOR_FORMAT_U8U8U8U8_ABGR = SCE_GXM_COLOR_BASE_FORMAT_U8U8U8U8 | SCE_GXM_COLOR_SWIZZLE4_ABGR,
	SCE_GXM_COLOR_FORMAT_U8U8U8U8_ARGB = SCE_GXM_COLOR_BASE_FORMAT_U8U8U8U8 | SCE_GXM_COLOR_SWIZZLE4_ARGB,
	SCE_GXM_COLOR_FORMAT_U8U8U8U8_RGBA = SCE_GXM_COLOR_BASE_FORMAT_U8U8U8U8 | SCE_GXM_COLOR_SWIZZLE4_RGBA,
	SCE_GXM_COLOR_FORMAT_U8U8U8U8_BGRA = SCE_GXM_COLOR_BASE_FORMAT_U8U8U8U8 | SCE_GXM_COLOR_SWIZZLE4_BGRA,

	SCE_GXM_COLOR_FORMAT_U8U8U8_BGR = SCE_GXM_COLOR_BASE_FORMAT_U8U8U8 | SCE_GXM_COLOR_SWIZZLE3_BGR,
	SCE_GXM_COLOR_FORMAT_U8U8U8_RGB = SCE_GXM_COLOR_BASE_FORMAT_U8U8U8 | SCE_GXM_COLOR_SWIZZLE3_RGB,

	SCE_GXM_COLOR_FORMAT_U5U6U5_BGR = SCE_GXM_COLOR_BASE_FORMAT_U5U6U5 | SCE_GXM_COLOR_SWIZZLE3_BGR,
	SCE_GXM_COLOR_FORMAT_U5U6U5_RGB = SCE_GXM_COLOR_BASE_FORMAT_U5U6U5 | SCE_GXM_COLOR_SWIZZLE3_RGB,

	SCE_GXM_COLOR_FORMAT_U1U5U5U5_ABGR = SCE_GXM_COLOR_BASE_FORMAT_U1U5U5U5 | SCE_GXM_COLOR_SWIZZLE4_ABGR,
	SCE_GXM_COLOR_FORMAT_U1U5U5U5_ARGB = SCE_GXM_COLOR_BASE_FORMAT_U1U5U5U5 | SCE_GXM_COLOR_SWIZZLE4_ARGB,
	SCE_GXM_COLOR_FORMAT_U5U5U5U1_RGBA = SCE_GXM_COLOR_BASE_FORMAT_U1U5U5U5 | SCE_GXM_COLOR_SWIZZLE4_RGBA,
	SCE_GXM_COLOR_FORMAT_U5U5U5U1_BGRA = SCE_GXM_COLOR_BASE_FORMAT_U1U5U5U5 | SCE_GXM_COLOR_SWIZZLE4_BGRA,

	SCE_GXM_COLOR_FORMAT_U4U4U4U4_ABGR = SCE_GXM_COLOR_BASE_FORMAT_U4U4U4U4 | SCE_GXM_COLOR_SWIZZLE4_ABGR,
	SCE_GXM_COLOR_FORMAT_U4U4U4U4_ARGB = SCE_GXM_COLOR_BASE_FORMAT_U4U4U4U4 | SCE_GXM_COLOR_SWIZZLE4_ARGB,
	SCE_GXM_COLOR_FORMAT_U4U4U4U4_RGBA = SCE_GXM_COLOR_BASE_FORMAT_U4U4U4U4 | SCE_GXM_COLOR_SWIZZLE4_RGBA,
	SCE_GXM_COLOR_FORMAT_U4U4U4U4_BGRA = SCE_GXM_COLOR_BASE_FORMAT_U4U4U4U4 | SCE_GXM_COLOR_SWIZZLE4_BGRA,

	SCE_GXM_COLOR_FORMAT_U8U3U3U2_ARGB = SCE_GXM_COLOR_BASE_FORMAT_U8U3U3U2,

	SCE_GXM_COLOR_FORMAT_F16_R = SCE_GXM_COLOR_BASE_FORMAT_F16 | SCE_GXM_COLOR_SWIZZLE1_R,
	SCE_GXM_COLOR_FORMAT_F16_G = SCE_GXM_COLOR_BASE_FORMAT_F16 | SCE_GXM_COLOR_SWIZZLE1_G,

	SCE_GXM_COLOR_FORMAT_F16F16_GR = SCE_GXM_COLOR_BASE_FORMAT_F16F16 | SCE_GXM_COLOR_SWIZZLE2_GR,
	SCE_GXM_COLOR_FORMAT_F16F16_RG = SCE_GXM_COLOR_BASE_FORMAT_F16F16 | SCE_GXM_COLOR_SWIZZLE2_RG,

	SCE_GXM_COLOR_FORMAT_F32_R = SCE_GXM_COLOR_BASE_FORMAT_F32 | SCE_GXM_COLOR_SWIZZLE1_R,

	SCE_GXM_COLOR_FORMAT_S16_R = SCE_GXM_COLOR_BASE_FORMAT_S16 | SCE_GXM_COLOR_SWIZZLE1_R,
	SCE_GXM_COLOR_FORMAT_S16_G = SCE_GXM_COLOR_BASE_FORMAT_S16 | SCE_GXM_COLOR_SWIZZLE1_G,

	SCE_GXM_COLOR_FORMAT_S16S16_GR = SCE_GXM_COLOR_BASE_FORMAT_S16S16 | SCE_GXM_COLOR_SWIZZLE2_GR,
	SCE_GXM_COLOR_FORMAT_S16S16_RG = SCE_GXM_COLOR_BASE_FORMAT_S16S16 | SCE_GXM_COLOR_SWIZZLE2_RG,

	SCE_GXM_COLOR_FORMAT_U16_R = SCE_GXM_COLOR_BASE_FORMAT_U16 | SCE_GXM_COLOR_SWIZZLE1_R,
	SCE_GXM_COLOR_FORMAT_U16_G = SCE_GXM_COLOR_BASE_FORMAT_U16 | SCE_GXM_COLOR_SWIZZLE1_G,

	SCE_GXM_COLOR_FORMAT_U16U16_GR = SCE_GXM_COLOR_BASE_FORMAT_U16U16 | SCE_GXM_COLOR_SWIZZLE2_GR,
	SCE_GXM_COLOR_FORMAT_U16U16_RG = SCE_GXM_COLOR_BASE_FORMAT_U16U16 | SCE_GXM_COLOR_SWIZZLE2_RG,

	SCE_GXM_COLOR_FORMAT_U2U10U10U10_ABGR = SCE_GXM_COLOR_BASE_FORMAT_U2U10U10U10 | SCE_GXM_COLOR_SWIZZLE4_ABGR,
	SCE_GXM_COLOR_FORMAT_U2U10U10U10_ARGB = SCE_GXM_COLOR_BASE_FORMAT_U2U10U10U10 | SCE_GXM_COLOR_SWIZZLE4_ARGB,
	SCE_GXM_COLOR_FORMAT_U10U10U10U2_RGBA = SCE_GXM_COLOR_BASE_FORMAT_U2U10U10U10 | SCE_GXM_COLOR_SWIZZLE4_RGBA,
	SCE_GXM_COLOR_FORMAT_U10U10U10U2_BGRA = SCE_GXM_COLOR_BASE_FORMAT_U2U10U10U10 | SCE_GXM_COLOR_SWIZZLE4_BGRA,

	SCE_GXM_COLOR_FORMAT_U8_R = SCE_GXM_COLOR_BASE_FORMAT_U8 | SCE_GXM_COLOR_SWIZZLE1_R,
	SCE_GXM_COLOR_FORMAT_U8_A = SCE_GXM_COLOR_BASE_FORMAT_U8 | SCE_GXM_COLOR_SWIZZLE1_A,

	SCE_GXM_COLOR_FORMAT_S8_R = SCE_GXM_COLOR_BASE_FORMAT_S8 | SCE_GXM_COLOR_SWIZZLE1_R,
	SCE_GXM_COLOR_FORMAT_S8_A = SCE_GXM_COLOR_BASE_FORMAT_S8 | SCE_GXM_COLOR_SWIZZLE1_A,

	SCE_GXM_COLOR_FORMAT_U6S5S5_BGR = SCE_GXM_COLOR_BASE_FORMAT_S5S5U6 | SCE_GXM_COLOR_SWIZZLE3_BGR,
	SCE_GXM_COLOR_FORMAT_S5S5U6_RGB = SCE_GXM_COLOR_BASE_FORMAT_S5S5U6 | SCE_GXM_COLOR_SWIZZLE3_RGB,

	SCE_GXM_COLOR_FORMAT_U8U8_GR = SCE_GXM_COLOR_BASE_FORMAT_U8U8 | SCE_GXM_COLOR_SWIZZLE2_GR,
	SCE_GXM_COLOR_FORMAT_U8U8_RG = SCE_GXM_COLOR_BASE_FORMAT_U8U8 | SCE_GXM_COLOR_SWIZZLE2_RG,
	SCE_GXM_COLOR_FORMAT_U8U8_RA = SCE_GXM_COLOR_BASE_FORMAT_U8U8 | SCE_GXM_COLOR_SWIZZLE2_RA,
	SCE_GXM_COLOR_FORMAT_U8U8_AR = SCE_GXM_COLOR_BASE_FORMAT_U8U8 | SCE_GXM_COLOR_SWIZZLE2_AR,

	SCE_GXM_COLOR_FORMAT_S8S8_GR = SCE_GXM_COLOR_BASE_FORMAT_S8S8 | SCE_GXM_COLOR_SWIZZLE2_GR,
	SCE_GXM_COLOR_FORMAT_S8S8_RG = SCE_GXM_COLOR_BASE_FORMAT_S8S8 | SCE_GXM_COLOR_SWIZZLE2_RG,
	SCE_GXM_COLOR_FORMAT_S8S8_RA = SCE_GXM_COLOR_BASE_FORMAT_S8S8 | SCE_GXM_COLOR_SWIZZLE2_RA,
	SCE_GXM_COLOR_FORMAT_S8S8_AR = SCE_GXM_COLOR_BASE_FORMAT_S8S8 | SCE_GXM_COLOR_SWIZZLE2_AR,

	SCE_GXM_COLOR_FORMAT_U8S8S8U8_ABGR = SCE_GXM_COLOR_BASE_FORMAT_U8S8S8U8 | SCE_GXM_COLOR_SWIZZLE4_ABGR,
	SCE_GXM_COLOR_FORMAT_U8U8S8S8_ARGB = SCE_GXM_COLOR_BASE_FORMAT_U8S8S8U8 | SCE_GXM_COLOR_SWIZZLE4_ARGB,
	SCE_GXM_COLOR_FORMAT_U8S8S8U8_RGBA = SCE_GXM_COLOR_BASE_FORMAT_U8S8S8U8 | SCE_GXM_COLOR_SWIZZLE4_RGBA,
	SCE_GXM_COLOR_FORMAT_S8S8U8U8_BGRA = SCE_GXM_COLOR_BASE_FORMAT_U8S8S8U8 | SCE_GXM_COLOR_SWIZZLE4_BGRA,

	SCE_GXM_COLOR_FORMAT_S8S8S8S8_ABGR = SCE_GXM_COLOR_BASE_FORMAT_S8S8S8S8 | SCE_GXM_COLOR_SWIZZLE4_ABGR,
	SCE_GXM_COLOR_FORMAT_S8S8S8S8_ARGB = SCE_GXM_COLOR_BASE_FORMAT_S8S8S8S8 | SCE_GXM_COLOR_SWIZZLE4_ARGB,
	SCE_GXM_COLOR_FORMAT_S8S8S8S8_RGBA = SCE_GXM_COLOR_BASE_FORMAT_S8S8S8S8 | SCE_GXM_COLOR_SWIZZLE4_RGBA,
	SCE_GXM_COLOR_FORMAT_S8S8S8S8_BGRA = SCE_GXM_COLOR_BASE_FORMAT_S8S8S8S8 | SCE_GXM_COLOR_SWIZZLE4_BGRA,

	SCE_GXM_COLOR_FORMAT_F16F16F16F16_ABGR = SCE_GXM_COLOR_BASE_FORMAT_F16F16F16F16 | SCE_GXM_COLOR_SWIZZLE4_ABGR,
	SCE_GXM_COLOR_FORMAT_F16F16F16F16_ARGB = SCE_GXM_COLOR_BASE_FORMAT_F16F16F16F16 | SCE_GXM_COLOR_SWIZZLE4_ARGB,
	SCE_GXM_COLOR_FORMAT_F16F16F16F16_RGBA = SCE_GXM_COLOR_BASE_FORMAT_F16F16F16F16 | SCE_GXM_COLOR_SWIZZLE4_RGBA,
	SCE_GXM_COLOR_FORMAT_F16F16F16F16_BGRA = SCE_GXM_COLOR_BASE_FORMAT_F16F16F16F16 | SCE_GXM_COLOR_SWIZZLE4_BGRA,

	SCE_GXM_COLOR_FORMAT_F32F32_GR = SCE_GXM_COLOR_BASE_FORMAT_F32F32 | SCE_GXM_COLOR_SWIZZLE2_GR,
	SCE_GXM_COLOR_FORMAT_F32F32_RG = SCE_GXM_COLOR_BASE_FORMAT_F32F32 | SCE_GXM_COLOR_SWIZZLE2_RG,

	SCE_GXM_COLOR_FORMAT_F10F11F11_BGR = SCE_GXM_COLOR_BASE_FORMAT_F11F11F10 | SCE_GXM_COLOR_SWIZZLE3_BGR,
	SCE_GXM_COLOR_FORMAT_F11F11F10_RGB = SCE_GXM_COLOR_BASE_FORMAT_F11F11F10 | SCE_GXM_COLOR_SWIZZLE3_RGB,

	SCE_GXM_COLOR_FORMAT_SE5M9M9M9_BGR = SCE_GXM_COLOR_BASE_FORMAT_SE5M9M9M9 | SCE_GXM_COLOR_SWIZZLE3_BGR,
	SCE_GXM_COLOR_FORMAT_SE5M9M9M9_RGB = SCE_GXM_COLOR_BASE_FORMAT_SE5M9M9M9 | SCE_GXM_COLOR_SWIZZLE3_RGB,

	SCE_GXM_COLOR_FORMAT_U2F10F10F10_ABGR = SCE_GXM_COLOR_BASE_FORMAT_U2F10F10F10 | SCE_GXM_COLOR_SWIZZLE4_ABGR,
	SCE_GXM_COLOR_FORMAT_U2F10F10F10_ARGB = SCE_GXM_COLOR_BASE_FORMAT_U2F10F10F10 | SCE_GXM_COLOR_SWIZZLE4_ARGB,
	SCE_GXM_COLOR_FORMAT_F10F10F10U2_RGBA = SCE_GXM_COLOR_BASE_FORMAT_U2F10F10F10 | SCE_GXM_COLOR_SWIZZLE4_RGBA,
	SCE_GXM_COLOR_FORMAT_F10F10F10U2_BGRA = SCE_GXM_COLOR_BASE_FORMAT_U2F10F10F10 | SCE_GXM_COLOR_SWIZZLE4_BGRA,

	// Legacy formats

	SCE_GXM_COLOR_FORMAT_A8B8G8R8 = SCE_GXM_COLOR_FORMAT_U8U8U8U8_ABGR,
	SCE_GXM_COLOR_FORMAT_A8R8G8B8 = SCE_GXM_COLOR_FORMAT_U8U8U8U8_ARGB,
	SCE_GXM_COLOR_FORMAT_R5G6B5   = SCE_GXM_COLOR_FORMAT_U5U6U5_RGB,
	SCE_GXM_COLOR_FORMAT_A1R5G5B5 = SCE_GXM_COLOR_FORMAT_U1U5U5U5_ARGB,
	SCE_GXM_COLOR_FORMAT_A4R4G4B4 = SCE_GXM_COLOR_FORMAT_U4U4U4U4_ARGB,
	SCE_GXM_COLOR_FORMAT_A8 = SCE_GXM_COLOR_FORMAT_U8_A
} SceGxmColorFormat;

typedef enum SceGxmColorSurfaceType {
	SCE_GXM_COLOR_SURFACE_LINEAR	= 0x00000000u,
	SCE_GXM_COLOR_SURFACE_TILED	= 0x04000000u,
	SCE_GXM_COLOR_SURFACE_SWIZZLED	= 0x08000000u
} SceGxmColorSurfaceType;

typedef enum SceGxmColorSurfaceGammaMode {
	SCE_GXM_COLOR_SURFACE_GAMMA_NONE	= 0x00000000u,
	SCE_GXM_COLOR_SURFACE_GAMMA_R	= 0x00001000u,
	SCE_GXM_COLOR_SURFACE_GAMMA_GR	= 0x00003000u,
	SCE_GXM_COLOR_SURFACE_GAMMA_BGR	= 0x00001000u
} SceGxmColorSurfaceGammaMode;

typedef enum SceGxmColorSurfaceDitherMode {
	SCE_GXM_COLOR_SURFACE_DITHER_DISABLED	= 0x00000000u,
	SCE_GXM_COLOR_SURFACE_DITHER_ENABLED	= 0x00000008u
} SceGxmColorSurfaceDitherMode;

typedef enum SceGxmDepthStencilSurfaceType {
	SCE_GXM_DEPTH_STENCIL_SURFACE_LINEAR	= 0x00000000u,
	SCE_GXM_DEPTH_STENCIL_SURFACE_TILED	= 0x00011000u
} SceGxmDepthStencilSurfaceType;

typedef enum SceGxmOutputRegisterFormat {
	SCE_GXM_OUTPUT_REGISTER_FORMAT_DECLARED,
	SCE_GXM_OUTPUT_REGISTER_FORMAT_UCHAR4,
	SCE_GXM_OUTPUT_REGISTER_FORMAT_CHAR4,
	SCE_GXM_OUTPUT_REGISTER_FORMAT_USHORT2,
	SCE_GXM_OUTPUT_REGISTER_FORMAT_SHORT2,
	SCE_GXM_OUTPUT_REGISTER_FORMAT_HALF4,
	SCE_GXM_OUTPUT_REGISTER_FORMAT_HALF2,
	SCE_GXM_OUTPUT_REGISTER_FORMAT_FLOAT2,
	SCE_GXM_OUTPUT_REGISTER_FORMAT_FLOAT
} SceGxmOutputRegisterFormat;

typedef enum SceGxmMultisampleMode {
	SCE_GXM_MULTISAMPLE_NONE,
	SCE_GXM_MULTISAMPLE_2X,
	SCE_GXM_MULTISAMPLE_4X
} SceGxmMultisampleMode;

typedef enum SceGxmTextureSwizzle4Mode {
	SCE_GXM_TEXTURE_SWIZZLE4_ABGR	= 0x00000000u,
	SCE_GXM_TEXTURE_SWIZZLE4_ARGB	= 0x00001000u,
	SCE_GXM_TEXTURE_SWIZZLE4_RGBA	= 0x00002000u,
	SCE_GXM_TEXTURE_SWIZZLE4_BGRA	= 0x00003000u,
	SCE_GXM_TEXTURE_SWIZZLE4_1BGR	= 0x00004000u,
	SCE_GXM_TEXTURE_SWIZZLE4_1RGB	= 0x00005000u,
	SCE_GXM_TEXTURE_SWIZZLE4_RGB1	= 0x00006000u,
	SCE_GXM_TEXTURE_SWIZZLE4_BGR1	= 0x00007000u
} SceGxmTextureSwizzle4Mode;

typedef enum SceGxmTextureSwizzle3Mode {
	SCE_GXM_TEXTURE_SWIZZLE3_BGR	= 0x00000000u,
	SCE_GXM_TEXTURE_SWIZZLE3_RGB	= 0x00001000u
} SceGxmTextureSwizzle3Mode;

typedef enum SceGxmTextureSwizzle2Mode {
	SCE_GXM_TEXTURE_SWIZZLE2_GR	= 0x00000000u,
	SCE_GXM_TEXTURE_SWIZZLE2_00GR	= 0x00001000u,
	SCE_GXM_TEXTURE_SWIZZLE2_GRRR	= 0x00002000u,
	SCE_GXM_TEXTURE_SWIZZLE2_RGGG	= 0x00003000u,
	SCE_GXM_TEXTURE_SWIZZLE2_GRGR	= 0x00004000u,
	SCE_GXM_TEXTURE_SWIZZLE2_00RG	= 0x00005000u
} SceGxmTextureSwizzle2Mode;

typedef enum SceGxmTextureSwizzle2ModeAlt {
	SCE_GXM_TEXTURE_SWIZZLE2_SD	= 0x00000000u,
	SCE_GXM_TEXTURE_SWIZZLE2_DS	= 0x00001000u
} SceGxmTextureSwizzle2ModeAlt;

typedef enum SceGxmTextureSwizzle1Mode {
	SCE_GXM_TEXTURE_SWIZZLE1_R	= 0x00000000u,
	SCE_GXM_TEXTURE_SWIZZLE1_000R	= 0x00001000u,
	SCE_GXM_TEXTURE_SWIZZLE1_111R	= 0x00002000u,
	SCE_GXM_TEXTURE_SWIZZLE1_RRRR	= 0x00003000u,
	SCE_GXM_TEXTURE_SWIZZLE1_0RRR	= 0x00004000u,
	SCE_GXM_TEXTURE_SWIZZLE1_1RRR	= 0x00005000u,
	SCE_GXM_TEXTURE_SWIZZLE1_R000	= 0x00006000u,
	SCE_GXM_TEXTURE_SWIZZLE1_R111	= 0x00007000u
} SceGxmTextureSwizzle1Mode;

typedef enum SceGxmTextureSwizzleYUV422Mode {
	SCE_GXM_TEXTURE_SWIZZLE_YUYV_CSC0	= 0x00000000u,
	SCE_GXM_TEXTURE_SWIZZLE_YVYU_CSC0	= 0x00001000u,
	SCE_GXM_TEXTURE_SWIZZLE_UYVY_CSC0	= 0x00002000u,
	SCE_GXM_TEXTURE_SWIZZLE_VYUY_CSC0	= 0x00003000u,
	SCE_GXM_TEXTURE_SWIZZLE_YUYV_CSC1	= 0x00004000u,
	SCE_GXM_TEXTURE_SWIZZLE_YVYU_CSC1	= 0x00005000u,
	SCE_GXM_TEXTURE_SWIZZLE_UYVY_CSC1	= 0x00006000u,
	SCE_GXM_TEXTURE_SWIZZLE_VYUY_CSC1	= 0x00007000u
} SceGxmTextureSwizzleYUV422Mode;

typedef enum SceGxmTextureSwizzleYUV420Mode {
	SCE_GXM_TEXTURE_SWIZZLE_YUV_CSC0	= 0x00000000u,
	SCE_GXM_TEXTURE_SWIZZLE_YVU_CSC0	= 0x00001000u,
	SCE_GXM_TEXTURE_SWIZZLE_YUV_CSC1	= 0x00002000u,
	SCE_GXM_TEXTURE_SWIZZLE_YVU_CSC1	= 0x00003000u
} SceGxmTextureSwizzleYUV420Mode;

typedef enum SceGxmTextureBaseFormat {
	SCE_GXM_TEXTURE_BASE_FORMAT_U8	= 0x00000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_S8	= 0x01000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_U4U4U4U4	= 0x02000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_U8U3U3U2	= 0x03000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_U1U5U5U5	= 0x04000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_U5U6U5	= 0x05000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_S5S5U6	= 0x06000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_U8U8	= 0x07000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_S8S8	= 0x08000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_U16	= 0x09000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_S16	= 0x0a000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_F16	= 0x0b000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_U8U8U8U8	= 0x0c000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_S8S8S8S8	= 0x0d000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_U2U10U10U10	= 0x0e000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_U16U16	= 0x0f000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_S16S16	= 0x10000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_F16F16	= 0x11000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_F32	= 0x12000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_F32M	= 0x13000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_X8S8S8U8	= 0x14000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_X8U24	= 0x15000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_U32	= 0x17000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_S32	= 0x18000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_SE5M9M9M9	= 0x19000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_F11F11F10	= 0x1a000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_F16F16F16F16	= 0x1b000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_U16U16U16U16	= 0x1c000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_S16S16S16S16	= 0x1d000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_F32F32	= 0x1e000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_U32U32	= 0x1f000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_PVRT2BPP	= 0x80000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_PVRT4BPP	= 0x81000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_PVRTII2BPP	= 0x82000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_PVRTII4BPP	= 0x83000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_UBC1	= 0x85000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_UBC2	= 0x86000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_UBC3	= 0x87000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_YUV420P2	= 0x90000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_YUV420P3	= 0x91000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_YUV422	= 0x92000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_P4	= 0x94000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_P8	= 0x95000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_U8U8U8	= 0x98000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_S8S8S8	= 0x99000000,
	SCE_GXM_TEXTURE_BASE_FORMAT_U2F10F10F10	= 0x9a000000
} SceGxmTextureBaseFormat;

typedef enum SceGxmTextureFormat {
	// Supported formats

	SCE_GXM_TEXTURE_FORMAT_U8_000R = SCE_GXM_TEXTURE_BASE_FORMAT_U8 | SCE_GXM_TEXTURE_SWIZZLE1_000R,
	SCE_GXM_TEXTURE_FORMAT_U8_111R = SCE_GXM_TEXTURE_BASE_FORMAT_U8 | SCE_GXM_TEXTURE_SWIZZLE1_111R,
	SCE_GXM_TEXTURE_FORMAT_U8_RRRR = SCE_GXM_TEXTURE_BASE_FORMAT_U8 | SCE_GXM_TEXTURE_SWIZZLE1_RRRR,
	SCE_GXM_TEXTURE_FORMAT_U8_0RRR = SCE_GXM_TEXTURE_BASE_FORMAT_U8 | SCE_GXM_TEXTURE_SWIZZLE1_0RRR,
	SCE_GXM_TEXTURE_FORMAT_U8_1RRR = SCE_GXM_TEXTURE_BASE_FORMAT_U8 | SCE_GXM_TEXTURE_SWIZZLE1_1RRR,
	SCE_GXM_TEXTURE_FORMAT_U8_R000 = SCE_GXM_TEXTURE_BASE_FORMAT_U8 | SCE_GXM_TEXTURE_SWIZZLE1_R000,
	SCE_GXM_TEXTURE_FORMAT_U8_R111 = SCE_GXM_TEXTURE_BASE_FORMAT_U8 | SCE_GXM_TEXTURE_SWIZZLE1_R111,
	SCE_GXM_TEXTURE_FORMAT_U8_R = SCE_GXM_TEXTURE_BASE_FORMAT_U8 | SCE_GXM_TEXTURE_SWIZZLE1_R,

	SCE_GXM_TEXTURE_FORMAT_S8_000R = SCE_GXM_TEXTURE_BASE_FORMAT_S8 | SCE_GXM_TEXTURE_SWIZZLE1_000R,
	SCE_GXM_TEXTURE_FORMAT_S8_111R = SCE_GXM_TEXTURE_BASE_FORMAT_S8 | SCE_GXM_TEXTURE_SWIZZLE1_111R,
	SCE_GXM_TEXTURE_FORMAT_S8_RRRR = SCE_GXM_TEXTURE_BASE_FORMAT_S8 | SCE_GXM_TEXTURE_SWIZZLE1_RRRR,
	SCE_GXM_TEXTURE_FORMAT_S8_0RRR = SCE_GXM_TEXTURE_BASE_FORMAT_S8 | SCE_GXM_TEXTURE_SWIZZLE1_0RRR,
	SCE_GXM_TEXTURE_FORMAT_S8_1RRR = SCE_GXM_TEXTURE_BASE_FORMAT_S8 | SCE_GXM_TEXTURE_SWIZZLE1_1RRR,
	SCE_GXM_TEXTURE_FORMAT_S8_R000 = SCE_GXM_TEXTURE_BASE_FORMAT_S8 | SCE_GXM_TEXTURE_SWIZZLE1_R000,
	SCE_GXM_TEXTURE_FORMAT_S8_R111 = SCE_GXM_TEXTURE_BASE_FORMAT_S8 | SCE_GXM_TEXTURE_SWIZZLE1_R111,
	SCE_GXM_TEXTURE_FORMAT_S8_R = SCE_GXM_TEXTURE_BASE_FORMAT_S8 | SCE_GXM_TEXTURE_SWIZZLE1_R,

	SCE_GXM_TEXTURE_FORMAT_U4U4U4U4_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_U4U4U4U4 | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,
	SCE_GXM_TEXTURE_FORMAT_U4U4U4U4_ARGB = SCE_GXM_TEXTURE_BASE_FORMAT_U4U4U4U4 | SCE_GXM_TEXTURE_SWIZZLE4_ARGB,
	SCE_GXM_TEXTURE_FORMAT_U4U4U4U4_RGBA = SCE_GXM_TEXTURE_BASE_FORMAT_U4U4U4U4 | SCE_GXM_TEXTURE_SWIZZLE4_RGBA,
	SCE_GXM_TEXTURE_FORMAT_U4U4U4U4_BGRA = SCE_GXM_TEXTURE_BASE_FORMAT_U4U4U4U4 | SCE_GXM_TEXTURE_SWIZZLE4_BGRA,
	SCE_GXM_TEXTURE_FORMAT_X4U4U4U4_1BGR = SCE_GXM_TEXTURE_BASE_FORMAT_U4U4U4U4 | SCE_GXM_TEXTURE_SWIZZLE4_1BGR,
	SCE_GXM_TEXTURE_FORMAT_X4U4U4U4_1RGB = SCE_GXM_TEXTURE_BASE_FORMAT_U4U4U4U4 | SCE_GXM_TEXTURE_SWIZZLE4_1RGB,
	SCE_GXM_TEXTURE_FORMAT_U4U4U4X4_RGB1 = SCE_GXM_TEXTURE_BASE_FORMAT_U4U4U4U4 | SCE_GXM_TEXTURE_SWIZZLE4_RGB1,
	SCE_GXM_TEXTURE_FORMAT_U4U4U4X4_BGR1 = SCE_GXM_TEXTURE_BASE_FORMAT_U4U4U4U4 | SCE_GXM_TEXTURE_SWIZZLE4_BGR1,

	SCE_GXM_TEXTURE_FORMAT_U8U3U3U2_ARGB = SCE_GXM_TEXTURE_BASE_FORMAT_U8U3U3U2,

	SCE_GXM_TEXTURE_FORMAT_U1U5U5U5_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_U1U5U5U5 | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,
	SCE_GXM_TEXTURE_FORMAT_U1U5U5U5_ARGB = SCE_GXM_TEXTURE_BASE_FORMAT_U1U5U5U5 | SCE_GXM_TEXTURE_SWIZZLE4_ARGB,
	SCE_GXM_TEXTURE_FORMAT_U5U5U5U1_RGBA = SCE_GXM_TEXTURE_BASE_FORMAT_U1U5U5U5 | SCE_GXM_TEXTURE_SWIZZLE4_RGBA,
	SCE_GXM_TEXTURE_FORMAT_U5U5U5U1_BGRA = SCE_GXM_TEXTURE_BASE_FORMAT_U1U5U5U5 | SCE_GXM_TEXTURE_SWIZZLE4_BGRA,
	SCE_GXM_TEXTURE_FORMAT_X1U5U5U5_1BGR = SCE_GXM_TEXTURE_BASE_FORMAT_U1U5U5U5 | SCE_GXM_TEXTURE_SWIZZLE4_1BGR,
	SCE_GXM_TEXTURE_FORMAT_X1U5U5U5_1RGB = SCE_GXM_TEXTURE_BASE_FORMAT_U1U5U5U5 | SCE_GXM_TEXTURE_SWIZZLE4_1RGB,
	SCE_GXM_TEXTURE_FORMAT_U5U5U5X1_RGB1 = SCE_GXM_TEXTURE_BASE_FORMAT_U1U5U5U5 | SCE_GXM_TEXTURE_SWIZZLE4_RGB1,
	SCE_GXM_TEXTURE_FORMAT_U5U5U5X1_BGR1 = SCE_GXM_TEXTURE_BASE_FORMAT_U1U5U5U5 | SCE_GXM_TEXTURE_SWIZZLE4_BGR1,

	SCE_GXM_TEXTURE_FORMAT_U5U6U5_BGR = SCE_GXM_TEXTURE_BASE_FORMAT_U5U6U5 | SCE_GXM_TEXTURE_SWIZZLE3_BGR,
	SCE_GXM_TEXTURE_FORMAT_U5U6U5_RGB = SCE_GXM_TEXTURE_BASE_FORMAT_U5U6U5 | SCE_GXM_TEXTURE_SWIZZLE3_RGB,

	SCE_GXM_TEXTURE_FORMAT_U6S5S5_BGR = SCE_GXM_TEXTURE_BASE_FORMAT_S5S5U6 | SCE_GXM_TEXTURE_SWIZZLE3_BGR,
	SCE_GXM_TEXTURE_FORMAT_S5S5U6_RGB = SCE_GXM_TEXTURE_BASE_FORMAT_S5S5U6 | SCE_GXM_TEXTURE_SWIZZLE3_RGB,

	SCE_GXM_TEXTURE_FORMAT_U8U8_00GR = SCE_GXM_TEXTURE_BASE_FORMAT_U8U8 | SCE_GXM_TEXTURE_SWIZZLE2_00GR,
	SCE_GXM_TEXTURE_FORMAT_U8U8_GRRR = SCE_GXM_TEXTURE_BASE_FORMAT_U8U8 | SCE_GXM_TEXTURE_SWIZZLE2_GRRR,
	SCE_GXM_TEXTURE_FORMAT_U8U8_RGGG = SCE_GXM_TEXTURE_BASE_FORMAT_U8U8 | SCE_GXM_TEXTURE_SWIZZLE2_RGGG,
	SCE_GXM_TEXTURE_FORMAT_U8U8_GRGR = SCE_GXM_TEXTURE_BASE_FORMAT_U8U8 | SCE_GXM_TEXTURE_SWIZZLE2_GRGR,
	SCE_GXM_TEXTURE_FORMAT_U8U8_00RG = SCE_GXM_TEXTURE_BASE_FORMAT_U8U8 | SCE_GXM_TEXTURE_SWIZZLE2_00RG,
	SCE_GXM_TEXTURE_FORMAT_U8U8_GR = SCE_GXM_TEXTURE_BASE_FORMAT_U8U8 | SCE_GXM_TEXTURE_SWIZZLE2_GR,

	SCE_GXM_TEXTURE_FORMAT_S8S8_00GR = SCE_GXM_TEXTURE_BASE_FORMAT_S8S8 | SCE_GXM_TEXTURE_SWIZZLE2_00GR,
	SCE_GXM_TEXTURE_FORMAT_S8S8_GRRR = SCE_GXM_TEXTURE_BASE_FORMAT_S8S8 | SCE_GXM_TEXTURE_SWIZZLE2_GRRR,
	SCE_GXM_TEXTURE_FORMAT_S8S8_RGGG = SCE_GXM_TEXTURE_BASE_FORMAT_S8S8 | SCE_GXM_TEXTURE_SWIZZLE2_RGGG,
	SCE_GXM_TEXTURE_FORMAT_S8S8_GRGR = SCE_GXM_TEXTURE_BASE_FORMAT_S8S8 | SCE_GXM_TEXTURE_SWIZZLE2_GRGR,
	SCE_GXM_TEXTURE_FORMAT_S8S8_00RG = SCE_GXM_TEXTURE_BASE_FORMAT_S8S8 | SCE_GXM_TEXTURE_SWIZZLE2_00RG,
	SCE_GXM_TEXTURE_FORMAT_S8S8_GR = SCE_GXM_TEXTURE_BASE_FORMAT_S8S8 | SCE_GXM_TEXTURE_SWIZZLE2_GR,

	SCE_GXM_TEXTURE_FORMAT_U16_000R = SCE_GXM_TEXTURE_BASE_FORMAT_U16 | SCE_GXM_TEXTURE_SWIZZLE1_000R,
	SCE_GXM_TEXTURE_FORMAT_U16_111R = SCE_GXM_TEXTURE_BASE_FORMAT_U16 | SCE_GXM_TEXTURE_SWIZZLE1_111R,
	SCE_GXM_TEXTURE_FORMAT_U16_RRRR = SCE_GXM_TEXTURE_BASE_FORMAT_U16 | SCE_GXM_TEXTURE_SWIZZLE1_RRRR,
	SCE_GXM_TEXTURE_FORMAT_U16_0RRR = SCE_GXM_TEXTURE_BASE_FORMAT_U16 | SCE_GXM_TEXTURE_SWIZZLE1_0RRR,
	SCE_GXM_TEXTURE_FORMAT_U16_1RRR = SCE_GXM_TEXTURE_BASE_FORMAT_U16 | SCE_GXM_TEXTURE_SWIZZLE1_1RRR,
	SCE_GXM_TEXTURE_FORMAT_U16_R000 = SCE_GXM_TEXTURE_BASE_FORMAT_U16 | SCE_GXM_TEXTURE_SWIZZLE1_R000,
	SCE_GXM_TEXTURE_FORMAT_U16_R111 = SCE_GXM_TEXTURE_BASE_FORMAT_U16 | SCE_GXM_TEXTURE_SWIZZLE1_R111,
	SCE_GXM_TEXTURE_FORMAT_U16_R = SCE_GXM_TEXTURE_BASE_FORMAT_U16 | SCE_GXM_TEXTURE_SWIZZLE1_R,

	SCE_GXM_TEXTURE_FORMAT_S16_000R = SCE_GXM_TEXTURE_BASE_FORMAT_S16 | SCE_GXM_TEXTURE_SWIZZLE1_000R,
	SCE_GXM_TEXTURE_FORMAT_S16_111R = SCE_GXM_TEXTURE_BASE_FORMAT_S16 | SCE_GXM_TEXTURE_SWIZZLE1_111R,
	SCE_GXM_TEXTURE_FORMAT_S16_RRRR = SCE_GXM_TEXTURE_BASE_FORMAT_S16 | SCE_GXM_TEXTURE_SWIZZLE1_RRRR,
	SCE_GXM_TEXTURE_FORMAT_S16_0RRR = SCE_GXM_TEXTURE_BASE_FORMAT_S16 | SCE_GXM_TEXTURE_SWIZZLE1_0RRR,
	SCE_GXM_TEXTURE_FORMAT_S16_1RRR = SCE_GXM_TEXTURE_BASE_FORMAT_S16 | SCE_GXM_TEXTURE_SWIZZLE1_1RRR,
	SCE_GXM_TEXTURE_FORMAT_S16_R000 = SCE_GXM_TEXTURE_BASE_FORMAT_S16 | SCE_GXM_TEXTURE_SWIZZLE1_R000,
	SCE_GXM_TEXTURE_FORMAT_S16_R111 = SCE_GXM_TEXTURE_BASE_FORMAT_S16 | SCE_GXM_TEXTURE_SWIZZLE1_R111,
	SCE_GXM_TEXTURE_FORMAT_S16_R = SCE_GXM_TEXTURE_BASE_FORMAT_S16 | SCE_GXM_TEXTURE_SWIZZLE1_R,

	SCE_GXM_TEXTURE_FORMAT_F16_000R = SCE_GXM_TEXTURE_BASE_FORMAT_F16 | SCE_GXM_TEXTURE_SWIZZLE1_000R,
	SCE_GXM_TEXTURE_FORMAT_F16_111R = SCE_GXM_TEXTURE_BASE_FORMAT_F16 | SCE_GXM_TEXTURE_SWIZZLE1_111R,
	SCE_GXM_TEXTURE_FORMAT_F16_RRRR = SCE_GXM_TEXTURE_BASE_FORMAT_F16 | SCE_GXM_TEXTURE_SWIZZLE1_RRRR,
	SCE_GXM_TEXTURE_FORMAT_F16_0RRR = SCE_GXM_TEXTURE_BASE_FORMAT_F16 | SCE_GXM_TEXTURE_SWIZZLE1_0RRR,
	SCE_GXM_TEXTURE_FORMAT_F16_1RRR = SCE_GXM_TEXTURE_BASE_FORMAT_F16 | SCE_GXM_TEXTURE_SWIZZLE1_1RRR,
	SCE_GXM_TEXTURE_FORMAT_F16_R000 = SCE_GXM_TEXTURE_BASE_FORMAT_F16 | SCE_GXM_TEXTURE_SWIZZLE1_R000,
	SCE_GXM_TEXTURE_FORMAT_F16_R111 = SCE_GXM_TEXTURE_BASE_FORMAT_F16 | SCE_GXM_TEXTURE_SWIZZLE1_R111,
	SCE_GXM_TEXTURE_FORMAT_F16_R = SCE_GXM_TEXTURE_BASE_FORMAT_F16 | SCE_GXM_TEXTURE_SWIZZLE1_R,

	SCE_GXM_TEXTURE_FORMAT_U8U8U8U8_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_U8U8U8U8 | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,
	SCE_GXM_TEXTURE_FORMAT_U8U8U8U8_ARGB = SCE_GXM_TEXTURE_BASE_FORMAT_U8U8U8U8 | SCE_GXM_TEXTURE_SWIZZLE4_ARGB,
	SCE_GXM_TEXTURE_FORMAT_U8U8U8U8_RGBA = SCE_GXM_TEXTURE_BASE_FORMAT_U8U8U8U8 | SCE_GXM_TEXTURE_SWIZZLE4_RGBA,
	SCE_GXM_TEXTURE_FORMAT_U8U8U8U8_BGRA = SCE_GXM_TEXTURE_BASE_FORMAT_U8U8U8U8 | SCE_GXM_TEXTURE_SWIZZLE4_BGRA,
	SCE_GXM_TEXTURE_FORMAT_X8U8U8U8_1BGR = SCE_GXM_TEXTURE_BASE_FORMAT_U8U8U8U8 | SCE_GXM_TEXTURE_SWIZZLE4_1BGR,
	SCE_GXM_TEXTURE_FORMAT_X8U8U8U8_1RGB = SCE_GXM_TEXTURE_BASE_FORMAT_U8U8U8U8 | SCE_GXM_TEXTURE_SWIZZLE4_1RGB,
	SCE_GXM_TEXTURE_FORMAT_U8U8U8X8_RGB1 = SCE_GXM_TEXTURE_BASE_FORMAT_U8U8U8U8 | SCE_GXM_TEXTURE_SWIZZLE4_RGB1,
	SCE_GXM_TEXTURE_FORMAT_U8U8U8X8_BGR1 = SCE_GXM_TEXTURE_BASE_FORMAT_U8U8U8U8 | SCE_GXM_TEXTURE_SWIZZLE4_BGR1,

	SCE_GXM_TEXTURE_FORMAT_S8S8S8S8_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_S8S8S8S8 | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,
	SCE_GXM_TEXTURE_FORMAT_S8S8S8S8_ARGB = SCE_GXM_TEXTURE_BASE_FORMAT_S8S8S8S8 | SCE_GXM_TEXTURE_SWIZZLE4_ARGB,
	SCE_GXM_TEXTURE_FORMAT_S8S8S8S8_RGBA = SCE_GXM_TEXTURE_BASE_FORMAT_S8S8S8S8 | SCE_GXM_TEXTURE_SWIZZLE4_RGBA,
	SCE_GXM_TEXTURE_FORMAT_S8S8S8S8_BGRA = SCE_GXM_TEXTURE_BASE_FORMAT_S8S8S8S8 | SCE_GXM_TEXTURE_SWIZZLE4_BGRA,
	SCE_GXM_TEXTURE_FORMAT_X8S8S8S8_1BGR = SCE_GXM_TEXTURE_BASE_FORMAT_S8S8S8S8 | SCE_GXM_TEXTURE_SWIZZLE4_1BGR,
	SCE_GXM_TEXTURE_FORMAT_X8S8S8S8_1RGB = SCE_GXM_TEXTURE_BASE_FORMAT_S8S8S8S8 | SCE_GXM_TEXTURE_SWIZZLE4_1RGB,
	SCE_GXM_TEXTURE_FORMAT_S8S8S8X8_RGB1 = SCE_GXM_TEXTURE_BASE_FORMAT_S8S8S8S8 | SCE_GXM_TEXTURE_SWIZZLE4_RGB1,
	SCE_GXM_TEXTURE_FORMAT_S8S8S8X8_BGR1 = SCE_GXM_TEXTURE_BASE_FORMAT_S8S8S8S8 | SCE_GXM_TEXTURE_SWIZZLE4_BGR1,

	SCE_GXM_TEXTURE_FORMAT_U2U10U10U10_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_U2U10U10U10 | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,
	SCE_GXM_TEXTURE_FORMAT_U2U10U10U10_ARGB = SCE_GXM_TEXTURE_BASE_FORMAT_U2U10U10U10 | SCE_GXM_TEXTURE_SWIZZLE4_ARGB,
	SCE_GXM_TEXTURE_FORMAT_U10U10U10U2_RGBA = SCE_GXM_TEXTURE_BASE_FORMAT_U2U10U10U10 | SCE_GXM_TEXTURE_SWIZZLE4_RGBA,
	SCE_GXM_TEXTURE_FORMAT_U10U10U10U2_BGRA = SCE_GXM_TEXTURE_BASE_FORMAT_U2U10U10U10 | SCE_GXM_TEXTURE_SWIZZLE4_BGRA,
	SCE_GXM_TEXTURE_FORMAT_X2U10U10U10_1BGR = SCE_GXM_TEXTURE_BASE_FORMAT_U2U10U10U10 | SCE_GXM_TEXTURE_SWIZZLE4_1BGR,
	SCE_GXM_TEXTURE_FORMAT_X2U10U10U10_1RGB = SCE_GXM_TEXTURE_BASE_FORMAT_U2U10U10U10 | SCE_GXM_TEXTURE_SWIZZLE4_1RGB,
	SCE_GXM_TEXTURE_FORMAT_U10U10U10X2_RGB1 = SCE_GXM_TEXTURE_BASE_FORMAT_U2U10U10U10 | SCE_GXM_TEXTURE_SWIZZLE4_RGB1,
	SCE_GXM_TEXTURE_FORMAT_U10U10U10X2_BGR1 = SCE_GXM_TEXTURE_BASE_FORMAT_U2U10U10U10 | SCE_GXM_TEXTURE_SWIZZLE4_BGR1,

	SCE_GXM_TEXTURE_FORMAT_U16U16_00GR = SCE_GXM_TEXTURE_BASE_FORMAT_U16U16 | SCE_GXM_TEXTURE_SWIZZLE2_00GR,
	SCE_GXM_TEXTURE_FORMAT_U16U16_GRRR = SCE_GXM_TEXTURE_BASE_FORMAT_U16U16 | SCE_GXM_TEXTURE_SWIZZLE2_GRRR,
	SCE_GXM_TEXTURE_FORMAT_U16U16_RGGG = SCE_GXM_TEXTURE_BASE_FORMAT_U16U16 | SCE_GXM_TEXTURE_SWIZZLE2_RGGG,
	SCE_GXM_TEXTURE_FORMAT_U16U16_GRGR = SCE_GXM_TEXTURE_BASE_FORMAT_U16U16 | SCE_GXM_TEXTURE_SWIZZLE2_GRGR,
	SCE_GXM_TEXTURE_FORMAT_U16U16_00RG = SCE_GXM_TEXTURE_BASE_FORMAT_U16U16 | SCE_GXM_TEXTURE_SWIZZLE2_00RG,
	SCE_GXM_TEXTURE_FORMAT_U16U16_GR = SCE_GXM_TEXTURE_BASE_FORMAT_U16U16 | SCE_GXM_TEXTURE_SWIZZLE2_GR,

	SCE_GXM_TEXTURE_FORMAT_S16S16_00GR = SCE_GXM_TEXTURE_BASE_FORMAT_S16S16 | SCE_GXM_TEXTURE_SWIZZLE2_00GR,
	SCE_GXM_TEXTURE_FORMAT_S16S16_GRRR = SCE_GXM_TEXTURE_BASE_FORMAT_S16S16 | SCE_GXM_TEXTURE_SWIZZLE2_GRRR,
	SCE_GXM_TEXTURE_FORMAT_S16S16_RGGG = SCE_GXM_TEXTURE_BASE_FORMAT_S16S16 | SCE_GXM_TEXTURE_SWIZZLE2_RGGG,
	SCE_GXM_TEXTURE_FORMAT_S16S16_GRGR = SCE_GXM_TEXTURE_BASE_FORMAT_S16S16 | SCE_GXM_TEXTURE_SWIZZLE2_GRGR,
	SCE_GXM_TEXTURE_FORMAT_S16S16_00RG = SCE_GXM_TEXTURE_BASE_FORMAT_S16S16 | SCE_GXM_TEXTURE_SWIZZLE2_00RG,
	SCE_GXM_TEXTURE_FORMAT_S16S16_GR = SCE_GXM_TEXTURE_BASE_FORMAT_S16S16 | SCE_GXM_TEXTURE_SWIZZLE2_GR,

	SCE_GXM_TEXTURE_FORMAT_F16F16_00GR = SCE_GXM_TEXTURE_BASE_FORMAT_F16F16 | SCE_GXM_TEXTURE_SWIZZLE2_00GR,
	SCE_GXM_TEXTURE_FORMAT_F16F16_GRRR = SCE_GXM_TEXTURE_BASE_FORMAT_F16F16 | SCE_GXM_TEXTURE_SWIZZLE2_GRRR,
	SCE_GXM_TEXTURE_FORMAT_F16F16_RGGG = SCE_GXM_TEXTURE_BASE_FORMAT_F16F16 | SCE_GXM_TEXTURE_SWIZZLE2_RGGG,
	SCE_GXM_TEXTURE_FORMAT_F16F16_GRGR = SCE_GXM_TEXTURE_BASE_FORMAT_F16F16 | SCE_GXM_TEXTURE_SWIZZLE2_GRGR,
	SCE_GXM_TEXTURE_FORMAT_F16F16_00RG = SCE_GXM_TEXTURE_BASE_FORMAT_F16F16 | SCE_GXM_TEXTURE_SWIZZLE2_00RG,
	SCE_GXM_TEXTURE_FORMAT_F16F16_GR = SCE_GXM_TEXTURE_BASE_FORMAT_F16F16 | SCE_GXM_TEXTURE_SWIZZLE2_GR,

	SCE_GXM_TEXTURE_FORMAT_F32_000R = SCE_GXM_TEXTURE_BASE_FORMAT_F32 | SCE_GXM_TEXTURE_SWIZZLE1_000R,
	SCE_GXM_TEXTURE_FORMAT_F32_111R = SCE_GXM_TEXTURE_BASE_FORMAT_F32 | SCE_GXM_TEXTURE_SWIZZLE1_111R,
	SCE_GXM_TEXTURE_FORMAT_F32_RRRR = SCE_GXM_TEXTURE_BASE_FORMAT_F32 | SCE_GXM_TEXTURE_SWIZZLE1_RRRR,
	SCE_GXM_TEXTURE_FORMAT_F32_0RRR = SCE_GXM_TEXTURE_BASE_FORMAT_F32 | SCE_GXM_TEXTURE_SWIZZLE1_0RRR,
	SCE_GXM_TEXTURE_FORMAT_F32_1RRR = SCE_GXM_TEXTURE_BASE_FORMAT_F32 | SCE_GXM_TEXTURE_SWIZZLE1_1RRR,
	SCE_GXM_TEXTURE_FORMAT_F32_R000 = SCE_GXM_TEXTURE_BASE_FORMAT_F32 | SCE_GXM_TEXTURE_SWIZZLE1_R000,
	SCE_GXM_TEXTURE_FORMAT_F32_R111 = SCE_GXM_TEXTURE_BASE_FORMAT_F32 | SCE_GXM_TEXTURE_SWIZZLE1_R111,
	SCE_GXM_TEXTURE_FORMAT_F32_R = SCE_GXM_TEXTURE_BASE_FORMAT_F32 | SCE_GXM_TEXTURE_SWIZZLE1_R,

	SCE_GXM_TEXTURE_FORMAT_F32M_000R = SCE_GXM_TEXTURE_BASE_FORMAT_F32M | SCE_GXM_TEXTURE_SWIZZLE1_000R,
	SCE_GXM_TEXTURE_FORMAT_F32M_111R = SCE_GXM_TEXTURE_BASE_FORMAT_F32M | SCE_GXM_TEXTURE_SWIZZLE1_111R,
	SCE_GXM_TEXTURE_FORMAT_F32M_RRRR = SCE_GXM_TEXTURE_BASE_FORMAT_F32M | SCE_GXM_TEXTURE_SWIZZLE1_RRRR,
	SCE_GXM_TEXTURE_FORMAT_F32M_0RRR = SCE_GXM_TEXTURE_BASE_FORMAT_F32M | SCE_GXM_TEXTURE_SWIZZLE1_0RRR,
	SCE_GXM_TEXTURE_FORMAT_F32M_1RRR = SCE_GXM_TEXTURE_BASE_FORMAT_F32M | SCE_GXM_TEXTURE_SWIZZLE1_1RRR,
	SCE_GXM_TEXTURE_FORMAT_F32M_R000 = SCE_GXM_TEXTURE_BASE_FORMAT_F32M | SCE_GXM_TEXTURE_SWIZZLE1_R000,
	SCE_GXM_TEXTURE_FORMAT_F32M_R111 = SCE_GXM_TEXTURE_BASE_FORMAT_F32M | SCE_GXM_TEXTURE_SWIZZLE1_R111,
	SCE_GXM_TEXTURE_FORMAT_F32M_R = SCE_GXM_TEXTURE_BASE_FORMAT_F32M | SCE_GXM_TEXTURE_SWIZZLE1_R,

	SCE_GXM_TEXTURE_FORMAT_X8S8S8U8_1BGR = SCE_GXM_TEXTURE_BASE_FORMAT_X8S8S8U8 | SCE_GXM_TEXTURE_SWIZZLE3_BGR,
	SCE_GXM_TEXTURE_FORMAT_X8U8S8S8_1RGB = SCE_GXM_TEXTURE_BASE_FORMAT_X8S8S8U8 | SCE_GXM_TEXTURE_SWIZZLE3_RGB,

	SCE_GXM_TEXTURE_FORMAT_X8U24_SD = SCE_GXM_TEXTURE_BASE_FORMAT_X8U24 | SCE_GXM_TEXTURE_SWIZZLE2_SD,
	SCE_GXM_TEXTURE_FORMAT_U24X8_DS = SCE_GXM_TEXTURE_BASE_FORMAT_X8U24 | SCE_GXM_TEXTURE_SWIZZLE2_DS,

	SCE_GXM_TEXTURE_FORMAT_U32_000R = SCE_GXM_TEXTURE_BASE_FORMAT_U32 | SCE_GXM_TEXTURE_SWIZZLE1_000R,
	SCE_GXM_TEXTURE_FORMAT_U32_111R = SCE_GXM_TEXTURE_BASE_FORMAT_U32 | SCE_GXM_TEXTURE_SWIZZLE1_111R,
	SCE_GXM_TEXTURE_FORMAT_U32_RRRR = SCE_GXM_TEXTURE_BASE_FORMAT_U32 | SCE_GXM_TEXTURE_SWIZZLE1_RRRR,
	SCE_GXM_TEXTURE_FORMAT_U32_0RRR = SCE_GXM_TEXTURE_BASE_FORMAT_U32 | SCE_GXM_TEXTURE_SWIZZLE1_0RRR,
	SCE_GXM_TEXTURE_FORMAT_U32_1RRR = SCE_GXM_TEXTURE_BASE_FORMAT_U32 | SCE_GXM_TEXTURE_SWIZZLE1_1RRR,
	SCE_GXM_TEXTURE_FORMAT_U32_R000 = SCE_GXM_TEXTURE_BASE_FORMAT_U32 | SCE_GXM_TEXTURE_SWIZZLE1_R000,
	SCE_GXM_TEXTURE_FORMAT_U32_R111 = SCE_GXM_TEXTURE_BASE_FORMAT_U32 | SCE_GXM_TEXTURE_SWIZZLE1_R111,
	SCE_GXM_TEXTURE_FORMAT_U32_R = SCE_GXM_TEXTURE_BASE_FORMAT_U32 | SCE_GXM_TEXTURE_SWIZZLE1_R,

	SCE_GXM_TEXTURE_FORMAT_S32_000R = SCE_GXM_TEXTURE_BASE_FORMAT_S32 | SCE_GXM_TEXTURE_SWIZZLE1_000R,
	SCE_GXM_TEXTURE_FORMAT_S32_111R = SCE_GXM_TEXTURE_BASE_FORMAT_S32 | SCE_GXM_TEXTURE_SWIZZLE1_111R,
	SCE_GXM_TEXTURE_FORMAT_S32_RRRR = SCE_GXM_TEXTURE_BASE_FORMAT_S32 | SCE_GXM_TEXTURE_SWIZZLE1_RRRR,
	SCE_GXM_TEXTURE_FORMAT_S32_0RRR = SCE_GXM_TEXTURE_BASE_FORMAT_S32 | SCE_GXM_TEXTURE_SWIZZLE1_0RRR,
	SCE_GXM_TEXTURE_FORMAT_S32_1RRR = SCE_GXM_TEXTURE_BASE_FORMAT_S32 | SCE_GXM_TEXTURE_SWIZZLE1_1RRR,
	SCE_GXM_TEXTURE_FORMAT_S32_R000 = SCE_GXM_TEXTURE_BASE_FORMAT_S32 | SCE_GXM_TEXTURE_SWIZZLE1_R000,
	SCE_GXM_TEXTURE_FORMAT_S32_R111 = SCE_GXM_TEXTURE_BASE_FORMAT_S32 | SCE_GXM_TEXTURE_SWIZZLE1_R111,
	SCE_GXM_TEXTURE_FORMAT_S32_R = SCE_GXM_TEXTURE_BASE_FORMAT_S32 | SCE_GXM_TEXTURE_SWIZZLE1_R,

	SCE_GXM_TEXTURE_FORMAT_SE5M9M9M9_BGR = SCE_GXM_TEXTURE_BASE_FORMAT_SE5M9M9M9 | SCE_GXM_TEXTURE_SWIZZLE3_BGR,
	SCE_GXM_TEXTURE_FORMAT_SE5M9M9M9_RGB = SCE_GXM_TEXTURE_BASE_FORMAT_SE5M9M9M9 | SCE_GXM_TEXTURE_SWIZZLE3_RGB,

	SCE_GXM_TEXTURE_FORMAT_F10F11F11_BGR = SCE_GXM_TEXTURE_BASE_FORMAT_F11F11F10 | SCE_GXM_TEXTURE_SWIZZLE3_BGR,
	SCE_GXM_TEXTURE_FORMAT_F11F11F10_RGB = SCE_GXM_TEXTURE_BASE_FORMAT_F11F11F10 | SCE_GXM_TEXTURE_SWIZZLE3_RGB,

	SCE_GXM_TEXTURE_FORMAT_F16F16F16F16_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_F16F16F16F16 | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,
	SCE_GXM_TEXTURE_FORMAT_F16F16F16F16_ARGB = SCE_GXM_TEXTURE_BASE_FORMAT_F16F16F16F16 | SCE_GXM_TEXTURE_SWIZZLE4_ARGB,
	SCE_GXM_TEXTURE_FORMAT_F16F16F16F16_RGBA = SCE_GXM_TEXTURE_BASE_FORMAT_F16F16F16F16 | SCE_GXM_TEXTURE_SWIZZLE4_RGBA,
	SCE_GXM_TEXTURE_FORMAT_F16F16F16F16_BGRA = SCE_GXM_TEXTURE_BASE_FORMAT_F16F16F16F16 | SCE_GXM_TEXTURE_SWIZZLE4_BGRA,
	SCE_GXM_TEXTURE_FORMAT_X16F16F16F16_1BGR = SCE_GXM_TEXTURE_BASE_FORMAT_F16F16F16F16 | SCE_GXM_TEXTURE_SWIZZLE4_1BGR,
	SCE_GXM_TEXTURE_FORMAT_X16F16F16F16_1RGB = SCE_GXM_TEXTURE_BASE_FORMAT_F16F16F16F16 | SCE_GXM_TEXTURE_SWIZZLE4_1RGB,
	SCE_GXM_TEXTURE_FORMAT_F16F16F16X16_RGB1 = SCE_GXM_TEXTURE_BASE_FORMAT_F16F16F16F16 | SCE_GXM_TEXTURE_SWIZZLE4_RGB1,
	SCE_GXM_TEXTURE_FORMAT_F16F16F16X16_BGR1 = SCE_GXM_TEXTURE_BASE_FORMAT_F16F16F16F16 | SCE_GXM_TEXTURE_SWIZZLE4_BGR1,

	SCE_GXM_TEXTURE_FORMAT_U16U16U16U16_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_U16U16U16U16 | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,
	SCE_GXM_TEXTURE_FORMAT_U16U16U16U16_ARGB = SCE_GXM_TEXTURE_BASE_FORMAT_U16U16U16U16 | SCE_GXM_TEXTURE_SWIZZLE4_ARGB,
	SCE_GXM_TEXTURE_FORMAT_U16U16U16U16_RGBA = SCE_GXM_TEXTURE_BASE_FORMAT_U16U16U16U16 | SCE_GXM_TEXTURE_SWIZZLE4_RGBA,
	SCE_GXM_TEXTURE_FORMAT_U16U16U16U16_BGRA = SCE_GXM_TEXTURE_BASE_FORMAT_U16U16U16U16 | SCE_GXM_TEXTURE_SWIZZLE4_BGRA,
	SCE_GXM_TEXTURE_FORMAT_X16U16U16U16_1BGR = SCE_GXM_TEXTURE_BASE_FORMAT_U16U16U16U16 | SCE_GXM_TEXTURE_SWIZZLE4_1BGR,
	SCE_GXM_TEXTURE_FORMAT_X16U16U16U16_1RGB = SCE_GXM_TEXTURE_BASE_FORMAT_U16U16U16U16 | SCE_GXM_TEXTURE_SWIZZLE4_1RGB,
	SCE_GXM_TEXTURE_FORMAT_U16U16U16X16_RGB1 = SCE_GXM_TEXTURE_BASE_FORMAT_U16U16U16U16 | SCE_GXM_TEXTURE_SWIZZLE4_RGB1,
	SCE_GXM_TEXTURE_FORMAT_U16U16U16X16_BGR1 = SCE_GXM_TEXTURE_BASE_FORMAT_U16U16U16U16 | SCE_GXM_TEXTURE_SWIZZLE4_BGR1,

	SCE_GXM_TEXTURE_FORMAT_S16S16S16S16_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_S16S16S16S16 | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,
	SCE_GXM_TEXTURE_FORMAT_S16S16S16S16_ARGB = SCE_GXM_TEXTURE_BASE_FORMAT_S16S16S16S16 | SCE_GXM_TEXTURE_SWIZZLE4_ARGB,
	SCE_GXM_TEXTURE_FORMAT_S16S16S16S16_RGBA = SCE_GXM_TEXTURE_BASE_FORMAT_S16S16S16S16 | SCE_GXM_TEXTURE_SWIZZLE4_RGBA,
	SCE_GXM_TEXTURE_FORMAT_S16S16S16S16_BGRA = SCE_GXM_TEXTURE_BASE_FORMAT_S16S16S16S16 | SCE_GXM_TEXTURE_SWIZZLE4_BGRA,
	SCE_GXM_TEXTURE_FORMAT_X16S16S16S16_1BGR = SCE_GXM_TEXTURE_BASE_FORMAT_S16S16S16S16 | SCE_GXM_TEXTURE_SWIZZLE4_1BGR,
	SCE_GXM_TEXTURE_FORMAT_X16S16S16S16_1RGB = SCE_GXM_TEXTURE_BASE_FORMAT_S16S16S16S16 | SCE_GXM_TEXTURE_SWIZZLE4_1RGB,
	SCE_GXM_TEXTURE_FORMAT_S16S16S16X16_RGB1 = SCE_GXM_TEXTURE_BASE_FORMAT_S16S16S16S16 | SCE_GXM_TEXTURE_SWIZZLE4_RGB1,
	SCE_GXM_TEXTURE_FORMAT_S16S16S16X16_BGR1 = SCE_GXM_TEXTURE_BASE_FORMAT_S16S16S16S16 | SCE_GXM_TEXTURE_SWIZZLE4_BGR1,

	SCE_GXM_TEXTURE_FORMAT_F32F32_00GR = SCE_GXM_TEXTURE_BASE_FORMAT_F32F32 | SCE_GXM_TEXTURE_SWIZZLE2_00GR,
	SCE_GXM_TEXTURE_FORMAT_F32F32_GRRR = SCE_GXM_TEXTURE_BASE_FORMAT_F32F32 | SCE_GXM_TEXTURE_SWIZZLE2_GRRR,
	SCE_GXM_TEXTURE_FORMAT_F32F32_RGGG = SCE_GXM_TEXTURE_BASE_FORMAT_F32F32 | SCE_GXM_TEXTURE_SWIZZLE2_RGGG,
	SCE_GXM_TEXTURE_FORMAT_F32F32_GRGR = SCE_GXM_TEXTURE_BASE_FORMAT_F32F32 | SCE_GXM_TEXTURE_SWIZZLE2_GRGR,
	SCE_GXM_TEXTURE_FORMAT_F32F32_00RG = SCE_GXM_TEXTURE_BASE_FORMAT_F32F32 | SCE_GXM_TEXTURE_SWIZZLE2_00RG,
	SCE_GXM_TEXTURE_FORMAT_F32F32_GR = SCE_GXM_TEXTURE_BASE_FORMAT_F32F32 | SCE_GXM_TEXTURE_SWIZZLE2_GR,

	SCE_GXM_TEXTURE_FORMAT_U32U32_00GR = SCE_GXM_TEXTURE_BASE_FORMAT_U32U32 | SCE_GXM_TEXTURE_SWIZZLE2_00GR,
	SCE_GXM_TEXTURE_FORMAT_U32U32_GRRR = SCE_GXM_TEXTURE_BASE_FORMAT_U32U32 | SCE_GXM_TEXTURE_SWIZZLE2_GRRR,
	SCE_GXM_TEXTURE_FORMAT_U32U32_RGGG = SCE_GXM_TEXTURE_BASE_FORMAT_U32U32 | SCE_GXM_TEXTURE_SWIZZLE2_RGGG,
	SCE_GXM_TEXTURE_FORMAT_U32U32_GRGR = SCE_GXM_TEXTURE_BASE_FORMAT_U32U32 | SCE_GXM_TEXTURE_SWIZZLE2_GRGR,
	SCE_GXM_TEXTURE_FORMAT_U32U32_00RG = SCE_GXM_TEXTURE_BASE_FORMAT_U32U32 | SCE_GXM_TEXTURE_SWIZZLE2_00RG,
	SCE_GXM_TEXTURE_FORMAT_U32U32_GR = SCE_GXM_TEXTURE_BASE_FORMAT_U32U32 | SCE_GXM_TEXTURE_SWIZZLE2_GR,

	SCE_GXM_TEXTURE_FORMAT_PVRT2BPP_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_PVRT2BPP | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,
	SCE_GXM_TEXTURE_FORMAT_PVRT2BPP_1BGR = SCE_GXM_TEXTURE_BASE_FORMAT_PVRT2BPP | SCE_GXM_TEXTURE_SWIZZLE4_1BGR,

	SCE_GXM_TEXTURE_FORMAT_PVRT4BPP_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_PVRT4BPP | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,
	SCE_GXM_TEXTURE_FORMAT_PVRT4BPP_1BGR = SCE_GXM_TEXTURE_BASE_FORMAT_PVRT4BPP | SCE_GXM_TEXTURE_SWIZZLE4_1BGR,

	SCE_GXM_TEXTURE_FORMAT_PVRTII2BPP_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_PVRTII2BPP | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,
	SCE_GXM_TEXTURE_FORMAT_PVRTII2BPP_1BGR = SCE_GXM_TEXTURE_BASE_FORMAT_PVRTII2BPP | SCE_GXM_TEXTURE_SWIZZLE4_1BGR,

	SCE_GXM_TEXTURE_FORMAT_PVRTII4BPP_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_PVRTII4BPP | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,
	SCE_GXM_TEXTURE_FORMAT_PVRTII4BPP_1BGR = SCE_GXM_TEXTURE_BASE_FORMAT_PVRTII4BPP | SCE_GXM_TEXTURE_SWIZZLE4_1BGR,

	SCE_GXM_TEXTURE_FORMAT_UBC1_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_UBC1 | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,

	SCE_GXM_TEXTURE_FORMAT_UBC2_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_UBC2 | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,

	SCE_GXM_TEXTURE_FORMAT_UBC3_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_UBC3 | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,

	SCE_GXM_TEXTURE_FORMAT_YUV420P2_CSC0 = SCE_GXM_TEXTURE_BASE_FORMAT_YUV420P2 | SCE_GXM_TEXTURE_SWIZZLE_YUV_CSC0,
	SCE_GXM_TEXTURE_FORMAT_YVU420P2_CSC0 = SCE_GXM_TEXTURE_BASE_FORMAT_YUV420P2 | SCE_GXM_TEXTURE_SWIZZLE_YVU_CSC0,
	SCE_GXM_TEXTURE_FORMAT_YUV420P2_CSC1 = SCE_GXM_TEXTURE_BASE_FORMAT_YUV420P2 | SCE_GXM_TEXTURE_SWIZZLE_YUV_CSC1,
	SCE_GXM_TEXTURE_FORMAT_YVU420P2_CSC1 = SCE_GXM_TEXTURE_BASE_FORMAT_YUV420P2 | SCE_GXM_TEXTURE_SWIZZLE_YVU_CSC1,

	SCE_GXM_TEXTURE_FORMAT_YUV420P3_CSC0 = SCE_GXM_TEXTURE_BASE_FORMAT_YUV420P3 | SCE_GXM_TEXTURE_SWIZZLE_YUV_CSC0,
	SCE_GXM_TEXTURE_FORMAT_YVU420P3_CSC0 = SCE_GXM_TEXTURE_BASE_FORMAT_YUV420P3 | SCE_GXM_TEXTURE_SWIZZLE_YVU_CSC0,
	SCE_GXM_TEXTURE_FORMAT_YUV420P3_CSC1 = SCE_GXM_TEXTURE_BASE_FORMAT_YUV420P3 | SCE_GXM_TEXTURE_SWIZZLE_YUV_CSC1,
	SCE_GXM_TEXTURE_FORMAT_YVU420P3_CSC1 = SCE_GXM_TEXTURE_BASE_FORMAT_YUV420P3 | SCE_GXM_TEXTURE_SWIZZLE_YVU_CSC1,

	SCE_GXM_TEXTURE_FORMAT_YUYV422_CSC0 = SCE_GXM_TEXTURE_BASE_FORMAT_YUV422 | SCE_GXM_TEXTURE_SWIZZLE_YUYV_CSC0,
	SCE_GXM_TEXTURE_FORMAT_YVYU422_CSC0 = SCE_GXM_TEXTURE_BASE_FORMAT_YUV422 | SCE_GXM_TEXTURE_SWIZZLE_YVYU_CSC0,
	SCE_GXM_TEXTURE_FORMAT_UYVY422_CSC0 = SCE_GXM_TEXTURE_BASE_FORMAT_YUV422 | SCE_GXM_TEXTURE_SWIZZLE_UYVY_CSC0,
	SCE_GXM_TEXTURE_FORMAT_VYUY422_CSC0 = SCE_GXM_TEXTURE_BASE_FORMAT_YUV422 | SCE_GXM_TEXTURE_SWIZZLE_VYUY_CSC0,
	SCE_GXM_TEXTURE_FORMAT_YUYV422_CSC1 = SCE_GXM_TEXTURE_BASE_FORMAT_YUV422 | SCE_GXM_TEXTURE_SWIZZLE_YUYV_CSC1,
	SCE_GXM_TEXTURE_FORMAT_YVYU422_CSC1 = SCE_GXM_TEXTURE_BASE_FORMAT_YUV422 | SCE_GXM_TEXTURE_SWIZZLE_YVYU_CSC1,
	SCE_GXM_TEXTURE_FORMAT_UYVY422_CSC1 = SCE_GXM_TEXTURE_BASE_FORMAT_YUV422 | SCE_GXM_TEXTURE_SWIZZLE_UYVY_CSC1,
	SCE_GXM_TEXTURE_FORMAT_VYUY422_CSC1 = SCE_GXM_TEXTURE_BASE_FORMAT_YUV422 | SCE_GXM_TEXTURE_SWIZZLE_VYUY_CSC1,

	SCE_GXM_TEXTURE_FORMAT_P4_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_P4 | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,
	SCE_GXM_TEXTURE_FORMAT_P4_ARGB = SCE_GXM_TEXTURE_BASE_FORMAT_P4 | SCE_GXM_TEXTURE_SWIZZLE4_ARGB,
	SCE_GXM_TEXTURE_FORMAT_P4_RGBA = SCE_GXM_TEXTURE_BASE_FORMAT_P4 | SCE_GXM_TEXTURE_SWIZZLE4_RGBA,
	SCE_GXM_TEXTURE_FORMAT_P4_BGRA = SCE_GXM_TEXTURE_BASE_FORMAT_P4 | SCE_GXM_TEXTURE_SWIZZLE4_BGRA,
	SCE_GXM_TEXTURE_FORMAT_P4_1BGR = SCE_GXM_TEXTURE_BASE_FORMAT_P4 | SCE_GXM_TEXTURE_SWIZZLE4_1BGR,
	SCE_GXM_TEXTURE_FORMAT_P4_1RGB = SCE_GXM_TEXTURE_BASE_FORMAT_P4 | SCE_GXM_TEXTURE_SWIZZLE4_1RGB,
	SCE_GXM_TEXTURE_FORMAT_P4_RGB1 = SCE_GXM_TEXTURE_BASE_FORMAT_P4 | SCE_GXM_TEXTURE_SWIZZLE4_RGB1,
	SCE_GXM_TEXTURE_FORMAT_P4_BGR1 = SCE_GXM_TEXTURE_BASE_FORMAT_P4 | SCE_GXM_TEXTURE_SWIZZLE4_BGR1,

	SCE_GXM_TEXTURE_FORMAT_P8_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_P8 | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,
	SCE_GXM_TEXTURE_FORMAT_P8_ARGB = SCE_GXM_TEXTURE_BASE_FORMAT_P8 | SCE_GXM_TEXTURE_SWIZZLE4_ARGB,
	SCE_GXM_TEXTURE_FORMAT_P8_RGBA = SCE_GXM_TEXTURE_BASE_FORMAT_P8 | SCE_GXM_TEXTURE_SWIZZLE4_RGBA,
	SCE_GXM_TEXTURE_FORMAT_P8_BGRA = SCE_GXM_TEXTURE_BASE_FORMAT_P8 | SCE_GXM_TEXTURE_SWIZZLE4_BGRA,
	SCE_GXM_TEXTURE_FORMAT_P8_1BGR = SCE_GXM_TEXTURE_BASE_FORMAT_P8 | SCE_GXM_TEXTURE_SWIZZLE4_1BGR,
	SCE_GXM_TEXTURE_FORMAT_P8_1RGB = SCE_GXM_TEXTURE_BASE_FORMAT_P8 | SCE_GXM_TEXTURE_SWIZZLE4_1RGB,
	SCE_GXM_TEXTURE_FORMAT_P8_RGB1 = SCE_GXM_TEXTURE_BASE_FORMAT_P8 | SCE_GXM_TEXTURE_SWIZZLE4_RGB1,
	SCE_GXM_TEXTURE_FORMAT_P8_BGR1 = SCE_GXM_TEXTURE_BASE_FORMAT_P8 | SCE_GXM_TEXTURE_SWIZZLE4_BGR1,

	SCE_GXM_TEXTURE_FORMAT_U8U8U8_BGR = SCE_GXM_TEXTURE_BASE_FORMAT_U8U8U8 | SCE_GXM_TEXTURE_SWIZZLE3_BGR,
	SCE_GXM_TEXTURE_FORMAT_U8U8U8_RGB = SCE_GXM_TEXTURE_BASE_FORMAT_U8U8U8 | SCE_GXM_TEXTURE_SWIZZLE3_RGB,

	SCE_GXM_TEXTURE_FORMAT_S8S8S8_BGR = SCE_GXM_TEXTURE_BASE_FORMAT_S8S8S8 | SCE_GXM_TEXTURE_SWIZZLE3_BGR,
	SCE_GXM_TEXTURE_FORMAT_S8S8S8_RGB = SCE_GXM_TEXTURE_BASE_FORMAT_S8S8S8 | SCE_GXM_TEXTURE_SWIZZLE3_RGB,

	SCE_GXM_TEXTURE_FORMAT_U2F10F10F10_ABGR = SCE_GXM_TEXTURE_BASE_FORMAT_U2F10F10F10 | SCE_GXM_TEXTURE_SWIZZLE4_ABGR,
	SCE_GXM_TEXTURE_FORMAT_U2F10F10F10_ARGB = SCE_GXM_TEXTURE_BASE_FORMAT_U2F10F10F10 | SCE_GXM_TEXTURE_SWIZZLE4_ARGB,
	SCE_GXM_TEXTURE_FORMAT_F10F10F10U2_RGBA = SCE_GXM_TEXTURE_BASE_FORMAT_U2F10F10F10 | SCE_GXM_TEXTURE_SWIZZLE4_RGBA,
	SCE_GXM_TEXTURE_FORMAT_F10F10F10U2_BGRA = SCE_GXM_TEXTURE_BASE_FORMAT_U2F10F10F10 | SCE_GXM_TEXTURE_SWIZZLE4_BGRA,
	SCE_GXM_TEXTURE_FORMAT_X2F10F10F10_1BGR = SCE_GXM_TEXTURE_BASE_FORMAT_U2F10F10F10 | SCE_GXM_TEXTURE_SWIZZLE4_1BGR,
	SCE_GXM_TEXTURE_FORMAT_X2F10F10F10_1RGB = SCE_GXM_TEXTURE_BASE_FORMAT_U2F10F10F10 | SCE_GXM_TEXTURE_SWIZZLE4_1RGB,
	SCE_GXM_TEXTURE_FORMAT_F10F10F10X2_RGB1 = SCE_GXM_TEXTURE_BASE_FORMAT_U2F10F10F10 | SCE_GXM_TEXTURE_SWIZZLE4_RGB1,
	SCE_GXM_TEXTURE_FORMAT_F10F10F10X2_BGR1 = SCE_GXM_TEXTURE_BASE_FORMAT_U2F10F10F10 | SCE_GXM_TEXTURE_SWIZZLE4_BGR1,

	// Legacy formats

	SCE_GXM_TEXTURE_FORMAT_L8 = SCE_GXM_TEXTURE_FORMAT_U8_1RRR,
	SCE_GXM_TEXTURE_FORMAT_A8 = SCE_GXM_TEXTURE_FORMAT_U8_R000,
	SCE_GXM_TEXTURE_FORMAT_R8 = SCE_GXM_TEXTURE_FORMAT_U8_000R,
	SCE_GXM_TEXTURE_FORMAT_A4R4G4B4 = SCE_GXM_TEXTURE_FORMAT_U4U4U4U4_ARGB,
	SCE_GXM_TEXTURE_FORMAT_A1R5G5B5 = SCE_GXM_TEXTURE_FORMAT_U1U5U5U5_ARGB,
	SCE_GXM_TEXTURE_FORMAT_R5G6B5 = SCE_GXM_TEXTURE_FORMAT_U5U6U5_RGB,
	SCE_GXM_TEXTURE_FORMAT_A8L8 = SCE_GXM_TEXTURE_FORMAT_U8U8_GRRR,
	SCE_GXM_TEXTURE_FORMAT_L8A8 = SCE_GXM_TEXTURE_FORMAT_U8U8_RGGG,
	SCE_GXM_TEXTURE_FORMAT_G8R8 = SCE_GXM_TEXTURE_FORMAT_U8U8_00GR,
	SCE_GXM_TEXTURE_FORMAT_L16 = SCE_GXM_TEXTURE_FORMAT_U16_1RRR,
	SCE_GXM_TEXTURE_FORMAT_A16 = SCE_GXM_TEXTURE_FORMAT_U16_R000,
	SCE_GXM_TEXTURE_FORMAT_R16 = SCE_GXM_TEXTURE_FORMAT_U16_000R,
	SCE_GXM_TEXTURE_FORMAT_D16 = SCE_GXM_TEXTURE_FORMAT_U16_R,
	SCE_GXM_TEXTURE_FORMAT_LF16 = SCE_GXM_TEXTURE_FORMAT_F16_1RRR,
	SCE_GXM_TEXTURE_FORMAT_AF16 = SCE_GXM_TEXTURE_FORMAT_F16_R000,
	SCE_GXM_TEXTURE_FORMAT_RF16 = SCE_GXM_TEXTURE_FORMAT_F16_000R,
	SCE_GXM_TEXTURE_FORMAT_A8R8G8B8 = SCE_GXM_TEXTURE_FORMAT_U8U8U8U8_ARGB,
	SCE_GXM_TEXTURE_FORMAT_A8B8G8R8 = SCE_GXM_TEXTURE_FORMAT_U8U8U8U8_ABGR,
	SCE_GXM_TEXTURE_FORMAT_AF16LF16 = SCE_GXM_TEXTURE_FORMAT_F16F16_GRRR,
	SCE_GXM_TEXTURE_FORMAT_LF16AF16 = SCE_GXM_TEXTURE_FORMAT_F16F16_RGGG,
	SCE_GXM_TEXTURE_FORMAT_GF16RF16 = SCE_GXM_TEXTURE_FORMAT_F16F16_00GR,
	SCE_GXM_TEXTURE_FORMAT_LF32M = SCE_GXM_TEXTURE_FORMAT_F32M_1RRR,
	SCE_GXM_TEXTURE_FORMAT_AF32M = SCE_GXM_TEXTURE_FORMAT_F32M_R000,
	SCE_GXM_TEXTURE_FORMAT_RF32M = SCE_GXM_TEXTURE_FORMAT_F32M_000R,
	SCE_GXM_TEXTURE_FORMAT_DF32M = SCE_GXM_TEXTURE_FORMAT_F32M_R,
	SCE_GXM_TEXTURE_FORMAT_VYUY = SCE_GXM_TEXTURE_FORMAT_VYUY422_CSC0,
	SCE_GXM_TEXTURE_FORMAT_YVYU = SCE_GXM_TEXTURE_FORMAT_YVYU422_CSC0,
	SCE_GXM_TEXTURE_FORMAT_UBC1 = SCE_GXM_TEXTURE_FORMAT_UBC1_ABGR,
	SCE_GXM_TEXTURE_FORMAT_UBC2 = SCE_GXM_TEXTURE_FORMAT_UBC2_ABGR,
	SCE_GXM_TEXTURE_FORMAT_UBC3 = SCE_GXM_TEXTURE_FORMAT_UBC3_ABGR,
	SCE_GXM_TEXTURE_FORMAT_PVRT2BPP = SCE_GXM_TEXTURE_FORMAT_PVRT2BPP_ABGR,
	SCE_GXM_TEXTURE_FORMAT_PVRT4BPP = SCE_GXM_TEXTURE_FORMAT_PVRT4BPP_ABGR,
	SCE_GXM_TEXTURE_FORMAT_PVRTII2BPP = SCE_GXM_TEXTURE_FORMAT_PVRTII2BPP_ABGR,
	SCE_GXM_TEXTURE_FORMAT_PVRTII4BPP = SCE_GXM_TEXTURE_FORMAT_PVRTII4BPP_ABGR
} SceGxmTextureFormat;

typedef enum SceGxmTextureAnisoMode {
	SCE_GXM_TEXTURE_ANISO_DISABLED	= 0x00000000u,
	SCE_GXM_TEXTURE_ANISO_ENABLED	= 0x00004000u
} SceGxmTextureAnisoMode;

typedef enum SceGxmTextureType {
	SCE_GXM_TEXTURE_SWIZZLED	= 0x00000000u,
	SCE_GXM_TEXTURE_CUBE		= 0x40000000u,
	SCE_GXM_TEXTURE_LINEAR		= 0x60000000u,
	SCE_GXM_TEXTURE_TILED		= 0x80000000u,
	SCE_GXM_TEXTURE_LINEAR_STRIDED	= 0xc0000000u
} SceGxmTextureType;

typedef enum SceGxmTextureFilter {
	SCE_GXM_TEXTURE_FILTER_POINT	= 0x00000000u,
	SCE_GXM_TEXTURE_FILTER_LINEAR	= 0x00000001u,
	SCE_GXM_TEXTURE_FILTER_ANISO_LINEAR	= 0x00000002u,
	SCE_GXM_TEXTURE_FILTER_ANISO_POINT	= 0x00000003u
} SceGxmTextureFilter;

typedef enum SceGxmTextureMipFilter {
	SCE_GXM_TEXTURE_MIP_FILTER_DISABLED	= 0x00000000u,
	SCE_GXM_TEXTURE_MIP_FILTER_ENABLED	= 0x00000200u
} SceGxmTextureMipFilter;

typedef enum SceGxmTextureAddrMode {
	SCE_GXM_TEXTURE_ADDR_REPEAT			= 0x00000000u,
	SCE_GXM_TEXTURE_ADDR_MIRROR			= 0x00000001u,
	SCE_GXM_TEXTURE_ADDR_CLAMP			= 0x00000002u,
	SCE_GXM_TEXTURE_ADDR_MIRROR_CLAMP		= 0x00000003u,
	SCE_GXM_TEXTURE_ADDR_REPEAT_IGNORE_BORDER	= 0x00000004u,
	SCE_GXM_TEXTURE_ADDR_CLAMP_FULL_BORDER		= 0x00000005u,
	SCE_GXM_TEXTURE_ADDR_CLAMP_IGNORE_BORDER	= 0x00000006u,
	SCE_GXM_TEXTURE_ADDR_CLAMP_HALF_BORDER		= 0x00000007u
} SceGxmTextureAddrMode;

typedef enum SceGxmTextureGammaMode {
	SCE_GXM_TEXTURE_GAMMA_NONE	= 0x00000000u,
	SCE_GXM_TEXTURE_GAMMA_R		= 0x08000000u,
	SCE_GXM_TEXTURE_GAMMA_GR	= 0x18000000u,
	SCE_GXM_TEXTURE_GAMMA_BGR	= 0x08000000u
} SceGxmTextureGammaMode;

typedef enum SceGxmIndexFormat {
	SCE_GXM_INDEX_FORMAT_U16	= 0x00000000u,
	SCE_GXM_INDEX_FORMAT_U32	= 0x01000000u
} SceGxmIndexFormat;

typedef enum SceGxmIndexSource {
	SCE_GXM_INDEX_SOURCE_INDEX_16BIT	= 0x00000000u,
	SCE_GXM_INDEX_SOURCE_INDEX_32BIT	= 0x00000001u,
	SCE_GXM_INDEX_SOURCE_INSTANCE_16BIT	= 0x00000002u,
	SCE_GXM_INDEX_SOURCE_INSTANCE_32BIT	= 0x00000003u
} SceGxmIndexSource;

typedef enum SceGxmFragmentProgramMode {
	SCE_GXM_FRAGMENT_PROGRAM_DISABLED	= 0x00200000u,
	SCE_GXM_FRAGMENT_PROGRAM_ENABLED	= 0x00000000u
} SceGxmFragmentProgramMode;

typedef enum SceGxmDepthWriteMode {
	SCE_GXM_DEPTH_WRITE_DISABLED	= 0x00100000u,
	SCE_GXM_DEPTH_WRITE_ENABLED	= 0x00000000u
} SceGxmDepthWriteMode;

typedef enum SceGxmLineFillLastPixelMode {
	SCE_GXM_LINE_FILL_LAST_PIXEL_DISABLED	= 0x00000000u,
	SCE_GXM_LINE_FILL_LAST_PIXEL_ENABLED	= 0x00080000u
} SceGxmLineFillLastPixelMode;

typedef enum SceGxmTwoSidedMode {
	SCE_GXM_TWO_SIDED_DISABLED	= 0x00000000u,
	SCE_GXM_TWO_SIDED_ENABLED	= 0x00000800u
} SceGxmTwoSidedMode;

typedef enum SceGxmWClampMode {
	SCE_GXM_WCLAMP_MODE_DISABLED	= 0x00000000u,
	SCE_GXM_WCLAMP_MODE_ENABLED	= 0x00008000u
} SceGxmWClampMode;

typedef enum SceGxmViewportMode {
	SCE_GXM_VIEWPORT_DISABLED	= 0x00010000u,
	SCE_GXM_VIEWPORT_ENABLED	= 0x00000000u
} SceGxmViewportMode;

typedef enum SceGxmWBufferMode {
	SCE_GXM_WBUFFER_DISABLED	= 0x00000000u,
	SCE_GXM_WBUFFER_ENABLED		= 0x00004000u
} SceGxmWBufferMode;

typedef enum SceGxmDepthStencilForceLoadMode {
	SCE_GXM_DEPTH_STENCIL_FORCE_LOAD_DISABLED	= 0x00000000u,
	SCE_GXM_DEPTH_STENCIL_FORCE_LOAD_ENABLED	= 0x00000002u
} SceGxmDepthStencilForceLoadMode;

typedef enum SceGxmDepthStencilForceStoreMode {
	SCE_GXM_DEPTH_STENCIL_FORCE_STORE_DISABLED	= 0x00000000u,
	SCE_GXM_DEPTH_STENCIL_FORCE_STORE_ENABLED	= 0x00000004u
} SceGxmDepthStencilForceStoreMode;

typedef enum SceGxmSceneFlags {
	SCE_GXM_SCENE_FRAGMENT_SET_DEPENDENCY		= 0x00000001u,
	SCE_GXM_SCENE_VERTEX_WAIT_FOR_DEPENDENCY	= 0x00000002u
} SceGxmSceneFlags;

typedef enum SceGxmMidSceneFlags {
	SCE_GXM_MIDSCENE_PRESERVE_DEFAULT_UNIFORM_BUFFERS	= 0x00000001u
} SceGxmMidSceneFlags;

typedef enum SceGxmColorSurfaceScaleMode {
	SCE_GXM_COLOR_SURFACE_SCALE_NONE		= 0x00000000u,
	SCE_GXM_COLOR_SURFACE_SCALE_MSAA_DOWNSCALE	= 0x00000001u
} SceGxmColorSurfaceScaleMode;

typedef enum SceGxmOutputRegisterSize {
	SCE_GXM_OUTPUT_REGISTER_SIZE_32BIT	= 0x00000000u,
	SCE_GXM_OUTPUT_REGISTER_SIZE_64BIT	= 0x00000001u
} SceGxmOutputRegisterSize;

typedef enum SceGxmVisibilityTestMode {
	SCE_GXM_VISIBILITY_TEST_DISABLED	= 0x00000000u,
	SCE_GXM_VISIBILITY_TEST_ENABLED		= 0x00004000u
} SceGxmVisibilityTestMode;

typedef enum SceGxmVisibilityTestOp {
	SCE_GXM_VISIBILITY_TEST_OP_INCREMENT	= 0x00000000u,
	SCE_GXM_VISIBILITY_TEST_OP_SET		= 0x00040000u
} SceGxmVisibilityTestOp;

typedef enum SceGxmBlendFunc {
	SCE_GXM_BLEND_FUNC_NONE,
	SCE_GXM_BLEND_FUNC_ADD,
	SCE_GXM_BLEND_FUNC_SUBTRACT,
	SCE_GXM_BLEND_FUNC_REVERSE_SUBTRACT
} SceGxmBlendFunc;

typedef enum SceGxmBlendFactor {
	SCE_GXM_BLEND_FACTOR_ZERO,
	SCE_GXM_BLEND_FACTOR_ONE,
	SCE_GXM_BLEND_FACTOR_SRC_COLOR,
	SCE_GXM_BLEND_FACTOR_ONE_MINUS_SRC_COLOR,
	SCE_GXM_BLEND_FACTOR_SRC_ALPHA,
	SCE_GXM_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA,
	SCE_GXM_BLEND_FACTOR_DST_COLOR,
	SCE_GXM_BLEND_FACTOR_ONE_MINUS_DST_COLOR,
	SCE_GXM_BLEND_FACTOR_DST_ALPHA,
	SCE_GXM_BLEND_FACTOR_ONE_MINUS_DST_ALPHA,
	SCE_GXM_BLEND_FACTOR_SRC_ALPHA_SATURATE,
	SCE_GXM_BLEND_FACTOR_DST_ALPHA_SATURATE
} SceGxmBlendFactor;

typedef enum SceGxmColorMask {
	SCE_GXM_COLOR_MASK_NONE	= 0,
	SCE_GXM_COLOR_MASK_A	= (1 << 0),
	SCE_GXM_COLOR_MASK_R	= (1 << 1),
	SCE_GXM_COLOR_MASK_G	= (1 << 2),
	SCE_GXM_COLOR_MASK_B	= (1 << 3),
	SCE_GXM_COLOR_MASK_ALL	= (SCE_GXM_COLOR_MASK_A | SCE_GXM_COLOR_MASK_B | SCE_GXM_COLOR_MASK_G | SCE_GXM_COLOR_MASK_R)
} SceGxmColorMask;

typedef struct SceGxmBlendInfo {
	SceGxmColorMask colorMask;
	SceGxmBlendFunc colorFunc : 4;
	SceGxmBlendFunc alphaFunc : 4;
	SceGxmBlendFactor colorSrc : 4;
	SceGxmBlendFactor colorDst : 4;
	SceGxmBlendFactor alphaSrc : 4;
	SceGxmBlendFactor alphaDst : 4;
} SceGxmBlendInfo;

typedef struct SceGxmRenderTarget SceGxmRenderTarget;

typedef struct SceGxmSyncObject SceGxmSyncObject;

typedef struct SceGxmVertexAttribute {
	unsigned short streamIndex;
	unsigned short offset;
	SceGxmAttributeFormat format;
	unsigned char componentCount;
	unsigned short regIndex;
} SceGxmVertexAttribute;

typedef struct SceGxmVertexStream {
	unsigned short stride;
	unsigned short indexSource;
} SceGxmVertexStream;

typedef struct SceGxmTexture {
	unsigned int controlWords[4];
} SceGxmTexture;

typedef struct SceGxmColorSurface {
	unsigned int pbeSidebandWord;
	unsigned int pbeEmitWords[6];
	unsigned int outputRegisterSize;
	SceGxmTexture backgroundTex;
} SceGxmColorSurface;

typedef struct SceGxmDepthStencilSurface {
	unsigned int zlsControl;
	void *depthData;
	void *stencilData;
	float backgroundDepth;
	unsigned int backgroundControl;
} SceGxmDepthStencilSurface;

//! Represents an auxiliary surface
typedef struct SceGxmAuxiliarySurface {
	uint32_t colorFormat; //!< Format of auxiliary surface data from SceGxmColorFormat
	uint32_t type; //!< Memory layout of the surface data from SceGxmColorSurfaceType
	uint32_t width; //!< Surface width
	uint32_t height; //!< Surface height
	uint32_t stride; //!< Surface stride in bytes
	void *data; //!< A pointer to the surface data
} SceGxmAuxiliarySurface;

typedef struct SceGxmNotification {
	volatile unsigned int *address;
	unsigned int value;
} SceGxmNotification;

typedef struct SceGxmValidRegion {
	unsigned int xMin;
	unsigned int yMin;
	unsigned int xMax;
	unsigned int yMax;
} SceGxmValidRegion;

typedef struct SceGxmContext SceGxmContext;

enum {
	SCE_GXM_MINIMUM_CONTEXT_HOST_MEM_SIZE		= (2 * 1024),
	SCE_GXM_DEFAULT_PARAMETER_BUFFER_SIZE           = (16 * 1024 * 1024),
	SCE_GXM_DEFAULT_VDM_RING_BUFFER_SIZE		= (128 * 1024),
	SCE_GXM_DEFAULT_VERTEX_RING_BUFFER_SIZE		= (2 * 1024 * 1024),
	SCE_GXM_DEFAULT_FRAGMENT_RING_BUFFER_SIZE	= (512 * 1024),
	SCE_GXM_DEFAULT_FRAGMENT_USSE_RING_BUFFER_SIZE	= (16 * 1024),
};

typedef struct SceGxmContextParams {
	void *hostMem;
	SceSize hostMemSize;
	void *vdmRingBufferMem;
	SceSize vdmRingBufferMemSize;
	void *vertexRingBufferMem;
	SceSize vertexRingBufferMemSize;
	void *fragmentRingBufferMem;
	SceSize fragmentRingBufferMemSize;
	void *fragmentUsseRingBufferMem;
	SceSize fragmentUsseRingBufferMemSize;
	unsigned int fragmentUsseRingBufferOffset;
} SceGxmContextParams;

typedef struct SceGxmVertexProgram SceGxmVertexProgram;

typedef struct SceGxmFragmentProgram SceGxmFragmentProgram;

enum {
	SCE_GXM_PRECOMPUTED_VERTEX_STATE_WORD_COUNT   = 7,
	SCE_GXM_PRECOMPUTED_FRAGMENT_STATE_WORD_COUNT = 9,
	SCE_GXM_PRECOMPUTED_DRAW_WORD_COUNT           = 11,
};

typedef struct SceGxmPrecomputedVertexState {
	unsigned int data[SCE_GXM_PRECOMPUTED_VERTEX_STATE_WORD_COUNT];
} SceGxmPrecomputedVertexState;

typedef struct SceGxmPrecomputedFragmentState {
	unsigned int data[SCE_GXM_PRECOMPUTED_FRAGMENT_STATE_WORD_COUNT];
} SceGxmPrecomputedFragmentState;

typedef struct SceGxmPrecomputedDraw {
	unsigned int data[SCE_GXM_PRECOMPUTED_DRAW_WORD_COUNT];
} SceGxmPrecomputedDraw;

enum {
	SCE_GXM_MAX_VERTEX_ATTRIBUTES  = 16,
	SCE_GXM_MAX_VERTEX_STREAMS     = 4,
	SCE_GXM_MAX_TEXTURE_UNITS      = 16,
	SCE_GXM_MAX_UNIFORM_BUFFERS    = 8,
	SCE_GXM_MAX_AUXILIARY_SURFACES = 3,
};

enum {
	SCE_GXM_TILE_SHIFTX = 5U,
	SCE_GXM_TILE_SHIFTY = 5U,
	SCE_GXM_TILE_SIZEX  = (1U << SCE_GXM_TILE_SHIFTX),
	SCE_GXM_TILE_SIZEY  = (1U << SCE_GXM_TILE_SHIFTY),
};

enum {
	SCE_GXM_COLOR_SURFACE_ALIGNMENT        = 4U,
	SCE_GXM_TEXTURE_ALIGNMENT              = 16U,
	SCE_GXM_DEPTHSTENCIL_SURFACE_ALIGNMENT = 16U,
	SCE_GXM_PALETTE_ALIGNMENT              = 64U,
};

typedef struct SceGxmProgram SceGxmProgram;

typedef struct SceGxmProgramParameter SceGxmProgramParameter;

typedef enum SceGxmProgramType {
	SCE_GXM_VERTEX_PROGRAM,
	SCE_GXM_FRAGMENT_PROGRAM
} SceGxmProgramType;

typedef enum SceGxmParameterCategory {
	SCE_GXM_PARAMETER_CATEGORY_ATTRIBUTE,
	SCE_GXM_PARAMETER_CATEGORY_UNIFORM,
	SCE_GXM_PARAMETER_CATEGORY_SAMPLER,
	SCE_GXM_PARAMETER_CATEGORY_AUXILIARY_SURFACE,
	SCE_GXM_PARAMETER_CATEGORY_UNIFORM_BUFFER
} SceGxmParameterCategory;

typedef enum SceGxmParameterType {
	SCE_GXM_PARAMETER_TYPE_F32,
	SCE_GXM_PARAMETER_TYPE_F16,
	SCE_GXM_PARAMETER_TYPE_C10,
	SCE_GXM_PARAMETER_TYPE_U32,
	SCE_GXM_PARAMETER_TYPE_S32,
	SCE_GXM_PARAMETER_TYPE_U16,
	SCE_GXM_PARAMETER_TYPE_S16,
	SCE_GXM_PARAMETER_TYPE_U8,
	SCE_GXM_PARAMETER_TYPE_S8,
	SCE_GXM_PARAMETER_TYPE_AGGREGATE
} SceGxmParameterType;

typedef enum SceGxmParameterSemantic {
	SCE_GXM_PARAMETER_SEMANTIC_NONE,
	SCE_GXM_PARAMETER_SEMANTIC_ATTR,
	SCE_GXM_PARAMETER_SEMANTIC_BCOL,
	SCE_GXM_PARAMETER_SEMANTIC_BINORMAL,
	SCE_GXM_PARAMETER_SEMANTIC_BLENDINDICES,
	SCE_GXM_PARAMETER_SEMANTIC_BLENDWEIGHT,
	SCE_GXM_PARAMETER_SEMANTIC_COLOR,
	SCE_GXM_PARAMETER_SEMANTIC_DIFFUSE,
	SCE_GXM_PARAMETER_SEMANTIC_FOGCOORD,
	SCE_GXM_PARAMETER_SEMANTIC_NORMAL,
	SCE_GXM_PARAMETER_SEMANTIC_POINTSIZE,
	SCE_GXM_PARAMETER_SEMANTIC_POSITION,
	SCE_GXM_PARAMETER_SEMANTIC_SPECULAR,
	SCE_GXM_PARAMETER_SEMANTIC_TANGENT,
	SCE_GXM_PARAMETER_SEMANTIC_TEXCOORD
} SceGxmParameterSemantic;

typedef struct SceGxmShaderPatcher SceGxmShaderPatcher;

typedef struct SceGxmRegisteredProgram SceGxmRegisteredProgram;

typedef SceGxmRegisteredProgram *SceGxmShaderPatcherId;

typedef void *(SceGxmShaderPatcherHostAllocCallback)(void *userData, SceSize size);
typedef void (SceGxmShaderPatcherHostFreeCallback)(void *userData, void *mem);
typedef void *(SceGxmShaderPatcherBufferAllocCallback)(void *userData, SceSize size);
typedef void (SceGxmShaderPatcherBufferFreeCallback)(void *userData, void *mem);
typedef void *(SceGxmShaderPatcherUsseAllocCallback)(void *userData, SceSize size, unsigned int *usseOffset);
typedef void (SceGxmShaderPatcherUsseFreeCallback)(void *userData, void *mem);

typedef struct SceGxmShaderPatcherParams {
	void *userData;
	SceGxmShaderPatcherHostAllocCallback *hostAllocCallback;
	SceGxmShaderPatcherHostFreeCallback *hostFreeCallback;
	SceGxmShaderPatcherBufferAllocCallback *bufferAllocCallback;
	SceGxmShaderPatcherBufferFreeCallback *bufferFreeCallback;
	void *bufferMem;
	SceSize bufferMemSize;
	SceGxmShaderPatcherUsseAllocCallback *vertexUsseAllocCallback;
	SceGxmShaderPatcherUsseFreeCallback *vertexUsseFreeCallback;
	void *vertexUsseMem;
	SceSize vertexUsseMemSize;
	unsigned int vertexUsseOffset;
	SceGxmShaderPatcherUsseAllocCallback *fragmentUsseAllocCallback;
	SceGxmShaderPatcherUsseFreeCallback *fragmentUsseFreeCallback;
	void *fragmentUsseMem;
	SceSize fragmentUsseMemSize;
	unsigned int fragmentUsseOffset;
} SceGxmShaderPatcherParams;

typedef enum SceGxmRenderTargetFlags {
	SCE_GXM_RENDER_TARGET_CUSTOM_MULTISAMPLE_LOCATIONS = (1 << 0),
} SceGxmRenderTargetFlags;

typedef struct SceGxmRenderTargetParams {
	uint32_t flags;	                //!< Bitwise combined flags from #SceGxmRenderTargetFlags.
	uint16_t width;	                //!< The width of the render target in pixels.
	uint16_t height;                //!< The height of the render target in pixels.
	uint16_t scenesPerFrame;        //!< The expected number of scenes per frame, in the range [1,#SCE_GXM_MAX_SCENES_PER_RENDERTARGET].
	uint16_t multisampleMode;       //!< A value from the #SceGxmMultisampleMode enum.
	uint32_t multisampleLocations;  //!< If enabled in the flags, the multisample locations to use.
	SceUID driverMemBlock;          //!< The uncached LPDDR memblock for the render target GPU data structures or SCE_UID_INVALID_UID to specify memory should be allocated in libgxm.
} SceGxmRenderTargetParams;

/* prototypes */

int sceGxmInitialize(const SceGxmInitializeParams *params);
int sceGxmTerminate();

volatile unsigned int *sceGxmGetNotificationRegion();
int sceGxmNotificationWait(const SceGxmNotification *notification);

int sceGxmMapMemory(void *base, SceSize size, SceGxmMemoryAttribFlags attr);
int sceGxmUnmapMemory(void *base);

int sceGxmMapVertexUsseMemory(void *base, SceSize size, unsigned int *offset);
int sceGxmUnmapVertexUsseMemory(void *base);

int sceGxmMapFragmentUsseMemory(void *base, SceSize size, unsigned int *offset);
int sceGxmUnmapFragmentUsseMemory(void *base);

int sceGxmDisplayQueueAddEntry(SceGxmSyncObject *oldBuffer, SceGxmSyncObject *newBuffer, const void *callbackData);
int sceGxmDisplayQueueFinish();

int sceGxmSyncObjectCreate(SceGxmSyncObject **syncObject);
int sceGxmSyncObjectDestroy(SceGxmSyncObject *syncObject);

int sceGxmCreateContext(const SceGxmContextParams *params, SceGxmContext **context);
int sceGxmDestroyContext(SceGxmContext *context);

void sceGxmSetValidationEnable(SceGxmContext *context, SceBool enable);

void sceGxmSetVertexProgram(SceGxmContext *context, const SceGxmVertexProgram *vertexProgram);
void sceGxmSetFragmentProgram(SceGxmContext *context, const SceGxmFragmentProgram *fragmentProgram);

int sceGxmReserveVertexDefaultUniformBuffer(SceGxmContext *context, void **uniformBuffer);
int sceGxmReserveFragmentDefaultUniformBuffer(SceGxmContext *context, void **uniformBuffer);

int sceGxmSetVertexStream(SceGxmContext *context, unsigned int streamIndex, const void *streamData);
int sceGxmSetVertexTexture(SceGxmContext *context, unsigned int textureIndex, const SceGxmTexture *texture);
int sceGxmSetFragmentTexture(SceGxmContext *context, unsigned int textureIndex, const SceGxmTexture *texture);
int sceGxmSetVertexUniformBuffer(SceGxmContext *context, unsigned int bufferIndex, const void *bufferData);
int sceGxmSetFragmentUniformBuffer(SceGxmContext *context, unsigned int bufferIndex, const void *bufferData);
int sceGxmSetAuxiliarySurface(SceGxmContext *context, unsigned int surfaceIndex, const SceGxmAuxiliarySurface *surface);

void sceGxmSetPrecomputedFragmentState(SceGxmContext *context, const SceGxmPrecomputedFragmentState *precomputedState);
void sceGxmSetPrecomputedVertexState(SceGxmContext *context, const SceGxmPrecomputedVertexState *precomputedState);

int sceGxmDrawPrecomputed(SceGxmContext *context, const SceGxmPrecomputedDraw *precomputedDraw);
int sceGxmDraw(SceGxmContext *context, SceGxmPrimitiveType primType, SceGxmIndexFormat indexType, const void *indexData, unsigned int indexCount);
int sceGxmDrawInstanced(SceGxmContext *context, SceGxmPrimitiveType primType, SceGxmIndexFormat indexType, const void *indexData, unsigned int indexCount, unsigned int indexWrap);
int sceGxmSetVisibilityBuffer(SceGxmContext *context, void *bufferBase, unsigned int stridePerCore);

int sceGxmBeginScene(SceGxmContext *context, unsigned int flags, const SceGxmRenderTarget *renderTarget, const SceGxmValidRegion *validRegion, SceGxmSyncObject *vertexSyncObject, SceGxmSyncObject *fragmentSyncObject, const SceGxmColorSurface *colorSurface, const SceGxmDepthStencilSurface *depthStencil);
int sceGxmMidSceneFlush(SceGxmContext *context, unsigned int flags, SceGxmSyncObject *vertexSyncObject, const SceGxmNotification *vertexNotification);
int sceGxmEndScene(SceGxmContext *context, const SceGxmNotification *vertexNotification, const SceGxmNotification *fragmentNotification);

void sceGxmSetFrontDepthFunc(SceGxmContext *context, SceGxmDepthFunc depthFunc);
void sceGxmSetBackDepthFunc(SceGxmContext *context, SceGxmDepthFunc depthFunc);
void sceGxmSetFrontFragmentProgramEnable(SceGxmContext *context, SceGxmFragmentProgramMode enable);
void sceGxmSetBackFragmentProgramEnable(SceGxmContext *context, SceGxmFragmentProgramMode enable);
void sceGxmSetFrontDepthWriteEnable(SceGxmContext *context, SceGxmDepthWriteMode enable);
void sceGxmSetBackDepthWriteEnable(SceGxmContext *context, SceGxmDepthWriteMode enable);
void sceGxmSetFrontLineFillLastPixelEnable(SceGxmContext *context, SceGxmLineFillLastPixelMode enable);
void sceGxmSetBackLineFillLastPixelEnable(SceGxmContext *context, SceGxmLineFillLastPixelMode enable);
void sceGxmSetFrontStencilRef(SceGxmContext *context, unsigned int sref);
void sceGxmSetBackStencilRef(SceGxmContext *context, unsigned int sref);
void sceGxmSetFrontPointLineWidth(SceGxmContext *context, unsigned int width);
void sceGxmSetBackPointLineWidth(SceGxmContext *context, unsigned int width);
void sceGxmSetFrontPolygonMode(SceGxmContext *context, SceGxmPolygonMode mode);
void sceGxmSetBackPolygonMode(SceGxmContext *context, SceGxmPolygonMode mode);
void sceGxmSetFrontStencilFunc(SceGxmContext *context, SceGxmStencilFunc func, SceGxmStencilOp stencilFail, SceGxmStencilOp depthFail, SceGxmStencilOp depthPass, unsigned char compareMask, unsigned char writeMask);
void sceGxmSetBackStencilFunc(SceGxmContext *context, SceGxmStencilFunc func, SceGxmStencilOp stencilFail, SceGxmStencilOp depthFail, SceGxmStencilOp depthPass, unsigned char compareMask, unsigned char writeMask);
void sceGxmSetFrontDepthBias(SceGxmContext *context, int factor, int units);
void sceGxmSetBackDepthBias(SceGxmContext *context, int factor, int units);
void sceGxmSetTwoSidedEnable(SceGxmContext *context, SceGxmTwoSidedMode enable);
void sceGxmSetViewport(SceGxmContext *context, float xOffset, float xScale, float yOffset, float yScale, float zOffset, float zScale);
void sceGxmSetWClampValue(SceGxmContext *context, float clampValue);
void sceGxmSetWClampEnable(SceGxmContext *context, SceGxmWClampMode enable);
void sceGxmSetRegionClip(SceGxmContext *context, SceGxmRegionClipMode mode, unsigned int xMin, unsigned int yMin, unsigned int xMax, unsigned int yMax);
void sceGxmSetCullMode(SceGxmContext *context, SceGxmCullMode mode);
void sceGxmSetViewportEnable(SceGxmContext *context, SceGxmViewportMode enable);
void sceGxmSetWBufferEnable(SceGxmContext *context, SceGxmWBufferMode enable);
void sceGxmSetFrontVisibilityTestIndex(SceGxmContext *context, unsigned int index);
void sceGxmSetBackVisibilityTestIndex(SceGxmContext *context, unsigned int index);
void sceGxmSetFrontVisibilityTestOp(SceGxmContext *context, SceGxmVisibilityTestOp op);
void sceGxmSetBackVisibilityTestOp(SceGxmContext *context, SceGxmVisibilityTestOp op);
void sceGxmSetFrontVisibilityTestEnable(SceGxmContext *context, SceGxmVisibilityTestMode enable);
void sceGxmSetBackVisibilityTestEnable(SceGxmContext *context, SceGxmVisibilityTestMode enable);

void sceGxmFinish(SceGxmContext *context);

int sceGxmPushUserMarker(SceGxmContext *context, const char *tag);
int sceGxmPopUserMarker(SceGxmContext *context);
int sceGxmSetUserMarker(SceGxmContext *context, const char *tag);

int sceGxmPadHeartbeat(const SceGxmColorSurface *displaySurface, SceGxmSyncObject *displaySyncObject);

int sceGxmPadTriggerGpuPaTrace();

int sceGxmColorSurfaceInit(SceGxmColorSurface *surface, SceGxmColorFormat colorFormat, SceGxmColorSurfaceType surfaceType, SceGxmColorSurfaceScaleMode scaleMode, SceGxmOutputRegisterSize outputRegisterSize, unsigned int width, unsigned int height, unsigned int strideInPixels, void *data);
int sceGxmColorSurfaceInitDisabled(SceGxmColorSurface *surface);
SceBool sceGxmColorSurfaceIsEnabled(const SceGxmColorSurface *surface);
void sceGxmColorSurfaceGetClip(const SceGxmColorSurface *surface, unsigned int *xMin, unsigned int *yMin, unsigned int *xMax, unsigned int *yMax);
void sceGxmColorSurfaceSetClip(SceGxmColorSurface *surface, unsigned int xMin, unsigned int yMin, unsigned int xMax, unsigned int yMax);

SceGxmColorSurfaceScaleMode sceGxmColorSurfaceGetScaleMode(const SceGxmColorSurface *surface);
void sceGxmColorSurfaceSetScaleMode(SceGxmColorSurface *surface, SceGxmColorSurfaceScaleMode scaleMode);

void *sceGxmColorSurfaceGetData(const SceGxmColorSurface *surface);
int sceGxmColorSurfaceSetData(SceGxmColorSurface *surface, void *data);

SceGxmColorFormat sceGxmColorSurfaceGetFormat(const SceGxmColorSurface *surface);
int sceGxmColorSurfaceSetFormat(SceGxmColorSurface *surface, SceGxmColorFormat format);
SceGxmColorSurfaceType sceGxmColorSurfaceGetType(const SceGxmColorSurface *surface);
unsigned int sceGxmColorSurfaceGetStrideInPixels(const SceGxmColorSurface *surface);

int sceGxmDepthStencilSurfaceInit(SceGxmDepthStencilSurface *surface, SceGxmDepthStencilFormat depthStencilFormat, SceGxmDepthStencilSurfaceType surfaceType, unsigned int strideInSamples, void *depthData, void *stencilData);
int sceGxmDepthStencilSurfaceInitDisabled(SceGxmDepthStencilSurface *surface);
float sceGxmDepthStencilSurfaceGetBackgroundDepth(const SceGxmDepthStencilSurface *surface);
void sceGxmDepthStencilSurfaceSetBackgroundDepth(SceGxmDepthStencilSurface *surface, float backgroundDepth);
unsigned char sceGxmDepthStencilSurfaceGetBackgroundStencil(const SceGxmDepthStencilSurface *surface);
void sceGxmDepthStencilSurfaceSetBackgroundStencil(SceGxmDepthStencilSurface *surface, unsigned char backgroundStencil);
SceBool sceGxmDepthStencilSurfaceIsEnabled(const SceGxmDepthStencilSurface *surface);
void sceGxmDepthStencilSurfaceSetForceLoadMode(SceGxmDepthStencilSurface *surface, SceGxmDepthStencilForceLoadMode forceLoad);
SceGxmDepthStencilForceLoadMode sceGxmDepthStencilSurfaceGetForceLoadMode(const SceGxmDepthStencilSurface *surface);
void sceGxmDepthStencilSurfaceSetForceStoreMode(SceGxmDepthStencilSurface *surface, SceGxmDepthStencilForceStoreMode forceStore);
SceGxmDepthStencilForceStoreMode sceGxmDepthStencilSurfaceGetForceStoreMode(const SceGxmDepthStencilSurface *surface);

SceGxmColorSurfaceGammaMode sceGxmColorSurfaceGetGammaMode(const SceGxmColorSurface *surface);
int sceGxmColorSurfaceSetGammaMode(SceGxmColorSurface *surface, SceGxmColorSurfaceGammaMode gammaMode);
SceGxmColorSurfaceDitherMode sceGxmColorSurfaceGetDitherMode(const SceGxmColorSurface *surface);
int sceGxmColorSurfaceSetDitherMode(SceGxmColorSurface *surface, SceGxmColorSurfaceDitherMode ditherMode);

SceGxmDepthStencilFormat sceGxmDepthStencilSurfaceGetFormat(const SceGxmDepthStencilSurface *surface);
unsigned int sceGxmDepthStencilSurfaceGetStrideInSamples(const SceGxmDepthStencilSurface *surface);

int sceGxmProgramCheck(const SceGxmProgram *program);
unsigned int sceGxmProgramGetSize(const SceGxmProgram *program);
SceGxmProgramType sceGxmProgramGetType(const SceGxmProgram *program);
SceBool sceGxmProgramIsDiscardUsed(const SceGxmProgram *program);
SceBool sceGxmProgramIsDepthReplaceUsed(const SceGxmProgram *program);
SceBool sceGxmProgramIsSpriteCoordUsed(const SceGxmProgram *program);
unsigned int sceGxmProgramGetDefaultUniformBufferSize(const SceGxmProgram *program);
unsigned int sceGxmProgramGetParameterCount(const SceGxmProgram *program);

const SceGxmProgramParameter *sceGxmProgramGetParameter(const SceGxmProgram *program, unsigned int index);
const SceGxmProgramParameter *sceGxmProgramFindParameterByName(const SceGxmProgram *program, const char *name);
const SceGxmProgramParameter *sceGxmProgramFindParameterBySemantic(const SceGxmProgram *program, SceGxmParameterSemantic semantic, unsigned int index);
unsigned int sceGxmProgramParameterGetIndex(const SceGxmProgram *program, const SceGxmProgramParameter *parameter);
SceGxmParameterCategory sceGxmProgramParameterGetCategory(const SceGxmProgramParameter *parameter);
const char *sceGxmProgramParameterGetName(const SceGxmProgramParameter *parameter);
SceGxmParameterSemantic sceGxmProgramParameterGetSemantic(const SceGxmProgramParameter *parameter);
unsigned int sceGxmProgramParameterGetSemanticIndex(const SceGxmProgramParameter *parameter);
SceGxmParameterType sceGxmProgramParameterGetType(const SceGxmProgramParameter *parameter);
unsigned int sceGxmProgramParameterGetComponentCount(const SceGxmProgramParameter *parameter);
unsigned int sceGxmProgramParameterGetArraySize(const SceGxmProgramParameter *parameter);
unsigned int sceGxmProgramParameterGetResourceIndex(const SceGxmProgramParameter *parameter);
unsigned int sceGxmProgramParameterGetContainerIndex(const SceGxmProgramParameter *parameter);
SceBool sceGxmProgramParameterIsSamplerCube(const SceGxmProgramParameter *parameter);

const SceGxmProgram *sceGxmFragmentProgramGetProgram(const SceGxmFragmentProgram *fragmentProgram);
const SceGxmProgram *sceGxmVertexProgramGetProgram(const SceGxmVertexProgram *vertexProgram);

int sceGxmShaderPatcherCreate(const SceGxmShaderPatcherParams *params, SceGxmShaderPatcher **shaderPatcher);
int sceGxmShaderPatcherSetUserData(SceGxmShaderPatcher *shaderPatcher, void *userData);
void *sceGxmShaderPatcherGetUserData(SceGxmShaderPatcher *shaderPatcher);
int sceGxmShaderPatcherDestroy(SceGxmShaderPatcher *shaderPatcher);
int sceGxmShaderPatcherRegisterProgram(SceGxmShaderPatcher *shaderPatcher, const SceGxmProgram *programHeader, SceGxmShaderPatcherId *programId);
int sceGxmShaderPatcherUnregisterProgram(SceGxmShaderPatcher *shaderPatcher, SceGxmShaderPatcherId programId);
const SceGxmProgram *sceGxmShaderPatcherGetProgramFromId(SceGxmShaderPatcherId programId);
int sceGxmShaderPatcherSetAuxiliarySurface(SceGxmShaderPatcher *shaderPatcher, unsigned int auxSurfaceIndex, const SceGxmAuxiliarySurface *auxSurface);
int sceGxmShaderPatcherCreateVertexProgram(SceGxmShaderPatcher *shaderPatcher, SceGxmShaderPatcherId programId, const SceGxmVertexAttribute *attributes, unsigned int attributeCount, const SceGxmVertexStream *streams, unsigned int streamCount, SceGxmVertexProgram **vertexProgram);
int sceGxmShaderPatcherCreateFragmentProgram(SceGxmShaderPatcher *shaderPatcher, SceGxmShaderPatcherId programId, SceGxmOutputRegisterFormat outputFormat, SceGxmMultisampleMode multisampleMode, const SceGxmBlendInfo *blendInfo, const SceGxmProgram *vertexProgram, SceGxmFragmentProgram **fragmentProgram);
int sceGxmShaderPatcherAddRefVertexProgram(SceGxmShaderPatcher *shaderPatcher, SceGxmVertexProgram *vertexProgram);
int sceGxmShaderPatcherAddRefFragmentProgram(SceGxmShaderPatcher *shaderPatcher, SceGxmFragmentProgram *fragmentProgram);
int sceGxmShaderPatcherReleaseVertexProgram(SceGxmShaderPatcher *shaderPatcher, SceGxmVertexProgram *vertexProgram);
int sceGxmShaderPatcherReleaseFragmentProgram(SceGxmShaderPatcher *shaderPatcher, SceGxmFragmentProgram *fragmentProgram);
unsigned int sceGxmShaderPatcherGetHostMemAllocated(const SceGxmShaderPatcher *shaderPatcher);
unsigned int sceGxmShaderPatcherGetBufferMemAllocated(const SceGxmShaderPatcher *shaderPatcher);
unsigned int sceGxmShaderPatcherGetVertexUsseMemAllocated(const SceGxmShaderPatcher *shaderPatcher);
unsigned int sceGxmShaderPatcherGetFragmentUsseMemAllocated(const SceGxmShaderPatcher *shaderPatcher);

int sceGxmTextureInitSwizzled(SceGxmTexture *texture, const void *data, SceGxmTextureFormat texFormat, unsigned int width, unsigned int height, unsigned int mipCount);
int sceGxmTextureInitLinear(SceGxmTexture *texture, const void *data, SceGxmTextureFormat texFormat, unsigned int width, unsigned int height, unsigned int mipCount);
int sceGxmTextureInitLinearStrided(SceGxmTexture *texture, const void *data, SceGxmTextureFormat texFormat, unsigned int width, unsigned int height, unsigned int byteStride);
int sceGxmTextureInitTiled(SceGxmTexture *texture, const void *data, SceGxmTextureFormat texFormat, unsigned int width, unsigned int height, unsigned int mipCount);
int sceGxmTextureInitCube(SceGxmTexture *texture, const void *data, SceGxmTextureFormat texFormat, unsigned int width, unsigned int height, unsigned int mipCount);

SceGxmTextureType sceGxmTextureGetType(const SceGxmTexture *texture);

int sceGxmTextureSetMinFilter(SceGxmTexture *texture, SceGxmTextureFilter minFilter);
SceGxmTextureFilter sceGxmTextureGetMinFilter(const SceGxmTexture *texture);

int sceGxmTextureSetMagFilter(SceGxmTexture *texture, SceGxmTextureFilter magFilter);
SceGxmTextureFilter sceGxmTextureGetMagFilter(const SceGxmTexture *texture);

int sceGxmTextureSetMipFilter(SceGxmTexture *texture, SceGxmTextureMipFilter mipFilter);
SceGxmTextureMipFilter sceGxmTextureGetMipFilter(const SceGxmTexture *texture);

int sceGxmTextureSetAnisoMode(SceGxmTexture *texture, SceGxmTextureAnisoMode anisoMode);
SceGxmTextureAnisoMode sceGxmTextureGetAnisoMode(const SceGxmTexture *texture);

int sceGxmTextureSetUAddrMode(SceGxmTexture *texture, SceGxmTextureAddrMode addrMode);
SceGxmTextureAddrMode sceGxmTextureGetUAddrMode(const SceGxmTexture *texture);

int sceGxmTextureSetVAddrMode(SceGxmTexture *texture, SceGxmTextureAddrMode addrMode);
SceGxmTextureAddrMode sceGxmTextureGetVAddrMode(const SceGxmTexture *texture);

int sceGxmTextureSetFormat(SceGxmTexture *texture, SceGxmTextureFormat texFormat);
SceGxmTextureFormat sceGxmTextureGetFormat(const SceGxmTexture *texture);

int sceGxmTextureSetLodBias(SceGxmTexture *texture, unsigned int bias);
unsigned int sceGxmTextureGetLodBias(const SceGxmTexture *texture);

int sceGxmTextureSetStride(SceGxmTexture *texture, unsigned int byteStride);
unsigned int sceGxmTextureGetStride(const SceGxmTexture *texture);

int sceGxmTextureSetWidth(SceGxmTexture *texture, unsigned int width);
unsigned int sceGxmTextureGetWidth(const SceGxmTexture *texture);

int sceGxmTextureSetHeight(SceGxmTexture *texture, unsigned int height);
unsigned int sceGxmTextureGetHeight(const SceGxmTexture *texture);

int sceGxmTextureSetData(SceGxmTexture *texture, const void *data);
void *sceGxmTextureGetData(const SceGxmTexture *texture);

int sceGxmTextureSetMipmapCount(SceGxmTexture *texture, unsigned int mipCount);
unsigned int sceGxmTextureGetMipmapCount(const SceGxmTexture *texture);

int sceGxmTextureSetPalette(SceGxmTexture *texture, const void *paletteData);
void *sceGxmTextureGetPalette(const SceGxmTexture *texture);

SceGxmTextureGammaMode sceGxmTextureGetGammaMode(const SceGxmTexture *texture);
int sceGxmTextureSetGammaMode(SceGxmTexture *texture, SceGxmTextureGammaMode gammaMode);

unsigned int sceGxmGetPrecomputedVertexStateSize(const SceGxmVertexProgram *vertexProgram);
int sceGxmPrecomputedVertexStateInit(SceGxmPrecomputedVertexState *precomputedState, const SceGxmVertexProgram *vertexProgram, void *memBlock);
void sceGxmPrecomputedVertexStateSetDefaultUniformBuffer(SceGxmPrecomputedVertexState *precomputedState, void *defaultBuffer);
void *sceGxmPrecomputedVertexStateGetDefaultUniformBuffer(const SceGxmPrecomputedVertexState *precomputedState);
int sceGxmPrecomputedVertexStateSetAllTextures(SceGxmPrecomputedVertexState *precomputedState, const SceGxmTexture *textures);
int sceGxmPrecomputedVertexStateSetTexture(SceGxmPrecomputedVertexState *precomputedState, unsigned int textureIndex, const SceGxmTexture *texture);
int sceGxmPrecomputedVertexStateSetAllUniformBuffers(SceGxmPrecomputedVertexState *precomputedState, const void * const *bufferDataArray);
int sceGxmPrecomputedVertexStateSetUniformBuffer(SceGxmPrecomputedVertexState *precomputedState, unsigned int bufferIndex, const void *bufferData);
unsigned int sceGxmGetPrecomputedFragmentStateSize(const SceGxmFragmentProgram *fragmentProgram);
int sceGxmPrecomputedFragmentStateInit(SceGxmPrecomputedFragmentState *precomputedState, const SceGxmFragmentProgram *fragmentProgram, void *memBlock);
void sceGxmPrecomputedFragmentStateSetDefaultUniformBuffer(SceGxmPrecomputedFragmentState *precomputedState, void *defaultBuffer);
void *sceGxmPrecomputedFragmentStateGetDefaultUniformBuffer(const SceGxmPrecomputedFragmentState *precomputedState);
int sceGxmPrecomputedFragmentStateSetAllTextures(SceGxmPrecomputedFragmentState *precomputedState, const SceGxmTexture *textureArray);
int sceGxmPrecomputedFragmentStateSetTexture(SceGxmPrecomputedFragmentState *precomputedState, unsigned int textureIndex, const SceGxmTexture *texture);
int sceGxmPrecomputedFragmentStateSetAllUniformBuffers(SceGxmPrecomputedFragmentState *precomputedState, const void * const *bufferDataArray);
int sceGxmPrecomputedFragmentStateSetUniformBuffer(SceGxmPrecomputedFragmentState *precomputedState, unsigned int bufferIndex, const void *bufferData);
int sceGxmPrecomputedFragmentStateSetAllAuxiliarySurfaces(SceGxmPrecomputedFragmentState *precomputedState, const SceGxmAuxiliarySurface *auxSurfaceArray);
unsigned int sceGxmGetPrecomputedDrawSize(const SceGxmVertexProgram *vertexProgram);
int sceGxmPrecomputedDrawInit(SceGxmPrecomputedDraw *precomputedDraw, const SceGxmVertexProgram *vertexProgram, void *memBlock);
int sceGxmPrecomputedDrawSetAllVertexStreams(SceGxmPrecomputedDraw *precomputedDraw, const void * const *streamDataArray);
int sceGxmPrecomputedDrawSetVertexStream(SceGxmPrecomputedDraw *precomputedDraw, unsigned int streamIndex, const void *streamData);
void sceGxmPrecomputedDrawSetParams(SceGxmPrecomputedDraw *precomputedDraw, SceGxmPrimitiveType primType, SceGxmIndexFormat indexType, const void *indexData, unsigned int indexCount);
void sceGxmPrecomputedDrawSetParamsInstanced(SceGxmPrecomputedDraw *precomputedDraw, SceGxmPrimitiveType primType, SceGxmIndexFormat indexType, const void *indexData, unsigned int indexCount, unsigned int indexWrap);

int sceGxmGetRenderTargetMemSizes(const SceGxmRenderTargetParams *params, unsigned int *hostMemSize, unsigned int *driverMemSize);
int sceGxmCreateRenderTarget(const SceGxmRenderTargetParams *params, SceGxmRenderTarget **renderTarget);
int sceGxmRenderTargetGetHostMem(const SceGxmRenderTarget *renderTarget, void **hostMem);
int sceGxmRenderTargetGetDriverMemBlock(const SceGxmRenderTarget *renderTarget, SceUID *driverMemBlock);
int sceGxmDestroyRenderTarget(SceGxmRenderTarget *renderTarget);

int sceGxmSetUniformDataF(void *uniformBuffer, const SceGxmProgramParameter *parameter, unsigned int componentOffset, unsigned int componentCount, const float *sourceData);

#ifdef __cplusplus
}
#endif

#endif /* _PSP2_GXM_ */
